/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.DirectionalityHelper;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.SelectorMatcher;
import io.sf.carte.doc.style.css.nsac.CombinatorSelector;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.nsac.SimpleSelector;
import io.sf.carte.doc.style.css.om.AbstractSelectorMatcher;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class BaseSelectorMatcher<E extends Element>
extends AbstractSelectorMatcher {
    private static final long serialVersionUID = 1L;
    private final E element;

    protected BaseSelectorMatcher(E e) {
        this.element = e;
        String string = e.getLocalName();
        if (string == null) {
            string = e.getTagName();
        }
        string = string.toLowerCase(Locale.ROOT).intern();
        this.setLocalName(string);
    }

    protected E getElement() {
        return this.element;
    }

    @Override
    protected AbstractSelectorMatcher getParentSelectorMatcher() {
        Node node = this.element.getParentNode();
        if (node.getNodeType() == 1) {
            return (AbstractSelectorMatcher)this.obtainSelectorMatcher((Element)node);
        }
        return null;
    }

    @Override
    protected AbstractSelectorMatcher getPreviousSiblingSelectorMatcher() {
        for (Node node = this.element.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (node.getNodeType() != 1) continue;
            return (AbstractSelectorMatcher)this.obtainSelectorMatcher((Element)node);
        }
        return null;
    }

    @Override
    protected int indexOf(SelectorList selectorList) {
        int n = 0;
        for (Node node = this.element.getParentNode().getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !this.matchSelectors(selectorList, (Element)node)) continue;
            ++n;
            if (node != this.element) continue;
            return n;
        }
        return -1;
    }

    @Override
    protected int reverseIndexOf(SelectorList selectorList) {
        int n = 0;
        for (Node node = this.element.getParentNode().getLastChild(); node != null; node = node.getPreviousSibling()) {
            if (node.getNodeType() != 1 || !this.matchSelectors(selectorList, (Element)node)) continue;
            ++n;
            if (node != this.element) continue;
            return n;
        }
        return -1;
    }

    private boolean matchSelectors(SelectorList selectorList, E e) {
        if (selectorList == null) {
            return true;
        }
        SelectorMatcher selectorMatcher = this.obtainSelectorMatcher(e);
        int n = selectorList.getLength();
        for (int i = 0; i < n; ++i) {
            if (!selectorMatcher.matches(selectorList.item(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isActivePseudoClass(String string) {
        return false;
    }

    @Override
    protected boolean isFirstChild() {
        for (Node node = this.element.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (node.getNodeType() != 1) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean isLastChild() {
        for (Node node = this.element.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean isFirstOfType() {
        for (Node node = this.element.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (node.getNodeType() != 1 || !this.getLocalName().equals(node.getNodeName())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean isLastOfType() {
        for (Node node = this.element.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !this.getLocalName().equals(node.getNodeName())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean isNthOfType(int n, int n2) {
        int n3 = 0;
        for (Node node = this.element.getParentNode().getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !this.getLocalName().equals(node.getLocalName())) continue;
            ++n3;
            if (node == this.element) break;
        }
        return n == 0 ? n3 == 0 : Math.floorMod(n3 -= n2, n) == 0;
    }

    @Override
    protected boolean isNthLastOfType(int n, int n2) {
        int n3 = 0;
        for (Node node = this.element.getParentNode().getLastChild(); node != null; node = node.getPreviousSibling()) {
            if (node.getNodeType() != 1 || !this.getLocalName().equals(node.getNodeName())) continue;
            ++n3;
            if (node == this.element) break;
        }
        return n == 0 ? n3 == 0 : Math.floorMod(n3 -= n2, n) == 0;
    }

    @Override
    protected boolean isTarget() {
        int n;
        String string = this.element.getOwnerDocument().getDocumentURI();
        if (string != null && (n = string.lastIndexOf(35)) != -1) {
            int n2 = string.length();
            return ++n < n2 && this.getId().equals(string.subSequence(n, n2));
        }
        return false;
    }

    @Override
    protected boolean isRoot() {
        return this.element.getOwnerDocument().getDocumentElement().isSameNode((Node)this.element);
    }

    @Override
    protected boolean isEmpty() {
        for (Node node = this.element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string;
            short s = node.getNodeType();
            if (s == 1) {
                return false;
            }
            if (!(s == 3 ? (string = node.getNodeValue()).trim().length() != 0 : s == 5)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean isBlank() {
        for (Node node = this.element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string;
            short s = node.getNodeType();
            if (s == 1) {
                return false;
            }
            if (!(s == 3 ? (string = node.getNodeValue()) != null && !((Text)node).isElementContentWhitespace() : s == 5)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean isDisabled() {
        if (this.element.hasAttribute("disabled")) {
            return true;
        }
        Node node = this.element.getParentNode();
        if (node != null && node.getNodeType() == 1 && "fieldset".equals(node.getNodeName()) && !"legend".equals(this.getLocalName())) {
            return ((Element)node).hasAttribute("disabled");
        }
        return false;
    }

    @Override
    protected boolean isDefaultButton() {
        Node node = this.element.getParentNode();
        if (node == null) {
            return false;
        }
        while (node != null && node.getNodeType() == 1 && !"form".equalsIgnoreCase(((Element)node).getTagName())) {
            node = node.getParentNode();
        }
        String string = node == null ? null : this.getElementId((Element)node);
        Node node2 = this.element.getPreviousSibling();
        while (node2 != null) {
            if (node2.getNodeType() != 1) continue;
            Element element = (Element)node2;
            if (!BaseSelectorMatcher.defaultButtonCheck(element, string)) {
                return false;
            }
            for (Node node3 = element.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                if (node3.getNodeType() != 1 || BaseSelectorMatcher.defaultButtonCheck((Element)node3, string)) continue;
                return false;
            }
            node2 = node2.getPreviousSibling();
        }
        return true;
    }

    private static boolean defaultButtonCheck(Element element, String string) {
        String string2;
        if (!element.hasAttribute("disabled") && ((string2 = element.getAttribute("form")) == null || string2.equals(string))) {
            String string3 = element.getTagName().toLowerCase(Locale.ROOT);
            if (string3.equals("input")) {
                String string4 = element.getAttribute("type");
                return !"submit".equalsIgnoreCase(string4) && !"image".equalsIgnoreCase(string4);
            }
            if (string3.equals("button")) {
                return !"submit".equalsIgnoreCase(element.getAttribute("type"));
            }
        }
        return true;
    }

    @Override
    protected String getNamespaceURI() {
        return this.element.getNamespaceURI();
    }

    @Override
    protected String getAttributeValue(String string) {
        return this.element.getAttribute(string);
    }

    @Override
    protected boolean hasAttribute(String string) {
        return this.element.hasAttribute(string);
    }

    @Override
    protected CSSDocument.ComplianceMode getComplianceMode() {
        Document document = this.getOwnerDocument();
        return document.getDoctype() != null ? CSSDocument.ComplianceMode.STRICT : CSSDocument.ComplianceMode.QUIRKS;
    }

    protected Document getOwnerDocument() {
        return this.element.getOwnerDocument();
    }

    @Override
    protected String getId() {
        return this.getElementId(this.element);
    }

    protected String getElementId(E e) {
        String string = e.getAttribute("id");
        if (string.length() == 0 && this.getComplianceMode() == CSSDocument.ComplianceMode.QUIRKS && (string = this.getAttributeValue("ID")).length() == 0) {
            string = this.getAttributeValue("Id");
        }
        return string;
    }

    @Override
    protected String getLanguage() {
        String string = this.element.getAttribute("lang");
        Object object = this.element;
        while (string.length() == 0 && (object = object.getParentNode()) != null) {
            if (!(object instanceof Element)) continue;
            string = ((Element)object).getAttribute("lang");
        }
        return string;
    }

    @Override
    protected DirectionalityHelper.Directionality getDirectionality() {
        return DirectionalityHelper.getDirectionality(this.element);
    }

    @Override
    protected boolean scopeMatchChild(CombinatorSelector combinatorSelector) {
        SimpleSelector simpleSelector = combinatorSelector.getSecondSelector();
        for (Node node = this.element.getFirstChild(); node != null; node = node.getNextSibling()) {
            SelectorMatcher selectorMatcher;
            if (node.getNodeType() != 1 || !(selectorMatcher = this.obtainSelectorMatcher((Element)node)).matches(simpleSelector)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean scopeMatchDescendant(CombinatorSelector combinatorSelector) {
        SimpleSelector simpleSelector = combinatorSelector.getSecondSelector();
        Node node = this.element.getFirstChild();
        return this.scopeMatchRecursive(node, simpleSelector);
    }

    @Override
    public boolean matchesRelational(Selector selector) {
        Node node = this.element.getFirstChild();
        return this.scopeMatchRecursive(node, selector);
    }

    private boolean scopeMatchRecursive(Node node, Selector selector) {
        while (node != null) {
            SelectorMatcher selectorMatcher;
            if (node.getNodeType() == 1 && ((selectorMatcher = this.obtainSelectorMatcher((Element)node)).matches(selector) || this.scopeMatchRecursive(node.getFirstChild(), selector))) {
                return true;
            }
            node = node.getNextSibling();
        }
        return false;
    }

    @Override
    protected boolean scopeMatchDirectAdjacent(CombinatorSelector combinatorSelector) {
        SelectorMatcher selectorMatcher = null;
        for (Node node = this.element.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            selectorMatcher = this.obtainSelectorMatcher((Element)node);
            break;
        }
        if (selectorMatcher != null) {
            return selectorMatcher.matches(combinatorSelector.getSecondSelector());
        }
        return false;
    }

    protected abstract SelectorMatcher obtainSelectorMatcher(E var1);
}

