﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/waf-regional/WAFRegional_EXPORTS.h>
#include <aws/waf-regional/model/SizeConstraintSet.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace WAFRegional {
namespace Model {
class CreateSizeConstraintSetResult {
 public:
  AWS_WAFREGIONAL_API CreateSizeConstraintSetResult() = default;
  AWS_WAFREGIONAL_API CreateSizeConstraintSetResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_WAFREGIONAL_API CreateSizeConstraintSetResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A <a>SizeConstraintSet</a> that contains no <code>SizeConstraint</code>
   * objects.</p>
   */
  inline const SizeConstraintSet& GetSizeConstraintSet() const { return m_sizeConstraintSet; }
  template <typename SizeConstraintSetT = SizeConstraintSet>
  void SetSizeConstraintSet(SizeConstraintSetT&& value) {
    m_sizeConstraintSetHasBeenSet = true;
    m_sizeConstraintSet = std::forward<SizeConstraintSetT>(value);
  }
  template <typename SizeConstraintSetT = SizeConstraintSet>
  CreateSizeConstraintSetResult& WithSizeConstraintSet(SizeConstraintSetT&& value) {
    SetSizeConstraintSet(std::forward<SizeConstraintSetT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The <code>ChangeToken</code> that you used to submit the
   * <code>CreateSizeConstraintSet</code> request. You can also use this value to
   * query the status of the request. For more information, see
   * <a>GetChangeTokenStatus</a>.</p>
   */
  inline const Aws::String& GetChangeToken() const { return m_changeToken; }
  template <typename ChangeTokenT = Aws::String>
  void SetChangeToken(ChangeTokenT&& value) {
    m_changeTokenHasBeenSet = true;
    m_changeToken = std::forward<ChangeTokenT>(value);
  }
  template <typename ChangeTokenT = Aws::String>
  CreateSizeConstraintSetResult& WithChangeToken(ChangeTokenT&& value) {
    SetChangeToken(std::forward<ChangeTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateSizeConstraintSetResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  SizeConstraintSet m_sizeConstraintSet;

  Aws::String m_changeToken;

  Aws::String m_requestId;
  bool m_sizeConstraintSetHasBeenSet = false;
  bool m_changeTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace WAFRegional
}  // namespace Aws
