/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.vfs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.vfs.CustomisableUniqueNameEditorTabTitleProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.i18n.GitBundle;
import git4idea.index.vfs.GitIndexVirtualFile;
import git4idea.index.vfs.GitIndexVirtualFileKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000e"}, d2={"Lgit4idea/index/vfs/GitIndexVirtualFileTabTitleProvider;", "Lcom/intellij/openapi/vcs/vfs/CustomisableUniqueNameEditorTabTitleProvider;", "<init>", "()V", "isApplicable", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getEditorTabTitle", "", "baseUniqueName", "getEditorTabTooltipText", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.git"})
public final class GitIndexVirtualFileTabTitleProvider
extends CustomisableUniqueNameEditorTabTitleProvider {
    public boolean isApplicable(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof GitIndexVirtualFile;
    }

    @NotNull
    public String getEditorTabTitle(@NotNull VirtualFile file, @NotNull String baseUniqueName) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)baseUniqueName, (String)"baseUniqueName");
        Object[] objectArray = new Object[]{baseUniqueName};
        String string = GitBundle.message("stage.vfs.presentable.file.name", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Nullable
    public String getEditorTabTooltipText(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!this.isApplicable(file)) {
            return null;
        }
        Object[] objectArray = new Object[]{VcsUtil.getPresentablePath((Project)project, (FilePath)GitIndexVirtualFileKt.filePath(file), (boolean)true, (boolean)false)};
        return GitBundle.message("stage.vfs.editor.tab.tooltip", objectArray);
    }
}

