/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Objects;
import org.assertj.core.error.ShouldNotBeNull;
import org.assertj.core.internal.DigestDiff;
import org.assertj.core.util.Hexadecimals;

public final class Digests {
    private static final int BUFFER_SIZE = 8192;

    private Digests() {
    }

    public static String toHex(byte[] digest) {
        Objects.requireNonNull(digest, ShouldNotBeNull.shouldNotBeNull("digest")::create);
        StringBuilder hex = new StringBuilder(digest.length * 2);
        for (byte b : digest) {
            hex.append(Hexadecimals.byteToHexString(b));
        }
        return hex.toString();
    }

    public static byte[] fromHex(String digest) {
        Objects.requireNonNull(digest, ShouldNotBeNull.shouldNotBeNull("digest")::create);
        byte[] bytes = new byte[digest.length() / 2];
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            bytes[i2] = Integer.valueOf(digest.substring(i2 * 2, (i2 + 1) * 2), 16).byteValue();
        }
        return bytes;
    }

    public static DigestDiff digestDiff(InputStream stream, MessageDigest messageDigest, byte[] expected) throws IOException {
        int len;
        Objects.requireNonNull(stream, "The stream should not be null");
        Objects.requireNonNull(messageDigest, "The digest should not be null");
        Objects.requireNonNull(expected, "The expected should not be null");
        messageDigest.reset();
        byte[] buffer = new byte[8192];
        while ((len = stream.read(buffer)) > 0) {
            messageDigest.update(buffer, 0, len);
        }
        byte[] actualDigest = messageDigest.digest();
        String expectedHex = Digests.toHex(expected);
        String actualHex = Digests.toHex(actualDigest);
        return new DigestDiff(actualHex, expectedHex, messageDigest);
    }
}

