/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.memorycontainer.memory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.ml.action.memorycontainer.memory.FactSearchResult;
import org.opensearch.ml.common.memorycontainer.MemoryConfiguration;
import org.opensearch.ml.common.memorycontainer.MemoryStrategy;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLAddMemoriesInput;
import org.opensearch.ml.helper.MemoryContainerHelper;
import org.opensearch.ml.utils.MemorySearchQueryBuilder;
import org.opensearch.remote.metadata.client.SearchDataObjectRequest;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;

public class MemorySearchService {
    @Generated
    private static final Logger log = LogManager.getLogger(MemorySearchService.class);
    private final MemoryContainerHelper memoryContainerHelper;

    public MemorySearchService(MemoryContainerHelper memoryContainerHelper) {
        this.memoryContainerHelper = memoryContainerHelper;
    }

    public void searchSimilarFactsForSession(MemoryStrategy strategy, MLAddMemoriesInput input, List<String> facts, MemoryConfiguration memoryConfig, ActionListener<List<FactSearchResult>> listener) {
        if (input.getNamespace() == null || input.getNamespace().isEmpty() || facts.isEmpty()) {
            log.debug("Skipping fact search: facts count={}", (Object)facts.size());
            listener.onResponse(new ArrayList());
            return;
        }
        ArrayList<FactSearchResult> allResults = new ArrayList<FactSearchResult>();
        int maxInferSize = memoryConfig != null && memoryConfig.getMaxInferSize() != null ? memoryConfig.getMaxInferSize() : 5;
        List<String> factsToProcess = facts.size() > maxInferSize ? facts.subList(0, maxInferSize) : facts;
        this.searchFactsSequentially(strategy, input, factsToProcess, 0, memoryConfig, maxInferSize, allResults, listener);
    }

    private void searchFactsSequentially(MemoryStrategy strategy, MLAddMemoriesInput input, List<String> facts, int currentIndex, MemoryConfiguration memoryConfig, int maxInferSize, List<FactSearchResult> allResults, ActionListener<List<FactSearchResult>> listener) {
        if (currentIndex >= facts.size()) {
            listener.onResponse(allResults);
            return;
        }
        String fact = facts.get(currentIndex);
        try {
            QueryBuilder queryBuilder = MemorySearchQueryBuilder.buildFactSearchQuery(strategy, fact, input.getNamespace(), input.getOwnerId(), memoryConfig, input.getMemoryContainerId());
            log.debug("Searching for similar facts with query: {}", (Object)queryBuilder.toString());
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query(queryBuilder);
            searchSourceBuilder.size(maxInferSize);
            searchSourceBuilder.fetchSource(new String[]{"memory"}, null);
            String indexName = memoryConfig.getLongMemoryIndexName();
            String tenantId = memoryConfig.getTenantId();
            SearchDataObjectRequest searchRequest = SearchDataObjectRequest.builder().indices(new String[]{indexName}).searchSourceBuilder(searchSourceBuilder).tenantId(tenantId).build();
            ActionListener searchResponseActionListener = ActionListener.wrap(response -> {
                for (SearchHit hit : response.getHits().getHits()) {
                    Map sourceMap = hit.getSourceAsMap();
                    String memory = (String)sourceMap.get("memory");
                    if (memory == null) continue;
                    allResults.add(new FactSearchResult(hit.getId(), memory, hit.getScore()));
                }
                log.debug("Found {} similar facts for: {}", (Object)response.getHits().getHits().length, (Object)fact);
                this.searchFactsSequentially(strategy, input, facts, currentIndex + 1, memoryConfig, maxInferSize, allResults, listener);
            }, e -> {
                log.error("Failed to search for similar facts for: {}", (Object)fact, e);
                this.searchFactsSequentially(strategy, input, facts, currentIndex + 1, memoryConfig, maxInferSize, allResults, listener);
            });
            this.memoryContainerHelper.searchData(memoryConfig, searchRequest, (ActionListener<SearchResponse>)searchResponseActionListener);
        }
        catch (Exception e2) {
            log.error("Failed to build search query for fact: {}", (Object)fact, (Object)e2);
            this.searchFactsSequentially(strategy, input, facts, currentIndex + 1, memoryConfig, maxInferSize, allResults, listener);
        }
    }
}

