/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.ad.indices.ADIndex;
import org.opensearch.ad.indices.ADIndexManagement;
import org.opensearch.ad.rest.handler.ValidateAnomalyDetectorActionHandler;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.transport.ValidateAnomalyDetectorAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.rest.RestRequest;
import org.opensearch.timeseries.feature.SearchFeatureDao;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.ValidationAspect;
import org.opensearch.timeseries.rest.handler.Processor;
import org.opensearch.timeseries.transport.BaseValidateConfigTransportAction;
import org.opensearch.timeseries.transport.ValidateConfigRequest;
import org.opensearch.timeseries.transport.ValidateConfigResponse;
import org.opensearch.timeseries.util.SecurityClientUtil;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class ValidateAnomalyDetectorTransportAction
extends BaseValidateConfigTransportAction<ADIndex, ADIndexManagement> {
    public static final Logger logger = LogManager.getLogger(ValidateAnomalyDetectorTransportAction.class);

    @Inject
    public ValidateAnomalyDetectorTransportAction(Client client, SecurityClientUtil clientUtil, ClusterService clusterService, NamedXContentRegistry xContentRegistry, Settings settings, ADIndexManagement anomalyDetectionIndices, ActionFilters actionFilters, TransportService transportService, SearchFeatureDao searchFeatureDao) {
        super(ValidateAnomalyDetectorAction.NAME, client, clientUtil, clusterService, xContentRegistry, settings, anomalyDetectionIndices, actionFilters, transportService, searchFeatureDao, AnomalyDetectorSettings.AD_FILTER_BY_BACKEND_ROLES, ValidationAspect.DETECTOR);
    }

    @Override
    protected Processor<ValidateConfigResponse> createProcessor(Config detector, ValidateConfigRequest request, User user) {
        return new ValidateAnomalyDetectorActionHandler(this.clusterService, this.client, this.clientUtil, (ADIndexManagement)this.indexManagement, detector, request.getRequestTimeout(), request.getMaxSingleEntityAnomalyDetectors(), request.getMaxMultiEntityAnomalyDetectors(), request.getMaxAnomalyFeatures(), request.getMaxCategoricalFields(), RestRequest.Method.POST, this.xContentRegistry, user, this.searchFeatureDao, request.getValidationType(), this.clock, this.settings);
    }
}

