
## Description

This module generates a macro-enabled Microsoft Office Word document (docm). It does not target a
specific CVE or vulnerability, instead it's more of a feature-abuse in Office, and yet it's still a
popular type of social-engineering attack such as in ransomware.

By default, the module uses a built-in Office document (docx) as the template. It injects the
Base64-encoded payload into the comments field, which will get decoded back by the macro and executed
as a Windows executable when the Office document is launched.

If you do not wish to use the built-in docx template, you can also choose your own. Please see more
details below.


## Vulnerable Application

A Windows or OSX machine with Microsoft Office installed. The Office application must support the docm
format.

Specifically, this module was tested specifically against:

* Microsoft Office 2010.
* Microsoft Office 2013.
* Microsoft Office 2016.
* Microsoft Office Word 15.29.1 (161215).

## Building the Office Document Template

It is recommended that you build your Office document (docx) template from either one of these
applications:

* Google Docs
* Microsoft Office Word

**Google Docs**

Google Docs is ideal in case you don't have Microsoft Office available.

Before you start, make sure you have a Gmail account.

Next, to create a new document, please go to the following:

[https://docs.google.com/document/?usp=mkt_docs](https://docs.google.com/document/?usp=mkt_docs)

To save the document as a docx on Google docs:

1. Click on File
2. Go to Download as
3. Click on Microsoft Word (.docx)

**Microsoft Office Word**

If you already have Microsoft Office, you can use it to create a docx file and use it as a template.


## Verification Steps

**To use the default template**

1. ```use exploit/multi/fileformat/office_word_macro```
2. ```set PAYLOAD [PAYLOAD NAME]```
3. Configure the rest of the settings accordingly (LHOST, LPORT, etc)
4. ```exploit```
5. The module should generate the malicious docm.

**To use the custom template**

1. ```use exploit/multi/fileformat/office_word_macro```
2. ```set PAYLOAD [PAYLOAD NAME]```
3. ```set CUSTOMTEMPLATE [DOCX PATH]```
4. Configure the rest of the settings accordingly
5. ```exploit```
6. The module should generate the malicious docm.

## Options

### CUSTOMTEMPLATE 

A docx file that will be used as a template to build the exploit.

## Trusted Document

By default, Microsoft Office does not execute macros automatically unless it is considered as a
trusted document. This means that if a macro is present, the user will most likely need to manually
click on the "Enable Content" or "Enable Macro" button in order to run the macro.

Many in-the-wild attacks face this type of challenge, and most rely on social-engineering to trick
the user into allowing the macro to run. For example, making the document look like something
written from a legit source, such as [this attack](https://motherboard.vice.com/en_us/article/these-hackers-cleverly-disguised-their-malware-as-a-document-about-trumps-victory).

To truly make the macro document run without any warnings, you must somehow figure out a way to
sign the macro by a trusted publisher, or using a certificate that the targeted machine trusts.

If money is not an issue, you can easily buy a certificate on-line:
[https://www.sslshopper.com/microsoft-vba-code-signing-certificates.html](https://www.sslshopper.com/microsoft-vba-code-signing-certificates.html)

For testing purposes, another way to have a certificate is to create a self-signed one using
Microsoft Office's SELFCERT.exe utility. This tool can be found in the following path on
Windows:

```
C:\Program Files\Microsoft Office\root\Office16\SELFCERT.exe
```

In Office 2010, the self-signing tool is actually an option in the Office tools folder in the
start menu. It should be named "Digital Certificate for VBA Projects".

Double-click on the executable, enter a random name and click "OK", at this point you have a
certificate to play with.

Next, we want to flag this certificate as trusted:

1. Click on Start, and then enter "Internet Options".
2. Click on the Content tab, and then click on the Certificates button.
3. You should see your new certificate under the Personal tab, export it.
4. Click on the Trusted Publishers, and then import your personal certificate.
5. Try the macro exploit again, it should run the malicious code without warning.
