/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.info;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.TimeZone;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.config.TimezoneHelper;
import tim.prune.data.AltitudeRange;
import tim.prune.data.Coordinate;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.FieldList;
import tim.prune.data.FileInfo;
import tim.prune.data.FileType;
import tim.prune.data.MediaObject;
import tim.prune.data.NumberUtils;
import tim.prune.data.RangeStatsWithGradients;
import tim.prune.data.Selection;
import tim.prune.data.SourceInfo;
import tim.prune.data.SpeedCalculator;
import tim.prune.data.SpeedValue;
import tim.prune.data.Track;
import tim.prune.data.Unit;
import tim.prune.data.UnitSet;
import tim.prune.gui.CoordDisplay;
import tim.prune.gui.DisplayUtils;

public class ShowFullDetails
extends GenericFunction {
    private JDialog _dialog = null;
    private JTabbedPane _tabs = null;
    private JButton _okButton = null;
    private JTextArea _fileTextArea = null;
    private JTextArea _pointTextArea = null;
    private JTextArea _rangeTextArea = null;

    public ShowFullDetails(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.viewfulldetails";
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, this.getName(), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this.updateDetails();
        this._dialog.setVisible(true);
        this._okButton.requestFocus();
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._tabs = new JTabbedPane();
        jPanel.add((Component)this._tabs, "Center");
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    ShowFullDetails.this._dialog.dispose();
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        };
        this._tabs.addKeyListener(keyListener);
        this._fileTextArea = new JTextArea(I18nManager.getText("details.nofileloaded"));
        JPanel jPanel2 = this.makePanelForTab(this._fileTextArea);
        this._tabs.add(I18nManager.getText("details.filedetails"), jPanel2);
        this._pointTextArea = new JTextArea(I18nManager.getText("details.nopointselection"));
        JPanel jPanel3 = this.makePanelForTab(this._pointTextArea);
        this._tabs.add(I18nManager.getText("details.pointdetails"), jPanel3);
        this._rangeTextArea = new JTextArea(I18nManager.getText("details.norangeselection"));
        JPanel jPanel4 = this.makePanelForTab(this._rangeTextArea);
        this._tabs.add(I18nManager.getText("details.rangedetails"), jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(1));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        this._okButton.addActionListener(actionEvent -> this._dialog.dispose());
        this._okButton.addKeyListener(keyListener);
        jPanel5.add(this._okButton);
        jPanel.add((Component)jPanel5, "South");
        return jPanel;
    }

    private JPanel makePanelForTab(JTextArea jTextArea) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setPreferredSize(new Dimension(500, 230));
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private void updateDetails() {
        Object object;
        int n = 0;
        this._fileTextArea.setText(this.makeFileDescription(this._app.getTrackInfo().getFileInfo()));
        if (this._app.getTrackInfo().getCurrentPoint() != null) {
            object = this.makePointDescription(this._app.getTrackInfo().getTrack(), this._app.getTrackInfo().getSelection().getCurrentPointIndex());
            this._pointTextArea.setText((String)object);
            n = 1;
        } else {
            this._pointTextArea.setText(I18nManager.getText("details.nopointselection"));
        }
        object = this._app.getTrackInfo().getSelection();
        if (((Selection)object).hasRangeSelected()) {
            int n2 = this.getConfig().getConfigInt("prune.altitudetolerance") / 100;
            RangeStatsWithGradients rangeStatsWithGradients = new RangeStatsWithGradients(this._app.getTrackInfo().getTrack(), ((Selection)object).getStart(), ((Selection)object).getEnd(), n2);
            SpeedValue speedValue = this.calculateMaxSpeed(this._app.getTrackInfo().getTrack(), ((Selection)object).getStart(), ((Selection)object).getEnd());
            this._rangeTextArea.setText(this.makeRangeDescription(rangeStatsWithGradients, speedValue));
            n = 2;
        } else {
            this._rangeTextArea.setText(I18nManager.getText("details.norangeselection"));
        }
        this._tabs.setSelectedIndex(n);
    }

    private String makeFileDescription(FileInfo fileInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = fileInfo.getNumFiles();
        int n2 = 0;
        while (n2 < n) {
            SourceInfo sourceInfo = fileInfo.getSource(n2);
            FileType fileType = sourceInfo.getFileType();
            if (fileType != null && fileType != FileType.GPSBABEL) {
                if (bl) {
                    stringBuilder.append("========================================\n");
                }
                bl = true;
                ShowFullDetails.addTextPair(stringBuilder, "details.track.file", sourceInfo.getName());
                ShowFullDetails.addTextPair(stringBuilder, "details.track.filetype", I18nManager.getText(fileType.getTextKey()));
                ShowFullDetails.addTextPair(stringBuilder, "details.track.fileversion", sourceInfo.getFileVersion());
                ShowFullDetails.addTextPair(stringBuilder, "details.track.filepath", sourceInfo.getFile().getAbsolutePath());
                ShowFullDetails.addTextPair(stringBuilder, "dialog.exportgpx.name", sourceInfo.getFileTitle());
                ShowFullDetails.addTextPair(stringBuilder, "dialog.exportgpx.desc", sourceInfo.getFileDescription());
                ShowFullDetails.addTextPair(stringBuilder, "dialog.exportgpx.extensions", sourceInfo.getExtensions());
                stringBuilder.append('\n');
            }
            ++n2;
        }
        if (bl) {
            return stringBuilder.toString();
        }
        return I18nManager.getText("details.nofileloaded");
    }

    private SpeedValue calculateMaxSpeed(Track track, int n, int n2) {
        SpeedValue speedValue = new SpeedValue();
        SpeedValue speedValue2 = new SpeedValue();
        int n3 = n;
        while (n3 <= n2) {
            SpeedCalculator.calculateSpeed(track, n3, this.getConfig().getUnitSet(), speedValue2);
            if (speedValue2.isValid() && (!speedValue.isValid() || speedValue2.getValue() > speedValue.getValue())) {
                speedValue.setValue(speedValue2.getValue());
            }
            ++n3;
        }
        return speedValue;
    }

    private String makePointDescription(Track track, int n) {
        Object object;
        Object object2;
        Object object3;
        DataPoint dataPoint = track.getPoint(n);
        if (dataPoint == null) {
            return "";
        }
        Coordinate.Format format = Coordinate.getCoordinateFormatForDisplay(this.getConfig().getConfigString("prune.coorddisplay"));
        StringBuilder stringBuilder = new StringBuilder();
        String string = CoordDisplay.makeCoordinateLabel(dataPoint.getLatitude(), format);
        String string2 = CoordDisplay.makeCoordinateLabel(dataPoint.getLongitude(), format);
        ShowFullDetails.addTextPair(stringBuilder, "fieldname.latitude", string);
        ShowFullDetails.addTextPair(stringBuilder, "fieldname.longitude", string2);
        ShowFullDetails.addTextPair(stringBuilder, "fieldname.coordinates", String.valueOf(string) + NumberUtils.getValueSeparator() + string2);
        UnitSet unitSet = this.getConfig().getUnitSet();
        if (dataPoint.hasAltitude()) {
            object3 = unitSet.getAltitudeUnit();
            ShowFullDetails.addTextPair(stringBuilder, "fieldname.altitude", dataPoint.getAltitude().getLocalStringValue((Unit)object3), I18nManager.getText(((Unit)object3).getShortnameKey()));
        }
        if (dataPoint.hasTimestamp()) {
            object3 = TimezoneHelper.getSelectedTimezone(this.getConfig());
            ShowFullDetails.addTextPair(stringBuilder, "fieldname.date", dataPoint.getTimestamp().getDateText((TimeZone)object3));
            ShowFullDetails.addTextPair(stringBuilder, "fieldname.timestamp", dataPoint.getTimestamp().getTimeText((TimeZone)object3));
        }
        ShowFullDetails.addTextPair(stringBuilder, "fieldname.waypointname", dataPoint.getWaypointName());
        ShowFullDetails.addTextPair(stringBuilder, "fieldname.description", dataPoint.getFieldValue(Field.DESCRIPTION));
        ShowFullDetails.addTextPair(stringBuilder, "fieldname.comment", dataPoint.getFieldValue(Field.COMMENT));
        ShowFullDetails.addTextPair(stringBuilder, "fieldname.symbol", dataPoint.getFieldValue(Field.SYMBOL));
        ShowFullDetails.addTextPair(stringBuilder, "fieldname.waypointtype", dataPoint.getFieldValue(Field.WAYPT_TYPE));
        object3 = new SpeedValue();
        SpeedCalculator.calculateSpeed(track, n, unitSet, (SpeedValue)object3);
        if (((SpeedValue)object3).isValid()) {
            object2 = I18nManager.getText(unitSet.getSpeedUnit().getShortnameKey());
            object = DisplayUtils.roundedNumber(((SpeedValue)object3).getValue());
            ShowFullDetails.addTextPair(stringBuilder, "fieldname.speed", (String)object, (String)object2);
        }
        SpeedCalculator.calculateVerticalSpeed(track, n, unitSet, (SpeedValue)object3);
        if (((SpeedValue)object3).isValid()) {
            object2 = I18nManager.getText(unitSet.getVerticalSpeedUnit().getShortnameKey());
            object = DisplayUtils.roundedNumber(((SpeedValue)object3).getValue());
            ShowFullDetails.addTextPair(stringBuilder, "fieldname.verticalspeed", (String)object, (String)object2);
        }
        if ((object2 = dataPoint.getPhoto()) != null) {
            ShowFullDetails.addTextPair(stringBuilder, "details.photofile", ((MediaObject)object2).getName());
            ShowFullDetails.addTextPair(stringBuilder, "details.media.fullpath", ((MediaObject)object2).getFullPath());
        }
        if ((object = dataPoint.getAudio()) != null) {
            ShowFullDetails.addTextPair(stringBuilder, "details.audio.file", ((MediaObject)object).getName());
            ShowFullDetails.addTextPair(stringBuilder, "details.media.fullpath", ((MediaObject)object).getFullPath());
        }
        FieldList fieldList = dataPoint.getFieldList();
        int n2 = 0;
        while (n2 < fieldList.getNumFields()) {
            Field field = fieldList.getField(n2);
            if (!field.isBuiltIn()) {
                ShowFullDetails.addTextPairWithoutTranslation(stringBuilder, field.getName(), dataPoint.getFieldValue(field));
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    private String makeRangeDescription(RangeStatsWithGradients rangeStatsWithGradients, SpeedValue speedValue) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        ShowFullDetails.addTextPair(stringBuilder, "details.track.points", "" + rangeStatsWithGradients.getNumPoints());
        ShowFullDetails.addTextPair(stringBuilder, "details.range.numsegments", "" + rangeStatsWithGradients.getNumSegments());
        boolean bl = rangeStatsWithGradients.getNumSegments() > 1;
        UnitSet unitSet = this.getConfig().getUnitSet();
        String string = I18nManager.getText(unitSet.getSpeedUnit().getShortnameKey());
        if (speedValue.isValid()) {
            object = String.valueOf(DisplayUtils.roundedNumber(speedValue.getValue())) + " " + string;
            ShowFullDetails.addTextPair(stringBuilder, "details.range.maxspeed", (String)object);
        }
        ShowFullDetails.addHeading(stringBuilder, "dialog.fullrangedetails.colsegments");
        object = unitSet.getDistanceUnit();
        String string2 = I18nManager.getText(((Unit)object).getShortnameKey());
        double d = rangeStatsWithGradients.getMovingDistance((Unit)object);
        ShowFullDetails.addTextPair(stringBuilder, "fieldname.distance", DisplayUtils.roundedNumber(d), string2);
        long l = rangeStatsWithGradients.getMovingDurationInSeconds();
        ShowFullDetails.addTextPair(stringBuilder, "fieldname.duration", DisplayUtils.buildDurationString(l));
        if (l > 0L && d > 0.0) {
            ShowFullDetails.addTextPair(stringBuilder, "details.range.avespeed", DisplayUtils.roundedNumber(d / (double)l * 3600.0), string);
            ShowFullDetails.addTextPair(stringBuilder, "details.range.pace", DisplayUtils.buildDurationString((long)((double)l / d)), "/ " + string2);
        }
        Unit unit = unitSet.getAltitudeUnit();
        String string3 = I18nManager.getText(unit.getShortnameKey());
        if (rangeStatsWithGradients.getMovingAltitudeRange().hasRange()) {
            AltitudeRange altitudeRange = rangeStatsWithGradients.getMovingAltitudeRange();
            ShowFullDetails.addTextPair(stringBuilder, "fieldname.altitude", altitudeRange.getMinimum(unit) + string3 + " " + I18nManager.getText("details.altitude.to") + " " + altitudeRange.getMaximum(unit) + string3);
            ShowFullDetails.addTextPair(stringBuilder, "details.range.climb", "" + altitudeRange.getClimb(unit), string3);
            ShowFullDetails.addTextPair(stringBuilder, "details.range.descent", "" + altitudeRange.getDescent(unit), string3);
            ShowFullDetails.addTextPair(stringBuilder, "details.range.gradient", DisplayUtils.formatOneDp(rangeStatsWithGradients.getMovingGradient()), "%");
            if (l > 0L) {
                String string4 = I18nManager.getText(unitSet.getVerticalSpeedUnit().getShortnameKey());
                String string5 = DisplayUtils.roundedNumber(rangeStatsWithGradients.getMovingVerticalSpeed());
                ShowFullDetails.addTextPair(stringBuilder, "fieldname.verticalspeed", string5, string4);
            }
        }
        if (bl) {
            ShowFullDetails.addHeading(stringBuilder, "dialog.fullrangedetails.coltotal");
            double d2 = rangeStatsWithGradients.getTotalDistance((Unit)object);
            ShowFullDetails.addTextPair(stringBuilder, "fieldname.distance", DisplayUtils.roundedNumber(d2), string2);
            long l2 = rangeStatsWithGradients.getTotalDurationInSeconds();
            ShowFullDetails.addTextPair(stringBuilder, "fieldname.duration", DisplayUtils.buildDurationString(l2));
            if (l2 > 0L && d2 > 0.0) {
                ShowFullDetails.addTextPair(stringBuilder, "details.range.avespeed", DisplayUtils.roundedNumber(d2 / (double)l2 * 3600.0), string);
                ShowFullDetails.addTextPair(stringBuilder, "details.range.pace", DisplayUtils.buildDurationString((long)((double)l2 / d2)), "/ " + string2);
            }
            if (rangeStatsWithGradients.getTotalAltitudeRange().hasRange()) {
                AltitudeRange altitudeRange = rangeStatsWithGradients.getTotalAltitudeRange();
                ShowFullDetails.addTextPair(stringBuilder, "details.range.climb", "" + altitudeRange.getClimb(unit), string3);
                ShowFullDetails.addTextPair(stringBuilder, "details.range.descent", "" + altitudeRange.getDescent(unit), string3);
                ShowFullDetails.addTextPair(stringBuilder, "details.range.gradient", DisplayUtils.formatOneDp(rangeStatsWithGradients.getTotalGradient()), "%");
                if (l2 > 0L) {
                    String string6 = I18nManager.getText(unitSet.getVerticalSpeedUnit().getShortnameKey());
                    String string7 = DisplayUtils.roundedNumber(rangeStatsWithGradients.getTotalVerticalSpeed());
                    ShowFullDetails.addTextPair(stringBuilder, "fieldname.verticalspeed", string7, string6);
                }
            }
        }
        return stringBuilder.toString();
    }

    private static void addTextPair(StringBuilder stringBuilder, String string, String string2) {
        ShowFullDetails.addTextPair(stringBuilder, string, string2, null);
    }

    private static void addTextPairWithoutTranslation(StringBuilder stringBuilder, String string, String string2) {
        if (string2 != null && !string2.equals("")) {
            stringBuilder.append(string).append(": ").append(string2);
            stringBuilder.append("\n");
        }
    }

    private static void addTextPair(StringBuilder stringBuilder, String string, String string2, String string3) {
        if (string2 != null && !string2.equals("")) {
            stringBuilder.append(I18nManager.getText(string));
            stringBuilder.append(": ");
            stringBuilder.append(string2);
            if (string3 != null && !string3.equals("")) {
                stringBuilder.append(' ');
                stringBuilder.append(string3);
            }
            stringBuilder.append("\n");
        }
    }

    private static void addHeading(StringBuilder stringBuilder, String string) {
        String string2 = I18nManager.getText(string);
        stringBuilder.append('\n').append(string2).append('\n');
        stringBuilder.append("=".repeat(string2.length()));
        stringBuilder.append('\n');
    }
}

