/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.lifecycle.Unfinished;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.BinOpGen;
import ghidra.pcode.emu.jit.gen.type.TypeConversions;
import ghidra.pcode.emu.jit.op.JitIntDivOp;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.objectweb.asm.MethodVisitor;

public enum IntDivOpGen implements BinOpGen<JitIntDivOp>
{
    GEN;


    @Override
    public JitType afterLeft(JitCodeGenerator gen, JitIntDivOp op, JitType lType, JitType rType, MethodVisitor rv) {
        return TypeConversions.forceUniformZExt(lType, rType, rv);
    }

    @Override
    public JitType generateBinOpRunCode(JitCodeGenerator gen, JitIntDivOp op, JitControlFlowModel.JitBlock block, JitType lType, JitType rType, MethodVisitor rv) {
        JitType jitType = rType = TypeConversions.forceUniformZExt(rType, lType, rv);
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
            case 0: {
                JitType.IntJitType t = (JitType.IntJitType)jitType2;
                rv.visitMethodInsn(184, GenConsts.NAME_INTEGER, "divideUnsigned", GenConsts.MDESC_$INT_BINOP, false);
                break;
            }
            case 1: {
                JitType.LongJitType t = (JitType.LongJitType)jitType2;
                rv.visitMethodInsn(184, GenConsts.NAME_LONG, "divideUnsigned", GenConsts.MDESC_$LONG_BINOP, false);
                break;
            }
            case 2: {
                JitType.MpIntJitType t = (JitType.MpIntJitType)jitType2;
                Unfinished.TODO((String)"MpInt", (Object[])new Object[0]);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return lType;
    }
}

