/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.auxiliary;

import ghidra.pcode.emu.AbstractPcodeMachine;
import ghidra.pcode.emu.PcodeThread;
import ghidra.pcode.emu.auxiliary.AuxEmulatorPartsFactory;
import ghidra.pcode.exec.BytesPcodeArithmetic;
import ghidra.pcode.exec.BytesPcodeExecutorStatePiece;
import ghidra.pcode.exec.PairedPcodeArithmetic;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.program.model.lang.Language;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AuxPcodeEmulator<U>
extends AbstractPcodeMachine<Pair<byte[], U>> {
    public AuxPcodeEmulator(Language language) {
        super(language);
    }

    protected abstract AuxEmulatorPartsFactory<U> getPartsFactory();

    @Override
    protected PcodeArithmetic<Pair<byte[], U>> createArithmetic() {
        return new PairedPcodeArithmetic<byte[], U>(BytesPcodeArithmetic.forLanguage((Language)this.language), this.getPartsFactory().getArithmetic((Language)this.language));
    }

    @Override
    protected PcodeUseropLibrary<Pair<byte[], U>> createUseropLibrary() {
        return this.getPartsFactory().createSharedUseropLibrary(this);
    }

    @Override
    protected PcodeUseropLibrary<Pair<byte[], U>> createThreadStubLibrary() {
        return this.getPartsFactory().createLocalUseropStub(this);
    }

    @Override
    protected PcodeExecutorState<Pair<byte[], U>> createSharedState() {
        return this.getPartsFactory().createSharedState(this, new BytesPcodeExecutorStatePiece((Language)this.language));
    }

    @Override
    protected PcodeExecutorState<Pair<byte[], U>> createLocalState(PcodeThread<Pair<byte[], U>> thread) {
        return this.getPartsFactory().createLocalState(this, thread, new BytesPcodeExecutorStatePiece((Language)this.language));
    }

    @Override
    protected PcodeThread<Pair<byte[], U>> createThread(String name) {
        return this.getPartsFactory().createThread(this, name);
    }
}

