/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import docking.widgets.fieldpanel.support.ViewerPosition;
import ghidra.app.decompiler.ClangTokenGroup;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.decompiler.DecompileResults;
import ghidra.app.decompiler.component.DecompileData;
import ghidra.app.decompiler.component.DecompilerCallbackHandler;
import ghidra.app.decompiler.component.DecompilerManager;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.decompiler.component.EmptyDecompileData;
import ghidra.app.plugin.core.decompile.DecompilerClipboardProvider;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.bean.field.AnnotatedTextFieldElement;
import java.awt.event.MouseEvent;
import java.io.File;
import utility.function.Callback;

public class DecompilerController {
    private ServiceProvider serviceProvider;
    private DecompilerPanel decompilerPanel;
    private DecompilerManager decompilerMgr;
    private final DecompilerCallbackHandler callbackHandler;
    private DecompileData currentDecompileData;
    private ProgramSelection currentSelection;
    private Cache<Function, DecompileResults> decompilerCache;
    private int cacheSize;

    public DecompilerController(ServiceProvider serviceProvider, DecompilerCallbackHandler handler, DecompileOptions options, DecompilerClipboardProvider clipboard) {
        this.serviceProvider = serviceProvider;
        this.cacheSize = options.getCacheSize();
        this.callbackHandler = handler;
        this.decompilerCache = this.buildCache();
        this.decompilerMgr = new DecompilerManager(this, options);
        this.decompilerPanel = new DecompilerPanel(this, options, clipboard, this.decompilerMgr.getTaskMonitorComponent());
        this.decompilerPanel.setHoverMode(true);
    }

    public ServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    public DecompilerPanel getDecompilerPanel() {
        return this.decompilerPanel;
    }

    public void dispose() {
        this.clearCache();
        this.decompilerMgr.dispose();
        this.decompilerPanel.dispose();
    }

    public void clear() {
        this.currentSelection = null;
        this.decompilerMgr.cancelAll();
        this.setDecompileData(new EmptyDecompileData("No Function"));
    }

    public void display(Program program, ProgramLocation location, ViewerPosition viewerPosition) {
        if (!this.decompilerMgr.isBusy() && this.decompilerPanel.containsLocation(location)) {
            this.decompilerPanel.setLocation(location, viewerPosition);
            return;
        }
        if (this.loadFromCache(program, location, viewerPosition)) {
            this.decompilerPanel.setLocation(location, viewerPosition);
            return;
        }
        this.decompilerMgr.decompile(program, location, viewerPosition, null, false);
    }

    private boolean loadFromCache(Program program, ProgramLocation location, ViewerPosition viewerPosition) {
        FunctionManager functionManager = program.getFunctionManager();
        Function function = functionManager.getFunctionContaining(location.getAddress());
        if (function == null) {
            return false;
        }
        DecompileResults results = (DecompileResults)this.decompilerCache.getIfPresent((Object)function);
        if (results == null) {
            return false;
        }
        this.decompilerMgr.cancelAll();
        this.setDecompileData(new DecompileData(program, function, location, results, null, null, viewerPosition));
        return true;
    }

    public void setSelection(ProgramSelection selection) {
        this.decompilerPanel.setSelection(selection);
    }

    public void setOptions(DecompileOptions decompilerOptions) {
        this.clearCache();
        if (decompilerOptions.getCacheSize() != this.cacheSize) {
            this.cacheSize = decompilerOptions.getCacheSize();
            this.decompilerCache = this.buildCache();
        }
        this.decompilerMgr.setOptions(decompilerOptions);
        this.decompilerPanel.optionsChanged(decompilerOptions);
    }

    public boolean isDecompiling() {
        return this.decompilerMgr.isBusy();
    }

    public void setMouseNavigationEnabled(boolean enabled) {
        this.decompilerPanel.setMouseNavigationEnabled(enabled);
    }

    public void resetDecompiler() {
        this.decompilerMgr.resetDecompiler();
    }

    public void setDecompileData(DecompileData decompileData) {
        this.updateCache(decompileData);
        this.currentDecompileData = decompileData;
        this.decompilerPanel.setDecompileData(decompileData);
        this.decompilerPanel.setSelection(this.currentSelection);
        this.callbackHandler.decompileDataChanged(decompileData);
    }

    private void updateCache(DecompileData decompileData) {
        Function function = decompileData.getFunction();
        DecompileResults results = decompileData.getDecompileResults();
        if (function != null && results != null && results.decompileCompleted()) {
            this.decompilerCache.put((Object)function, (Object)results);
        }
    }

    void decompilerStatusChanged() {
        this.callbackHandler.contextChanged();
    }

    public void doWhenNotBusy(Callback c) {
        this.callbackHandler.doWhenNotBusy(c);
    }

    public void refreshDisplay(Program program, ProgramLocation location, File debugFile) {
        this.clearCache();
        this.decompilerMgr.decompile(program, location, null, debugFile, true);
    }

    public boolean hasDecompileResults() {
        if (this.currentDecompileData != null) {
            return this.currentDecompileData.hasDecompileResults();
        }
        return false;
    }

    public ClangTokenGroup getCCodeModel() {
        return this.currentDecompileData.getCCodeMarkup();
    }

    public void setStatusMessage(String message) {
        this.callbackHandler.setStatusMessage(message);
    }

    public Program getProgram() {
        if (this.currentDecompileData != null) {
            return this.currentDecompileData.getProgram();
        }
        return null;
    }

    public Function getFunction() {
        if (this.currentDecompileData != null) {
            return this.currentDecompileData.getFunction();
        }
        return null;
    }

    public HighFunction getHighFunction() {
        if (this.currentDecompileData != null) {
            return this.currentDecompileData.getHighFunction();
        }
        return null;
    }

    public ProgramLocation getLocation() {
        if (this.currentDecompileData != null) {
            return this.currentDecompileData.getLocation();
        }
        return null;
    }

    void locationChanged(ProgramLocation programLocation) {
        this.callbackHandler.locationChanged(programLocation);
    }

    void selectionChanged(ProgramSelection programSelection) {
        this.currentSelection = programSelection;
        this.callbackHandler.selectionChanged(programSelection);
    }

    void annotationClicked(AnnotatedTextFieldElement annotation, MouseEvent event, boolean newWindow) {
        this.callbackHandler.annotationClicked(annotation, newWindow);
    }

    void goToFunction(Function function, boolean newWindow) {
        Function thunkedFunction = function.getThunkedFunction(true);
        if (thunkedFunction != null) {
            function = thunkedFunction;
        }
        this.callbackHandler.goToFunction(function, newWindow);
    }

    void goToLabel(String labelName, boolean newWindow) {
        this.callbackHandler.goToLabel(labelName, newWindow);
    }

    void goToAddress(Address addr, boolean newWindow) {
        this.callbackHandler.goToAddress(addr, newWindow);
    }

    void goToScalar(long value, boolean newWindow) {
        this.callbackHandler.goToScalar(value, newWindow);
    }

    public DecompileData getDecompileData() {
        return this.currentDecompileData;
    }

    public void exportLocation() {
        this.callbackHandler.exportLocation();
    }

    private Cache<Function, DecompileResults> buildCache() {
        return CacheBuilder.newBuilder().softValues().maximumSize((long)this.cacheSize).build();
    }

    void setCache(Cache<Function, DecompileResults> cache) {
        this.decompilerCache.invalidateAll();
        this.decompilerCache = cache;
    }

    public void clearCache() {
        this.decompilerCache.invalidateAll();
    }

    public void programClosed(Program closedProgram) {
        for (Function function : this.decompilerCache.asMap().keySet()) {
            Program functionProgram = function.getProgram();
            if (functionProgram != closedProgram) continue;
            this.decompilerCache.invalidate((Object)function);
        }
    }
}

