/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem;

import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import java.io.File;
import java.util.Objects;

public class GFileLocal
implements GFile {
    private GFileSystem fs;
    private FSRL fsrl;
    private String path;
    private File f;
    private GFile parent;

    public GFileLocal(File f, String path, FSRL fsrl, GFileSystem fs, GFile parent) {
        this.fs = fs;
        this.fsrl = fsrl;
        this.path = path;
        this.f = f;
        this.parent = parent;
    }

    @Override
    public GFileSystem getFilesystem() {
        return this.fs;
    }

    @Override
    public FSRL getFSRL() {
        return this.fsrl;
    }

    @Override
    public GFile getParentFile() {
        return this.parent;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getName() {
        return this.fsrl.getName();
    }

    @Override
    public boolean isDirectory() {
        return this.f.isDirectory();
    }

    @Override
    public long getLength() {
        return this.f.length();
    }

    public File getLocalFile() {
        return this.f;
    }

    public String toString() {
        return "Local " + this.f.toString() + " with path " + this.path;
    }

    public int hashCode() {
        return Objects.hash(this.f, this.fs, this.fsrl, this.parent, this.path);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GFileLocal)) {
            return false;
        }
        GFileLocal other = (GFileLocal)obj;
        return Objects.equals(this.f, other.f) && Objects.equals(this.fs, other.fs) && Objects.equals(this.fsrl, other.fsrl) && Objects.equals(this.parent, other.parent) && Objects.equals(this.path, other.path);
    }
}

