/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.equate;

import ghidra.app.plugin.core.equate.AbstractConvertAction;
import ghidra.app.plugin.core.equate.EquatePlugin;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;

public class ConvertToUnsignedHexAction
extends AbstractConvertAction {
    public static final String ACTION_NAME = "Convert To Unsigned Hex";

    public ConvertToUnsignedHexAction(EquatePlugin plugin) {
        super(plugin, ACTION_NAME, false);
    }

    @Override
    protected String getMenuName(Program program, Scalar scalar, boolean isData) {
        return this.getStandardLengthString("Unsigned Hex:") + this.convertToString(program, scalar, isData);
    }

    @Override
    protected String convertToString(Program program, Scalar scalar, boolean isData) {
        String valueStr = Long.toHexString(scalar.getUnsignedValue()).toUpperCase();
        if (isData) {
            return valueStr + "h";
        }
        return "0x" + valueStr;
    }

    @Override
    protected int getFormatChoice() {
        return 0;
    }
}

