/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.IntField;
import db.LongField;
import db.Schema;
import db.Table;
import java.io.IOException;

class OldVariableStorageDBAdapterV0V1 {
    static final String VARIABLE_STORAGE_TABLE_NAME = "VariableStorage";
    static final Schema VARIABLE_STORAGE_SCHEMA = new Schema(1, "Key", new Field[]{LongField.INSTANCE, LongField.INSTANCE, IntField.INSTANCE}, new String[]{"Address", "NamespaceID", "SymCount"});
    static final int STORAGE_ADDR_COL = 0;
    static final int NAMESPACE_ID_COL = 1;
    static final int SYMBOL_COUNT_COL = 2;
    private Table variableStorageTable;

    OldVariableStorageDBAdapterV0V1(DBHandle handle) throws IOException {
        this.variableStorageTable = handle.getTable(VARIABLE_STORAGE_TABLE_NAME);
        if (this.variableStorageTable == null) {
            throw new IOException("No such table: VariableStorage");
        }
        int version = this.variableStorageTable.getSchema().getVersion();
        if (version != 0 && version != 1) {
            throw new IOException("No such table schema version: " + version);
        }
    }

    DBRecord getRecord(long key) throws IOException {
        return this.variableStorageTable.getRecord(key);
    }

    DBRecord[] getRecordsForNamespace(long namespaceID) throws IOException {
        Field[] keys = this.variableStorageTable.findRecords((Field)new LongField(namespaceID), 1);
        DBRecord[] records = new DBRecord[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            records[i] = this.variableStorageTable.getRecord(keys[i]);
        }
        return records;
    }
}

