/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.dom;

import io.sf.carte.echosvg.css.dom.CSSOMValue;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.value.CSSVal;
import io.sf.carte.echosvg.css.engine.value.Value;
import java.util.HashMap;
import java.util.Map;
import org.w3c.css.om.CSSRule;
import org.w3c.css.om.CSSStyleDeclaration;
import org.w3c.dom.DOMException;

public class CSSOMComputedStyle
implements CSSStyleDeclaration {
    protected CSSEngine cssEngine;
    protected CSSStylableElement element;
    protected String pseudoElement;
    protected Map<String, CSSVal> values = new HashMap<String, CSSVal>();

    public CSSOMComputedStyle(CSSEngine e, CSSStylableElement elt, String pseudoElt) {
        this.cssEngine = e;
        this.element = elt;
        this.pseudoElement = pseudoElt;
    }

    public String getCssText() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.cssEngine.getNumberOfProperties(); ++i) {
            sb.append(this.cssEngine.getPropertyName(i));
            sb.append(": ");
            sb.append(this.cssEngine.getComputedStyle(this.element, this.pseudoElement, i).getCssText());
            sb.append(";\n");
        }
        return sb.toString();
    }

    public void setCssText(String cssText) throws DOMException {
        throw new DOMException(7, "");
    }

    public String getPropertyValue(String propertyName) {
        int idx = this.cssEngine.getPropertyIndex(propertyName);
        if (idx == -1) {
            return "";
        }
        Value v = this.cssEngine.getComputedStyle(this.element, this.pseudoElement, idx);
        return v.getCssText();
    }

    public CSSVal getCSSStyleValue(String propertyName) {
        return this.getCSSValue(propertyName);
    }

    public CSSVal getCSSValue(String propertyName) {
        int idx;
        CSSVal result = this.values.get(propertyName);
        if (result == null && (idx = this.cssEngine.getPropertyIndex(propertyName)) != -1) {
            result = this.createCSSValue(idx);
            this.values.put(propertyName, result);
        }
        return result;
    }

    public String removeProperty(String propertyName) throws DOMException {
        throw new DOMException(7, "");
    }

    public String getPropertyPriority(String propertyName) {
        return "";
    }

    public void setProperty(String propertyName, String value, String prio) throws DOMException {
        throw new DOMException(7, "");
    }

    public int getLength() {
        return this.cssEngine.getNumberOfProperties();
    }

    public String item(int index) {
        if (index < 0 || index >= this.cssEngine.getNumberOfProperties()) {
            return "";
        }
        return this.cssEngine.getPropertyName(index);
    }

    public CSSRule getParentRule() {
        return null;
    }

    protected CSSVal createCSSValue(int idx) {
        return new ComputedCSSValue(idx);
    }

    public class ComputedCSSValue
    extends CSSOMValue
    implements CSSOMValue.ValueProvider {
        private static final long serialVersionUID = 1L;
        protected int index;

        public ComputedCSSValue(int idx) {
            super(null);
            this.valueProvider = this;
            this.index = idx;
        }

        @Override
        public Value getValue() {
            return CSSOMComputedStyle.this.cssEngine.getComputedStyle(CSSOMComputedStyle.this.element, CSSOMComputedStyle.this.pseudoElement, this.index);
        }
    }
}

