# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------


# pylint: disable=protected-access

# pylint: disable=no-self-use


import argparse
from collections import defaultdict
from knack.util import CLIError


class AddTableLevelSharingProperties(argparse.Action):
    def __call__(self, parser, namespace, values, option_string=None):
        action = self.get_action(values, option_string)
        namespace.table_level_sharing_properties = action

    def get_action(self, values, option_string):
        try:
            properties = defaultdict(list)
            for (k, v) in (x.split('=', 1) for x in values):
                properties[k].append(v)
            properties = dict(properties)
        except ValueError:
            raise CLIError('usage error: {} [KEY=VALUE ...]'.format(option_string))
        d = {}
        for k in properties:
            kl = k.lower()
            v = properties[k]

            if kl == 'tables-to-include':
                d['tables_to_include'] = v

            elif kl == 'tables-to-exclude':
                d['tables_to_exclude'] = v

            elif kl == 'external-tables-to-include':
                d['external_tables_to_include'] = v

            elif kl == 'external-tables-to-exclude':
                d['external_tables_to_exclude'] = v

            elif kl == 'materialized-views-to-include':
                d['materialized_views_to_include'] = v

            elif kl == 'materialized-views-to-exclude':
                d['materialized_views_to_exclude'] = v

            else:
                raise CLIError(
                    'Unsupported Key {} is provided for parameter table-level-sharing-properties. All possible keys'
                    ' are: tables-to-include, tables-to-exclude, external-tables-to-include,'
                    ' external-tables-to-exclude, materialized-views-to-include, materialized-views-to-exclude'.format(
                        k
                    )
                )

        return d


class AddReadWriteDatabase(argparse.Action):
    def __call__(self, parser, namespace, values, option_string=None):
        action = self.get_action(values, option_string)
        namespace.read_write_database = action

    def get_action(self, values, option_string):
        try:
            properties = defaultdict(list)
            for (k, v) in (x.split('=', 1) for x in values):
                properties[k].append(v)
            properties = dict(properties)
        except ValueError:
            raise CLIError('usage error: {} [KEY=VALUE ...]'.format(option_string))
        d = {}
        for k in properties:
            kl = k.lower()
            v = properties[k]

            if kl == 'soft-delete-period':
                d['soft_delete_period'] = v[0]

            elif kl == 'hot-cache-period':
                d['hot_cache_period'] = v[0]

            elif kl == 'location':
                d['location'] = v[0]

            else:
                raise CLIError(
                    'Unsupported Key {} is provided for parameter read-write-database. All possible keys are:'
                    ' soft-delete-period, hot-cache-period, location'.format(k)
                )

        d['kind'] = 'ReadWrite'

        return d
