#!/bin/sh
# -*- mode: shell-script; indent-tabs-mode: nil; sh-basic-offset: 4; -*-
# ex: ts=8 sw=4 sts=4 et filetype=sh

# NFS root might have reached here before /tmp/net.ifaces was written
udevadm settle --timeout=30
# Don't write anything if we don't know our bootdev
[ -f /tmp/net.ifaces ] || return 1

read IFACES < /tmp/net.ifaces

if [ -e /tmp/bond.info ]; then
    . /tmp/bond.info
fi

if [ -e /tmp/bridge.info ]; then
    . /tmp/bridge.info
fi

mkdir -m 0755 -p /tmp/ifcfg/
mkdir -m 0755 -p /tmp/ifcfg-leases/

for netif in $IFACES ; do
    # bridge?
    unset bridge
    unset bond
    uuid=$(cat /proc/sys/kernel/random/uuid)
    if [ "$netif" = "$bridgename" ]; then
        bridge=yes
    elif [ "$netif" = "$bondname" ]; then
    # $netif can't be bridge and bond at the same time
        bond=yes
    fi
    cat /sys/class/net/$netif/address > /tmp/net.$netif.hwaddr
    {
        echo "# Generated by dracut initrd"
        echo "DEVICE=$netif"
        echo "ONBOOT=yes"
        echo "NETBOOT=yes"
        echo "UUID=$uuid"
        [ -n "$macaddr" ] && echo "MACADDR=$macaddr"
        [ -n "$mtu" ] && echo "MTU=$mtu"
        if [ -f /tmp/net.$netif.lease ]; then
            strstr "$ip" '*:*:*' &&
            echo "DHCPV6C=yes"
            echo "BOOTPROTO=dhcp"
            cp /tmp/net.$netif.lease /tmp/ifcfg-leases/dhclient-$uuid-$netif.lease
        else
            echo "BOOTPROTO=none"
        # If we've booted with static ip= lines, the override file is there
            [ -e /tmp/net.$netif.override ] && . /tmp/net.$netif.override
            echo "IPADDR=$ip"
            echo "NETMASK=$mask"
            [ -n "$gw" ] && echo "GATEWAY=$gw"
        fi
    } > /tmp/ifcfg/ifcfg-$netif

    # bridge needs different things written to ifcfg
    if [ -z "$bridge" ] && [ -z "$bond" ]; then
        # standard interface
        {
            echo "HWADDR=$(cat /sys/class/net/$netif/address)"
            echo "TYPE=Ethernet"
            echo "NAME=\"Boot Disk\""
            [ -n "$mtu" ] && echo "MTU=$mtu"
        } >> /tmp/ifcfg/ifcfg-$netif
    fi

    if [ -n "$bond" ] ; then
        # bond interface
        {
            # This variable is an indicator of a bond interface for initscripts
            echo "BONDING_OPTS=\"$bondoptions\""
            echo "NAME=\"Boot Disk\""
        } >> /tmp/ifcfg/ifcfg-$netif

        for slave in $bondslaves ; do
            # Set ONBOOT=no to prevent initscripts from trying to setup already bonded physical interface
            # write separate ifcfg file for the raw eth interface
            {
                echo "# Generated by dracut initrd"
                echo "DEVICE=$slave"
                echo "TYPE=Ethernet"
                echo "ONBOOT=no"
                echo "NETBOOT=yes"
                echo "HWADDR=$(cat /sys/class/net/$slave/address)"
                echo "SLAVE=yes"
                echo "MASTER=$netif"
                echo "NAME=$slave"
            } >> /tmp/ifcfg/ifcfg-$slave
        done
    fi

    if [ -n "$bridge" ] ; then
        # bridge
        {
            echo "TYPE=Bridge"
            echo "NAME=\"Boot Disk\""
        } >> /tmp/ifcfg/ifcfg-$netif
        if [ "$ethname" = "$bondname" ] ; then
            {
                # Set ONBOOT=no to prevent initscripts from trying to setup already bridged bond interface
                echo "# Generated by dracut initrd"
                echo "DEVICE=$bondname"
                echo "ONBOOT=no"
                echo "NETBOOT=yes"
                # This variable is an indicator of a bond interface for initscripts
                echo "BONDING_OPTS=\"$bondoptions\""
                echo "BRIDGE=$netif"
                echo "NAME=\"$bondname\""
            } >> /tmp/ifcfg/ifcfg-$bondname
            for slave in $bondslaves ; do
                # write separate ifcfg file for the raw eth interface
                # Set ONBOOT=no to prevent initscripts from trying to setup already bridged physical interface
                {
                    echo "# Generated by dracut initrd"
                    echo "DEVICE=$slave"
                    echo "TYPE=Ethernet"
                    echo "ONBOOT=no"
                    echo "NETBOOT=yes"
                    echo "HWADDR=$(cat /sys/class/net/$slave/address)"
                    echo "SLAVE=yes"
                    echo "MASTER=$bondname"
                    echo "NAME=$slave"
                } >> /tmp/ifcfg/ifcfg-$slave
            done
        else
            # write separate ifcfg file for the raw eth interface
            {
                echo "# Generated by dracut initrd"
                echo "DEVICE=$ethname"
                echo "TYPE=Ethernet"
                echo "ONBOOT=no"
                echo "NETBOOT=yes"
                echo "HWADDR=$(cat /sys/class/net/$ethname/address)"
                echo "BRIDGE=$netif"
                echo "NAME=$ethname"
            } >> /tmp/ifcfg/ifcfg-$ethname
        fi
    fi
done

# Pass network opts
mkdir -m 0755 -p /run/initramfs/state/etc/sysconfig/network-scripts
mkdir -m 0755 -p /run/initramfs/state/var/lib/dhclient
echo "files /etc/sysconfig/network-scripts" >> /run/initramfs/rwtab
echo "files /var/lib/dhclient" >> /run/initramfs/rwtab
{
    cp /tmp/net.* /run/initramfs/
    cp /tmp/net.$netif.resolv.conf /run/initramfs/state/etc/
    cp -a -t /run/initramfs/state/etc/sysconfig/network-scripts/ /tmp/ifcfg/*
    cp /tmp/ifcfg-leases/* /run/initramfs/state/var/lib/dhclient
} > /dev/null 2>&1
