/*
    Copyright (c) 2003 Tobias Koenig <tokoe@kde.org>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include <kabc/distributionlist.h>
#include <kabc/stdaddressbook.h>
#include <kaboutdata.h>
#include <kapplication.h>
#include <kcmdlineargs.h>

int main( int argc, char **argv )
{
  KAboutData aboutData( "distlists", I18N_NOOP( "KDE DistLists Test" ),
                        "0.1", "Test Programm", KAboutData::License_GPL,
                        I18N_NOOP( "(c) 2003 Tobias Koenig" ) );

  KApplication::disableAutoDcopRegistration();
  KCmdLineArgs::init( argc, argv, &aboutData );

  KApplication app( false, false );

  KABC::DistributionListManager manager( KABC::StdAddressBook::self() );

  // load the lists
  manager.load();

  QStringList listNames = manager.listNames();
  QStringList::Iterator it;
  for ( it = listNames.begin(); it != listNames.end(); ++it ) {
    KABC::DistributionList *list = manager.list( *it );
    printf( "%s\n", list->name().latin1() );

    QStringList emails = list->emails();
    QStringList::Iterator eit;
    for ( eit = emails.begin(); eit != emails.end(); ++eit )
      printf( "\t%s\n", (*eit).latin1() );
  }

  return 0;
}
