/**
 * @file list-accounts.c Displays a list of accounts.
 *
 * @Copyright (C) 2004-2006 Christian Hammond
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA
 */
#include <libgalago/galago.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static void
display_service(GalagoService *service)
{
	GList *l;

	printf("%s (%s):\n",
		   galago_service_get_name(service),
		   galago_service_get_id(service));

	for (l = galago_service_get_accounts(service, TRUE);
		 l != NULL;
		 l = l->next)
	{
		GalagoAccount *account = (GalagoAccount *)l->data;
		GalagoPerson *person = galago_account_get_person(account);

		printf("\t%s%s\n", galago_account_get_username(account),
			  (galago_person_is_me(person) ? " (me)" : ""));
	}

	printf("\n");
}

int
main(int argc, char **argv)
{
	char *service_id = NULL;

	if (!galago_init("list-accounts-test", GALAGO_INIT_CLIENT) ||
		!galago_is_connected())
	{
		fprintf(stderr, "Unable to connect to the Galago service.\n");
		exit(1);
	}

	if (argc > 1)
		service_id = argv[1];

	if (service_id == NULL)
	{
		GList *l;

		for (l = galago_get_services(GALAGO_REMOTE, TRUE);
			 l != NULL;
			 l = l->next)
		{
			display_service((GalagoService *)l->data);
		}
	}
	else
	{
		GalagoService *service;

		service = galago_get_service(service_id, GALAGO_REMOTE, TRUE);

		if (service == NULL)
			printf("%s is not a known service\n", service_id);
		else
			display_service(service);
	}

	return 0;
}
