/* wptMDSumDlg.cpp
 *	Copyright (C) 2003 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <windows.h>
#include <stdio.h>
#include "../resource.h"

#include "wptTypes.h"
#include "wptW32API.h"
#include "wptGPG.h"
#include "wptCommonCtl.h"
#include "wptContext.h"
#include "wptNLS.h"
#include "wptErrors.h"


static const char *
printable_digest( byte *mdbuf, size_t n )
{
    static char mdasc[64];
    size_t i;
    for( i = 0; i < n; i++ )
	sprintf( mdasc+2*i, "%02X", mdbuf[i] );
    return mdasc;
} /* printable_digest */


BOOL CALLBACK
mdsum_dlg_proc( HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam )
{
    static listview_ctrl_t lv;
    static struct md_file_s * md;
    struct listview_column_s cols[] = {
        {0, 264, (char *)_("Digest")},
        {1, 128, (char *)_("Name")},
        {0, 0, 0}
    };
    gpgme_data_t sumlist;
    char fname[300], mdasc[64], buf[128];
    byte mdbuf[20];
    int i;
    size_t n;

    switch( msg ) {
    case WM_INITDIALOG:
	md = (md_file_s *)lparam;
	if( !md )
	    BUG( NULL );	
	if( listview_new( &lv ) )
	    BUG( NULL );
	lv->ctrl = GetDlgItem( dlg, IDC_MDSUM_LIST );
	for( i = 0; i < cols[i].width; i++ )
	    listview_add_column( lv, &cols[i] );
	for( i = 0; i < listview_count_items( md->lv, 0 ); i++ ) {
	    if( listview_get_item_state( md->lv, i ) ) {
		listview_get_item_text( md->lv, i, 1, fname, sizeof fname-1 );
		if( !gpg_md_hash_file( md->mdalgo, fname, mdbuf, &n ) ) {
		    listview_add_item( lv, "" );
		    listview_add_sub_item( lv, 0, 0, printable_digest( mdbuf, n ) );
		    listview_add_sub_item( lv, 0, 1, fname );
		}
	    }
	}
	SetForegroundWindow( dlg );
	break;

    case WM_DESTROY:
	if( lv ) {
	    listview_release( lv );
	    lv = NULL;
	}
	break;

    case WM_COMMAND:
	switch( LOWORD( wparam ) ) {
	case IDOK:
	    EndDialog( dlg, TRUE );
	    break;

	case IDC_MDSUM_COPY:
	    if( gpgme_data_new( &sumlist ) )
		BUG( NULL );
	    sprintf( buf, "--- begin %s digest list ---\r\n",
		md->mdalgo == 1? "MD5" : md->mdalgo == 2? "SHA-1" :
		md->mdalgo == 3? "RIPEMD160" : "UNKNOWN" );		
	    gpgme_data_write( sumlist, buf, strlen( buf ) );
	    for( i = 0; i < listview_count_items( lv, 0 ); i++ ) {
		listview_get_item_text( lv, i, 0, mdasc, sizeof mdasc-1 );
		listview_get_item_text( lv, i, 1, fname, sizeof fname-1 );
		
		gpgme_data_write( sumlist, mdasc, strlen( mdasc ) );
		gpgme_data_write( sumlist, " ", 1 );
		gpgme_data_write( sumlist, fname, strlen( fname ) );
		gpgme_data_write( sumlist, "\r\n", 2 );
	    }
	    gpgme_data_write( sumlist, "--- end digest list ---\r\n", 25 );
	    gpgme_data_release_and_set_clipboard( sumlist );
	    break;
	}
	break;
    }
    return FALSE;
} /* mdsum_dlg_proc */
