/* wptDateDlg.cpp - Universal dialog to ask for a date
 *	Copyright (C) 2001, 2002, 2003 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>
#include <commctrl.h>

#include "../resource.h"
#include "wptGPG.h" /* for GpgmeRecipients */
#include "wptCommonCtl.h"
#include "wptContext.h"
#include "wptDlgs.h"
#include "wptTypes.h"


BOOL CALLBACK
date_dlg_proc( HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam )
{
    static date_s * udd;
    
    switch( msg ) {
    case WM_INITDIALOG:
        udd = (date_s *)lparam;
        if( udd == NULL )
            dlg_fatal_error( dlg, "Can't get dialog param" );
        if( udd->text )
            SetWindowText( dlg, udd->text );
        SetForegroundWindow( dlg );
        return TRUE;
        
    case WM_SYSCOMMAND:
        if( LOWORD( wparam ) == SC_CLOSE ) {
            udd->cancel = 1;
            EndDialog( dlg, TRUE );
        }
        return FALSE;
        
    case WM_COMMAND:
        switch( LOWORD( wparam) ) {
        case IDOK:
            DateTime_GetSystemtime( GetDlgItem( dlg, IDC_DATE_DTP ), &udd->st );
            udd->cancel = 0;
            EndDialog( dlg, TRUE );
            return TRUE;
        }
        break;
    }
    
    return FALSE;
} /* date_dlg_proc */
