#ifndef GPGLIB_PACKET_H
#define GPGLIB_PACKET_H

int copy_all_packets( gpg_iobuf_t inp, gpg_iobuf_t out );
int copy_some_packets( gpg_iobuf_t inp, gpg_iobuf_t out, _off_t stopoff );
int skip_some_packets( gpg_iobuf_t inp, unsigned n );
int set_packet_list_mode( int mode );
int search_packet( gpg_iobuf_t inp, PACKET *pkt, _off_t *retpos, int with_uid );

const byte *enum_sig_subpkt ( const subpktarea_t *subpkts,
                              sigsubpkttype_t reqtype,
                              size_t *ret_n, int *start, int *critical );

const byte * get_session_marker( size_t *rlen );

void free_symkey_enc( PKT_symkey_enc *enc );
void free_pubkey_enc( PKT_pubkey_enc *enc );
void free_seckey_enc( PKT_signature *enc );
int  digest_algo_from_sig( PKT_signature *sig );
void release_public_key_parts( PKT_public_key *pk );
void free_public_key( PKT_public_key *key );
void release_secret_key_parts( PKT_secret_key *sk );
void free_secret_key( PKT_secret_key *sk );
void free_attributes(PKT_user_id *uid);
void free_user_id( PKT_user_id *uid );
void free_comment( PKT_comment *rem );


int parse_one_sig_subpkt( const byte *buffer, size_t n, int type );
void parse_revkeys(PKT_signature *sig);
int parse_attribute_subpkts(PKT_user_id *uid);
void make_attribute_uidname(PKT_user_id *uid);

prefitem_t *copy_prefs (const prefitem_t *prefs);

void copy_public_parts_to_secret_key( PKT_public_key *pk, PKT_secret_key *sk );

/*-- armor.c --*/
void print_string( FILE *fp, const byte *p, size_t n, int delim );
const char* get_armor_error( void );

#endif /*GPGLIB_PACKET_H*/