/* wptTrayPop.cpp - Alternative status box
 *	Copyright (C) 2002, 2004 Timo Schulz
 *	Copyright (C) 2002 Prasenjeet Dutta. <http://www.chaoszone.org>
 * 
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * as published by the Free Software Foundation; either version 2 
 * of the License, or (at your option) any later version.
 *  
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *
 */

/*
 * ChangeLog
 * Maybe I didn't understand how to use the code, but the original code
 * always produces a window near the taskbar icon. This is not very useful
 * because we need it near the dialog. I also removed some code we don't use.
 * -ts
 */

#include <windows.h>

#define PD_WINDOWNAME "ClsTrayPop"
#define PD_TIMER_IDENTIFIER 23
#define PD_TIMER_TIMEOUT 1500

#define PD_TRAYPOP_WIDTH 200
#define PD_TRAYPOP_HEIGHT 80

extern HINSTANCE glob_hinst;
extern HWND glob_hwnd;


static LPCTSTR 
store_text( LPCTSTR alert_text )
{
    static LPCTSTR text;

    if( alert_text )
	text = alert_text;
    return text;
} /* store_text */


static void 
paint_alert (HDC *p_hdc, PAINTSTRUCT *p_ps)
{
    SetBkMode(*p_hdc, TRANSPARENT);
    HFONT hFont = CreateFont(
        13, // height of font (in css px-style)
        0, // average character width
        0, // angle of escapement
        0, // base-line orientation angle
        FW_DONTCARE, // font weight
        FALSE, // italic attribute option
        FALSE, // underline attribute option
        FALSE, // strikeout attribute option
        // TODO: future i18n problem, see docs
        DEFAULT_CHARSET, // character set identifier
        OUT_DEFAULT_PRECIS, // output precision
        CLIP_DEFAULT_PRECIS, // clipping precision
        DEFAULT_QUALITY, // output quality
        FF_DONTCARE, // pitch and family
        "Tahoma" // typeface name
	);
    
    HFONT hOldFont = (HFONT) SelectObject(*p_hdc, hFont);
    RECT recttext;
    recttext.top = 0;
    recttext.bottom = PD_TRAYPOP_HEIGHT - 2;
    recttext.left = 10;
    recttext.right = PD_TRAYPOP_WIDTH - 12;
    
    MoveToEx(*p_hdc, 0, 0, (LPPOINT) NULL); 
    LineTo(*p_hdc, PD_TRAYPOP_WIDTH - 3, 0);
    LineTo(*p_hdc, PD_TRAYPOP_WIDTH - 3, PD_TRAYPOP_HEIGHT - 3);
    LineTo(*p_hdc, 0, PD_TRAYPOP_HEIGHT - 3);
    LineTo(*p_hdc, 0, 0);
    
    UINT dtFormat = DT_END_ELLIPSIS | DT_NOPREFIX |	DT_WORDBREAK;
    
    // determine text height
    int text_height = DrawText(
        *p_hdc, // handle to DC
        store_text(NULL), // text to draw
        -1, // text length // TODO: future i18n problem, see docs
        &recttext, // formatting dimensions
        dtFormat | DT_CENTER | DT_CALCRECT
	);
    
    // vertically center text in the box
    recttext.top = PD_TRAYPOP_HEIGHT/2 - text_height/2 - 5;
    recttext.bottom = PD_TRAYPOP_HEIGHT/2 + text_height/2 + 5;
    recttext.left = 10;
    recttext.right = PD_TRAYPOP_WIDTH - 12;
    
    // change over to left-justified from centered, for longer lines
    (text_height > 30)? (dtFormat |= DT_LEFT) : (dtFormat |= DT_CENTER);
    
    DrawText (*p_hdc,
	      store_text (NULL),
	      -1, // text length // TODO: future i18n problem, see docs
	      &recttext, // formatting dimensions
	      dtFormat);
    
    hFont = (HFONT) SelectObject(*p_hdc, hOldFont);
    DeleteObject(hFont);
} /* paint_alert */


static LRESULT CALLBACK
WndProc (HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
    PAINTSTRUCT ps;
    HDC hdc;
    
    switch (msg) 
    {
    case WM_PAINT:
	hdc = BeginPaint (hWnd, &ps);
	paint_alert (&hdc, &ps);
	EndPaint (hWnd, &ps);
	break;

    case WM_LBUTTONUP:
	KillTimer (hWnd, PD_TIMER_IDENTIFIER);
	PostQuitMessage (1);
	break;
        
    case WM_DESTROY:
	KillTimer (hWnd, PD_TIMER_IDENTIFIER);
	PostQuitMessage (1);
	break;
        
    default:
	return DefWindowProc (hWnd, msg, wParam, lParam);
    }
    
    return 0;
} /* WndProc */


static VOID CALLBACK 
popup_timer_proc( HWND hwnd, UINT uMsg, UINT_PTR idEvent, DWORD dwTime)
{	
    DestroyWindow(hwnd);
} /* popup_timer_proc */


static void 
init_wclass (WNDCLASS *p_wclass, HINSTANCE hInst)
{
    p_wclass->style = CS_HREDRAW | CS_VREDRAW;
    p_wclass->lpfnWndProc = WndProc;
    p_wclass->cbClsExtra = 0;
    p_wclass->cbWndExtra = 0;
    p_wclass->hInstance = hInst;
    p_wclass->hIcon = LoadIcon(hInst, IDI_APPLICATION);
    p_wclass->hCursor = LoadCursor(NULL, IDC_ARROW);
    p_wclass->hbrBackground = (HBRUSH) (COLOR_INFOBK + 1);
    p_wclass->lpszMenuName = NULL;
    p_wclass->lpszClassName = PD_WINDOWNAME;
} /* init_wclass */


int 
show_msg (HWND hParentWnd, int millis, LPCTSTR string)
{    
    RECT parent;
    int nWndWidth = PD_TRAYPOP_WIDTH;
    int nWndHeight = PD_TRAYPOP_HEIGHT;
    MSG msg;
    HWND hWnd;
    UINT_PTR timer;
    WNDCLASS wClass;
    
    store_text (string);
    GetWindowRect (hParentWnd, &parent);
    
    init_wclass (&wClass, glob_hinst);
    RegisterClass (&wClass);
    
    hWnd = CreateWindowEx(
	WS_EX_TOOLWINDOW | WS_EX_TOPMOST, // extended style	
	PD_WINDOWNAME, // class name        
	PD_WINDOWNAME, // window name
        WS_POPUP, // window style
        (parent.right + parent.left) / 2, (parent.bottom + parent.top) / 2,
        nWndWidth - 2, nWndHeight - 2, // width and height, with corrections
        NULL, // parent handle
        NULL, // menu handle
        glob_hinst, // instance handle
        NULL // other parameters
	);                        
    
    if (hWnd == NULL)
        return 0; 
    else {
        ShowWindow(hWnd, SW_SHOW);
        UpdateWindow(hWnd);
        // ensure parent never loses focus
        EnableWindow(hParentWnd, TRUE);
        SetActiveWindow(NULL);
    }
    
    timer = SetTimer(
	hWnd, // handle to window
	PD_TIMER_IDENTIFIER, // timer identifier
	millis, // time-out value
	(TIMERPROC) popup_timer_proc // timer procedure	
	);
    
    while( GetMessage(&msg, NULL, 0, 0) ) {
	TranslateMessage(&msg);
	DispatchMessage(&msg);	
    }
    
    return msg.wParam;
} /* show_alert */
