//---------------------------------------------------------------------------
// GPGee - GNU Privacy Guard Explorer Extension
// GPGeeExceptions.h - GPGee-specific exception classes
// Copyright 2005, Kurt Fitzner <kfitzner@excelcia.org>
//---------------------------------------------------------------------------
// This file is part of GPGee.
//
// GPGee is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License (Version 2) as
// published by the Free Software Foundation.
//
// GPGee is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// General GPGME Error
//
class EGPGMEError : public Exception {
public:
  __fastcall EGPGMEError(const AnsiString Msg): Exception(Msg) {};
	__fastcall EGPGMEError(const AnsiString Msg, const System::TVarRec * Args, const int Args_Size): Exception(Msg, Args, Args_Size) {};
	__fastcall EGPGMEError(int Ident): Exception(Ident) {};
	__fastcall EGPGMEError(System::PResStringRec ResStringRec): Exception(ResStringRec) {};
	__fastcall EGPGMEError(int Ident, const System::TVarRec * Args, const int Args_Size): Exception(Ident, Args, Args_Size) {};
	__fastcall EGPGMEError(System::PResStringRec ResStringRec, const System::TVarRec * Args, const int Args_Size): Exception(ResStringRec, Args, Args_Size) {};
	__fastcall EGPGMEError(const AnsiString Msg, int AHelpContext): Exception(Msg, AHelpContext) {};
	__fastcall EGPGMEError(const AnsiString Msg, const System::TVarRec * Args, const int Args_Size, int AHelpContext): Exception(Msg, Args, Args_Size, AHelpContext) {};
	__fastcall EGPGMEError(int Ident, int AHelpContext): Exception(Ident, AHelpContext) {};
	__fastcall EGPGMEError(System::PResStringRec ResStringRec, int AHelpContext): Exception(ResStringRec, AHelpContext) {};
	__fastcall EGPGMEError(System::PResStringRec ResStringRec, const System::TVarRec * Args, const int Args_Size, int AHelpContext): Exception(ResStringRec, Args, Args_Size) {};
	__fastcall EGPGMEError(int Ident, const System::TVarRec * Args, const int Args_Size, int AHelpContext): Exception(Ident, Args, Args_Size, AHelpContext) {};
}; // class EGPGMEError
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// GPGME encountered an error during a system call of some sort.
//
class EGPGMESystemError : public Exception {
public:
  __fastcall EGPGMESystemError(const AnsiString Msg): Exception(Msg) {};
	__fastcall EGPGMESystemError(const AnsiString Msg, const System::TVarRec * Args, const int Args_Size): Exception(Msg, Args, Args_Size) {};
	__fastcall EGPGMESystemError(int Ident): Exception(Ident) {};
	__fastcall EGPGMESystemError(System::PResStringRec ResStringRec): Exception(ResStringRec) {};
	__fastcall EGPGMESystemError(int Ident, const System::TVarRec * Args, const int Args_Size): Exception(Ident, Args, Args_Size) {};
	__fastcall EGPGMESystemError(System::PResStringRec ResStringRec, const System::TVarRec * Args, const int Args_Size): Exception(ResStringRec, Args, Args_Size) {};
	__fastcall EGPGMESystemError(const AnsiString Msg, int AHelpContext): Exception(Msg, AHelpContext) {};
	__fastcall EGPGMESystemError(const AnsiString Msg, const System::TVarRec * Args, const int Args_Size, int AHelpContext): Exception(Msg, Args, Args_Size, AHelpContext) {};
	__fastcall EGPGMESystemError(int Ident, int AHelpContext): Exception(Ident, AHelpContext) {};
	__fastcall EGPGMESystemError(System::PResStringRec ResStringRec, int AHelpContext): Exception(ResStringRec, AHelpContext) {};
	__fastcall EGPGMESystemError(System::PResStringRec ResStringRec, const System::TVarRec * Args, const int Args_Size, int AHelpContext): Exception(ResStringRec, Args, Args_Size) {};
	__fastcall EGPGMESystemError(int Ident, const System::TVarRec * Args, const int Args_Size, int AHelpContext): Exception(Ident, Args, Args_Size, AHelpContext) {};
}; // class EGPGMESystemError
//---------------------------------------------------------------------------

