/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.mode;

import gnu.crypto.cipher.IBlockCipher;
import gnu.crypto.mac.IMac;
import gnu.crypto.mac.MacFactory;
import gnu.crypto.mode.IAuthenticatedMode;
import gnu.crypto.mode.IMode;
import gnu.crypto.mode.ModeFactory;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EAX
implements IAuthenticatedMode {
    private static boolean valid = false;
    private int tagSize;
    private IMac nonceOmac;
    private IMac headerOmac;
    private IMac msgOmac;
    private IMode ctr;
    private int state;
    private boolean init;
    private int cipherBlockSize;
    private IBlockCipher cipher;
    private byte[] t_n;

    public Object clone() {
        return new EAX((IBlockCipher)this.cipher.clone(), this.cipherBlockSize);
    }

    public String name() {
        return "eax(" + this.cipher.name() + ')';
    }

    public int defaultBlockSize() {
        return this.ctr.defaultBlockSize();
    }

    public int defaultKeySize() {
        return this.ctr.defaultKeySize();
    }

    public Iterator blockSizes() {
        return this.ctr.blockSizes();
    }

    public Iterator keySizes() {
        return this.ctr.keySizes();
    }

    public void init(Map attrib) throws InvalidKeyException {
        Integer ts;
        byte[] nonce = (byte[])attrib.get("gnu.crypto.mode.iv");
        if (nonce == null) {
            throw new IllegalArgumentException("no nonce provided");
        }
        byte[] key = (byte[])attrib.get("gnu.crypto.cipher.key.material");
        if (key == null) {
            throw new IllegalArgumentException("no key provided");
        }
        Arrays.fill(this.t_n, (byte)0);
        this.nonceOmac.reset();
        this.nonceOmac.init(Collections.singletonMap("gnu.crypto.mac.key.material", key));
        this.nonceOmac.update(this.t_n, 0, this.t_n.length);
        this.nonceOmac.update(nonce, 0, nonce.length);
        byte[] N = this.nonceOmac.digest();
        this.nonceOmac.reset();
        this.nonceOmac.update(this.t_n, 0, this.t_n.length);
        this.nonceOmac.update(nonce, 0, nonce.length);
        this.t_n[this.t_n.length - 1] = 1;
        this.headerOmac.reset();
        this.headerOmac.init(Collections.singletonMap("gnu.crypto.mac.key.material", key));
        this.headerOmac.update(this.t_n, 0, this.t_n.length);
        this.t_n[this.t_n.length - 1] = 2;
        this.msgOmac.reset();
        this.msgOmac.init(Collections.singletonMap("gnu.crypto.mac.key.material", key));
        this.msgOmac.update(this.t_n, 0, this.t_n.length);
        Integer modeSize = (Integer)attrib.get("gnu.crypto.mode.block.size");
        if (modeSize == null) {
            modeSize = new Integer(this.cipherBlockSize);
        }
        HashMap<String, Object> ctrAttr = new HashMap<String, Object>();
        ctrAttr.put("gnu.crypto.cipher.key.material", key);
        ctrAttr.put("gnu.crypto.mode.iv", N);
        ctrAttr.put("gnu.crypto.mode.state", new Integer(1));
        ctrAttr.put("gnu.crypto.mode.block.size", modeSize);
        this.ctr.reset();
        this.ctr.init(ctrAttr);
        Integer st = (Integer)attrib.get("gnu.crypto.mode.state");
        if (st != null) {
            this.state = st;
            if (this.state != 1 && this.state != 2) {
                throw new IllegalArgumentException("invalid state");
            }
        } else {
            this.state = 1;
        }
        this.tagSize = (ts = (Integer)attrib.get("gnu.crypto.mac.truncated.size")) != null ? ts : this.cipherBlockSize;
        if (this.tagSize < 0 || this.tagSize > this.cipherBlockSize) {
            throw new IllegalArgumentException("tag size out of range");
        }
        this.init = true;
    }

    public int currentBlockSize() {
        return this.ctr.currentBlockSize();
    }

    public void encryptBlock(byte[] in, int inOff, byte[] out, int outOff) {
        if (!this.init) {
            throw new IllegalStateException("not initialized");
        }
        if (this.state != 1) {
            throw new IllegalStateException("not encrypting");
        }
        this.ctr.update(in, inOff, out, outOff);
        this.msgOmac.update(out, outOff, this.ctr.currentBlockSize());
    }

    public void decryptBlock(byte[] in, int inOff, byte[] out, int outOff) {
        if (!this.init) {
            throw new IllegalStateException("not initialized");
        }
        if (this.state != 2) {
            throw new IllegalStateException("not decrypting");
        }
        this.msgOmac.update(in, inOff, this.ctr.currentBlockSize());
        this.ctr.update(in, inOff, out, outOff);
    }

    public void update(byte[] in, int inOff, byte[] out, int outOff) {
        switch (this.state) {
            case 1: {
                this.encryptBlock(in, inOff, out, outOff);
                break;
            }
            case 2: {
                this.decryptBlock(in, inOff, out, outOff);
                break;
            }
            default: {
                throw new IllegalStateException("impossible state " + this.state);
            }
        }
    }

    public void reset() {
        this.nonceOmac.reset();
        this.headerOmac.reset();
        this.msgOmac.reset();
        this.ctr.reset();
    }

    public boolean selfTest() {
        return true;
    }

    public int macSize() {
        return this.tagSize;
    }

    public byte[] digest() {
        byte[] tag = new byte[this.tagSize];
        this.digest(tag, 0);
        return tag;
    }

    public void digest(byte[] out, int outOffset) {
        if (outOffset < 0 || outOffset + this.tagSize > out.length) {
            throw new IndexOutOfBoundsException();
        }
        byte[] N = this.nonceOmac.digest();
        byte[] H = this.headerOmac.digest();
        byte[] M = this.msgOmac.digest();
        int i = 0;
        while (i < this.tagSize) {
            out[outOffset + i] = (byte)(N[i] ^ H[i] ^ M[i]);
            ++i;
        }
        this.reset();
    }

    public void update(byte b) {
        if (!this.init) {
            throw new IllegalStateException("not initialized");
        }
        this.headerOmac.update(b);
    }

    public void update(byte[] buf, int off, int len) {
        if (!this.init) {
            throw new IllegalStateException("not initialized");
        }
        this.headerOmac.update(buf, off, len);
    }

    public EAX(IBlockCipher cipher, int cipherBlockSize) {
        this.cipher = cipher;
        this.cipherBlockSize = cipherBlockSize;
        String name = cipher.name();
        int i = name.indexOf(45);
        if (i >= 0) {
            name = name.substring(0, i);
        }
        String omacname = "omac-" + name;
        this.nonceOmac = MacFactory.getInstance(omacname);
        this.headerOmac = MacFactory.getInstance(omacname);
        this.msgOmac = MacFactory.getInstance(omacname);
        this.ctr = ModeFactory.getInstance("ctr", cipher, cipherBlockSize);
        this.t_n = new byte[cipherBlockSize];
        this.init = false;
    }
}

