/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.gnu.crypto.jce;

import gnu.crypto.jce.GnuCrypto;
import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Iterator;

public class TestOfProvider
implements Testlet {
    public void test(TestHarness harness) {
        this.setUp();
        this.testProviderName(harness);
        this.testSha(harness);
        this.testWhirlpool(harness);
        this.testShaPRNG(harness);
        this.testWhirlpoolPRNG(harness);
        this.testGNUSecureRandoms(harness);
    }

    public void testProviderName(TestHarness harness) {
        harness.checkPoint("testProviderName");
        Provider us = Security.getProvider("GNU-CRYPTO");
        harness.check("GNU-CRYPTO".equals(us.getName()));
    }

    public void testSha(TestHarness harness) {
        harness.checkPoint("testSha");
        try {
            MessageDigest md = MessageDigest.getInstance("SHA", "GNU-CRYPTO");
            harness.check(md != null);
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("testSha()");
        }
    }

    public void testWhirlpool(TestHarness harness) {
        harness.checkPoint("testWhirlpool");
        try {
            MessageDigest md = MessageDigest.getInstance("Whirlpool", "GNU-CRYPTO");
            harness.check(md != null);
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("testWhirlpool()");
        }
    }

    public void testShaPRNG(TestHarness harness) {
        harness.checkPoint("testShaPRNG");
        try {
            SecureRandom rnd = SecureRandom.getInstance("SHA1PRNG", "GNU-CRYPTO");
            harness.check(rnd != null);
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("testShaPRNG()");
        }
    }

    public void testWhirlpoolPRNG(TestHarness harness) {
        harness.checkPoint("testWhirlpoolPRNG");
        try {
            SecureRandom rnd = SecureRandom.getInstance("WHIRLPOOLPRNG", "GNU-CRYPTO");
            harness.check(rnd != null);
        }
        catch (Exception x) {
            x.printStackTrace(System.err);
            harness.fail("testWhirlpoolPRNG()");
        }
    }

    public void testGNUSecureRandoms(TestHarness harness) {
        harness.checkPoint("testGNUSecureRandoms");
        Iterator it = GnuCrypto.getSecureRandomNames().iterator();
        while (it.hasNext()) {
            String rand = (String)it.next();
            try {
                SecureRandom algorithm = null;
                algorithm = SecureRandom.getInstance(rand, "GNU-CRYPTO");
                harness.check(algorithm != null, "getInstance(" + String.valueOf(rand) + ")");
            }
            catch (NoSuchProviderException x) {
                harness.fail("getInstance(" + String.valueOf(rand) + "): " + String.valueOf(x));
            }
            catch (NoSuchAlgorithmException x) {
                harness.fail("getInstance(" + String.valueOf(rand) + "): " + String.valueOf(x));
            }
        }
    }

    private void setUp() {
        Security.addProvider((Provider)new GnuCrypto());
    }
}

