/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.gnu.crypto.hash;

import gnu.crypto.hash.IMessageDigest;
import gnu.crypto.hash.RipeMD160;
import gnu.crypto.util.Util;
import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;

public class TestOfRipeMD160
implements Testlet {
    private IMessageDigest algorithm;
    private IMessageDigest clone;

    public void test(TestHarness harness) {
        String exp;
        byte[] md;
        harness.checkPoint("TestOfRipeMD160");
        try {
            this.algorithm = new RipeMD160();
            harness.check(this.algorithm.selfTest(), "selfTest");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfRipeMD160.selfTest");
        }
        try {
            this.algorithm = new RipeMD160();
            this.algorithm.update("a".getBytes(), 0, 1);
            md = this.algorithm.digest();
            exp = "0BDC9D2D256B3EE9DAAE347BE6F4DC835A467FFE";
            harness.check(exp.equals(Util.toString((byte[])md)), "testA");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfRipeMD160.testA");
        }
        try {
            this.algorithm = new RipeMD160();
            this.algorithm.update("abc".getBytes(), 0, 3);
            md = this.algorithm.digest();
            exp = "8EB208F7E05D987A9B044A8E98C6B087F15A0BFC";
            harness.check(exp.equals(Util.toString((byte[])md)), "testABC");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfRipeMD160.testABC");
        }
        try {
            this.algorithm = new RipeMD160();
            this.algorithm.update("message digest".getBytes(), 0, 14);
            md = this.algorithm.digest();
            exp = "5D0689EF49D2FAE572B881B123A85FFA21595F36";
            harness.check(exp.equals(Util.toString((byte[])md)), "testMessageDigest");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfRipeMD160.testMessageDigest");
        }
        try {
            this.algorithm = new RipeMD160();
            this.algorithm.update("abcdefghijklmnopqrstuvwxyz".getBytes(), 0, 26);
            md = this.algorithm.digest();
            exp = "F71C27109C692C1B56BBDCEB5B9D2865B3708DBC";
            harness.check(exp.equals(Util.toString((byte[])md)), "testAlphabet");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfRipeMD160.testAlphabet");
        }
        try {
            this.algorithm = new RipeMD160();
            this.algorithm.update("a".getBytes(), 0, 1);
            this.clone = (IMessageDigest)this.algorithm.clone();
            md = this.algorithm.digest();
            exp = "0BDC9D2D256B3EE9DAAE347BE6F4DC835A467FFE";
            harness.check(exp.equals(Util.toString((byte[])md)), "testCloning #1");
            this.clone.update("bc".getBytes(), 0, 2);
            md = this.clone.digest();
            exp = "8EB208F7E05D987A9B044A8E98C6B087F15A0BFC";
            harness.check(exp.equals(Util.toString((byte[])md)), "testCloning #2");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfRipeMD160.testCloning");
        }
    }
}

