/* valagtypemodule.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valagtypemodule.h>
#include <vala/valatypesymbol.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valacodenode.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include <vala/valasymbol.h>
#include <ccode/valaccodestruct.h>
#include <ccode/valaccodenewline.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodemacroreplacement.h>
#include <vala/valasourcefile.h>
#include <ccode/valaccodetypedefinition.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodecomment.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodeblock.h>
#include <ccode/valaccodedeclaration.h>
#include <vala/valadatatype.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeifstatement.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodestatement.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodeassignment.h>
#include <vala/valaobjecttypesymbol.h>
#include <gee/list.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valaproperty.h>
#include <ccode/valaccodefunctioncall.h>
#include <vala/valasignal.h>
#include <vala/valamethod.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodefragment.h>
#include <vala/valacodecontext.h>
#include <gobject/valaccodebasemodule.h>
#include <gobject/valaccodedeclarationspace.h>
#include <gobject/valainterfaceregisterfunction.h>
#include <gobject/valatyperegisterfunction.h>
#include <gobject/valastructregisterfunction.h>




enum  {
	VALA_GTYPE_MODULE_DUMMY_PROPERTY
};
static void vala_gtype_module_real_visit_interface (ValaCCodeModule* base, ValaInterface* iface);
static void vala_gtype_module_add_interface_base_init_function (ValaGTypeModule* self, ValaInterface* iface);
static void vala_gtype_module_real_visit_struct (ValaCCodeModule* base, ValaStruct* st);
static gpointer vala_gtype_module_parent_class = NULL;



ValaGTypeModule* vala_gtype_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaGTypeModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaGTypeModule*) vala_gerror_module_construct (object_type, codegen, next);
	return self;
}


ValaGTypeModule* vala_gtype_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_gtype_module_construct (VALA_TYPE_GTYPE_MODULE, codegen, next);
}


static void vala_gtype_module_real_visit_interface (ValaCCodeModule* base, ValaInterface* iface) {
	ValaGTypeModule * self;
	ValaSymbol* _tmp1;
	ValaSymbol* _tmp0;
	ValaTypeSymbol* _tmp3;
	ValaTypeSymbol* _tmp2;
	char* _tmp4;
	gboolean _tmp5;
	ValaCCodeDeclarationSpace* decl_space;
	ValaCCodeStruct* _tmp14;
	char* _tmp13;
	char* _tmp12;
	ValaCCodeNewline* _tmp15;
	char* _tmp16;
	char* _tmp17;
	char* macro;
	ValaCCodeMacroReplacement* _tmp19;
	char* _tmp18;
	char* _tmp22;
	char* _tmp21;
	char* _tmp20;
	ValaCCodeMacroReplacement* _tmp25;
	char* _tmp24;
	char* _tmp23;
	char* _tmp27;
	char* _tmp26;
	ValaCCodeMacroReplacement* _tmp30;
	char* _tmp29;
	char* _tmp28;
	char* _tmp33;
	char* _tmp32;
	char* _tmp31;
	ValaCCodeMacroReplacement* _tmp36;
	char* _tmp35;
	char* _tmp34;
	ValaCCodeNewline* _tmp37;
	ValaInterfaceRegisterFunction* type_fun;
	ValaCCodeFragment* _tmp50;
	ValaTypeSymbol* _tmp51;
	self = (ValaGTypeModule*) base;
	g_return_if_fail (iface != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	((ValaCCodeBaseModule*) self)->current_symbol = (_tmp1 = (_tmp0 = (ValaSymbol*) iface, (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0)), (((ValaCCodeBaseModule*) self)->current_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_symbol), NULL)), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	((ValaCCodeBaseModule*) self)->current_type_symbol = (_tmp3 = (_tmp2 = (ValaTypeSymbol*) iface, (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2)), (((ValaCCodeBaseModule*) self)->current_type_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_type_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_type_symbol), NULL)), _tmp3);
	_tmp4 = NULL;
	if ((_tmp5 = g_utf8_strlen (_tmp4 = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE), -1) < 3, _tmp4 = (g_free (_tmp4), NULL), _tmp5)) {
		char* _tmp7;
		char* _tmp6;
		vala_code_node_set_error ((ValaCodeNode*) iface, TRUE);
		_tmp7 = NULL;
		_tmp6 = NULL;
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) iface), _tmp7 = g_strdup_printf ("Interface name `%s' is too short", _tmp6 = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE)));
		_tmp7 = (g_free (_tmp7), NULL);
		_tmp6 = (g_free (_tmp6), NULL);
		return;
	}
	decl_space = NULL;
	if (vala_symbol_get_access ((ValaSymbol*) iface) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeDeclarationSpace* _tmp9;
		ValaCCodeDeclarationSpace* _tmp8;
		_tmp9 = NULL;
		_tmp8 = NULL;
		decl_space = (_tmp9 = (_tmp8 = ((ValaCCodeBaseModule*) self)->header_declarations, (_tmp8 == NULL) ? NULL : vala_ccode_declaration_space_ref (_tmp8)), (decl_space == NULL) ? NULL : (decl_space = (vala_ccode_declaration_space_unref (decl_space), NULL)), _tmp9);
	} else {
		ValaCCodeDeclarationSpace* _tmp11;
		ValaCCodeDeclarationSpace* _tmp10;
		_tmp11 = NULL;
		_tmp10 = NULL;
		decl_space = (_tmp11 = (_tmp10 = ((ValaCCodeBaseModule*) self)->source_declarations, (_tmp10 == NULL) ? NULL : vala_ccode_declaration_space_ref (_tmp10)), (decl_space == NULL) ? NULL : (decl_space = (vala_ccode_declaration_space_unref (decl_space), NULL)), _tmp11);
	}
	_tmp14 = NULL;
	_tmp13 = NULL;
	_tmp12 = NULL;
	((ValaCCodeBaseModule*) self)->type_struct = (_tmp14 = vala_ccode_struct_new (_tmp13 = g_strdup_printf ("_%s", _tmp12 = vala_interface_get_type_cname (iface))), (((ValaCCodeBaseModule*) self)->type_struct == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->type_struct = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->type_struct), NULL)), _tmp14);
	_tmp13 = (g_free (_tmp13), NULL);
	_tmp12 = (g_free (_tmp12), NULL);
	_tmp15 = NULL;
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp15 = vala_ccode_newline_new ()));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	_tmp16 = NULL;
	_tmp17 = NULL;
	macro = (_tmp17 = g_strdup_printf ("(%s_get_type ())", _tmp16 = vala_symbol_get_lower_case_cname ((ValaSymbol*) iface, NULL)), _tmp16 = (g_free (_tmp16), NULL), _tmp17);
	_tmp19 = NULL;
	_tmp18 = NULL;
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp19 = vala_ccode_macro_replacement_new (_tmp18 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) iface), macro)));
	(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
	_tmp18 = (g_free (_tmp18), NULL);
	_tmp22 = NULL;
	_tmp21 = NULL;
	_tmp20 = NULL;
	macro = (_tmp22 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_CAST ((obj), %s, %s))", _tmp20 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) iface), _tmp21 = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE)), macro = (g_free (macro), NULL), _tmp22);
	_tmp21 = (g_free (_tmp21), NULL);
	_tmp20 = (g_free (_tmp20), NULL);
	_tmp25 = NULL;
	_tmp24 = NULL;
	_tmp23 = NULL;
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp25 = vala_ccode_macro_replacement_new (_tmp24 = g_strdup_printf ("%s(obj)", _tmp23 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) iface, NULL)), macro)));
	(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
	_tmp24 = (g_free (_tmp24), NULL);
	_tmp23 = (g_free (_tmp23), NULL);
	_tmp27 = NULL;
	_tmp26 = NULL;
	macro = (_tmp27 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_TYPE ((obj), %s))", _tmp26 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) iface)), macro = (g_free (macro), NULL), _tmp27);
	_tmp26 = (g_free (_tmp26), NULL);
	_tmp30 = NULL;
	_tmp29 = NULL;
	_tmp28 = NULL;
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp30 = vala_ccode_macro_replacement_new (_tmp29 = g_strdup_printf ("%s(obj)", _tmp28 = vala_ccode_base_module_get_type_check_function ((ValaCCodeBaseModule*) self, (ValaTypeSymbol*) iface)), macro)));
	(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
	_tmp29 = (g_free (_tmp29), NULL);
	_tmp28 = (g_free (_tmp28), NULL);
	_tmp33 = NULL;
	_tmp32 = NULL;
	_tmp31 = NULL;
	macro = (_tmp33 = g_strdup_printf ("(G_TYPE_INSTANCE_GET_INTERFACE ((obj), %s, %s))", _tmp31 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) iface), _tmp32 = vala_interface_get_type_cname (iface)), macro = (g_free (macro), NULL), _tmp33);
	_tmp32 = (g_free (_tmp32), NULL);
	_tmp31 = (g_free (_tmp31), NULL);
	_tmp36 = NULL;
	_tmp35 = NULL;
	_tmp34 = NULL;
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp36 = vala_ccode_macro_replacement_new (_tmp35 = g_strdup_printf ("%s_GET_INTERFACE(obj)", _tmp34 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) iface, NULL)), macro)));
	(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
	_tmp35 = (g_free (_tmp35), NULL);
	_tmp34 = (g_free (_tmp34), NULL);
	_tmp37 = NULL;
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp37 = vala_ccode_newline_new ()));
	(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
	if (vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) iface))) == NULL) {
		ValaCCodeTypeDefinition* _tmp42;
		ValaCCodeVariableDeclarator* _tmp41;
		char* _tmp40;
		char* _tmp39;
		char* _tmp38;
		ValaCCodeTypeDefinition* _tmp46;
		ValaCCodeVariableDeclarator* _tmp45;
		char* _tmp44;
		char* _tmp43;
		_tmp42 = NULL;
		_tmp41 = NULL;
		_tmp40 = NULL;
		_tmp39 = NULL;
		_tmp38 = NULL;
		vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp42 = vala_ccode_type_definition_new (_tmp39 = g_strdup_printf ("struct _%s", _tmp38 = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE)), (ValaCCodeDeclarator*) (_tmp41 = vala_ccode_variable_declarator_new (_tmp40 = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE), NULL)))));
		(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL));
		(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
		_tmp40 = (g_free (_tmp40), NULL);
		_tmp39 = (g_free (_tmp39), NULL);
		_tmp38 = (g_free (_tmp38), NULL);
		_tmp46 = NULL;
		_tmp45 = NULL;
		_tmp44 = NULL;
		_tmp43 = NULL;
		vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp46 = vala_ccode_type_definition_new (_tmp43 = g_strdup_printf ("struct %s", vala_ccode_struct_get_name (((ValaCCodeBaseModule*) self)->type_struct)), (ValaCCodeDeclarator*) (_tmp45 = vala_ccode_variable_declarator_new (_tmp44 = vala_interface_get_type_cname (iface), NULL)))));
		(_tmp46 == NULL) ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL));
		(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
		_tmp44 = (g_free (_tmp44), NULL);
		_tmp43 = (g_free (_tmp43), NULL);
	}
	vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->type_struct, "GTypeInterface", "parent_iface");
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) iface)) != NULL) {
		ValaCCodeComment* _tmp47;
		_tmp47 = NULL;
		vala_ccode_declaration_space_add_type_definition (decl_space, (ValaCCodeNode*) (_tmp47 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) iface)))));
		(_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL));
	}
	vala_ccode_declaration_space_add_type_definition (decl_space, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->type_struct);
	vala_code_node_accept_children ((ValaCodeNode*) iface, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	vala_gtype_module_add_interface_base_init_function (self, iface);
	type_fun = vala_interface_register_function_new (iface, vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self));
	vala_typeregister_function_init_from_type ((ValaTypeRegisterFunction*) type_fun, FALSE);
	if (vala_symbol_get_access ((ValaSymbol*) iface) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFragment* _tmp48;
		_tmp48 = NULL;
		vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->header_declarations, (ValaCCodeNode*) (_tmp48 = vala_typeregister_function_get_declaration ((ValaTypeRegisterFunction*) type_fun)));
		(_tmp48 == NULL) ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL));
	} else {
		ValaCCodeFragment* _tmp49;
		_tmp49 = NULL;
		vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp49 = vala_typeregister_function_get_declaration ((ValaTypeRegisterFunction*) type_fun)));
		(_tmp49 == NULL) ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL));
	}
	_tmp50 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) (_tmp50 = vala_typeregister_function_get_definition ((ValaTypeRegisterFunction*) type_fun)));
	(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
	_tmp51 = NULL;
	((ValaCCodeBaseModule*) self)->current_type_symbol = (_tmp51 = NULL, (((ValaCCodeBaseModule*) self)->current_type_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_type_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_type_symbol), NULL)), _tmp51);
	(decl_space == NULL) ? NULL : (decl_space = (vala_ccode_declaration_space_unref (decl_space), NULL));
	macro = (g_free (macro), NULL);
	(type_fun == NULL) ? NULL : (type_fun = (vala_typeregister_function_unref (type_fun), NULL));
}


static void vala_gtype_module_add_interface_base_init_function (ValaGTypeModule* self, ValaInterface* iface) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* base_init;
	ValaCCodeFormalParameter* _tmp5;
	char* _tmp4;
	char* _tmp3;
	ValaCCodeBlock* init_block;
	ValaCCodeBlock* _tmp6;
	char* _tmp7;
	ValaCCodeDeclaration* _tmp8;
	ValaCCodeDeclaration* decl;
	ValaCCodeVariableDeclarator* _tmp10;
	ValaCCodeConstant* _tmp9;
	ValaCCodeUnaryExpression* _tmp12;
	ValaCCodeIdentifier* _tmp11;
	ValaCCodeIfStatement* _tmp13;
	ValaCCodeIfStatement* cif;
	ValaCCodeExpressionStatement* _tmp17;
	ValaCCodeAssignment* _tmp16;
	ValaCCodeConstant* _tmp15;
	ValaCCodeIdentifier* _tmp14;
	ValaCCodeFragment* _tmp33;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	base_init = (_tmp2 = vala_ccode_function_new (_tmp1 = g_strdup_printf ("%s_base_init", _tmp0 = vala_symbol_get_lower_case_cname ((ValaSymbol*) iface, NULL)), "void"), _tmp1 = (g_free (_tmp1), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp2);
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (base_init, _tmp5 = vala_ccode_formal_parameter_new ("iface", _tmp4 = g_strdup_printf ("%sIface *", _tmp3 = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE))));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp4 = (g_free (_tmp4), NULL);
	_tmp3 = (g_free (_tmp3), NULL);
	vala_ccode_function_set_modifiers (base_init, VALA_CCODE_MODIFIERS_STATIC);
	init_block = vala_ccode_block_new ();
	/* make sure not to run the initialization code twice */
	_tmp6 = NULL;
	vala_ccode_function_set_block (base_init, _tmp6 = vala_ccode_block_new ());
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	_tmp7 = NULL;
	_tmp8 = NULL;
	decl = (_tmp8 = vala_ccode_declaration_new (_tmp7 = vala_data_type_get_cname (((ValaCCodeBaseModule*) self)->bool_type)), _tmp7 = (g_free (_tmp7), NULL), _tmp8);
	vala_ccode_declaration_set_modifiers (decl, vala_ccode_declaration_get_modifiers (decl) | VALA_CCODE_MODIFIERS_STATIC);
	_tmp10 = NULL;
	_tmp9 = NULL;
	vala_ccode_declaration_add_declarator (decl, (ValaCCodeDeclarator*) (_tmp10 = vala_ccode_variable_declarator_new ("initialized", (ValaCCodeExpression*) (_tmp9 = vala_ccode_constant_new ("FALSE")))));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (base_init), (ValaCCodeNode*) decl);
	_tmp12 = NULL;
	_tmp11 = NULL;
	_tmp13 = NULL;
	cif = (_tmp13 = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp12 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION, (ValaCCodeExpression*) (_tmp11 = vala_ccode_identifier_new ("initialized")))), (ValaCCodeStatement*) init_block, NULL), (_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)), (_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL)), _tmp13);
	vala_ccode_block_add_statement (vala_ccode_function_get_block (base_init), (ValaCCodeNode*) cif);
	_tmp17 = NULL;
	_tmp16 = NULL;
	_tmp15 = NULL;
	_tmp14 = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp17 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp14 = vala_ccode_identifier_new ("initialized")), (ValaCCodeExpression*) (_tmp15 = vala_ccode_constant_new ("TRUE")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) iface, ((ValaCCodeBaseModule*) self)->gobject_type)) {
		GeeList* props;
		/* create properties */
		props = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) iface);
		{
			GeeIterator* _prop_it;
			_prop_it = gee_iterable_iterator ((GeeIterable*) props);
			while (gee_iterator_next (_prop_it)) {
				ValaProperty* prop;
				prop = (ValaProperty*) gee_iterator_get (_prop_it);
				if (vala_property_get_is_abstract (prop)) {
					ValaCCodeIdentifier* _tmp18;
					ValaCCodeFunctionCall* _tmp19;
					ValaCCodeFunctionCall* cinst;
					ValaCCodeIdentifier* _tmp20;
					ValaCCodeFunctionCall* _tmp21;
					ValaCCodeExpressionStatement* _tmp22;
					_tmp18 = NULL;
					_tmp19 = NULL;
					cinst = (_tmp19 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new ("g_object_interface_install_property"))), (_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)), _tmp19);
					_tmp20 = NULL;
					vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) (_tmp20 = vala_ccode_identifier_new ("iface")));
					(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
					_tmp21 = NULL;
					vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) (_tmp21 = vala_ccode_module_get_param_spec (vala_ccode_module_get_head ((ValaCCodeModule*) self), prop)));
					(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
					_tmp22 = NULL;
					vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp22 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cinst)));
					(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
					(cinst == NULL) ? NULL : (cinst = (vala_ccode_node_unref (cinst), NULL));
				}
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
			}
			(_prop_it == NULL) ? NULL : (_prop_it = (gee_collection_object_unref (_prop_it), NULL));
		}
		(props == NULL) ? NULL : (props = (gee_collection_object_unref (props), NULL));
	}
	/* create signals */
	{
		GeeList* _tmp23;
		GeeIterator* _tmp24;
		GeeIterator* _sig_it;
		/* create signals */
		_tmp23 = NULL;
		_tmp24 = NULL;
		_sig_it = (_tmp24 = gee_iterable_iterator ((GeeIterable*) (_tmp23 = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) iface))), (_tmp23 == NULL) ? NULL : (_tmp23 = (gee_collection_object_unref (_tmp23), NULL)), _tmp24);
		/* create signals */
		while (gee_iterator_next (_sig_it)) {
			ValaSignal* sig;
			ValaCCodeExpressionStatement* _tmp26;
			ValaCCodeFunctionCall* _tmp25;
			/* create signals */
			sig = (ValaSignal*) gee_iterator_get (_sig_it);
			_tmp26 = NULL;
			_tmp25 = NULL;
			vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp26 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp25 = vala_ccode_module_get_signal_creation (vala_ccode_module_get_head ((ValaCCodeModule*) self), sig, (ValaTypeSymbol*) iface)))));
			(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
			(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
			(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
		}
		(_sig_it == NULL) ? NULL : (_sig_it = (gee_collection_object_unref (_sig_it), NULL));
	}
	/* connect default implementations*/
	{
		GeeList* _tmp27;
		GeeIterator* _tmp28;
		GeeIterator* _m_it;
		/* connect default implementations*/
		_tmp27 = NULL;
		_tmp28 = NULL;
		_m_it = (_tmp28 = gee_iterable_iterator ((GeeIterable*) (_tmp27 = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) iface))), (_tmp27 == NULL) ? NULL : (_tmp27 = (gee_collection_object_unref (_tmp27), NULL)), _tmp28);
		/* connect default implementations*/
		while (gee_iterator_next (_m_it)) {
			ValaMethod* m;
			/* connect default implementations*/
			m = (ValaMethod*) gee_iterator_get (_m_it);
			if (vala_method_get_is_virtual (m)) {
				ValaCCodeIdentifier* ciface;
				char* cname;
				ValaCCodeExpressionStatement* _tmp32;
				ValaCCodeAssignment* _tmp31;
				ValaCCodeIdentifier* _tmp30;
				ValaCCodeMemberAccess* _tmp29;
				ciface = vala_ccode_identifier_new ("iface");
				cname = vala_method_get_real_cname (m);
				_tmp32 = NULL;
				_tmp31 = NULL;
				_tmp30 = NULL;
				_tmp29 = NULL;
				vala_ccode_block_add_statement (vala_ccode_function_get_block (base_init), (ValaCCodeNode*) (_tmp32 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp31 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp29 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ciface, vala_method_get_vfunc_name (m))), (ValaCCodeExpression*) (_tmp30 = vala_ccode_identifier_new (cname)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
				(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
				(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
				(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
				(ciface == NULL) ? NULL : (ciface = (vala_ccode_node_unref (ciface), NULL));
				cname = (g_free (cname), NULL);
			}
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
		}
		(_m_it == NULL) ? NULL : (_m_it = (gee_collection_object_unref (_m_it), NULL));
	}
	_tmp33 = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp33 = vala_ccode_module_register_dbus_info (vala_ccode_module_get_head ((ValaCCodeModule*) self), (ValaObjectTypeSymbol*) iface)));
	(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) base_init);
	(base_init == NULL) ? NULL : (base_init = (vala_ccode_node_unref (base_init), NULL));
	(init_block == NULL) ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL));
	(decl == NULL) ? NULL : (decl = (vala_ccode_node_unref (decl), NULL));
	(cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL));
}


static void vala_gtype_module_real_visit_struct (ValaCCodeModule* base, ValaStruct* st) {
	ValaGTypeModule * self;
	ValaCCodeDeclarationSpace* decl_space;
	ValaCCodeNewline* _tmp4;
	char* _tmp5;
	char* _tmp6;
	char* macro;
	ValaCCodeMacroReplacement* _tmp8;
	char* _tmp7;
	ValaStructRegisterFunction* type_fun;
	ValaCCodeFragment* _tmp11;
	self = (ValaGTypeModule*) base;
	g_return_if_fail (st != NULL);
	VALA_CCODE_MODULE_CLASS (vala_gtype_module_parent_class)->visit_struct ((ValaCCodeModule*) VALA_GERROR_MODULE (self), st);
	decl_space = NULL;
	if (vala_symbol_get_access ((ValaSymbol*) st) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeDeclarationSpace* _tmp1;
		ValaCCodeDeclarationSpace* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		decl_space = (_tmp1 = (_tmp0 = ((ValaCCodeBaseModule*) self)->header_declarations, (_tmp0 == NULL) ? NULL : vala_ccode_declaration_space_ref (_tmp0)), (decl_space == NULL) ? NULL : (decl_space = (vala_ccode_declaration_space_unref (decl_space), NULL)), _tmp1);
	} else {
		ValaCCodeDeclarationSpace* _tmp3;
		ValaCCodeDeclarationSpace* _tmp2;
		_tmp3 = NULL;
		_tmp2 = NULL;
		decl_space = (_tmp3 = (_tmp2 = ((ValaCCodeBaseModule*) self)->source_declarations, (_tmp2 == NULL) ? NULL : vala_ccode_declaration_space_ref (_tmp2)), (decl_space == NULL) ? NULL : (decl_space = (vala_ccode_declaration_space_unref (decl_space), NULL)), _tmp3);
	}
	_tmp4 = NULL;
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp4 = vala_ccode_newline_new ()));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp5 = NULL;
	_tmp6 = NULL;
	macro = (_tmp6 = g_strdup_printf ("(%s_get_type ())", _tmp5 = vala_symbol_get_lower_case_cname ((ValaSymbol*) st, NULL)), _tmp5 = (g_free (_tmp5), NULL), _tmp6);
	_tmp8 = NULL;
	_tmp7 = NULL;
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp8 = vala_ccode_macro_replacement_new (_tmp7 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) st), macro)));
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	_tmp7 = (g_free (_tmp7), NULL);
	type_fun = vala_struct_register_function_new (st, vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self));
	vala_typeregister_function_init_from_type ((ValaTypeRegisterFunction*) type_fun, FALSE);
	if (vala_symbol_get_access ((ValaSymbol*) st) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFragment* _tmp9;
		_tmp9 = NULL;
		vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->header_declarations, (ValaCCodeNode*) (_tmp9 = vala_typeregister_function_get_declaration ((ValaTypeRegisterFunction*) type_fun)));
		(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	} else {
		ValaCCodeFragment* _tmp10;
		_tmp10 = NULL;
		vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp10 = vala_typeregister_function_get_declaration ((ValaTypeRegisterFunction*) type_fun)));
		(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	}
	_tmp11 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) (_tmp11 = vala_typeregister_function_get_definition ((ValaTypeRegisterFunction*) type_fun)));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	(decl_space == NULL) ? NULL : (decl_space = (vala_ccode_declaration_space_unref (decl_space), NULL));
	macro = (g_free (macro), NULL);
	(type_fun == NULL) ? NULL : (type_fun = (vala_typeregister_function_unref (type_fun), NULL));
}


static void vala_gtype_module_class_init (ValaGTypeModuleClass * klass) {
	vala_gtype_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_interface = vala_gtype_module_real_visit_interface;
	VALA_CCODE_MODULE_CLASS (klass)->visit_struct = vala_gtype_module_real_visit_struct;
}


static void vala_gtype_module_instance_init (ValaGTypeModule * self) {
}


GType vala_gtype_module_get_type (void) {
	static GType vala_gtype_module_type_id = 0;
	if (vala_gtype_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGTypeModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gtype_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGTypeModule), 0, (GInstanceInitFunc) vala_gtype_module_instance_init, NULL };
		vala_gtype_module_type_id = g_type_register_static (VALA_TYPE_GERROR_MODULE, "ValaGTypeModule", &g_define_type_info, 0);
	}
	return vala_gtype_module_type_id;
}




