/* valaccodedeclarationspace.vala
 *
 * Copyright (C) 2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __GOBJECT_VALACCODEDECLARATIONSPACE_H__
#define __GOBJECT_VALACCODEDECLARATIONSPACE_H__

#include <glib.h>
#include <glib-object.h>
#include <ccode/valaccodefragment.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_DECLARATION_SPACE (vala_ccode_declaration_space_get_type ())
#define VALA_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpace))
#define VALA_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))
#define VALA_IS_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_IS_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_CCODE_DECLARATION_SPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))

typedef struct _ValaCCodeDeclarationSpace ValaCCodeDeclarationSpace;
typedef struct _ValaCCodeDeclarationSpaceClass ValaCCodeDeclarationSpaceClass;
typedef struct _ValaCCodeDeclarationSpacePrivate ValaCCodeDeclarationSpacePrivate;
typedef struct _ValaParamSpecCCodeDeclarationSpace ValaParamSpecCCodeDeclarationSpace;

struct _ValaCCodeDeclarationSpace {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeDeclarationSpacePrivate * priv;
	ValaCCodeFragment* begin;
	ValaCCodeFragment* include_directives;
	ValaCCodeFragment* type_declaration;
	ValaCCodeFragment* type_definition;
	ValaCCodeFragment* type_member_declaration;
	ValaCCodeFragment* constant_declaration;
};

struct _ValaCCodeDeclarationSpaceClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeDeclarationSpace *self);
};

struct _ValaParamSpecCCodeDeclarationSpace {
	GParamSpec parent_instance;
};


void vala_ccode_declaration_space_add_include (ValaCCodeDeclarationSpace* self, const char* filename, gboolean local);
void vala_ccode_declaration_space_add_begin (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
void vala_ccode_declaration_space_add_type_declaration (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
void vala_ccode_declaration_space_add_type_definition (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
void vala_ccode_declaration_space_add_type_member_declaration (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
void vala_ccode_declaration_space_add_constant_declaration (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
ValaCCodeDeclarationSpace* vala_ccode_declaration_space_construct (GType object_type);
ValaCCodeDeclarationSpace* vala_ccode_declaration_space_new (void);
GParamSpec* vala_param_spec_ccode_declaration_space (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
gpointer vala_value_get_ccode_declaration_space (const GValue* value);
void vala_value_set_ccode_declaration_space (GValue* value, gpointer v_object);
GType vala_ccode_declaration_space_get_type (void);
gpointer vala_ccode_declaration_space_ref (gpointer instance);
void vala_ccode_declaration_space_unref (gpointer instance);


G_END_DECLS

#endif
