/* valamarkupreader.c generated by valac, the Vala compiler
 * generated from valamarkupreader.vala, do not modify */

/* valamarkupreader.vala
 *
 * Copyright (C) 2008-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_MARKUP_READER (vala_markup_reader_get_type ())
#define VALA_MARKUP_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MARKUP_READER, ValaMarkupReader))
#define VALA_MARKUP_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MARKUP_READER, ValaMarkupReaderClass))
#define VALA_IS_MARKUP_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MARKUP_READER))
#define VALA_IS_MARKUP_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MARKUP_READER))
#define VALA_MARKUP_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MARKUP_READER, ValaMarkupReaderClass))

typedef struct _ValaMarkupReader ValaMarkupReader;
typedef struct _ValaMarkupReaderClass ValaMarkupReaderClass;
typedef struct _ValaMarkupReaderPrivate ValaMarkupReaderPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_mapped_file_free0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_free (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VALA_TYPE_SOURCE_LOCATION (vala_source_location_get_type ())
typedef struct _ValaSourceLocation ValaSourceLocation;

#define VALA_TYPE_MARKUP_TOKEN_TYPE (vala_markup_token_type_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaMarkupReader {
	GObject parent_instance;
	ValaMarkupReaderPrivate * priv;
};

struct _ValaMarkupReaderClass {
	GObjectClass parent_class;
};

struct _ValaMarkupReaderPrivate {
	gchar* _filename;
	gchar* _name;
	gchar* _content;
	GMappedFile* mapped_file;
	gchar* begin;
	gchar* current;
	gchar* end;
	gint line;
	gint column;
	ValaMap* attributes;
	gboolean empty_element;
};

struct _ValaSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

typedef enum  {
	VALA_MARKUP_TOKEN_TYPE_NONE,
	VALA_MARKUP_TOKEN_TYPE_START_ELEMENT,
	VALA_MARKUP_TOKEN_TYPE_END_ELEMENT,
	VALA_MARKUP_TOKEN_TYPE_TEXT,
	VALA_MARKUP_TOKEN_TYPE_EOF
} ValaMarkupTokenType;


static gpointer vala_markup_reader_parent_class = NULL;

GType vala_markup_reader_get_type (void) G_GNUC_CONST;
#define VALA_MARKUP_READER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_MARKUP_READER, ValaMarkupReaderPrivate))
enum  {
	VALA_MARKUP_READER_DUMMY_PROPERTY,
	VALA_MARKUP_READER_FILENAME,
	VALA_MARKUP_READER_NAME,
	VALA_MARKUP_READER_CONTENT
};
ValaMarkupReader* vala_markup_reader_new (const gchar* filename);
ValaMarkupReader* vala_markup_reader_construct (GType object_type, const gchar* filename);
static void vala_markup_reader_set_filename (ValaMarkupReader* self, const gchar* value);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
void vala_report_error (ValaSourceReference* source, const gchar* message);
gchar* vala_markup_reader_get_attribute (ValaMarkupReader* self, const gchar* attr);
static gchar* vala_markup_reader_read_name (ValaMarkupReader* self);
GType vala_source_location_get_type (void) G_GNUC_CONST;
ValaSourceLocation* vala_source_location_dup (const ValaSourceLocation* self);
void vala_source_location_free (ValaSourceLocation* self);
GType vala_markup_token_type_get_type (void) G_GNUC_CONST;
ValaMarkupTokenType vala_markup_reader_read_token (ValaMarkupReader* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end);
static void vala_markup_reader_space (ValaMarkupReader* self);
static void vala_markup_reader_set_name (ValaMarkupReader* self, const gchar* value);
static gchar* vala_markup_reader_text (ValaMarkupReader* self, gchar end_char, gboolean rm_trailing_whitespace);
static void vala_markup_reader_set_content (ValaMarkupReader* self, const gchar* value);
const gchar* vala_markup_reader_get_filename (ValaMarkupReader* self);
const gchar* vala_markup_reader_get_name (ValaMarkupReader* self);
const gchar* vala_markup_reader_get_content (ValaMarkupReader* self);
static void vala_markup_reader_finalize (GObject* obj);
static void _vala_vala_markup_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_vala_markup_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
const gchar* vala_markup_token_type_to_string (ValaMarkupTokenType self);


ValaMarkupReader* vala_markup_reader_construct (GType object_type, const gchar* filename) {
	ValaMarkupReader * self = NULL;
	GMappedFile* _tmp0_ = NULL;
	GMappedFile* _tmp1_;
	GMappedFile* _tmp2_;
	gchar* _tmp3_ = NULL;
	gsize _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	self = (ValaMarkupReader*) g_object_new (object_type, NULL);
	vala_markup_reader_set_filename (self, filename);
	_tmp0_ = g_mapped_file_new (filename, FALSE, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_FILE_ERROR) {
			goto __catch8_g_file_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp2_ = _tmp1_;
	_g_mapped_file_free0 (self->priv->mapped_file);
	self->priv->mapped_file = _tmp2_;
	_tmp3_ = g_mapped_file_get_contents (self->priv->mapped_file);
	self->priv->begin = _tmp3_;
	_tmp4_ = g_mapped_file_get_length (self->priv->mapped_file);
	self->priv->end = self->priv->begin + _tmp4_;
	self->priv->current = self->priv->begin;
	self->priv->line = 1;
	self->priv->column = 1;
	goto __finally8;
	__catch8_g_file_error:
	{
		GError * e;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = g_strdup_printf ("Unable to map file `%s': %s", filename, e->message);
		_tmp6_ = _tmp5_;
		vala_report_error (NULL, _tmp6_);
		_g_free0 (_tmp6_);
		_g_error_free0 (e);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


ValaMarkupReader* vala_markup_reader_new (const gchar* filename) {
	return vala_markup_reader_construct (VALA_TYPE_MARKUP_READER, filename);
}


gchar* vala_markup_reader_get_attribute (ValaMarkupReader* self, const gchar* attr) {
	gchar* result = NULL;
	gpointer _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (attr != NULL, NULL);
	_tmp0_ = vala_map_get (self->priv->attributes, attr);
	result = (gchar*) _tmp0_;
	return result;
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = strnlen ((gchar*) self, (gsize) (offset + len));
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


static gchar* vala_markup_reader_read_name (ValaMarkupReader* self) {
	gchar* result = NULL;
	gchar* begin;
	gchar* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	begin = self->priv->current;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gunichar _tmp5_;
		gunichar u;
		if (!(self->priv->current < self->priv->end)) {
			break;
		}
		if (self->priv->current[0] == ' ') {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = self->priv->current[0] == '\t';
		}
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = self->priv->current[0] == '>';
		}
		if (_tmp3_) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = self->priv->current[0] == '/';
		}
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = self->priv->current[0] == '=';
		}
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = self->priv->current[0] == '\n';
		}
		if (_tmp0_) {
			break;
		}
		_tmp5_ = g_utf8_get_char_validated ((const gchar*) self->priv->current, (gssize) ((glong) (self->priv->end - self->priv->current)));
		u = _tmp5_;
		if (u != ((gunichar) (-1))) {
			gint _tmp6_;
			_tmp6_ = g_unichar_to_utf8 (u, NULL);
			self->priv->current = self->priv->current + _tmp6_;
		} else {
			vala_report_error (NULL, "invalid UTF-8 character");
		}
	}
	if (self->priv->current == begin) {
	}
	_tmp7_ = string_substring ((const gchar*) begin, (glong) 0, (glong) ((gint) (self->priv->current - begin)));
	result = _tmp7_;
	return result;
}


ValaMarkupTokenType vala_markup_reader_read_token (ValaMarkupReader* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end) {
	ValaSourceLocation _token_begin = {0};
	ValaSourceLocation _token_end = {0};
	ValaMarkupTokenType result = 0;
	ValaMarkupTokenType type;
	gchar* begin;
	g_return_val_if_fail (self != NULL, 0);
	vala_map_clear (self->priv->attributes);
	if (self->priv->empty_element) {
		self->priv->empty_element = FALSE;
		result = VALA_MARKUP_TOKEN_TYPE_END_ELEMENT;
		if (token_begin) {
			*token_begin = _token_begin;
		}
		if (token_end) {
			*token_end = _token_end;
		}
		return result;
	}
	vala_markup_reader_space (self);
	type = VALA_MARKUP_TOKEN_TYPE_NONE;
	begin = self->priv->current;
	_token_begin.pos = begin;
	_token_begin.line = self->priv->line;
	_token_begin.column = self->priv->column;
	if (self->priv->current >= self->priv->end) {
		type = VALA_MARKUP_TOKEN_TYPE_EOF;
	} else {
		if (self->priv->current[0] == '<') {
			self->priv->current++;
			if (self->priv->current >= self->priv->end) {
			} else {
				if (self->priv->current[0] == '?') {
				} else {
					if (self->priv->current[0] == '!') {
						gboolean _tmp0_ = FALSE;
						gboolean _tmp1_ = FALSE;
						self->priv->current++;
						if (self->priv->current < (self->priv->end - 1)) {
							_tmp1_ = self->priv->current[0] == '-';
						} else {
							_tmp1_ = FALSE;
						}
						if (_tmp1_) {
							_tmp0_ = self->priv->current[1] == '-';
						} else {
							_tmp0_ = FALSE;
						}
						if (_tmp0_) {
							ValaSourceLocation _tmp4_ = {0};
							ValaSourceLocation _tmp5_ = {0};
							ValaMarkupTokenType _tmp6_;
							self->priv->current = self->priv->current + 2;
							while (TRUE) {
								gboolean _tmp2_ = FALSE;
								gboolean _tmp3_ = FALSE;
								if (!(self->priv->current < (self->priv->end - 2))) {
									break;
								}
								if (self->priv->current[0] == '-') {
									_tmp3_ = self->priv->current[1] == '-';
								} else {
									_tmp3_ = FALSE;
								}
								if (_tmp3_) {
									_tmp2_ = self->priv->current[2] == '>';
								} else {
									_tmp2_ = FALSE;
								}
								if (_tmp2_) {
									self->priv->current = self->priv->current + 3;
									break;
								} else {
									if (self->priv->current[0] == '\n') {
										self->priv->line++;
										self->priv->column = 0;
									}
								}
								self->priv->current++;
							}
							_tmp6_ = vala_markup_reader_read_token (self, &_tmp4_, &_tmp5_);
							_token_begin = _tmp4_;
							_token_end = _tmp5_;
							result = _tmp6_;
							if (token_begin) {
								*token_begin = _token_begin;
							}
							if (token_end) {
								*token_end = _token_end;
							}
							return result;
						}
					} else {
						if (self->priv->current[0] == '/') {
							gchar* _tmp7_ = NULL;
							gchar* _tmp8_;
							gboolean _tmp9_ = FALSE;
							type = VALA_MARKUP_TOKEN_TYPE_END_ELEMENT;
							self->priv->current++;
							_tmp7_ = vala_markup_reader_read_name (self);
							_tmp8_ = _tmp7_;
							vala_markup_reader_set_name (self, _tmp8_);
							_g_free0 (_tmp8_);
							if (self->priv->current >= self->priv->end) {
								_tmp9_ = TRUE;
							} else {
								_tmp9_ = self->priv->current[0] != '>';
							}
							if (_tmp9_) {
							}
							self->priv->current++;
						} else {
							gchar* _tmp10_ = NULL;
							gchar* _tmp11_;
							gboolean _tmp19_ = FALSE;
							type = VALA_MARKUP_TOKEN_TYPE_START_ELEMENT;
							_tmp10_ = vala_markup_reader_read_name (self);
							_tmp11_ = _tmp10_;
							vala_markup_reader_set_name (self, _tmp11_);
							_g_free0 (_tmp11_);
							vala_markup_reader_space (self);
							while (TRUE) {
								gboolean _tmp12_ = FALSE;
								gboolean _tmp13_ = FALSE;
								gchar* _tmp14_ = NULL;
								gchar* attr_name;
								gboolean _tmp15_ = FALSE;
								gboolean _tmp16_ = FALSE;
								gchar* _tmp17_ = NULL;
								gchar* attr_value;
								gboolean _tmp18_ = FALSE;
								if (self->priv->current < self->priv->end) {
									_tmp13_ = self->priv->current[0] != '>';
								} else {
									_tmp13_ = FALSE;
								}
								if (_tmp13_) {
									_tmp12_ = self->priv->current[0] != '/';
								} else {
									_tmp12_ = FALSE;
								}
								if (!_tmp12_) {
									break;
								}
								_tmp14_ = vala_markup_reader_read_name (self);
								attr_name = _tmp14_;
								if (self->priv->current >= self->priv->end) {
									_tmp15_ = TRUE;
								} else {
									_tmp15_ = self->priv->current[0] != '=';
								}
								if (_tmp15_) {
								}
								self->priv->current++;
								if (self->priv->current >= self->priv->end) {
									_tmp16_ = TRUE;
								} else {
									_tmp16_ = self->priv->current[0] != '"';
								}
								if (_tmp16_) {
								}
								self->priv->current++;
								_tmp17_ = vala_markup_reader_text (self, '"', FALSE);
								attr_value = _tmp17_;
								if (self->priv->current >= self->priv->end) {
									_tmp18_ = TRUE;
								} else {
									_tmp18_ = self->priv->current[0] != '"';
								}
								if (_tmp18_) {
								}
								self->priv->current++;
								vala_map_set (self->priv->attributes, attr_name, attr_value);
								vala_markup_reader_space (self);
								_g_free0 (attr_value);
								_g_free0 (attr_name);
							}
							if (self->priv->current[0] == '/') {
								self->priv->empty_element = TRUE;
								self->priv->current++;
								vala_markup_reader_space (self);
							} else {
								self->priv->empty_element = FALSE;
							}
							if (self->priv->current >= self->priv->end) {
								_tmp19_ = TRUE;
							} else {
								_tmp19_ = self->priv->current[0] != '>';
							}
							if (_tmp19_) {
							}
							self->priv->current++;
						}
					}
				}
			}
		} else {
			vala_markup_reader_space (self);
			if (self->priv->current[0] != '<') {
				gchar* _tmp20_ = NULL;
				gchar* _tmp21_;
				_tmp20_ = vala_markup_reader_text (self, '<', TRUE);
				_tmp21_ = _tmp20_;
				vala_markup_reader_set_content (self, _tmp21_);
				_g_free0 (_tmp21_);
			} else {
				ValaSourceLocation _tmp22_ = {0};
				ValaSourceLocation _tmp23_ = {0};
				ValaMarkupTokenType _tmp24_;
				_tmp24_ = vala_markup_reader_read_token (self, &_tmp22_, &_tmp23_);
				_token_begin = _tmp22_;
				_token_end = _tmp23_;
				result = _tmp24_;
				if (token_begin) {
					*token_begin = _token_begin;
				}
				if (token_end) {
					*token_end = _token_end;
				}
				return result;
			}
			type = VALA_MARKUP_TOKEN_TYPE_TEXT;
		}
	}
	_token_end.pos = self->priv->current;
	_token_end.line = self->priv->line;
	_token_end.column = self->priv->column - 1;
	result = type;
	if (token_begin) {
		*token_begin = _token_begin;
	}
	if (token_end) {
		*token_end = _token_end;
	}
	return result;
}


static gchar* vala_markup_reader_text (ValaMarkupReader* self, gchar end_char, gboolean rm_trailing_whitespace) {
	gchar* result = NULL;
	GString* _tmp0_ = NULL;
	GString* content;
	gchar* text_begin;
	gchar* last_linebreak;
	gchar* _tmp26_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	content = _tmp0_;
	text_begin = self->priv->current;
	last_linebreak = self->priv->current;
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gunichar _tmp2_;
		gunichar u;
		if (self->priv->current < self->priv->end) {
			_tmp1_ = self->priv->current[0] != end_char;
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		_tmp2_ = g_utf8_get_char_validated ((const gchar*) self->priv->current, (gssize) ((glong) (self->priv->end - self->priv->current)));
		u = _tmp2_;
		if (u == ((gunichar) (-1))) {
			vala_report_error (NULL, "invalid UTF-8 character");
		} else {
			if (u == '&') {
				gint _tmp3_;
				gchar* next_pos;
				gboolean _tmp4_;
				_tmp3_ = g_unichar_to_utf8 (u, NULL);
				next_pos = self->priv->current + _tmp3_;
				_tmp4_ = g_str_has_prefix ((const gchar*) next_pos, "amp;");
				if (_tmp4_) {
					gchar* _tmp5_ = NULL;
					gchar* _tmp6_;
					_tmp5_ = string_substring ((const gchar*) text_begin, (glong) 0, (glong) ((gint) (self->priv->current - text_begin)));
					_tmp6_ = _tmp5_;
					g_string_append (content, _tmp6_);
					_g_free0 (_tmp6_);
					g_string_append_c (content, '&');
					self->priv->current = self->priv->current + 5;
					text_begin = self->priv->current;
				} else {
					gboolean _tmp7_;
					_tmp7_ = g_str_has_prefix ((const gchar*) next_pos, "quot;");
					if (_tmp7_) {
						gchar* _tmp8_ = NULL;
						gchar* _tmp9_;
						_tmp8_ = string_substring ((const gchar*) text_begin, (glong) 0, (glong) ((gint) (self->priv->current - text_begin)));
						_tmp9_ = _tmp8_;
						g_string_append (content, _tmp9_);
						_g_free0 (_tmp9_);
						g_string_append_c (content, '"');
						self->priv->current = self->priv->current + 6;
						text_begin = self->priv->current;
					} else {
						gboolean _tmp10_;
						_tmp10_ = g_str_has_prefix ((const gchar*) next_pos, "apos;");
						if (_tmp10_) {
							gchar* _tmp11_ = NULL;
							gchar* _tmp12_;
							_tmp11_ = string_substring ((const gchar*) text_begin, (glong) 0, (glong) ((gint) (self->priv->current - text_begin)));
							_tmp12_ = _tmp11_;
							g_string_append (content, _tmp12_);
							_g_free0 (_tmp12_);
							g_string_append_c (content, '\'');
							self->priv->current = self->priv->current + 6;
							text_begin = self->priv->current;
						} else {
							gboolean _tmp13_;
							_tmp13_ = g_str_has_prefix ((const gchar*) next_pos, "lt;");
							if (_tmp13_) {
								gchar* _tmp14_ = NULL;
								gchar* _tmp15_;
								_tmp14_ = string_substring ((const gchar*) text_begin, (glong) 0, (glong) ((gint) (self->priv->current - text_begin)));
								_tmp15_ = _tmp14_;
								g_string_append (content, _tmp15_);
								_g_free0 (_tmp15_);
								g_string_append_c (content, '<');
								self->priv->current = self->priv->current + 4;
								text_begin = self->priv->current;
							} else {
								gboolean _tmp16_;
								_tmp16_ = g_str_has_prefix ((const gchar*) next_pos, "gt;");
								if (_tmp16_) {
									gchar* _tmp17_ = NULL;
									gchar* _tmp18_;
									_tmp17_ = string_substring ((const gchar*) text_begin, (glong) 0, (glong) ((gint) (self->priv->current - text_begin)));
									_tmp18_ = _tmp17_;
									g_string_append (content, _tmp18_);
									_g_free0 (_tmp18_);
									g_string_append_c (content, '>');
									self->priv->current = self->priv->current + 4;
									text_begin = self->priv->current;
								} else {
									gint _tmp19_;
									_tmp19_ = g_unichar_to_utf8 (u, NULL);
									self->priv->current = self->priv->current + _tmp19_;
								}
							}
						}
					}
				}
			} else {
				gint _tmp20_;
				if (u == '\n') {
					self->priv->line++;
					self->priv->column = 0;
					last_linebreak = self->priv->current;
				}
				_tmp20_ = g_unichar_to_utf8 (u, NULL);
				self->priv->current = self->priv->current + _tmp20_;
				self->priv->column++;
			}
		}
	}
	if (text_begin != self->priv->current) {
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		_tmp21_ = string_substring ((const gchar*) text_begin, (glong) 0, (glong) ((gint) (self->priv->current - text_begin)));
		_tmp22_ = _tmp21_;
		g_string_append (content, _tmp22_);
		_g_free0 (_tmp22_);
	}
	self->priv->column = self->priv->column + ((gint) (self->priv->current - last_linebreak));
	if (rm_trailing_whitespace) {
		gchar* str_pos;
		str_pos = ((gchar*) content->str) + content->len;
		{
			gboolean _tmp23_;
			str_pos--;
			_tmp23_ = TRUE;
			while (TRUE) {
				gboolean _tmp24_ = FALSE;
				if (!_tmp23_) {
					str_pos--;
				}
				_tmp23_ = FALSE;
				if (str_pos > ((gchar*) content->str)) {
					gboolean _tmp25_;
					_tmp25_ = g_ascii_isspace (str_pos[0]);
					_tmp24_ = _tmp25_;
				} else {
					_tmp24_ = FALSE;
				}
				if (!_tmp24_) {
					break;
				}
			}
		}
		g_string_erase (content, (gssize) ((str_pos - ((gchar*) content->str)) + 1), (gssize) (-1));
	}
	_tmp26_ = g_strdup (content->str);
	result = _tmp26_;
	_g_string_free0 (content);
	return result;
}


static void vala_markup_reader_space (ValaMarkupReader* self) {
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (self->priv->current < self->priv->end) {
			gboolean _tmp1_;
			_tmp1_ = g_ascii_isspace (self->priv->current[0]);
			_tmp0_ = _tmp1_;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		if (self->priv->current[0] == '\n') {
			self->priv->line++;
			self->priv->column = 0;
		}
		self->priv->current++;
		self->priv->column++;
	}
}


const gchar* vala_markup_reader_get_filename (ValaMarkupReader* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_filename;
	return result;
}


static void vala_markup_reader_set_filename (ValaMarkupReader* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_filename);
	self->priv->_filename = _tmp1_;
	g_object_notify ((GObject *) self, "filename");
}


const gchar* vala_markup_reader_get_name (ValaMarkupReader* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_name;
	return result;
}


static void vala_markup_reader_set_name (ValaMarkupReader* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	g_object_notify ((GObject *) self, "name");
}


const gchar* vala_markup_reader_get_content (ValaMarkupReader* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_content;
	return result;
}


static void vala_markup_reader_set_content (ValaMarkupReader* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_content);
	self->priv->_content = _tmp1_;
	g_object_notify ((GObject *) self, "content");
}


static void vala_markup_reader_class_init (ValaMarkupReaderClass * klass) {
	vala_markup_reader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaMarkupReaderPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_vala_markup_reader_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_vala_markup_reader_set_property;
	G_OBJECT_CLASS (klass)->finalize = vala_markup_reader_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_MARKUP_READER_FILENAME, g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_MARKUP_READER_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_MARKUP_READER_CONTENT, g_param_spec_string ("content", "content", "content", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void vala_markup_reader_instance_init (ValaMarkupReader * self) {
	ValaHashMap* _tmp0_ = NULL;
	self->priv = VALA_MARKUP_READER_GET_PRIVATE (self);
	_tmp0_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_direct_equal);
	self->priv->attributes = (ValaMap*) _tmp0_;
}


static void vala_markup_reader_finalize (GObject* obj) {
	ValaMarkupReader * self;
	self = VALA_MARKUP_READER (obj);
	_g_free0 (self->priv->_filename);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_content);
	_g_mapped_file_free0 (self->priv->mapped_file);
	_vala_map_unref0 (self->priv->attributes);
	G_OBJECT_CLASS (vala_markup_reader_parent_class)->finalize (obj);
}


/**
 * Simple reader for a subset of XML.
 */
GType vala_markup_reader_get_type (void) {
	static volatile gsize vala_markup_reader_type_id__volatile = 0;
	if (g_once_init_enter (&vala_markup_reader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMarkupReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_markup_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMarkupReader), 0, (GInstanceInitFunc) vala_markup_reader_instance_init, NULL };
		GType vala_markup_reader_type_id;
		vala_markup_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaMarkupReader", &g_define_type_info, 0);
		g_once_init_leave (&vala_markup_reader_type_id__volatile, vala_markup_reader_type_id);
	}
	return vala_markup_reader_type_id__volatile;
}


static void _vala_vala_markup_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaMarkupReader * self;
	self = VALA_MARKUP_READER (object);
	switch (property_id) {
		case VALA_MARKUP_READER_FILENAME:
		g_value_set_string (value, vala_markup_reader_get_filename (self));
		break;
		case VALA_MARKUP_READER_NAME:
		g_value_set_string (value, vala_markup_reader_get_name (self));
		break;
		case VALA_MARKUP_READER_CONTENT:
		g_value_set_string (value, vala_markup_reader_get_content (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_vala_markup_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaMarkupReader * self;
	self = VALA_MARKUP_READER (object);
	switch (property_id) {
		case VALA_MARKUP_READER_FILENAME:
		vala_markup_reader_set_filename (self, g_value_get_string (value));
		break;
		case VALA_MARKUP_READER_NAME:
		vala_markup_reader_set_name (self, g_value_get_string (value));
		break;
		case VALA_MARKUP_READER_CONTENT:
		vala_markup_reader_set_content (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


const gchar* vala_markup_token_type_to_string (ValaMarkupTokenType self) {
	const gchar* result = NULL;
	switch (self) {
		case VALA_MARKUP_TOKEN_TYPE_START_ELEMENT:
		{
			result = "start element";
			return result;
		}
		case VALA_MARKUP_TOKEN_TYPE_END_ELEMENT:
		{
			result = "end element";
			return result;
		}
		case VALA_MARKUP_TOKEN_TYPE_TEXT:
		{
			result = "text";
			return result;
		}
		case VALA_MARKUP_TOKEN_TYPE_EOF:
		{
			result = "end of file";
			return result;
		}
		default:
		{
			result = "unknown token type";
			return result;
		}
	}
}


GType vala_markup_token_type_get_type (void) {
	static volatile gsize vala_markup_token_type_type_id__volatile = 0;
	if (g_once_init_enter (&vala_markup_token_type_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_MARKUP_TOKEN_TYPE_NONE, "VALA_MARKUP_TOKEN_TYPE_NONE", "none"}, {VALA_MARKUP_TOKEN_TYPE_START_ELEMENT, "VALA_MARKUP_TOKEN_TYPE_START_ELEMENT", "start-element"}, {VALA_MARKUP_TOKEN_TYPE_END_ELEMENT, "VALA_MARKUP_TOKEN_TYPE_END_ELEMENT", "end-element"}, {VALA_MARKUP_TOKEN_TYPE_TEXT, "VALA_MARKUP_TOKEN_TYPE_TEXT", "text"}, {VALA_MARKUP_TOKEN_TYPE_EOF, "VALA_MARKUP_TOKEN_TYPE_EOF", "eof"}, {0, NULL, NULL}};
		GType vala_markup_token_type_type_id;
		vala_markup_token_type_type_id = g_enum_register_static ("ValaMarkupTokenType", values);
		g_once_init_leave (&vala_markup_token_type_type_id__volatile, vala_markup_token_type_type_id);
	}
	return vala_markup_token_type_type_id__volatile;
}



