/* valaproperty.c generated by valac, the Vala compiler
 * generated from valaproperty.vala, do not modify */

/* valaproperty.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <valaccode.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_ERROR_DOMAIN (vala_error_domain_get_type ())
#define VALA_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain))
#define VALA_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))
#define VALA_IS_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_DOMAIN))
#define VALA_IS_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_DOMAIN))
#define VALA_ERROR_DOMAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))

typedef struct _ValaErrorDomain ValaErrorDomain;
typedef struct _ValaErrorDomainClass ValaErrorDomainClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignal ValaSignal;
typedef struct _ValaSignalClass ValaSignalClass;

#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructor ValaConstructor;
typedef struct _ValaConstructorClass ValaConstructorClass;

#define VALA_TYPE_DESTRUCTOR (vala_destructor_get_type ())
#define VALA_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructor))
#define VALA_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))
#define VALA_IS_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DESTRUCTOR))
#define VALA_IS_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DESTRUCTOR))
#define VALA_DESTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))

typedef struct _ValaDestructor ValaDestructor;
typedef struct _ValaDestructorClass ValaDestructorClass;

#define VALA_TYPE_LOCKABLE (vala_lockable_get_type ())
#define VALA_LOCKABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCKABLE, ValaLockable))
#define VALA_IS_LOCKABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCKABLE))
#define VALA_LOCKABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), VALA_TYPE_LOCKABLE, ValaLockableIface))

typedef struct _ValaLockable ValaLockable;
typedef struct _ValaLockableIface ValaLockableIface;
typedef struct _ValaPropertyPrivate ValaPropertyPrivate;

#define VALA_TYPE_FORMAL_PARAMETER (vala_formal_parameter_get_type ())
#define VALA_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameter))
#define VALA_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))
#define VALA_IS_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_IS_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_FORMAL_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))

typedef struct _ValaFormalParameter ValaFormalParameter;
typedef struct _ValaFormalParameterClass ValaFormalParameterClass;

#define VALA_TYPE_MEMBER_BINDING (vala_member_binding_get_type ())

#define VALA_TYPE_PROPERTY_ACCESSOR (vala_property_accessor_get_type ())
#define VALA_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor))
#define VALA_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))
#define VALA_IS_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_IS_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_PROPERTY_ACCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))

typedef struct _ValaPropertyAccessor ValaPropertyAccessor;
typedef struct _ValaPropertyAccessorClass ValaPropertyAccessorClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

#define VALA_TYPE_SYMBOL_ACCESSIBILITY (vala_symbol_accessibility_get_type ())

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

#define VALA_TYPE_VOID_TYPE (vala_void_type_get_type ())
#define VALA_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VOID_TYPE, ValaVoidType))
#define VALA_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))
#define VALA_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VOID_TYPE))
#define VALA_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VOID_TYPE))
#define VALA_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))

typedef struct _ValaVoidType ValaVoidType;
typedef struct _ValaVoidTypeClass ValaVoidTypeClass;
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	gchar* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	gchar* (*get_cprefix) (ValaSymbol* self);
	gchar* (*get_lower_case_cname) (ValaSymbol* self, const gchar* infix);
	gchar* (*get_lower_case_cprefix) (ValaSymbol* self);
	ValaList* (*get_cheader_filenames) (ValaSymbol* self);
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
	void (*process_deprecated_attribute) (ValaSymbol* self, ValaAttribute* attr);
	void (*add_namespace) (ValaSymbol* self, ValaNamespace* ns);
	void (*add_class) (ValaSymbol* self, ValaClass* cl);
	void (*add_interface) (ValaSymbol* self, ValaInterface* iface);
	void (*add_struct) (ValaSymbol* self, ValaStruct* st);
	void (*add_enum) (ValaSymbol* self, ValaEnum* en);
	void (*add_error_domain) (ValaSymbol* self, ValaErrorDomain* edomain);
	void (*add_delegate) (ValaSymbol* self, ValaDelegate* d);
	void (*add_constant) (ValaSymbol* self, ValaConstant* constant);
	void (*add_field) (ValaSymbol* self, ValaField* f);
	void (*add_method) (ValaSymbol* self, ValaMethod* m);
	void (*add_property) (ValaSymbol* self, ValaProperty* prop);
	void (*add_signal) (ValaSymbol* self, ValaSignal* sig);
	void (*add_constructor) (ValaSymbol* self, ValaConstructor* c);
	void (*add_destructor) (ValaSymbol* self, ValaDestructor* d);
};

struct _ValaLockableIface {
	GTypeInterface parent_iface;
	gboolean (*get_lock_used) (ValaLockable* self);
	void (*set_lock_used) (ValaLockable* self, gboolean used);
};

struct _ValaProperty {
	ValaSymbol parent_instance;
	ValaPropertyPrivate * priv;
};

struct _ValaPropertyClass {
	ValaSymbolClass parent_class;
};

typedef enum  {
	VALA_MEMBER_BINDING_INSTANCE,
	VALA_MEMBER_BINDING_CLASS,
	VALA_MEMBER_BINDING_STATIC
} ValaMemberBinding;

struct _ValaPropertyPrivate {
	ValaFormalParameter* _this_parameter;
	gboolean _notify;
	gboolean _no_accessor_method;
	gboolean _interface_only;
	gboolean _is_abstract;
	gboolean _is_virtual;
	gboolean _overrides;
	ValaField* _field;
	ValaMemberBinding _binding;
	ValaExpression* _initializer;
	gboolean _no_array_length;
	gboolean _array_null_terminated;
	gboolean lock_used;
	ValaDataType* _data_type;
	gchar* _nick;
	gchar* _blurb;
	ValaProperty* _base_property;
	ValaProperty* _base_interface_property;
	gboolean base_properties_valid;
	ValaPropertyAccessor* _get_accessor;
	ValaPropertyAccessor* _set_accessor;
};

typedef enum  {
	VALA_SYMBOL_ACCESSIBILITY_PRIVATE,
	VALA_SYMBOL_ACCESSIBILITY_INTERNAL,
	VALA_SYMBOL_ACCESSIBILITY_PROTECTED,
	VALA_SYMBOL_ACCESSIBILITY_PUBLIC
} ValaSymbolAccessibility;


static gpointer vala_property_parent_class = NULL;
static ValaLockableIface* vala_property_vala_lockable_parent_iface = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
GType vala_semantic_analyzer_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_local_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
GType vala_namespace_get_type (void) G_GNUC_CONST;
GType vala_typesymbol_get_type (void) G_GNUC_CONST;
GType vala_object_type_symbol_get_type (void) G_GNUC_CONST;
GType vala_class_get_type (void) G_GNUC_CONST;
GType vala_interface_get_type (void) G_GNUC_CONST;
GType vala_struct_get_type (void) G_GNUC_CONST;
GType vala_enum_get_type (void) G_GNUC_CONST;
GType vala_error_domain_get_type (void) G_GNUC_CONST;
GType vala_delegate_get_type (void) G_GNUC_CONST;
GType vala_constant_get_type (void) G_GNUC_CONST;
GType vala_field_get_type (void) G_GNUC_CONST;
GType vala_method_get_type (void) G_GNUC_CONST;
GType vala_property_get_type (void) G_GNUC_CONST;
GType vala_signal_get_type (void) G_GNUC_CONST;
GType vala_constructor_get_type (void) G_GNUC_CONST;
GType vala_destructor_get_type (void) G_GNUC_CONST;
GType vala_lockable_get_type (void) G_GNUC_CONST;
GType vala_formal_parameter_get_type (void) G_GNUC_CONST;
GType vala_member_binding_get_type (void) G_GNUC_CONST;
GType vala_property_accessor_get_type (void) G_GNUC_CONST;
#define VALA_PROPERTY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_PROPERTY, ValaPropertyPrivate))
enum  {
	VALA_PROPERTY_DUMMY_PROPERTY
};
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
ValaProperty* vala_property_new (const gchar* name, ValaDataType* property_type, ValaPropertyAccessor* get_accessor, ValaPropertyAccessor* set_accessor, ValaSourceReference* source_reference, ValaComment* comment);
ValaProperty* vala_property_construct (GType object_type, const gchar* name, ValaDataType* property_type, ValaPropertyAccessor* get_accessor, ValaPropertyAccessor* set_accessor, ValaSourceReference* source_reference, ValaComment* comment);
ValaSymbol* vala_symbol_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment);
void vala_property_set_property_type (ValaProperty* self, ValaDataType* value);
void vala_property_set_get_accessor (ValaProperty* self, ValaPropertyAccessor* value);
void vala_property_set_set_accessor (ValaProperty* self, ValaPropertyAccessor* value);
static void vala_property_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_property (ValaCodeVisitor* self, ValaProperty* prop);
static void vala_property_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
ValaDataType* vala_property_get_property_type (ValaProperty* self);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
ValaPropertyAccessor* vala_property_get_get_accessor (ValaProperty* self);
ValaPropertyAccessor* vala_property_get_set_accessor (ValaProperty* self);
ValaExpression* vala_property_get_initializer (ValaProperty* self);
gchar* vala_property_get_upper_case_cname (ValaProperty* self);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
gchar* vala_symbol_get_lower_case_cname (ValaSymbol* self, const gchar* infix);
gchar* vala_symbol_camel_case_to_lower_case (const gchar* camel_case);
const gchar* vala_symbol_get_name (ValaSymbol* self);
ValaCCodeConstant* vala_property_get_canonical_cconstant (ValaProperty* self);
gchar* vala_property_get_canonical_name (ValaProperty* self);
static void vala_property_process_ccode_attribute (ValaProperty* self, ValaAttribute* a);
gboolean vala_attribute_has_argument (ValaAttribute* self, const gchar* name);
gboolean vala_attribute_get_bool (ValaAttribute* self, const gchar* name);
void vala_property_set_notify (ValaProperty* self, gboolean value);
void vala_property_set_no_array_length (ValaProperty* self, gboolean value);
void vala_property_set_array_null_terminated (ValaProperty* self, gboolean value);
void vala_property_process_attributes (ValaProperty* self);
const gchar* vala_attribute_get_name (ValaAttribute* self);
void vala_property_set_no_accessor_method (ValaProperty* self, gboolean value);
gchar* vala_attribute_get_string (ValaAttribute* self, const gchar* name);
void vala_property_set_nick (ValaProperty* self, const gchar* value);
void vala_property_set_blurb (ValaProperty* self, const gchar* value);
void vala_symbol_process_deprecated_attribute (ValaSymbol* self, ValaAttribute* attr);
static gboolean vala_property_real_get_lock_used (ValaLockable* base);
static void vala_property_real_set_lock_used (ValaLockable* base, gboolean used);
gboolean vala_property_equals (ValaProperty* self, ValaProperty* prop2);
ValaDataType* vala_property_accessor_get_value_type (ValaPropertyAccessor* self);
gboolean vala_data_type_equals (ValaDataType* self, ValaDataType* type2);
gboolean vala_property_accessor_get_writable (ValaPropertyAccessor* self);
gboolean vala_property_accessor_get_construction (ValaPropertyAccessor* self);
static void vala_property_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static void vala_property_find_base_properties (ValaProperty* self);
static void vala_property_find_base_interface_property (ValaProperty* self, ValaClass* cl);
gboolean vala_property_get_is_virtual (ValaProperty* self);
gboolean vala_property_get_overrides (ValaProperty* self);
static void vala_property_find_base_class_property (ValaProperty* self, ValaClass* cl);
gboolean vala_property_get_is_abstract (ValaProperty* self);
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
void vala_value_take_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void) G_GNUC_CONST;
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
ValaSymbol* vala_scope_lookup (ValaScope* self, const gchar* name);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
void vala_report_error (ValaSourceReference* source, const gchar* message);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
gchar* vala_symbol_get_full_name (ValaSymbol* self);
ValaClass* vala_class_get_base_class (ValaClass* self);
ValaList* vala_class_get_base_types (ValaClass* self);
ValaTypeSymbol* vala_data_type_get_data_type (ValaDataType* self);
static gboolean vala_property_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
gboolean vala_class_get_is_abstract (ValaClass* self);
gboolean vala_class_get_is_compact (ValaClass* self);
GType vala_symbol_accessibility_get_type (void) G_GNUC_CONST;
ValaSymbolAccessibility vala_symbol_get_access (ValaSymbol* self);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
ValaSourceFile* vala_semantic_analyzer_get_current_source_file (ValaSemanticAnalyzer* self);
ValaSymbol* vala_semantic_analyzer_get_current_symbol (ValaSemanticAnalyzer* self);
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
void vala_semantic_analyzer_set_current_source_file (ValaSemanticAnalyzer* self, ValaSourceFile* value);
void vala_semantic_analyzer_set_current_symbol (ValaSemanticAnalyzer* self, ValaSymbol* value);
GType vala_void_type_get_type (void) G_GNUC_CONST;
gboolean vala_code_node_check (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
gboolean vala_semantic_analyzer_is_type_accessible (ValaSemanticAnalyzer* self, ValaSymbol* sym, ValaDataType* type);
gchar* vala_code_node_to_string (ValaCodeNode* self);
ValaProperty* vala_property_get_base_property (ValaProperty* self);
gboolean vala_symbol_get_external_package (ValaSymbol* self);
gboolean vala_symbol_get_hides (ValaSymbol* self);
ValaSymbol* vala_symbol_get_hidden_member (ValaSymbol* self);
void vala_report_warning (ValaSourceReference* source, const gchar* message);
ValaDataType* vala_expression_get_value_type (ValaExpression* self);
gboolean vala_data_type_compatible (ValaDataType* self, ValaDataType* target_type);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
void vala_symbol_set_owner (ValaSymbol* self, ValaScope* value);
ValaFormalParameter* vala_property_get_this_parameter (ValaProperty* self);
void vala_property_set_this_parameter (ValaProperty* self, ValaFormalParameter* value);
gboolean vala_property_get_notify (ValaProperty* self);
gboolean vala_property_get_no_accessor_method (ValaProperty* self);
gboolean vala_property_get_interface_only (ValaProperty* self);
void vala_property_set_interface_only (ValaProperty* self, gboolean value);
void vala_property_set_is_abstract (ValaProperty* self, gboolean value);
void vala_property_set_is_virtual (ValaProperty* self, gboolean value);
void vala_property_set_overrides (ValaProperty* self, gboolean value);
ValaField* vala_property_get_field (ValaProperty* self);
void vala_property_set_field (ValaProperty* self, ValaField* value);
ValaMemberBinding vala_property_get_binding (ValaProperty* self);
void vala_property_set_binding (ValaProperty* self, ValaMemberBinding value);
ValaProperty* vala_property_get_base_interface_property (ValaProperty* self);
void vala_property_set_initializer (ValaProperty* self, ValaExpression* value);
gboolean vala_property_get_no_array_length (ValaProperty* self);
gboolean vala_property_get_array_null_terminated (ValaProperty* self);
const gchar* vala_property_get_nick (ValaProperty* self);
const gchar* vala_property_get_blurb (ValaProperty* self);
static void vala_property_finalize (ValaCodeNode* obj);


/**
 * Creates a new property.
 *
 * @param name         property name
 * @param type         property type
 * @param get_accessor get accessor
 * @param set_accessor set/construct accessor
 * @param source       reference to source code
 * @return             newly created property
 */
ValaProperty* vala_property_construct (GType object_type, const gchar* name, ValaDataType* property_type, ValaPropertyAccessor* get_accessor, ValaPropertyAccessor* set_accessor, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaProperty* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaProperty*) vala_symbol_construct (object_type, name, source_reference, comment);
	vala_property_set_property_type (self, property_type);
	vala_property_set_get_accessor (self, get_accessor);
	vala_property_set_set_accessor (self, set_accessor);
	return self;
}


ValaProperty* vala_property_new (const gchar* name, ValaDataType* property_type, ValaPropertyAccessor* get_accessor, ValaPropertyAccessor* set_accessor, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_property_construct (VALA_TYPE_PROPERTY, name, property_type, get_accessor, set_accessor, source_reference, comment);
}


static void vala_property_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaProperty * self;
	self = (ValaProperty*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_property (visitor, self);
}


static void vala_property_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaProperty * self;
	ValaDataType* _tmp0_ = NULL;
	ValaPropertyAccessor* _tmp1_ = NULL;
	ValaPropertyAccessor* _tmp3_ = NULL;
	self = (ValaProperty*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_property_get_property_type (self);
	vala_code_node_accept ((ValaCodeNode*) _tmp0_, visitor);
	_tmp1_ = vala_property_get_get_accessor (self);
	if (_tmp1_ != NULL) {
		ValaPropertyAccessor* _tmp2_ = NULL;
		_tmp2_ = vala_property_get_get_accessor (self);
		vala_code_node_accept ((ValaCodeNode*) _tmp2_, visitor);
	}
	_tmp3_ = vala_property_get_set_accessor (self);
	if (_tmp3_ != NULL) {
		ValaPropertyAccessor* _tmp4_ = NULL;
		_tmp4_ = vala_property_get_set_accessor (self);
		vala_code_node_accept ((ValaCodeNode*) _tmp4_, visitor);
	}
	if (self->priv->_initializer != NULL) {
		vala_code_node_accept ((ValaCodeNode*) self->priv->_initializer, visitor);
	}
}


/**
 * Returns the C name of this property in upper case. Words are
 * separated by underscores. The upper case C name of the class is
 * prefix of the result.
 *
 * @return the upper case name to be used in C code
 */
gchar* vala_property_get_upper_case_cname (ValaProperty* self) {
	gchar* result = NULL;
	ValaSymbol* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp1_ = vala_symbol_get_lower_case_cname (_tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp4_ = vala_symbol_camel_case_to_lower_case (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%s_%s", _tmp2_, _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_utf8_strup (_tmp7_, (gssize) (-1));
	result = (_tmp9_ = _tmp8_, _g_free0 (_tmp7_), _g_free0 (_tmp5_), _g_free0 (_tmp2_), _tmp9_);
	return result;
}


/**
 * Returns the string literal of this property to be used in C code.
 *
 * @return string literal to be used in C code
 */
ValaCCodeConstant* vala_property_get_canonical_cconstant (ValaProperty* self) {
	ValaCCodeConstant* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	ValaCCodeConstant* _tmp4_ = NULL;
	ValaCCodeConstant* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_property_get_canonical_name (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("\"%s\"", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_constant_new (_tmp3_);
	result = (_tmp5_ = _tmp4_, _g_free0 (_tmp3_), _g_free0 (_tmp1_), _tmp5_);
	return result;
}


static gunichar string_get_char (const gchar* self, gint index) {
	gunichar result = 0U;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = g_utf8_get_char (((gchar*) self) + index);
	result = _tmp0_;
	return result;
}


gchar* vala_property_get_canonical_name (ValaProperty* self) {
	gchar* result = NULL;
	GString* _tmp0_ = NULL;
	GString* str;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* i;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	str = _tmp0_;
	_tmp1_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp2_ = g_strdup (_tmp1_);
	i = _tmp2_;
	while (TRUE) {
		glong _tmp3_;
		gunichar _tmp4_;
		gunichar c;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp3_ = strlen (i);
		if (!(_tmp3_ > 0)) {
			break;
		}
		_tmp4_ = string_get_char (i, 0);
		c = _tmp4_;
		if (c == '_') {
			g_string_append_c (str, '-');
		} else {
			g_string_append_unichar (str, c);
		}
		_tmp5_ = g_utf8_next_char (i);
		_tmp6_ = g_strdup (_tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (i);
		i = _tmp7_;
	}
	_tmp8_ = g_strdup (str->str);
	result = _tmp8_;
	_g_free0 (i);
	_g_string_free0 (str);
	return result;
}


static void vala_property_process_ccode_attribute (ValaProperty* self, ValaAttribute* a) {
	gboolean _tmp0_;
	gboolean _tmp2_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	_tmp0_ = vala_attribute_has_argument (a, "notify");
	if (_tmp0_) {
		gboolean _tmp1_;
		_tmp1_ = vala_attribute_get_bool (a, "notify");
		vala_property_set_notify (self, _tmp1_);
	}
	_tmp2_ = vala_attribute_has_argument (a, "array_length");
	if (_tmp2_) {
		gboolean _tmp3_;
		_tmp3_ = vala_attribute_get_bool (a, "array_length");
		vala_property_set_no_array_length (self, !_tmp3_);
	}
	_tmp4_ = vala_attribute_has_argument (a, "array_null_terminated");
	if (_tmp4_) {
		gboolean _tmp5_;
		_tmp5_ = vala_attribute_get_bool (a, "array_null_terminated");
		vala_property_set_array_null_terminated (self, _tmp5_);
	}
}


/**
 * Process all associated attributes.
 */
static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_property_process_attributes (ValaProperty* self) {
	g_return_if_fail (self != NULL);
	{
		GList* a_collection;
		GList* a_it;
		a_collection = ((ValaCodeNode*) self)->attributes;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			ValaAttribute* _tmp0_;
			ValaAttribute* a;
			_tmp0_ = _vala_code_node_ref0 ((ValaAttribute*) a_it->data);
			a = _tmp0_;
			{
				const gchar* _tmp1_ = NULL;
				_tmp1_ = vala_attribute_get_name (a);
				if (g_strcmp0 (_tmp1_, "CCode") == 0) {
					vala_property_process_ccode_attribute (self, a);
				} else {
					const gchar* _tmp2_ = NULL;
					_tmp2_ = vala_attribute_get_name (a);
					if (g_strcmp0 (_tmp2_, "NoAccessorMethod") == 0) {
						vala_property_set_no_accessor_method (self, TRUE);
					} else {
						const gchar* _tmp3_ = NULL;
						_tmp3_ = vala_attribute_get_name (a);
						if (g_strcmp0 (_tmp3_, "Description") == 0) {
							gboolean _tmp4_;
							gboolean _tmp7_;
							_tmp4_ = vala_attribute_has_argument (a, "nick");
							if (_tmp4_) {
								gchar* _tmp5_ = NULL;
								gchar* _tmp6_;
								_tmp5_ = vala_attribute_get_string (a, "nick");
								_tmp6_ = _tmp5_;
								vala_property_set_nick (self, _tmp6_);
								_g_free0 (_tmp6_);
							}
							_tmp7_ = vala_attribute_has_argument (a, "blurb");
							if (_tmp7_) {
								gchar* _tmp8_ = NULL;
								gchar* _tmp9_;
								_tmp8_ = vala_attribute_get_string (a, "blurb");
								_tmp9_ = _tmp8_;
								vala_property_set_blurb (self, _tmp9_);
								_g_free0 (_tmp9_);
							}
						} else {
							const gchar* _tmp10_ = NULL;
							_tmp10_ = vala_attribute_get_name (a);
							if (g_strcmp0 (_tmp10_, "Deprecated") == 0) {
								vala_symbol_process_deprecated_attribute ((ValaSymbol*) self, a);
							}
						}
					}
				}
				_vala_code_node_unref0 (a);
			}
		}
	}
}


static gboolean vala_property_real_get_lock_used (ValaLockable* base) {
	ValaProperty * self;
	gboolean result = FALSE;
	self = (ValaProperty*) base;
	result = self->priv->lock_used;
	return result;
}


static void vala_property_real_set_lock_used (ValaLockable* base, gboolean used) {
	ValaProperty * self;
	self = (ValaProperty*) base;
	self->priv->lock_used = used;
}


/**
 * Checks whether the accessors and type of the specified property
 * matches this property.
 *
 * @param prop a property
 * @return     true if the specified property is compatible to this
 *             property
 */
gboolean vala_property_equals (ValaProperty* self, ValaProperty* prop2) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaPropertyAccessor* _tmp2_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	ValaPropertyAccessor* _tmp9_ = NULL;
	ValaPropertyAccessor* _tmp14_ = NULL;
	ValaPropertyAccessor* _tmp20_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (prop2 != NULL, FALSE);
	_tmp2_ = vala_property_get_get_accessor (self);
	if (_tmp2_ == NULL) {
		ValaPropertyAccessor* _tmp3_ = NULL;
		_tmp3_ = vala_property_get_get_accessor (prop2);
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		ValaPropertyAccessor* _tmp5_ = NULL;
		_tmp5_ = vala_property_get_get_accessor (self);
		if (_tmp5_ != NULL) {
			ValaPropertyAccessor* _tmp6_ = NULL;
			_tmp6_ = vala_property_get_get_accessor (prop2);
			_tmp4_ = _tmp6_ == NULL;
		} else {
			_tmp4_ = FALSE;
		}
		_tmp0_ = _tmp4_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp9_ = vala_property_get_set_accessor (self);
	if (_tmp9_ == NULL) {
		ValaPropertyAccessor* _tmp10_ = NULL;
		_tmp10_ = vala_property_get_set_accessor (prop2);
		_tmp8_ = _tmp10_ != NULL;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		gboolean _tmp11_ = FALSE;
		ValaPropertyAccessor* _tmp12_ = NULL;
		_tmp12_ = vala_property_get_set_accessor (self);
		if (_tmp12_ != NULL) {
			ValaPropertyAccessor* _tmp13_ = NULL;
			_tmp13_ = vala_property_get_set_accessor (prop2);
			_tmp11_ = _tmp13_ == NULL;
		} else {
			_tmp11_ = FALSE;
		}
		_tmp7_ = _tmp11_;
	}
	if (_tmp7_) {
		result = FALSE;
		return result;
	}
	_tmp14_ = vala_property_get_get_accessor (self);
	if (_tmp14_ != NULL) {
		ValaPropertyAccessor* _tmp15_ = NULL;
		ValaDataType* _tmp16_ = NULL;
		ValaPropertyAccessor* _tmp17_ = NULL;
		ValaDataType* _tmp18_ = NULL;
		gboolean _tmp19_;
		_tmp15_ = vala_property_get_get_accessor (prop2);
		_tmp16_ = vala_property_accessor_get_value_type (_tmp15_);
		_tmp17_ = vala_property_get_get_accessor (self);
		_tmp18_ = vala_property_accessor_get_value_type (_tmp17_);
		_tmp19_ = vala_data_type_equals (_tmp16_, _tmp18_);
		if (!_tmp19_) {
			result = FALSE;
			return result;
		}
	}
	_tmp20_ = vala_property_get_set_accessor (self);
	if (_tmp20_ != NULL) {
		ValaPropertyAccessor* _tmp21_ = NULL;
		ValaDataType* _tmp22_ = NULL;
		ValaPropertyAccessor* _tmp23_ = NULL;
		ValaDataType* _tmp24_ = NULL;
		gboolean _tmp25_;
		ValaPropertyAccessor* _tmp26_ = NULL;
		gboolean _tmp27_;
		ValaPropertyAccessor* _tmp28_ = NULL;
		gboolean _tmp29_;
		ValaPropertyAccessor* _tmp30_ = NULL;
		gboolean _tmp31_;
		ValaPropertyAccessor* _tmp32_ = NULL;
		gboolean _tmp33_;
		_tmp21_ = vala_property_get_set_accessor (prop2);
		_tmp22_ = vala_property_accessor_get_value_type (_tmp21_);
		_tmp23_ = vala_property_get_set_accessor (self);
		_tmp24_ = vala_property_accessor_get_value_type (_tmp23_);
		_tmp25_ = vala_data_type_equals (_tmp22_, _tmp24_);
		if (!_tmp25_) {
			result = FALSE;
			return result;
		}
		_tmp26_ = vala_property_get_set_accessor (self);
		_tmp27_ = vala_property_accessor_get_writable (_tmp26_);
		_tmp28_ = vala_property_get_set_accessor (prop2);
		_tmp29_ = vala_property_accessor_get_writable (_tmp28_);
		if (_tmp27_ != _tmp29_) {
			result = FALSE;
			return result;
		}
		_tmp30_ = vala_property_get_set_accessor (self);
		_tmp31_ = vala_property_accessor_get_construction (_tmp30_);
		_tmp32_ = vala_property_get_set_accessor (prop2);
		_tmp33_ = vala_property_accessor_get_construction (_tmp32_);
		if (_tmp31_ != _tmp33_) {
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}


static void vala_property_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaProperty * self;
	ValaDataType* _tmp0_ = NULL;
	self = (ValaProperty*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_property_get_property_type (self);
	if (_tmp0_ == old_type) {
		vala_property_set_property_type (self, new_type);
	}
}


static void vala_property_find_base_properties (ValaProperty* self) {
	ValaSymbol* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->base_properties_valid) {
		return;
	}
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	if (VALA_IS_CLASS (_tmp0_)) {
		ValaSymbol* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		_tmp1_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		vala_property_find_base_interface_property (self, VALA_CLASS (_tmp1_));
		if (self->priv->_is_virtual) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = self->priv->_overrides;
		}
		if (_tmp2_) {
			ValaSymbol* _tmp3_ = NULL;
			_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			vala_property_find_base_class_property (self, VALA_CLASS (_tmp3_));
		}
	} else {
		ValaSymbol* _tmp4_ = NULL;
		_tmp4_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		if (VALA_IS_INTERFACE (_tmp4_)) {
			gboolean _tmp5_ = FALSE;
			if (self->priv->_is_virtual) {
				_tmp5_ = TRUE;
			} else {
				_tmp5_ = self->priv->_is_abstract;
			}
			if (_tmp5_) {
				ValaProperty* _tmp6_;
				ValaProperty* _tmp7_;
				_tmp6_ = _vala_code_node_ref0 (self);
				_tmp7_ = _tmp6_;
				_vala_code_node_unref0 (self->priv->_base_interface_property);
				self->priv->_base_interface_property = _tmp7_;
			}
		}
	}
	self->priv->base_properties_valid = TRUE;
}


static void vala_property_find_base_class_property (ValaProperty* self, ValaClass* cl) {
	ValaScope* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	ValaSymbol* _tmp2_ = NULL;
	ValaSymbol* sym;
	ValaClass* _tmp13_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_symbol_get_scope ((ValaSymbol*) cl);
	_tmp1_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp2_ = vala_scope_lookup (_tmp0_, _tmp1_);
	sym = _tmp2_;
	if (VALA_IS_PROPERTY (sym)) {
		ValaProperty* _tmp3_;
		ValaProperty* base_property;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = _vala_code_node_ref0 (VALA_PROPERTY (sym));
		base_property = _tmp3_;
		if (base_property->priv->_is_abstract) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = base_property->priv->_is_virtual;
		}
		if (_tmp4_) {
			gboolean _tmp5_;
			_tmp5_ = vala_property_equals (self, base_property);
			if (!_tmp5_) {
				ValaSourceReference* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp7_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp8_ = _tmp7_;
				_tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) base_property);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strdup_printf ("Type and/or accessors of overriding property `%s' do not match overrid" \
"den property `%s'.", _tmp8_, _tmp10_);
				_tmp12_ = _tmp11_;
				vala_report_error (_tmp6_, _tmp12_);
				_g_free0 (_tmp12_);
				_g_free0 (_tmp10_);
				_g_free0 (_tmp8_);
				_vala_code_node_unref0 (base_property);
				_vala_code_node_unref0 (sym);
				return;
			}
			self->priv->_base_property = base_property;
			_vala_code_node_unref0 (base_property);
			_vala_code_node_unref0 (sym);
			return;
		}
		_vala_code_node_unref0 (base_property);
	}
	_tmp13_ = vala_class_get_base_class (cl);
	if (_tmp13_ != NULL) {
		ValaClass* _tmp14_ = NULL;
		_tmp14_ = vala_class_get_base_class (cl);
		vala_property_find_base_class_property (self, _tmp14_);
	}
	_vala_code_node_unref0 (sym);
}


static void vala_property_find_base_interface_property (ValaProperty* self, ValaClass* cl) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	{
		ValaList* _tmp0_ = NULL;
		ValaList* _type_list;
		gint _tmp1_;
		gint _type_size;
		gint _type_index;
		_tmp0_ = vala_class_get_base_types (cl);
		_type_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _type_list);
		_type_size = _tmp1_;
		_type_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			ValaDataType* type;
			ValaTypeSymbol* _tmp3_ = NULL;
			_type_index = _type_index + 1;
			if (!(_type_index < _type_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_type_list, _type_index);
			type = (ValaDataType*) _tmp2_;
			_tmp3_ = vala_data_type_get_data_type (type);
			if (VALA_IS_INTERFACE (_tmp3_)) {
				ValaTypeSymbol* _tmp4_ = NULL;
				ValaScope* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				ValaSymbol* _tmp7_ = NULL;
				ValaSymbol* sym;
				_tmp4_ = vala_data_type_get_data_type (type);
				_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) _tmp4_);
				_tmp6_ = vala_symbol_get_name ((ValaSymbol*) self);
				_tmp7_ = vala_scope_lookup (_tmp5_, _tmp6_);
				sym = _tmp7_;
				if (VALA_IS_PROPERTY (sym)) {
					ValaProperty* _tmp8_;
					ValaProperty* base_property;
					_tmp8_ = _vala_code_node_ref0 (VALA_PROPERTY (sym));
					base_property = _tmp8_;
					if (base_property->priv->_is_abstract) {
						gboolean _tmp9_;
						ValaProperty* _tmp17_;
						ValaProperty* _tmp18_;
						_tmp9_ = vala_property_equals (self, base_property);
						if (!_tmp9_) {
							ValaSourceReference* _tmp10_ = NULL;
							gchar* _tmp11_ = NULL;
							gchar* _tmp12_;
							gchar* _tmp13_ = NULL;
							gchar* _tmp14_;
							gchar* _tmp15_ = NULL;
							gchar* _tmp16_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp10_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp11_ = vala_symbol_get_full_name ((ValaSymbol*) self);
							_tmp12_ = _tmp11_;
							_tmp13_ = vala_symbol_get_full_name ((ValaSymbol*) base_property);
							_tmp14_ = _tmp13_;
							_tmp15_ = g_strdup_printf ("Type and/or accessors of overriding property `%s' do not match overrid" \
"den property `%s'.", _tmp12_, _tmp14_);
							_tmp16_ = _tmp15_;
							vala_report_error (_tmp10_, _tmp16_);
							_g_free0 (_tmp16_);
							_g_free0 (_tmp14_);
							_g_free0 (_tmp12_);
							_vala_code_node_unref0 (base_property);
							_vala_code_node_unref0 (sym);
							_vala_code_node_unref0 (type);
							_vala_iterable_unref0 (_type_list);
							return;
						}
						_tmp17_ = _vala_code_node_ref0 (base_property);
						_tmp18_ = _tmp17_;
						_vala_code_node_unref0 (self->priv->_base_interface_property);
						self->priv->_base_interface_property = _tmp18_;
						_vala_code_node_unref0 (base_property);
						_vala_code_node_unref0 (sym);
						_vala_code_node_unref0 (type);
						_vala_iterable_unref0 (_type_list);
						return;
					}
					_vala_code_node_unref0 (base_property);
				}
				_vala_code_node_unref0 (sym);
			}
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean vala_property_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaProperty * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	ValaSourceFile* _tmp25_ = NULL;
	ValaSourceFile* _tmp26_;
	ValaSourceFile* old_source_file;
	ValaSymbol* _tmp27_ = NULL;
	ValaSymbol* _tmp28_;
	ValaSymbol* old_symbol;
	ValaSourceReference* _tmp29_ = NULL;
	ValaDataType* _tmp32_ = NULL;
	ValaDataType* _tmp34_ = NULL;
	ValaPropertyAccessor* _tmp35_ = NULL;
	ValaPropertyAccessor* _tmp37_ = NULL;
	ValaDataType* _tmp39_ = NULL;
	gboolean _tmp40_;
	gboolean _tmp49_ = FALSE;
	gboolean _tmp56_ = FALSE;
	gboolean _tmp57_ = FALSE;
	gboolean _tmp58_ = FALSE;
	gboolean _tmp59_;
	gboolean _tmp72_ = FALSE;
	ValaPropertyAccessor* _tmp73_ = NULL;
	gboolean _tmp82_ = FALSE;
	gboolean _tmp83_ = FALSE;
	gboolean _tmp84_ = FALSE;
	gboolean _tmp99_;
	self = (ValaProperty*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	if (_tmp0_) {
		gboolean _tmp1_;
		_tmp1_ = vala_code_node_get_error ((ValaCodeNode*) self);
		result = !_tmp1_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	vala_property_process_attributes (self);
	if (self->priv->_is_abstract) {
		ValaSymbol* _tmp2_ = NULL;
		_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		if (VALA_IS_CLASS (_tmp2_)) {
			ValaSymbol* _tmp3_ = NULL;
			ValaClass* _tmp4_;
			ValaClass* cl;
			gboolean _tmp5_;
			_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp4_ = _vala_code_node_ref0 (VALA_CLASS (_tmp3_));
			cl = _tmp4_;
			_tmp5_ = vala_class_get_is_abstract (cl);
			if (!_tmp5_) {
				ValaSourceReference* _tmp6_ = NULL;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				vala_report_error (_tmp6_, "Abstract properties may not be declared in non-abstract classes");
				result = FALSE;
				_vala_code_node_unref0 (cl);
				return result;
			}
			_vala_code_node_unref0 (cl);
		} else {
			ValaSymbol* _tmp7_ = NULL;
			_tmp7_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			if (!VALA_IS_INTERFACE (_tmp7_)) {
				ValaSourceReference* _tmp8_ = NULL;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				vala_report_error (_tmp8_, "Abstract properties may not be declared outside of classes and interfa" \
"ces");
				result = FALSE;
				return result;
			}
		}
	} else {
		if (self->priv->_is_virtual) {
			gboolean _tmp9_ = FALSE;
			ValaSymbol* _tmp10_ = NULL;
			ValaSymbol* _tmp13_ = NULL;
			_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			if (!VALA_IS_CLASS (_tmp10_)) {
				ValaSymbol* _tmp11_ = NULL;
				_tmp11_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp9_ = !VALA_IS_INTERFACE (_tmp11_);
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				ValaSourceReference* _tmp12_ = NULL;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				vala_report_error (_tmp12_, "Virtual properties may not be declared outside of classes and interfac" \
"es");
				result = FALSE;
				return result;
			}
			_tmp13_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			if (VALA_IS_CLASS (_tmp13_)) {
				ValaSymbol* _tmp14_ = NULL;
				ValaClass* _tmp15_;
				ValaClass* cl;
				gboolean _tmp16_;
				_tmp14_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp15_ = _vala_code_node_ref0 (VALA_CLASS (_tmp14_));
				cl = _tmp15_;
				_tmp16_ = vala_class_get_is_compact (cl);
				if (_tmp16_) {
					ValaSourceReference* _tmp17_ = NULL;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp17_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					vala_report_error (_tmp17_, "Virtual properties may not be declared in compact classes");
					result = FALSE;
					_vala_code_node_unref0 (cl);
					return result;
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			if (self->priv->_overrides) {
				ValaSymbol* _tmp18_ = NULL;
				_tmp18_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				if (!VALA_IS_CLASS (_tmp18_)) {
					ValaSourceReference* _tmp19_ = NULL;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					vala_report_error (_tmp19_, "Properties may not be overridden outside of classes");
					result = FALSE;
					return result;
				}
			} else {
				ValaSymbolAccessibility _tmp20_;
				_tmp20_ = vala_symbol_get_access ((ValaSymbol*) self);
				if (_tmp20_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
					gboolean _tmp21_ = FALSE;
					ValaSymbol* _tmp22_ = NULL;
					_tmp22_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
					if (!VALA_IS_CLASS (_tmp22_)) {
						ValaSymbol* _tmp23_ = NULL;
						_tmp23_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
						_tmp21_ = !VALA_IS_INTERFACE (_tmp23_);
					} else {
						_tmp21_ = FALSE;
					}
					if (_tmp21_) {
						ValaSourceReference* _tmp24_ = NULL;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						vala_report_error (_tmp24_, "Protected properties may not be declared outside of classes and interf" \
"aces");
						result = FALSE;
						return result;
					}
				}
			}
		}
	}
	_tmp25_ = vala_semantic_analyzer_get_current_source_file (analyzer);
	_tmp26_ = _vala_source_file_ref0 (_tmp25_);
	old_source_file = _tmp26_;
	_tmp27_ = vala_semantic_analyzer_get_current_symbol (analyzer);
	_tmp28_ = _vala_code_node_ref0 (_tmp27_);
	old_symbol = _tmp28_;
	_tmp29_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	if (_tmp29_ != NULL) {
		ValaSourceReference* _tmp30_ = NULL;
		ValaSourceFile* _tmp31_ = NULL;
		_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp31_ = vala_source_reference_get_file (_tmp30_);
		vala_semantic_analyzer_set_current_source_file (analyzer, _tmp31_);
	}
	vala_semantic_analyzer_set_current_symbol (analyzer, (ValaSymbol*) self);
	_tmp32_ = vala_property_get_property_type (self);
	if (VALA_IS_VOID_TYPE (_tmp32_)) {
		ValaSourceReference* _tmp33_ = NULL;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		vala_report_error (_tmp33_, "'void' not supported as property type");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp34_ = vala_property_get_property_type (self);
	vala_code_node_check ((ValaCodeNode*) _tmp34_, analyzer);
	_tmp35_ = vala_property_get_get_accessor (self);
	if (_tmp35_ != NULL) {
		ValaPropertyAccessor* _tmp36_ = NULL;
		_tmp36_ = vala_property_get_get_accessor (self);
		vala_code_node_check ((ValaCodeNode*) _tmp36_, analyzer);
	}
	_tmp37_ = vala_property_get_set_accessor (self);
	if (_tmp37_ != NULL) {
		ValaPropertyAccessor* _tmp38_ = NULL;
		_tmp38_ = vala_property_get_set_accessor (self);
		vala_code_node_check ((ValaCodeNode*) _tmp38_, analyzer);
	}
	if (self->priv->_initializer != NULL) {
		vala_code_node_check ((ValaCodeNode*) self->priv->_initializer, analyzer);
	}
	_tmp39_ = vala_property_get_property_type (self);
	_tmp40_ = vala_semantic_analyzer_is_type_accessible (analyzer, (ValaSymbol*) self, _tmp39_);
	if (!_tmp40_) {
		ValaSourceReference* _tmp41_ = NULL;
		ValaDataType* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		gchar* _tmp44_;
		gchar* _tmp45_ = NULL;
		gchar* _tmp46_;
		gchar* _tmp47_ = NULL;
		gchar* _tmp48_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp42_ = vala_property_get_property_type (self);
		_tmp43_ = vala_code_node_to_string ((ValaCodeNode*) _tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp46_ = _tmp45_;
		_tmp47_ = g_strdup_printf ("property type `%s` is less accessible than property `%s`", _tmp44_, _tmp46_);
		_tmp48_ = _tmp47_;
		vala_report_error (_tmp41_, _tmp48_);
		_g_free0 (_tmp48_);
		_g_free0 (_tmp46_);
		_g_free0 (_tmp44_);
	}
	if (self->priv->_overrides) {
		ValaProperty* _tmp50_ = NULL;
		_tmp50_ = vala_property_get_base_property (self);
		_tmp49_ = _tmp50_ == NULL;
	} else {
		_tmp49_ = FALSE;
	}
	if (_tmp49_) {
		ValaSourceReference* _tmp51_ = NULL;
		gchar* _tmp52_ = NULL;
		gchar* _tmp53_;
		gchar* _tmp54_ = NULL;
		gchar* _tmp55_;
		_tmp51_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp52_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp53_ = _tmp52_;
		_tmp54_ = g_strdup_printf ("%s: no suitable property found to override", _tmp53_);
		_tmp55_ = _tmp54_;
		vala_report_error (_tmp51_, _tmp55_);
		_g_free0 (_tmp55_);
		_g_free0 (_tmp53_);
	}
	_tmp59_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	if (!_tmp59_) {
		_tmp58_ = !self->priv->_overrides;
	} else {
		_tmp58_ = FALSE;
	}
	if (_tmp58_) {
		gboolean _tmp60_;
		_tmp60_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp57_ = !_tmp60_;
	} else {
		_tmp57_ = FALSE;
	}
	if (_tmp57_) {
		ValaSymbol* _tmp61_ = NULL;
		ValaSymbol* _tmp62_;
		_tmp61_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp62_ = _tmp61_;
		_tmp56_ = _tmp62_ != NULL;
		_vala_code_node_unref0 (_tmp62_);
	} else {
		_tmp56_ = FALSE;
	}
	if (_tmp56_) {
		ValaSourceReference* _tmp63_ = NULL;
		gchar* _tmp64_ = NULL;
		gchar* _tmp65_;
		ValaSymbol* _tmp66_ = NULL;
		ValaSymbol* _tmp67_;
		gchar* _tmp68_ = NULL;
		gchar* _tmp69_;
		gchar* _tmp70_ = NULL;
		gchar* _tmp71_;
		_tmp63_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp64_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp65_ = _tmp64_;
		_tmp66_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp67_ = _tmp66_;
		_tmp68_ = vala_symbol_get_full_name (_tmp67_);
		_tmp69_ = _tmp68_;
		_tmp70_ = g_strdup_printf ("%s hides inherited property `%s'. Use the `new' keyword if hiding was " \
"intentional", _tmp65_, _tmp69_);
		_tmp71_ = _tmp70_;
		vala_report_warning (_tmp63_, _tmp71_);
		_g_free0 (_tmp71_);
		_g_free0 (_tmp69_);
		_vala_code_node_unref0 (_tmp67_);
		_g_free0 (_tmp65_);
	}
	_tmp73_ = vala_property_get_set_accessor (self);
	if (_tmp73_ != NULL) {
		ValaPropertyAccessor* _tmp74_ = NULL;
		gboolean _tmp75_;
		_tmp74_ = vala_property_get_set_accessor (self);
		_tmp75_ = vala_property_accessor_get_construction (_tmp74_);
		_tmp72_ = _tmp75_;
	} else {
		_tmp72_ = FALSE;
	}
	if (_tmp72_) {
		ValaSymbolAccessibility _tmp76_;
		_tmp76_ = vala_symbol_get_access ((ValaSymbol*) self);
		if (_tmp76_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
			ValaSourceReference* _tmp77_ = NULL;
			gchar* _tmp78_ = NULL;
			gchar* _tmp79_;
			gchar* _tmp80_ = NULL;
			gchar* _tmp81_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp77_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp78_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp79_ = _tmp78_;
			_tmp80_ = g_strdup_printf ("%s: construct properties must be public", _tmp79_);
			_tmp81_ = _tmp80_;
			vala_report_error (_tmp77_, _tmp81_);
			_g_free0 (_tmp81_);
			_g_free0 (_tmp79_);
		}
	}
	if (self->priv->_initializer != NULL) {
		gboolean _tmp85_;
		_tmp85_ = vala_code_node_get_error ((ValaCodeNode*) self->priv->_initializer);
		_tmp84_ = !_tmp85_;
	} else {
		_tmp84_ = FALSE;
	}
	if (_tmp84_) {
		ValaDataType* _tmp86_ = NULL;
		_tmp86_ = vala_expression_get_value_type (self->priv->_initializer);
		_tmp83_ = _tmp86_ != NULL;
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		ValaDataType* _tmp87_ = NULL;
		ValaDataType* _tmp88_ = NULL;
		gboolean _tmp89_;
		_tmp87_ = vala_expression_get_value_type (self->priv->_initializer);
		_tmp88_ = vala_property_get_property_type (self);
		_tmp89_ = vala_data_type_compatible (_tmp87_, _tmp88_);
		_tmp82_ = !_tmp89_;
	} else {
		_tmp82_ = FALSE;
	}
	if (_tmp82_) {
		ValaSourceReference* _tmp90_ = NULL;
		ValaDataType* _tmp91_ = NULL;
		gchar* _tmp92_ = NULL;
		gchar* _tmp93_;
		ValaDataType* _tmp94_ = NULL;
		gchar* _tmp95_ = NULL;
		gchar* _tmp96_;
		gchar* _tmp97_ = NULL;
		gchar* _tmp98_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp90_ = vala_code_node_get_source_reference ((ValaCodeNode*) self->priv->_initializer);
		_tmp91_ = vala_property_get_property_type (self);
		_tmp92_ = vala_code_node_to_string ((ValaCodeNode*) _tmp91_);
		_tmp93_ = _tmp92_;
		_tmp94_ = vala_expression_get_value_type (self->priv->_initializer);
		_tmp95_ = vala_code_node_to_string ((ValaCodeNode*) _tmp94_);
		_tmp96_ = _tmp95_;
		_tmp97_ = g_strdup_printf ("Expected initializer of type `%s' but got `%s'", _tmp93_, _tmp96_);
		_tmp98_ = _tmp97_;
		vala_report_error (_tmp90_, _tmp98_);
		_g_free0 (_tmp98_);
		_g_free0 (_tmp96_);
		_g_free0 (_tmp93_);
	}
	vala_semantic_analyzer_set_current_source_file (analyzer, old_source_file);
	vala_semantic_analyzer_set_current_symbol (analyzer, old_symbol);
	_tmp99_ = vala_code_node_get_error ((ValaCodeNode*) self);
	result = !_tmp99_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


ValaDataType* vala_property_get_property_type (ValaProperty* self) {
	ValaDataType* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_data_type;
	return result;
}


void vala_property_set_property_type (ValaProperty* self, ValaDataType* value) {
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_tmp1_ = _tmp0_;
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp1_;
	if (value != NULL) {
		vala_code_node_set_parent_node ((ValaCodeNode*) self->priv->_data_type, (ValaCodeNode*) self);
	}
}


ValaPropertyAccessor* vala_property_get_get_accessor (ValaProperty* self) {
	ValaPropertyAccessor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_get_accessor;
	return result;
}


void vala_property_set_get_accessor (ValaProperty* self, ValaPropertyAccessor* value) {
	ValaPropertyAccessor* _tmp0_;
	ValaPropertyAccessor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_tmp1_ = _tmp0_;
	_vala_code_node_unref0 (self->priv->_get_accessor);
	self->priv->_get_accessor = _tmp1_;
	if (value != NULL) {
		ValaScope* _tmp2_ = NULL;
		_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
		vala_symbol_set_owner ((ValaSymbol*) value, _tmp2_);
	}
}


ValaPropertyAccessor* vala_property_get_set_accessor (ValaProperty* self) {
	ValaPropertyAccessor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_set_accessor;
	return result;
}


void vala_property_set_set_accessor (ValaProperty* self, ValaPropertyAccessor* value) {
	ValaPropertyAccessor* _tmp0_;
	ValaPropertyAccessor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_tmp1_ = _tmp0_;
	_vala_code_node_unref0 (self->priv->_set_accessor);
	self->priv->_set_accessor = _tmp1_;
	if (value != NULL) {
		ValaScope* _tmp2_ = NULL;
		_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
		vala_symbol_set_owner ((ValaSymbol*) value, _tmp2_);
	}
}


ValaFormalParameter* vala_property_get_this_parameter (ValaProperty* self) {
	ValaFormalParameter* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_this_parameter;
	return result;
}


void vala_property_set_this_parameter (ValaProperty* self, ValaFormalParameter* value) {
	ValaFormalParameter* _tmp0_;
	ValaFormalParameter* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_tmp1_ = _tmp0_;
	_vala_code_node_unref0 (self->priv->_this_parameter);
	self->priv->_this_parameter = _tmp1_;
}


gboolean vala_property_get_notify (ValaProperty* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_notify;
	return result;
}


void vala_property_set_notify (ValaProperty* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_notify = value;
}


gboolean vala_property_get_no_accessor_method (ValaProperty* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_no_accessor_method;
	return result;
}


void vala_property_set_no_accessor_method (ValaProperty* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_no_accessor_method = value;
}


gboolean vala_property_get_interface_only (ValaProperty* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_interface_only;
	return result;
}


void vala_property_set_interface_only (ValaProperty* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_interface_only = value;
}


gboolean vala_property_get_is_abstract (ValaProperty* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}


void vala_property_set_is_abstract (ValaProperty* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}


gboolean vala_property_get_is_virtual (ValaProperty* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_virtual;
	return result;
}


void vala_property_set_is_virtual (ValaProperty* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_virtual = value;
}


gboolean vala_property_get_overrides (ValaProperty* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_overrides;
	return result;
}


void vala_property_set_overrides (ValaProperty* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_overrides = value;
}


ValaField* vala_property_get_field (ValaProperty* self) {
	ValaField* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_field;
	return result;
}


void vala_property_set_field (ValaProperty* self, ValaField* value) {
	ValaField* _tmp0_;
	ValaField* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_tmp1_ = _tmp0_;
	_vala_code_node_unref0 (self->priv->_field);
	self->priv->_field = _tmp1_;
}


ValaMemberBinding vala_property_get_binding (ValaProperty* self) {
	ValaMemberBinding result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_binding;
	return result;
}


void vala_property_set_binding (ValaProperty* self, ValaMemberBinding value) {
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}


ValaProperty* vala_property_get_base_property (ValaProperty* self) {
	ValaProperty* result;
	g_return_val_if_fail (self != NULL, NULL);
	vala_property_find_base_properties (self);
	result = self->priv->_base_property;
	return result;
}


ValaProperty* vala_property_get_base_interface_property (ValaProperty* self) {
	ValaProperty* result;
	g_return_val_if_fail (self != NULL, NULL);
	vala_property_find_base_properties (self);
	result = self->priv->_base_interface_property;
	return result;
}


ValaExpression* vala_property_get_initializer (ValaProperty* self) {
	ValaExpression* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_initializer;
	return result;
}


void vala_property_set_initializer (ValaProperty* self, ValaExpression* value) {
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_tmp1_ = _tmp0_;
	_vala_code_node_unref0 (self->priv->_initializer);
	self->priv->_initializer = _tmp1_;
}


gboolean vala_property_get_no_array_length (ValaProperty* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_no_array_length;
	return result;
}


void vala_property_set_no_array_length (ValaProperty* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_no_array_length = value;
}


gboolean vala_property_get_array_null_terminated (ValaProperty* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_array_null_terminated;
	return result;
}


void vala_property_set_array_null_terminated (ValaProperty* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_array_null_terminated = value;
}


const gchar* vala_property_get_nick (ValaProperty* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_nick == NULL) {
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		_tmp0_ = vala_property_get_canonical_name (self);
		_tmp1_ = _tmp0_;
		_g_free0 (self->priv->_nick);
		self->priv->_nick = _tmp1_;
	}
	result = self->priv->_nick;
	return result;
}


void vala_property_set_nick (ValaProperty* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_nick);
	self->priv->_nick = _tmp1_;
}


const gchar* vala_property_get_blurb (ValaProperty* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_blurb == NULL) {
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		_tmp0_ = vala_property_get_canonical_name (self);
		_tmp1_ = _tmp0_;
		_g_free0 (self->priv->_blurb);
		self->priv->_blurb = _tmp1_;
	}
	result = self->priv->_blurb;
	return result;
}


void vala_property_set_blurb (ValaProperty* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_blurb);
	self->priv->_blurb = _tmp1_;
}


static void vala_property_class_init (ValaPropertyClass * klass) {
	vala_property_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_property_finalize;
	g_type_class_add_private (klass, sizeof (ValaPropertyPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_property_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_property_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_property_real_replace_type;
	VALA_CODE_NODE_CLASS (klass)->check = vala_property_real_check;
}


static void vala_property_vala_lockable_interface_init (ValaLockableIface * iface) {
	vala_property_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = (gboolean (*)(ValaLockable*)) vala_property_real_get_lock_used;
	iface->set_lock_used = (void (*)(ValaLockable* ,gboolean)) vala_property_real_set_lock_used;
}


static void vala_property_instance_init (ValaProperty * self) {
	self->priv = VALA_PROPERTY_GET_PRIVATE (self);
	self->priv->_notify = TRUE;
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
	self->priv->lock_used = FALSE;
}


static void vala_property_finalize (ValaCodeNode* obj) {
	ValaProperty * self;
	self = VALA_PROPERTY (obj);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	_vala_code_node_unref0 (self->priv->_field);
	_vala_code_node_unref0 (self->priv->_initializer);
	_vala_code_node_unref0 (self->priv->_data_type);
	_g_free0 (self->priv->_nick);
	_g_free0 (self->priv->_blurb);
	_vala_code_node_unref0 (self->priv->_base_interface_property);
	_vala_code_node_unref0 (self->priv->_get_accessor);
	_vala_code_node_unref0 (self->priv->_set_accessor);
	VALA_CODE_NODE_CLASS (vala_property_parent_class)->finalize (obj);
}


/**
 * Represents a property declaration in the source code.
 */
GType vala_property_get_type (void) {
	static volatile gsize vala_property_type_id__volatile = 0;
	if (g_once_init_enter (&vala_property_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaPropertyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_property_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaProperty), 0, (GInstanceInitFunc) vala_property_instance_init, NULL };
		static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_property_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_property_type_id;
		vala_property_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaProperty", &g_define_type_info, 0);
		g_type_add_interface_static (vala_property_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
		g_once_init_leave (&vala_property_type_id__volatile, vala_property_type_id);
	}
	return vala_property_type_id__volatile;
}



