/* valavapigen.c generated by valac, the Vala compiler
 * generated from valavapigen.vala, do not modify */

/* valavapigen.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <valagee.h>
#include <version.h>


#define VALA_TYPE_VAPI_GEN (vala_vapi_gen_get_type ())
#define VALA_VAPI_GEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VAPI_GEN, ValaVAPIGen))
#define VALA_VAPI_GEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VAPI_GEN, ValaVAPIGenClass))
#define VALA_IS_VAPI_GEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VAPI_GEN))
#define VALA_IS_VAPI_GEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VAPI_GEN))
#define VALA_VAPI_GEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VAPI_GEN, ValaVAPIGenClass))

typedef struct _ValaVAPIGen ValaVAPIGen;
typedef struct _ValaVAPIGenClass ValaVAPIGenClass;
typedef struct _ValaVAPIGenPrivate ValaVAPIGenPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

#define VALA_TYPE_GIDL_PARSER (vala_gidl_parser_get_type ())
#define VALA_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParser))
#define VALA_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))
#define VALA_IS_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIDL_PARSER))
#define VALA_IS_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIDL_PARSER))
#define VALA_GIDL_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))

typedef struct _ValaGIdlParser ValaGIdlParser;
typedef struct _ValaGIdlParserClass ValaGIdlParserClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _ValaVAPIGen {
	GObject parent_instance;
	ValaVAPIGenPrivate * priv;
};

struct _ValaVAPIGenClass {
	GObjectClass parent_class;
};

struct _ValaVAPIGenPrivate {
	ValaCodeContext* context;
};


static gpointer vala_vapi_gen_parent_class = NULL;
static char* vala_vapi_gen_directory;
static char* vala_vapi_gen_directory = NULL;
static gboolean vala_vapi_gen_version;
static gboolean vala_vapi_gen_version = FALSE;
static gboolean vala_vapi_gen_quiet_mode;
static gboolean vala_vapi_gen_quiet_mode = FALSE;
static char** vala_vapi_gen_sources;
static char** vala_vapi_gen_sources = NULL;
static char** vala_vapi_gen_vapi_directories;
static char** vala_vapi_gen_vapi_directories = NULL;
static char** vala_vapi_gen_gir_directories;
static char** vala_vapi_gen_gir_directories = NULL;
static char* vala_vapi_gen_library;
static char* vala_vapi_gen_library = NULL;
static char** vala_vapi_gen_packages;
static char** vala_vapi_gen_packages = NULL;
static char* vala_vapi_gen_metadata_filename;
static char* vala_vapi_gen_metadata_filename = NULL;

GType vala_vapi_gen_get_type (void) G_GNUC_CONST;
#define VALA_VAPI_GEN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_VAPI_GEN, ValaVAPIGenPrivate))
enum  {
	VALA_VAPI_GEN_DUMMY_PROPERTY
};
static gint vala_vapi_gen_quit (ValaVAPIGen* self);
static gint vala_vapi_gen_run (ValaVAPIGen* self);
static char** _vala_array_dup1 (char** self, int length);
static char** _vala_array_dup2 (char** self, int length);
ValaGIdlParser* vala_gidl_parser_new (void);
ValaGIdlParser* vala_gidl_parser_construct (GType object_type);
GType vala_gidl_parser_get_type (void) G_GNUC_CONST;
void vala_gidl_parser_parse (ValaGIdlParser* self, ValaCodeContext* context);
static gint vala_vapi_gen_main (char** args, int args_length1);
ValaVAPIGen* vala_vapi_gen_new (void);
ValaVAPIGen* vala_vapi_gen_construct (GType object_type);
static void vala_vapi_gen_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_VAPI_GEN_options[10] = {{"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_gir_directories, "Look for GIR bindings in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_vapi_gen_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_vapi_gen_library, "Library name", "NAME"}, {"metadata", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_vapi_gen_metadata_filename, "Metadata filename", "FILE"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_vapi_gen_directory, "Output directory", "DIRECTORY"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_vapi_gen_version, "Display version number", NULL}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_vapi_gen_quiet_mode, "Do not print messages to the console", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_sources, NULL, "FILE..."}, {NULL}};

static gint vala_vapi_gen_quit (ValaVAPIGen* self) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	if (vala_report_get_errors (vala_code_context_get_report (self->priv->context)) == 0) {
		if (!vala_vapi_gen_quiet_mode) {
			fprintf (stdout, "Generation succeeded - %d warning(s)\n", vala_report_get_warnings (vala_code_context_get_report (self->priv->context)));
		}
		result = 0;
		return result;
	} else {
		if (!vala_vapi_gen_quiet_mode) {
			fprintf (stdout, "Generation failed: %d error(s), %d warning(s)\n", vala_report_get_errors (vala_code_context_get_report (self->priv->context)), vala_report_get_warnings (vala_code_context_get_report (self->priv->context)));
		}
		result = 1;
		return result;
	}
}


static char** _vala_array_dup1 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static char** _vala_array_dup2 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static const char* string_offset (const char* self, glong offset) {
	const char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = (const char*) (((gchar*) self) + offset);
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = strlen (self);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = string_offset (self, offset);
	result = g_strndup (start, ((gchar*) string_offset (start, len)) - ((gchar*) start));
	return result;
}


static gint vala_vapi_gen_run (ValaVAPIGen* self) {
	gint result = 0;
	ValaCodeContext* _tmp0_;
	char** _tmp1_;
	char** _tmp2_;
	char** _tmp3_;
	char** _tmp4_;
	char** _tmp10_;
	ValaParser* parser;
	ValaGirParser* girparser;
	ValaGIdlParser* gidlparser;
	ValaSymbolResolver* resolver;
	ValaSemanticAnalyzer* analyzer;
	gboolean _tmp11_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	self->priv->context = (_tmp0_ = vala_code_context_new (), _vala_code_context_unref0 (self->priv->context), _tmp0_);
	vala_code_context_set_profile (self->priv->context, VALA_PROFILE_GOBJECT);
	self->priv->context->vapi_directories = (_tmp2_ = (_tmp1_ = vala_vapi_gen_vapi_directories, (_tmp1_ == NULL) ? ((gpointer) _tmp1_) : _vala_array_dup1 (_tmp1_, _vala_array_length (vala_vapi_gen_vapi_directories))), self->priv->context->vapi_directories = (_vala_array_free (self->priv->context->vapi_directories, self->priv->context->vapi_directories_length1, (GDestroyNotify) g_free), NULL), self->priv->context->vapi_directories_length1 = _vala_array_length (vala_vapi_gen_vapi_directories), _tmp2_);
	self->priv->context->gir_directories = (_tmp4_ = (_tmp3_ = vala_vapi_gen_gir_directories, (_tmp3_ == NULL) ? ((gpointer) _tmp3_) : _vala_array_dup2 (_tmp3_, _vala_array_length (vala_vapi_gen_gir_directories))), self->priv->context->gir_directories = (_vala_array_free (self->priv->context->gir_directories, self->priv->context->gir_directories_length1, (GDestroyNotify) g_free), NULL), self->priv->context->gir_directories_length1 = _vala_array_length (vala_vapi_gen_gir_directories), _tmp4_);
	vala_code_context_push (self->priv->context);
	vala_code_context_add_external_package (self->priv->context, "glib-2.0");
	vala_code_context_add_external_package (self->priv->context, "gobject-2.0");
	if (vala_report_get_errors (vala_code_context_get_report (self->priv->context)) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	{
		char** source_collection;
		int source_collection_length1;
		int source_it;
		source_collection = vala_vapi_gen_sources;
		source_collection_length1 = _vala_array_length (vala_vapi_gen_sources);
		for (source_it = 0; source_it < _vala_array_length (vala_vapi_gen_sources); source_it = source_it + 1) {
			char* source;
			source = g_strdup (source_collection[source_it]);
			{
				char* _tmp5_;
				char* _tmp6_;
				char* depsfile;
				if (!g_str_has_suffix (source, ".gi")) {
					_g_free0 (source);
					continue;
				}
				depsfile = (_tmp6_ = g_strconcat (_tmp5_ = string_substring (source, (glong) 0, strlen (source) - strlen ("gi")), "deps", NULL), _g_free0 (_tmp5_), _tmp6_);
				vala_code_context_add_packages_from_file (self->priv->context, depsfile);
				_g_free0 (depsfile);
				_g_free0 (source);
			}
		}
	}
	if (vala_report_get_errors (vala_code_context_get_report (self->priv->context)) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	if (vala_vapi_gen_library != NULL) {
		char* depsfile;
		depsfile = g_strconcat (vala_vapi_gen_library, ".deps", NULL);
		vala_code_context_add_packages_from_file (self->priv->context, depsfile);
		_g_free0 (depsfile);
	} else {
		vala_report_error (NULL, "--library option must be specified");
	}
	if (vala_report_get_errors (vala_code_context_get_report (self->priv->context)) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	if (vala_vapi_gen_packages != NULL) {
		char** _tmp7_;
		{
			char** package_collection;
			int package_collection_length1;
			int package_it;
			package_collection = vala_vapi_gen_packages;
			package_collection_length1 = _vala_array_length (vala_vapi_gen_packages);
			for (package_it = 0; package_it < _vala_array_length (vala_vapi_gen_packages); package_it = package_it + 1) {
				char* package;
				package = g_strdup (package_collection[package_it]);
				{
					vala_code_context_add_external_package (self->priv->context, package);
					_g_free0 (package);
				}
			}
		}
		vala_vapi_gen_packages = (_tmp7_ = NULL, vala_vapi_gen_packages = (_vala_array_free (vala_vapi_gen_packages, _vala_array_length (vala_vapi_gen_packages), (GDestroyNotify) g_free), NULL), _tmp7_);
	}
	if (vala_report_get_errors (vala_code_context_get_report (self->priv->context)) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	{
		char** source_collection;
		int source_collection_length1;
		int source_it;
		source_collection = vala_vapi_gen_sources;
		source_collection_length1 = _vala_array_length (vala_vapi_gen_sources);
		for (source_it = 0; source_it < _vala_array_length (vala_vapi_gen_sources); source_it = source_it + 1) {
			char* source;
			source = g_strdup (source_collection[source_it]);
			{
				if (g_file_test (source, G_FILE_TEST_EXISTS)) {
					ValaSourceFile* _tmp8_;
					vala_code_context_add_source_file (self->priv->context, _tmp8_ = vala_source_file_new (self->priv->context, SOURCE_FILE_TYPE_PACKAGE, source, NULL));
					_vala_source_file_unref0 (_tmp8_);
				} else {
					char* _tmp9_;
					vala_report_error (NULL, _tmp9_ = g_strdup_printf ("%s not found", source));
					_g_free0 (_tmp9_);
				}
				_g_free0 (source);
			}
		}
	}
	vala_vapi_gen_sources = (_tmp10_ = NULL, vala_vapi_gen_sources = (_vala_array_free (vala_vapi_gen_sources, _vala_array_length (vala_vapi_gen_sources), (GDestroyNotify) g_free), NULL), _tmp10_);
	if (vala_report_get_errors (vala_code_context_get_report (self->priv->context)) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	parser = vala_parser_new ();
	vala_parser_parse (parser, self->priv->context);
	if (vala_report_get_errors (vala_code_context_get_report (self->priv->context)) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	girparser = vala_gir_parser_new ();
	if (vala_vapi_gen_metadata_filename != NULL) {
		vala_gir_parser_parse_metadata (girparser, vala_vapi_gen_metadata_filename);
	}
	vala_gir_parser_parse (girparser, self->priv->context);
	if (vala_report_get_errors (vala_code_context_get_report (self->priv->context)) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	gidlparser = vala_gidl_parser_new ();
	vala_gidl_parser_parse (gidlparser, self->priv->context);
	if (vala_report_get_errors (vala_code_context_get_report (self->priv->context)) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (gidlparser);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	resolver = vala_symbol_resolver_new ();
	vala_symbol_resolver_resolve (resolver, self->priv->context);
	if (vala_report_get_errors (vala_code_context_get_report (self->priv->context)) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (resolver);
		_vala_code_visitor_unref0 (gidlparser);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	analyzer = vala_semantic_analyzer_new ();
	vala_semantic_analyzer_analyze (analyzer, self->priv->context);
	if (vala_report_get_errors (vala_code_context_get_report (self->priv->context)) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (analyzer);
		_vala_code_visitor_unref0 (resolver);
		_vala_code_visitor_unref0 (gidlparser);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	if (vala_vapi_gen_library == NULL) {
		gint _tmp12_;
		char** _tmp13_;
		gint _tmp13__length1;
		_tmp11_ = (_tmp13_ = vala_gir_parser_get_package_names (girparser, &_tmp12_), _tmp13__length1 = _tmp12_, _tmp13_) != NULL;
		_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		gint _tmp14_;
		gint names_length1;
		gint _names_size_;
		char** _tmp15_;
		char** names;
		char* _tmp16_;
		names = (_tmp15_ = vala_gir_parser_get_package_names (girparser, &_tmp14_), names_length1 = _tmp14_, _names_size_ = names_length1, _tmp15_);
		if (names_length1 != 1) {
			vala_report_error (NULL, "multiple packages encountered and no library name given");
			result = vala_vapi_gen_quit (self);
			names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
			_vala_code_visitor_unref0 (analyzer);
			_vala_code_visitor_unref0 (resolver);
			_vala_code_visitor_unref0 (gidlparser);
			_vala_code_visitor_unref0 (girparser);
			_vala_code_visitor_unref0 (parser);
			return result;
		}
		vala_vapi_gen_library = (_tmp16_ = g_strdup (names[0]), _g_free0 (vala_vapi_gen_library), _tmp16_);
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	}
	if (vala_vapi_gen_library != NULL) {
		ValaCodeWriter* interface_writer;
		char* _tmp17_;
		char* _tmp18_;
		{
			ValaList* _file_list;
			gint _file_size;
			gint _file_index;
			_file_list = vala_code_context_get_source_files (self->priv->context);
			_file_size = vala_collection_get_size ((ValaCollection*) _file_list);
			_file_index = -1;
			while (TRUE) {
				ValaSourceFile* file;
				if (!((_file_index = _file_index + 1) < _file_size)) {
					break;
				}
				file = (ValaSourceFile*) vala_list_get (_file_list, _file_index);
				if (!g_str_has_suffix (vala_source_file_get_filename (file), ".vapi")) {
					vala_source_file_set_file_type (file, SOURCE_FILE_TYPE_SOURCE);
				}
				_vala_source_file_unref0 (file);
			}
			_vala_iterable_unref0 (_file_list);
		}
		interface_writer = vala_code_writer_new (CODE_WRITER_TYPE_EXTERNAL);
		vala_code_writer_write_file (interface_writer, self->priv->context, _tmp17_ = g_strdup_printf ("%s.vapi", vala_vapi_gen_library));
		_g_free0 (_tmp17_);
		vala_vapi_gen_library = (_tmp18_ = NULL, _g_free0 (vala_vapi_gen_library), _tmp18_);
		_vala_code_visitor_unref0 (interface_writer);
	}
	result = vala_vapi_gen_quit (self);
	_vala_code_visitor_unref0 (analyzer);
	_vala_code_visitor_unref0 (resolver);
	_vala_code_visitor_unref0 (gidlparser);
	_vala_code_visitor_unref0 (girparser);
	_vala_code_visitor_unref0 (parser);
	return result;
}


static gint vala_vapi_gen_main (char** args, int args_length1) {
	gint result = 0;
	GOptionContext* opt_context;
	ValaVAPIGen* vapigen;
	GError * _inner_error_ = NULL;
	opt_context = g_option_context_new ("- Vala API Generator");
	g_option_context_set_help_enabled (opt_context, TRUE);
	g_option_context_add_main_entries (opt_context, VALA_VAPI_GEN_options, NULL);
	g_option_context_parse (opt_context, &args_length1, &args, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (opt_context);
		if (_inner_error_->domain == G_OPTION_ERROR) {
			goto __catch2_g_option_error;
		}
		_g_option_context_free0 (opt_context);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_g_option_context_free0 (opt_context);
	goto __finally2;
	__catch2_g_option_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stdout, "%s\n", e->message);
		fprintf (stdout, "Run '%s --help' to see a full list of available command line options.\n", args[0]);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	if (vala_vapi_gen_version) {
		fprintf (stdout, "Vala API Generator %s\n", BUILD_VERSION);
		result = 0;
		return result;
	}
	if (vala_vapi_gen_sources == NULL) {
		fprintf (stderr, "No source file specified.\n");
		result = 1;
		return result;
	}
	vapigen = vala_vapi_gen_new ();
	result = vala_vapi_gen_run (vapigen);
	_g_object_unref0 (vapigen);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return vala_vapi_gen_main (argv, argc);
}


ValaVAPIGen* vala_vapi_gen_construct (GType object_type) {
	ValaVAPIGen * self;
	self = (ValaVAPIGen*) g_object_new (object_type, NULL);
	return self;
}


ValaVAPIGen* vala_vapi_gen_new (void) {
	return vala_vapi_gen_construct (VALA_TYPE_VAPI_GEN);
}


static void vala_vapi_gen_class_init (ValaVAPIGenClass * klass) {
	vala_vapi_gen_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaVAPIGenPrivate));
	G_OBJECT_CLASS (klass)->finalize = vala_vapi_gen_finalize;
}


static void vala_vapi_gen_instance_init (ValaVAPIGen * self) {
	self->priv = VALA_VAPI_GEN_GET_PRIVATE (self);
}


static void vala_vapi_gen_finalize (GObject* obj) {
	ValaVAPIGen * self;
	self = VALA_VAPI_GEN (obj);
	_vala_code_context_unref0 (self->priv->context);
	G_OBJECT_CLASS (vala_vapi_gen_parent_class)->finalize (obj);
}


GType vala_vapi_gen_get_type (void) {
	static volatile gsize vala_vapi_gen_type_id__volatile = 0;
	if (g_once_init_enter (&vala_vapi_gen_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaVAPIGenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_vapi_gen_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaVAPIGen), 0, (GInstanceInitFunc) vala_vapi_gen_instance_init, NULL };
		GType vala_vapi_gen_type_id;
		vala_vapi_gen_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaVAPIGen", &g_define_type_info, 0);
		g_once_init_leave (&vala_vapi_gen_type_id__volatile, vala_vapi_gen_type_id);
	}
	return vala_vapi_gen_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



