/*
 * wsdl-soap-memory.c: Runtime memory management
 *
 * Authors:
 *	Dick Porter (dick@ximian.com)
 *
 * Copyright (C) 2001, Ximian, Inc.
 */

#include <glib.h>
#include <stdlib.h>

#include "wsdl-param.h"
#include "wsdl-soap-memory.h"

void wsdl_soap_initialise(const wsdl_param * const params)
{
	const wsdl_param *param;

	/* Zero the memory that will be filled in with type data */
	param=params;
		
	while(param->name!=NULL) {
		if(param->typecode==NULL) {
			g_warning(G_GNUC_FUNCTION
				  ": Parameter %s has no typecode!",
				  param->name);
		} else {
			if(param->param==NULL) {
				g_warning(G_GNUC_FUNCTION
					  ": Parameter %s has no memory location!",
					  param->name);
			} else {
				memset(param->param, '\0',
				       wsdl_typecode_size(param->typecode));
			}
		}
			
		param++;
	}
}

void wsdl_soap_free(const wsdl_param *const params G_GNUC_UNUSED)
{
	const wsdl_param *param;

	/* Free the memory that pointed to by '->param' if it isnt NULL */
	param=params;
		
	while(param->name!=NULL) {
		if(param->typecode==NULL) {
			g_warning(G_GNUC_FUNCTION
				  ": Parameter %s has no typecode!",
				  param->name);
		} else {
			if(param->param!=NULL &&
			   *(guchar **)param->param!=NULL &&
			   param->typecode->free_func!=NULL) {
				param->typecode->free_func(*(guchar **)param->param);
			}
		}
			
		param++;
	}
}
