/* rygel-tracker-titles.c generated by valac 0.11.5, the Vala compiler
 * generated from rygel-tracker-titles.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TRACKER_TYPE_METADATA_VALUES (rygel_tracker_metadata_values_get_type ())
#define RYGEL_TRACKER_METADATA_VALUES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_METADATA_VALUES, RygelTrackerMetadataValues))
#define RYGEL_TRACKER_METADATA_VALUES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_METADATA_VALUES, RygelTrackerMetadataValuesClass))
#define RYGEL_TRACKER_IS_METADATA_VALUES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_METADATA_VALUES))
#define RYGEL_TRACKER_IS_METADATA_VALUES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_METADATA_VALUES))
#define RYGEL_TRACKER_METADATA_VALUES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_METADATA_VALUES, RygelTrackerMetadataValuesClass))

typedef struct _RygelTrackerMetadataValues RygelTrackerMetadataValues;
typedef struct _RygelTrackerMetadataValuesClass RygelTrackerMetadataValuesClass;
typedef struct _RygelTrackerMetadataValuesPrivate RygelTrackerMetadataValuesPrivate;

#define RYGEL_TRACKER_TYPE_TITLES (rygel_tracker_titles_get_type ())
#define RYGEL_TRACKER_TITLES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_TITLES, RygelTrackerTitles))
#define RYGEL_TRACKER_TITLES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_TITLES, RygelTrackerTitlesClass))
#define RYGEL_TRACKER_IS_TITLES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_TITLES))
#define RYGEL_TRACKER_IS_TITLES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_TITLES))
#define RYGEL_TRACKER_TITLES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_TITLES, RygelTrackerTitlesClass))

typedef struct _RygelTrackerTitles RygelTrackerTitles;
typedef struct _RygelTrackerTitlesClass RygelTrackerTitlesClass;
typedef struct _RygelTrackerTitlesPrivate RygelTrackerTitlesPrivate;

#define RYGEL_TRACKER_TYPE_ITEM_FACTORY (rygel_tracker_item_factory_get_type ())
#define RYGEL_TRACKER_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactory))
#define RYGEL_TRACKER_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))
#define RYGEL_TRACKER_IS_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_IS_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))

typedef struct _RygelTrackerItemFactory RygelTrackerItemFactory;
typedef struct _RygelTrackerItemFactoryClass RygelTrackerItemFactoryClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelTrackerMetadataValues {
	RygelSimpleContainer parent_instance;
	RygelTrackerMetadataValuesPrivate * priv;
	gchar** key_chain;
	gint key_chain_length1;
};

struct _RygelTrackerMetadataValuesClass {
	RygelSimpleContainerClass parent_class;
	gchar* (*create_id_for_title) (RygelTrackerMetadataValues* self, const gchar* title);
	gchar* (*create_title_for_value) (RygelTrackerMetadataValues* self, const gchar* value);
	gchar* (*create_filter) (RygelTrackerMetadataValues* self, const gchar* variable, const gchar* value);
};

struct _RygelTrackerTitles {
	RygelTrackerMetadataValues parent_instance;
	RygelTrackerTitlesPrivate * priv;
};

struct _RygelTrackerTitlesClass {
	RygelTrackerMetadataValuesClass parent_class;
};


static gpointer rygel_tracker_titles_parent_class = NULL;

GType rygel_tracker_metadata_values_get_type (void) G_GNUC_CONST;
GType rygel_tracker_titles_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_TRACKER_TITLES_DUMMY_PROPERTY
};
gpointer rygel_tracker_item_factory_ref (gpointer instance);
void rygel_tracker_item_factory_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_item_factory (GValue* value, gpointer v_object);
void rygel_tracker_value_take_item_factory (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_item_factory (const GValue* value);
GType rygel_tracker_item_factory_get_type (void) G_GNUC_CONST;
RygelTrackerTitles* rygel_tracker_titles_new (RygelMediaContainer* parent, RygelTrackerItemFactory* item_factory);
RygelTrackerTitles* rygel_tracker_titles_construct (GType object_type, RygelMediaContainer* parent, RygelTrackerItemFactory* item_factory);
RygelTrackerMetadataValues* rygel_tracker_metadata_values_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelTrackerItemFactory* item_factory, gchar** key_chain, int key_chain_length1, const gchar* child_class);
static gchar* rygel_tracker_titles_real_create_title_for_value (RygelTrackerMetadataValues* base, const gchar* value);
static gchar* rygel_tracker_titles_real_create_filter (RygelTrackerMetadataValues* base, const gchar* variable, const gchar* value);
gchar* rygel_tracker_metadata_values_create_title_for_value (RygelTrackerMetadataValues* self, const gchar* value);

static const gchar* RYGEL_TRACKER_TITLES_KEY_CHAIN[2] = {"nie:title", NULL};

RygelTrackerTitles* rygel_tracker_titles_construct (GType object_type, RygelMediaContainer* parent, RygelTrackerItemFactory* item_factory) {
	RygelTrackerTitles * self = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (item_factory != NULL, NULL);
	_tmp0_ = g_strconcat (((RygelMediaObject*) parent)->id, "Titles", NULL);
	_tmp1_ = _ ("Titles");
	self = (RygelTrackerTitles*) rygel_tracker_metadata_values_construct (object_type, _tmp0_, parent, _tmp1_, item_factory, RYGEL_TRACKER_TITLES_KEY_CHAIN, G_N_ELEMENTS (RYGEL_TRACKER_TITLES_KEY_CHAIN), NULL);
	_g_free0 (_tmp0_);
	return self;
}


RygelTrackerTitles* rygel_tracker_titles_new (RygelMediaContainer* parent, RygelTrackerItemFactory* item_factory) {
	return rygel_tracker_titles_construct (RYGEL_TRACKER_TYPE_TITLES, parent, item_factory);
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* str;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}


static gchar* rygel_tracker_titles_real_create_title_for_value (RygelTrackerMetadataValues* base, const gchar* value) {
	RygelTrackerTitles * self;
	gchar* result = NULL;
	gunichar _tmp0_;
	gunichar c;
	gboolean _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	self = (RygelTrackerTitles*) base;
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = g_utf8_get_char_validated (value, (gssize) (-1));
	c = _tmp0_;
	_tmp1_ = G_UNLIKELY (c < 0);
	if (_tmp1_) {
		result = NULL;
		return result;
	}
	_tmp2_ = g_unichar_to_string (c);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_utf8_strup (_tmp3_, (gssize) (-1));
	result = (_tmp5_ = _tmp4_, _g_free0 (_tmp3_), _tmp5_);
	return result;
}


static gchar* rygel_tracker_titles_real_create_filter (RygelTrackerMetadataValues* base, const gchar* variable, const gchar* value) {
	RygelTrackerTitles * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* title;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	self = (RygelTrackerTitles*) base;
	g_return_val_if_fail (variable != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = rygel_tracker_metadata_values_create_title_for_value ((RygelTrackerMetadataValues*) self, value);
	title = _tmp0_;
	_tmp1_ = g_strconcat ("regex(", variable, NULL);
	_tmp2_ = g_strconcat (_tmp1_, ", \"^", NULL);
	_tmp3_ = g_strconcat (_tmp2_, title, NULL);
	result = (_tmp4_ = g_strconcat (_tmp3_, "\", \"i\")", NULL), _g_free0 (_tmp3_), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _tmp4_);
	_g_free0 (title);
	return result;
}


static void rygel_tracker_titles_class_init (RygelTrackerTitlesClass * klass) {
	rygel_tracker_titles_parent_class = g_type_class_peek_parent (klass);
	RYGEL_TRACKER_METADATA_VALUES_CLASS (klass)->create_title_for_value = rygel_tracker_titles_real_create_title_for_value;
	RYGEL_TRACKER_METADATA_VALUES_CLASS (klass)->create_filter = rygel_tracker_titles_real_create_filter;
}


static void rygel_tracker_titles_instance_init (RygelTrackerTitles * self) {
}


/**
 * Container providing a title-based hierarchy.
 *
 * Under each category container, add a container providing a title-based
 * hierarchy: One container for each unique starting character of all the titles
 * available for the contegory in question. Something like this:
 *
 * Music
 *   |
 *   |----> Genre
 *           |..
 *   ^
 *   |----> Titles
 *           |
 *           |---> A
 *                 |
 *                 |--> Alpha
 *                 |--> alright
 *           ^
 *           |---> B
 *                 |
 *                 |--> Bravo
 *                 |--> brave
 *                 |..
 *           ^
 *   ^       |..
 *   |..
 */
GType rygel_tracker_titles_get_type (void) {
	static volatile gsize rygel_tracker_titles_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_titles_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerTitlesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_titles_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerTitles), 0, (GInstanceInitFunc) rygel_tracker_titles_instance_init, NULL };
		GType rygel_tracker_titles_type_id;
		rygel_tracker_titles_type_id = g_type_register_static (RYGEL_TRACKER_TYPE_METADATA_VALUES, "RygelTrackerTitles", &g_define_type_info, 0);
		g_once_init_leave (&rygel_tracker_titles_type_id__volatile, rygel_tracker_titles_type_id);
	}
	return rygel_tracker_titles_type_id__volatile;
}



