/* rygel-writable-user-config.c generated by valac 0.11.3, the Vala compiler
 * generated from rygel-writable-user-config.vala, do not modify */

/*
 * Copyright (C) 2008-2011 Nokia Corporation.
 * Copyright (C) 2008,2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <gio/gio.h>


#define RYGEL_TYPE_WRITABLE_USER_CONFIG (rygel_writable_user_config_get_type ())
#define RYGEL_WRITABLE_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_USER_CONFIG, RygelWritableUserConfig))
#define RYGEL_WRITABLE_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_WRITABLE_USER_CONFIG, RygelWritableUserConfigClass))
#define RYGEL_IS_WRITABLE_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_USER_CONFIG))
#define RYGEL_IS_WRITABLE_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_WRITABLE_USER_CONFIG))
#define RYGEL_WRITABLE_USER_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_WRITABLE_USER_CONFIG, RygelWritableUserConfigClass))

typedef struct _RygelWritableUserConfig RygelWritableUserConfig;
typedef struct _RygelWritableUserConfigClass RygelWritableUserConfigClass;
typedef struct _RygelWritableUserConfigPrivate RygelWritableUserConfigPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelWritableUserConfig {
	RygelUserConfig parent_instance;
	RygelWritableUserConfigPrivate * priv;
};

struct _RygelWritableUserConfigClass {
	RygelUserConfigClass parent_class;
};


static gpointer rygel_writable_user_config_parent_class = NULL;

GType rygel_writable_user_config_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_WRITABLE_USER_CONFIG_DUMMY_PROPERTY
};
#define RYGEL_WRITABLE_USER_CONFIG_RYGEL_SERVICE "org.gnome.Rygel1"
#define RYGEL_WRITABLE_USER_CONFIG_RYGEL_PATH "/org/gnome/Rygel1"
#define RYGEL_WRITABLE_USER_CONFIG_RYGEL_INTERFACE "org.gnome.Rygel1"
void rygel_writable_user_config_set_upnp_enabled (RygelWritableUserConfig* self, gboolean value);
static void rygel_writable_user_config_enable_upnp (RygelWritableUserConfig* self, gboolean enable);
void rygel_writable_user_config_set_interface (RygelWritableUserConfig* self, const gchar* value);
void rygel_writable_user_config_set_string (RygelWritableUserConfig* self, const gchar* section, const gchar* key, const gchar* value);
void rygel_writable_user_config_set_port (RygelWritableUserConfig* self, gint value);
void rygel_writable_user_config_set_int (RygelWritableUserConfig* self, const gchar* section, const gchar* key, gint value);
void rygel_writable_user_config_set_transcoding (RygelWritableUserConfig* self, gboolean value);
void rygel_writable_user_config_set_bool (RygelWritableUserConfig* self, const gchar* section, const gchar* key, gboolean value);
void rygel_writable_user_config_set_mp3_transcoder (RygelWritableUserConfig* self, gboolean value);
void rygel_writable_user_config_set_mp2ts_transcoder (RygelWritableUserConfig* self, gboolean value);
void rygel_writable_user_config_set_lpcm_transcoder (RygelWritableUserConfig* self, gboolean value);
void rygel_writable_user_config_set_wmv_transcoder (RygelWritableUserConfig* self, gboolean value);
void rygel_writable_user_config_set_allow_upload (RygelWritableUserConfig* self, gboolean value, GError** error);
void rygel_writable_user_config_set_allow_deletion (RygelWritableUserConfig* self, gboolean value, GError** error);
RygelWritableUserConfig* rygel_writable_user_config_new (GError** error);
RygelWritableUserConfig* rygel_writable_user_config_construct (GType object_type, GError** error);
void rygel_writable_user_config_save (RygelWritableUserConfig* self);
void rygel_writable_user_config_set_string_list (RygelWritableUserConfig* self, const gchar* section, const gchar* key, GeeArrayList* str_list);
static void rygel_writable_user_config_ensure_dir_exists (RygelWritableUserConfig* self, const gchar* dir_path, GError** error);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


void rygel_writable_user_config_set_upnp_enabled (RygelWritableUserConfig* self, gboolean value) {
	gboolean enabled;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	enabled = FALSE;
	_tmp0_ = rygel_configuration_get_upnp_enabled ((RygelConfiguration*) self, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch13_g_error;
	}
	enabled = _tmp1_;
	goto __finally13;
	__catch13_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	if (value != enabled) {
		rygel_writable_user_config_enable_upnp (self, value);
	}
}


void rygel_writable_user_config_set_interface (RygelWritableUserConfig* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	rygel_writable_user_config_set_string (self, "general", RYGEL_USER_CONFIG_IFACE_KEY, value);
}


void rygel_writable_user_config_set_port (RygelWritableUserConfig* self, gint value) {
	g_return_if_fail (self != NULL);
	rygel_writable_user_config_set_int (self, "general", RYGEL_USER_CONFIG_PORT_KEY, value);
}


void rygel_writable_user_config_set_transcoding (RygelWritableUserConfig* self, gboolean value) {
	g_return_if_fail (self != NULL);
	rygel_writable_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_TRANSCODING_KEY, value);
}


void rygel_writable_user_config_set_mp3_transcoder (RygelWritableUserConfig* self, gboolean value) {
	g_return_if_fail (self != NULL);
	rygel_writable_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_MP3_TRANSCODER_KEY, value);
}


void rygel_writable_user_config_set_mp2ts_transcoder (RygelWritableUserConfig* self, gboolean value) {
	g_return_if_fail (self != NULL);
	rygel_writable_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_MP2TS_TRANSCODER_KEY, value);
}


void rygel_writable_user_config_set_lpcm_transcoder (RygelWritableUserConfig* self, gboolean value) {
	g_return_if_fail (self != NULL);
	rygel_writable_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_LPCM_TRANSCODER_KEY, value);
}


void rygel_writable_user_config_set_wmv_transcoder (RygelWritableUserConfig* self, gboolean value) {
	g_return_if_fail (self != NULL);
	rygel_writable_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_WMV_TRANSCODER_KEY, value);
}


void rygel_writable_user_config_set_allow_upload (RygelWritableUserConfig* self, gboolean value, GError** error) {
	g_return_if_fail (self != NULL);
	rygel_writable_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_ALLOW_UPLOAD_KEY, value);
}


void rygel_writable_user_config_set_allow_deletion (RygelWritableUserConfig* self, gboolean value, GError** error) {
	g_return_if_fail (self != NULL);
	rygel_writable_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_ALLOW_DELETION_KEY, value);
}


RygelWritableUserConfig* rygel_writable_user_config_construct (GType object_type, GError** error) {
	RygelWritableUserConfig * self = NULL;
	GKeyFile* _tmp0_ = NULL;
	GKeyFile* _tmp1_;
	gchar** _tmp2_ = NULL;
	gint dirs_length1;
	gint _dirs_size_;
	gchar** _tmp3_;
	gchar** dirs;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* path;
	gchar* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelWritableUserConfig*) rygel_user_config_construct (object_type, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp0_ = g_key_file_new ();
	_tmp1_ = _tmp0_;
	_g_key_file_free0 (((RygelUserConfig*) self)->key_file);
	((RygelUserConfig*) self)->key_file = _tmp1_;
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp3_ = _tmp2_;
	dirs_length1 = 2;
	_dirs_size_ = dirs_length1;
	dirs = _tmp3_;
	_tmp4_ = g_get_user_config_dir ();
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (dirs[0]);
	dirs[0] = _tmp6_;
	_tmp7_ = g_strdup (SYS_CONFIG_DIR);
	_tmp8_ = _tmp7_;
	_g_free0 (dirs[1]);
	dirs[1] = _tmp8_;
	path = NULL;
	g_key_file_load_from_dirs (((RygelUserConfig*) self)->key_file, RYGEL_USER_CONFIG_CONFIG_FILE, dirs, &_tmp9_, G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error_);
	_g_free0 (path);
	path = _tmp9_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (path);
		dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		return NULL;
	}
	g_debug ("rygel-writable-user-config.vala:96: Loaded user configuration from fil" \
"e '%s'", path);
	_g_free0 (path);
	dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


RygelWritableUserConfig* rygel_writable_user_config_new (GError** error) {
	return rygel_writable_user_config_construct (RYGEL_TYPE_WRITABLE_USER_CONFIG, error);
}


void rygel_writable_user_config_save (RygelWritableUserConfig* self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* path;
	gsize length = 0UL;
	gsize _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* data;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_build_filename (_tmp0_, RYGEL_USER_CONFIG_CONFIG_FILE, NULL);
	path = _tmp1_;
	_tmp3_ = g_key_file_to_data (((RygelUserConfig*) self)->key_file, &_tmp2_, NULL);
	length = _tmp2_;
	data = _tmp3_;
	g_file_set_contents (path, data, (gssize) ((glong) length), &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_FILE_ERROR) {
			goto __catch14_g_file_error;
		}
		_g_free0 (data);
		_g_free0 (path);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	goto __finally14;
	__catch14_g_file_error:
	{
		GError * err;
		const gchar* _tmp4_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = _ ("Failed to save configuration data to file '%s': %s");
		g_critical (_tmp4_, path, err->message);
		_g_error_free0 (err);
	}
	__finally14:
	if (_inner_error_ != NULL) {
		_g_free0 (data);
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (data);
	_g_free0 (path);
}


void rygel_writable_user_config_set_string (RygelWritableUserConfig* self, const gchar* section, const gchar* key, const gchar* value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	g_key_file_set_string (((RygelUserConfig*) self)->key_file, section, key, value);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void rygel_writable_user_config_set_string_list (RygelWritableUserConfig* self, const gchar* section, const gchar* key, GeeArrayList* str_list) {
	gint _tmp0_;
	gchar** _tmp1_ = NULL;
	gint strings_length1;
	gint _strings_size_;
	gchar** _tmp2_;
	gchar** strings;
	gint i;
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (str_list != NULL);
	_tmp0_ = gee_collection_get_size ((GeeCollection*) str_list);
	_tmp1_ = g_new0 (gchar*, _tmp0_ + 1);
	_tmp2_ = _tmp1_;
	strings_length1 = _tmp0_;
	_strings_size_ = strings_length1;
	strings = _tmp2_;
	i = 0;
	{
		GeeArrayList* _tmp3_;
		GeeArrayList* _str_list;
		gint _tmp4_;
		gint _str_size;
		gint _str_index;
		_tmp3_ = _g_object_ref0 (str_list);
		_str_list = _tmp3_;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _str_list);
		_str_size = _tmp4_;
		_str_index = -1;
		while (TRUE) {
			gpointer _tmp5_ = NULL;
			gchar* str;
			_str_index = _str_index + 1;
			if (!(_str_index < _str_size)) {
				break;
			}
			_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _str_list, _str_index);
			str = (gchar*) _tmp5_;
			if (g_strcmp0 (str, "") != 0) {
				gint _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp6_ = i;
				i = _tmp6_ + 1;
				_tmp7_ = g_strdup (str);
				_tmp8_ = _tmp7_;
				_g_free0 (strings[_tmp6_]);
				strings[_tmp6_] = _tmp8_;
			}
			_g_free0 (str);
		}
		_g_object_unref0 (_str_list);
	}
	g_key_file_set_string_list (((RygelUserConfig*) self)->key_file, section, key, (const gchar* const*) strings, strings_length1);
	strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
}


void rygel_writable_user_config_set_int (RygelWritableUserConfig* self, const gchar* section, const gchar* key, gint value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	g_return_if_fail (key != NULL);
	g_key_file_set_integer (((RygelUserConfig*) self)->key_file, section, key, value);
}


void rygel_writable_user_config_set_bool (RygelWritableUserConfig* self, const gchar* section, const gchar* key, gboolean value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	g_return_if_fail (key != NULL);
	g_key_file_set_boolean (((RygelUserConfig*) self)->key_file, section, key, value);
}


static void rygel_writable_user_config_enable_upnp (RygelWritableUserConfig* self, gboolean enable) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* config_dir;
	gchar* _tmp2_ = NULL;
	gchar* dest_dir;
	gchar* _tmp3_ = NULL;
	gchar* dest_path;
	GFile* _tmp4_ = NULL;
	GFile* dest;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	config_dir = _tmp1_;
	rygel_writable_user_config_ensure_dir_exists (self, config_dir, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (config_dir);
		goto __catch15_g_error;
	}
	_tmp2_ = g_build_filename (config_dir, "autostart", NULL);
	dest_dir = _tmp2_;
	rygel_writable_user_config_ensure_dir_exists (self, dest_dir, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (dest_dir);
		_g_free0 (config_dir);
		goto __catch15_g_error;
	}
	_tmp3_ = g_build_filename (dest_dir, "rygel.desktop", NULL);
	dest_path = _tmp3_;
	_tmp4_ = g_file_new_for_path (dest_path);
	dest = _tmp4_;
	if (enable) {
		FreeDesktopDBusObject* _tmp5_ = NULL;
		FreeDesktopDBusObject* dbus;
		gchar* _tmp6_ = NULL;
		gchar* source_path;
		_tmp5_ = g_initable_new (FREE_DESKTOP_TYPE_DBUS_OBJECT_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", FREE_DESKTOP_DBUS_SERVICE, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", FREE_DESKTOP_DBUS_OBJECT, "g-interface-name", "org.freedesktop.DBus", NULL);
		dbus = (FreeDesktopDBusObject*) _tmp5_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dest);
			_g_free0 (dest_path);
			_g_free0 (dest_dir);
			_g_free0 (config_dir);
			goto __catch15_g_error;
		}
		free_desktop_dbus_object_start_service_by_name (dbus, RYGEL_DBUS_INTERFACE_SERVICE_NAME, (guint32) 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dbus);
			_g_object_unref0 (dest);
			_g_free0 (dest_path);
			_g_free0 (dest_dir);
			_g_free0 (config_dir);
			goto __catch15_g_error;
		}
		_tmp6_ = g_build_filename (DESKTOP_DIR, "rygel.desktop", NULL);
		source_path = _tmp6_;
		g_file_make_symbolic_link (dest, source_path, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
				goto __catch16_g_io_error_exists;
			}
			goto __finally16;
		}
		goto __finally16;
		__catch16_g_io_error_exists:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (err);
		}
		__finally16:
		if (_inner_error_ != NULL) {
			_g_free0 (source_path);
			_g_object_unref0 (dbus);
			_g_object_unref0 (dest);
			_g_free0 (dest_path);
			_g_free0 (dest_dir);
			_g_free0 (config_dir);
			goto __catch15_g_error;
		}
		rygel_writable_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_ENABLED_KEY, TRUE);
		_g_free0 (source_path);
		_g_object_unref0 (dbus);
	} else {
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp7_ = rygel_configuration_get_enabled ((RygelConfiguration*) self, "general", &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dest);
			_g_free0 (dest_path);
			_g_free0 (dest_dir);
			_g_free0 (config_dir);
			goto __catch15_g_error;
		}
		if (_tmp8_) {
			RygelDBusInterface* _tmp9_ = NULL;
			RygelDBusInterface* rygel_proxy;
			_tmp9_ = g_initable_new (RYGEL_TYPE_DBUS_INTERFACE_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", RYGEL_DBUS_INTERFACE_SERVICE_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", RYGEL_DBUS_INTERFACE_OBJECT_PATH, "g-interface-name", "org.gnome.Rygel1", NULL);
			rygel_proxy = (RygelDBusInterface*) _tmp9_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (dest);
				_g_free0 (dest_path);
				_g_free0 (dest_dir);
				_g_free0 (config_dir);
				goto __catch15_g_error;
			}
			rygel_dbus_interface_shutdown (rygel_proxy, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (rygel_proxy);
				_g_object_unref0 (dest);
				_g_free0 (dest_path);
				_g_free0 (dest_dir);
				_g_free0 (config_dir);
				goto __catch15_g_error;
			}
			_g_object_unref0 (rygel_proxy);
		}
		g_file_delete (dest, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
				goto __catch17_g_io_error_not_found;
			}
			goto __finally17;
		}
		goto __finally17;
		__catch17_g_io_error_not_found:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (err);
		}
		__finally17:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dest);
			_g_free0 (dest_path);
			_g_free0 (dest_dir);
			_g_free0 (config_dir);
			goto __catch15_g_error;
		}
		rygel_writable_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_ENABLED_KEY, FALSE);
	}
	_g_object_unref0 (dest);
	_g_free0 (dest_path);
	_g_free0 (dest_dir);
	_g_free0 (config_dir);
	goto __finally15;
	__catch15_g_error:
	{
		GError * err;
		gchar* message;
		err = _inner_error_;
		_inner_error_ = NULL;
		message = NULL;
		if (enable) {
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp10_ = _ ("Failed to start Rygel service: %s");
			_tmp11_ = g_strdup (_tmp10_);
			_tmp12_ = _tmp11_;
			_g_free0 (message);
			message = _tmp12_;
		} else {
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp13_ = _ ("Failed to stop Rygel service: %s");
			_tmp14_ = g_strdup (_tmp13_);
			_tmp15_ = _tmp14_;
			_g_free0 (message);
			message = _tmp15_;
		}
		g_warning (message, err->message);
		_g_free0 (message);
		_g_error_free0 (err);
	}
	__finally15:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_writable_user_config_ensure_dir_exists (RygelWritableUserConfig* self, const gchar* dir_path, GError** error) {
	GFile* _tmp0_ = NULL;
	GFile* dir;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir_path != NULL);
	_tmp0_ = g_file_new_for_path (dir_path);
	dir = _tmp0_;
	g_file_make_directory (dir, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
			goto __catch18_g_io_error_exists;
		}
		goto __finally18;
	}
	goto __finally18;
	__catch18_g_io_error_exists:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally18:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (dir);
		return;
	}
	_g_object_unref0 (dir);
}


static void rygel_writable_user_config_class_init (RygelWritableUserConfigClass * klass) {
	rygel_writable_user_config_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_writable_user_config_instance_init (RygelWritableUserConfig * self) {
}


/**
 * Manages the user configuration for Rygel.
 */
GType rygel_writable_user_config_get_type (void) {
	static volatile gsize rygel_writable_user_config_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_writable_user_config_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelWritableUserConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_writable_user_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelWritableUserConfig), 0, (GInstanceInitFunc) rygel_writable_user_config_instance_init, NULL };
		GType rygel_writable_user_config_type_id;
		rygel_writable_user_config_type_id = g_type_register_static (RYGEL_TYPE_USER_CONFIG, "RygelWritableUserConfig", &g_define_type_info, 0);
		g_once_init_leave (&rygel_writable_user_config_type_id__volatile, rygel_writable_user_config_type_id);
	}
	return rygel_writable_user_config_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



