/* rygel-user-config.c generated by valac 0.11.3, the Vala compiler
 * generated from rygel-user-config.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Nokia Corporation.
 * Copyright (C) 2008,2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <config.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;

#define RYGEL_TYPE_LOG_LEVEL (rygel_log_level_get_type ())

#define RYGEL_TYPE_USER_CONFIG (rygel_user_config_get_type ())
#define RYGEL_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_USER_CONFIG, RygelUserConfig))
#define RYGEL_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_USER_CONFIG, RygelUserConfigClass))
#define RYGEL_IS_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_USER_CONFIG))
#define RYGEL_IS_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_USER_CONFIG))
#define RYGEL_USER_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_USER_CONFIG, RygelUserConfigClass))

typedef struct _RygelUserConfig RygelUserConfig;
typedef struct _RygelUserConfigClass RygelUserConfigClass;
typedef struct _RygelUserConfigPrivate RygelUserConfigPrivate;
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	RYGEL_LOG_LEVEL_INVALID = 0,
	RYGEL_LOG_LEVEL_CRITICAL = 1,
	RYGEL_LOG_LEVEL_ERROR = 2,
	RYGEL_LOG_LEVEL_WARNING = 3,
	RYGEL_LOG_LEVEL_INFO = 4,
	RYGEL_LOG_LEVEL_DEFAULT = 4,
	RYGEL_LOG_LEVEL_DEBUG = 5
} RygelLogLevel;

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp3_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp2ts_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_lpcm_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_wmv_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	RygelLogLevel (*get_log_level) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelUserConfig {
	GObject parent_instance;
	RygelUserConfigPrivate * priv;
	GKeyFile* key_file;
};

struct _RygelUserConfigClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET,
	RYGEL_CONFIGURATION_ERROR_VALUE_OUT_OF_RANGE
} RygelConfigurationError;
#define RYGEL_CONFIGURATION_ERROR rygel_configuration_error_quark ()

static gpointer rygel_user_config_parent_class = NULL;
static RygelUserConfig* rygel_user_config_config;
static RygelUserConfig* rygel_user_config_config = NULL;
static RygelConfigurationIface* rygel_user_config_rygel_configuration_parent_iface = NULL;

GType rygel_log_level_get_type (void) G_GNUC_CONST;
GType rygel_configuration_get_type (void) G_GNUC_CONST;
GType rygel_user_config_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_USER_CONFIG_DUMMY_PROPERTY
};
#define RYGEL_USER_CONFIG_CONFIG_FILE "rygel.conf"
#define RYGEL_USER_CONFIG_IFACE_KEY "interface"
#define RYGEL_USER_CONFIG_PORT_KEY "port"
#define RYGEL_USER_CONFIG_ENABLED_KEY "upnp_enabled"
#define RYGEL_USER_CONFIG_TITLE_KEY "title"
#define RYGEL_USER_CONFIG_TRANSCODING_KEY "enable-transcoding"
#define RYGEL_USER_CONFIG_MP3_TRANSCODER_KEY "enable-mp3-transcoder"
#define RYGEL_USER_CONFIG_MP2TS_TRANSCODER_KEY "enable-mp2ts-transcoder"
#define RYGEL_USER_CONFIG_LPCM_TRANSCODER_KEY "enable-lpcm-transcoder"
#define RYGEL_USER_CONFIG_WMV_TRANSCODER_KEY "enable-wmv-transcoder"
#define RYGEL_USER_CONFIG_ALLOW_UPLOAD_KEY "allow-upload"
#define RYGEL_USER_CONFIG_ALLOW_DELETION_KEY "allow-deletion"
#define RYGEL_USER_CONFIG_LOG_LEVEL_KEY "log-level"
#define RYGEL_USER_CONFIG_PLUGIN_PATH_KEY "plugin-path"
static gboolean rygel_user_config_real_get_upnp_enabled (RygelConfiguration* base, GError** error);
gboolean rygel_configuration_get_bool (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
static gchar* rygel_user_config_real_get_interface (RygelConfiguration* base, GError** error);
gchar* rygel_configuration_get_string (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
static gint rygel_user_config_real_get_port (RygelConfiguration* base, GError** error);
gint rygel_configuration_get_int (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
static gboolean rygel_user_config_real_get_transcoding (RygelConfiguration* base, GError** error);
static gboolean rygel_user_config_real_get_mp3_transcoder (RygelConfiguration* base, GError** error);
static gboolean rygel_user_config_real_get_mp2ts_transcoder (RygelConfiguration* base, GError** error);
static gboolean rygel_user_config_real_get_lpcm_transcoder (RygelConfiguration* base, GError** error);
static gboolean rygel_user_config_real_get_wmv_transcoder (RygelConfiguration* base, GError** error);
static gboolean rygel_user_config_real_get_allow_upload (RygelConfiguration* base, GError** error);
static gboolean rygel_user_config_real_get_allow_deletion (RygelConfiguration* base, GError** error);
static RygelLogLevel rygel_user_config_real_get_log_level (RygelConfiguration* base, GError** error);
static gchar* rygel_user_config_real_get_plugin_path (RygelConfiguration* base, GError** error);
RygelUserConfig* rygel_user_config_get_default (GError** error);
RygelUserConfig* rygel_user_config_new (GError** error);
RygelUserConfig* rygel_user_config_construct (GType object_type, GError** error);
static gboolean rygel_user_config_real_get_enabled (RygelConfiguration* base, const gchar* section, GError** error);
static gchar* rygel_user_config_real_get_title (RygelConfiguration* base, const gchar* section, GError** error);
static gchar* rygel_user_config_real_get_string (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
GQuark rygel_configuration_error_quark (void);
static GeeArrayList* rygel_user_config_real_get_string_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static gint rygel_user_config_real_get_int (RygelConfiguration* base, const gchar* section, const gchar* key, gint min, gint max, GError** error);
static GeeArrayList* rygel_user_config_real_get_int_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static gboolean rygel_user_config_real_get_bool (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static void rygel_user_config_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gboolean rygel_user_config_real_get_upnp_enabled (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_ENABLED_KEY, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp1_;
	return result;
}


static gchar* rygel_user_config_real_get_interface (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp0_ = rygel_configuration_get_string ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_IFACE_KEY, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp1_;
	return result;
}


static gint rygel_user_config_real_get_port (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp0_ = rygel_configuration_get_int ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_PORT_KEY, (gint) 0U, (gint) G_MAXUINT16, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	result = _tmp1_;
	return result;
}


static gboolean rygel_user_config_real_get_transcoding (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_TRANSCODING_KEY, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp1_;
	return result;
}


static gboolean rygel_user_config_real_get_mp3_transcoder (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_MP3_TRANSCODER_KEY, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp1_;
	return result;
}


static gboolean rygel_user_config_real_get_mp2ts_transcoder (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_MP2TS_TRANSCODER_KEY, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp1_;
	return result;
}


static gboolean rygel_user_config_real_get_lpcm_transcoder (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_LPCM_TRANSCODER_KEY, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp1_;
	return result;
}


static gboolean rygel_user_config_real_get_wmv_transcoder (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_WMV_TRANSCODER_KEY, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp1_;
	return result;
}


static gboolean rygel_user_config_real_get_allow_upload (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_ALLOW_UPLOAD_KEY, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp1_;
	return result;
}


static gboolean rygel_user_config_real_get_allow_deletion (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_ALLOW_DELETION_KEY, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp1_;
	return result;
}


static RygelLogLevel rygel_user_config_real_get_log_level (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	RygelLogLevel result = 0;
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp0_ = rygel_configuration_get_int ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_LOG_LEVEL_KEY, (gint) RYGEL_LOG_LEVEL_INVALID, (gint) RYGEL_LOG_LEVEL_DEBUG, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	result = (RygelLogLevel) _tmp1_;
	return result;
}


static gchar* rygel_user_config_real_get_plugin_path (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp0_ = rygel_configuration_get_string ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_PLUGIN_PATH_KEY, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp1_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelUserConfig* rygel_user_config_get_default (GError** error) {
	RygelUserConfig* result = NULL;
	RygelUserConfig* _tmp3_;
	GError * _inner_error_ = NULL;
	if (rygel_user_config_config == NULL) {
		RygelUserConfig* _tmp0_ = NULL;
		RygelUserConfig* _tmp1_;
		RygelUserConfig* _tmp2_;
		_tmp0_ = rygel_user_config_new (&_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		_tmp2_ = _tmp1_;
		_g_object_unref0 (rygel_user_config_config);
		rygel_user_config_config = _tmp2_;
	}
	_tmp3_ = _g_object_ref0 (rygel_user_config_config);
	result = _tmp3_;
	return result;
}


RygelUserConfig* rygel_user_config_construct (GType object_type, GError** error) {
	RygelUserConfig * self = NULL;
	GKeyFile* _tmp0_ = NULL;
	GKeyFile* _tmp1_;
	gchar** _tmp2_ = NULL;
	gint dirs_length1;
	gint _dirs_size_;
	gchar** _tmp3_;
	gchar** dirs;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* path;
	gchar* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) g_object_new (object_type, NULL);
	_tmp0_ = g_key_file_new ();
	_tmp1_ = _tmp0_;
	_g_key_file_free0 (self->key_file);
	self->key_file = _tmp1_;
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp3_ = _tmp2_;
	dirs_length1 = 2;
	_dirs_size_ = dirs_length1;
	dirs = _tmp3_;
	_tmp4_ = g_get_user_config_dir ();
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (dirs[0]);
	dirs[0] = _tmp6_;
	_tmp7_ = g_strdup (SYS_CONFIG_DIR);
	_tmp8_ = _tmp7_;
	_g_free0 (dirs[1]);
	dirs[1] = _tmp8_;
	path = NULL;
	g_key_file_load_from_dirs (self->key_file, RYGEL_USER_CONFIG_CONFIG_FILE, dirs, &_tmp9_, G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error_);
	_g_free0 (path);
	path = _tmp9_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (path);
		dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		return NULL;
	}
	g_debug ("rygel-user-config.vala:123: Loaded user configuration from file '%s'", path);
	_g_free0 (path);
	dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


RygelUserConfig* rygel_user_config_new (GError** error) {
	return rygel_user_config_construct (RYGEL_TYPE_USER_CONFIG, error);
}


static gboolean rygel_user_config_real_get_enabled (RygelConfiguration* base, const gchar* section, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	g_return_val_if_fail (section != NULL, FALSE);
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, section, RYGEL_USER_CONFIG_ENABLED_KEY, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp1_;
	return result;
}


static gchar* rygel_user_config_real_get_title (RygelConfiguration* base, const gchar* section, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	_tmp0_ = rygel_configuration_get_string ((RygelConfiguration*) self, section, RYGEL_USER_CONFIG_TITLE_KEY, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp1_;
	return result;
}


static gchar* rygel_user_config_real_get_string (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* val;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = g_key_file_get_string (self->key_file, section, key, &_inner_error_);
	val = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	if (val == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_strcmp0 (val, "") == 0;
	}
	if (_tmp1_) {
		const gchar* _tmp2_ = NULL;
		GError* _tmp3_ = NULL;
		_tmp2_ = _ ("No value available for '%s'");
		_tmp3_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp2_, key);
		_inner_error_ = _tmp3_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (val);
		return NULL;
	}
	result = val;
	return result;
}


static GeeArrayList* rygel_user_config_real_get_string_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelUserConfig * self;
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* str_list;
	gsize _tmp1_;
	gchar** _tmp2_ = NULL;
	gint strings_length1;
	gint _strings_size_;
	gchar** _tmp3_;
	gchar** strings;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	str_list = _tmp0_;
	_tmp2_ = g_key_file_get_string_list (self->key_file, section, key, &_tmp1_, &_inner_error_);
	_tmp3_ = _tmp2_;
	strings_length1 = _tmp1_;
	_strings_size_ = strings_length1;
	strings = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (str_list);
		return NULL;
	}
	{
		gchar** str_collection;
		int str_collection_length1;
		int str_it;
		str_collection = strings;
		str_collection_length1 = strings_length1;
		for (str_it = 0; str_it < strings_length1; str_it = str_it + 1) {
			gchar* _tmp4_;
			gchar* str;
			_tmp4_ = g_strdup (str_collection[str_it]);
			str = _tmp4_;
			{
				gee_abstract_collection_add ((GeeAbstractCollection*) str_list, str);
				_g_free0 (str);
			}
		}
	}
	result = str_list;
	strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gint rygel_user_config_real_get_int (RygelConfiguration* base, const gchar* section, const gchar* key, gint min, gint max, GError** error) {
	RygelUserConfig * self;
	gint result = 0;
	gint _tmp0_;
	gint val;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	g_return_val_if_fail (section != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	_tmp0_ = g_key_file_get_integer (self->key_file, section, key, &_inner_error_);
	val = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	if (val == 0) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = val < min;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = val > max;
	}
	if (_tmp1_) {
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		_tmp3_ = _ ("Value of '%s' out of range");
		_tmp4_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_VALUE_OUT_OF_RANGE, _tmp3_, key);
		_inner_error_ = _tmp4_;
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	result = val;
	return result;
}


static GeeArrayList* rygel_user_config_real_get_int_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelUserConfig * self;
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* int_list;
	gsize _tmp1_;
	gint* _tmp2_ = NULL;
	gint ints_length1;
	gint _ints_size_;
	gint* _tmp3_;
	gint* ints;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL);
	int_list = _tmp0_;
	_tmp2_ = g_key_file_get_integer_list (self->key_file, section, key, &_tmp1_, &_inner_error_);
	_tmp3_ = _tmp2_;
	ints_length1 = _tmp1_;
	_ints_size_ = ints_length1;
	ints = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (int_list);
		return NULL;
	}
	{
		gint* num_collection;
		int num_collection_length1;
		int num_it;
		num_collection = ints;
		num_collection_length1 = ints_length1;
		for (num_it = 0; num_it < ints_length1; num_it = num_it + 1) {
			gint num;
			num = num_collection[num_it];
			{
				gee_abstract_collection_add ((GeeAbstractCollection*) int_list, GINT_TO_POINTER (num));
			}
		}
	}
	result = int_list;
	ints = (g_free (ints), NULL);
	return result;
}


static gboolean rygel_user_config_real_get_bool (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	g_return_val_if_fail (section != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = g_key_file_get_boolean (self->key_file, section, key, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp1_;
	return result;
}


static void rygel_user_config_class_init (RygelUserConfigClass * klass) {
	rygel_user_config_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_user_config_finalize;
}


static void rygel_user_config_rygel_configuration_interface_init (RygelConfigurationIface * iface) {
	rygel_user_config_rygel_configuration_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_upnp_enabled = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_user_config_real_get_upnp_enabled;
	iface->get_interface = (gchar* (*)(RygelConfiguration* ,GError**)) rygel_user_config_real_get_interface;
	iface->get_port = (gint (*)(RygelConfiguration* ,GError**)) rygel_user_config_real_get_port;
	iface->get_transcoding = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_user_config_real_get_transcoding;
	iface->get_mp3_transcoder = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_user_config_real_get_mp3_transcoder;
	iface->get_mp2ts_transcoder = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_user_config_real_get_mp2ts_transcoder;
	iface->get_lpcm_transcoder = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_user_config_real_get_lpcm_transcoder;
	iface->get_wmv_transcoder = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_user_config_real_get_wmv_transcoder;
	iface->get_allow_upload = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_user_config_real_get_allow_upload;
	iface->get_allow_deletion = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_user_config_real_get_allow_deletion;
	iface->get_log_level = (RygelLogLevel (*)(RygelConfiguration* ,GError**)) rygel_user_config_real_get_log_level;
	iface->get_plugin_path = (gchar* (*)(RygelConfiguration* ,GError**)) rygel_user_config_real_get_plugin_path;
	iface->get_enabled = (gboolean (*)(RygelConfiguration* ,const gchar* ,GError**)) rygel_user_config_real_get_enabled;
	iface->get_title = (gchar* (*)(RygelConfiguration* ,const gchar* ,GError**)) rygel_user_config_real_get_title;
	iface->get_string = (gchar* (*)(RygelConfiguration* ,const gchar* ,const gchar* ,GError**)) rygel_user_config_real_get_string;
	iface->get_string_list = (GeeArrayList* (*)(RygelConfiguration* ,const gchar* ,const gchar* ,GError**)) rygel_user_config_real_get_string_list;
	iface->get_int = (gint (*)(RygelConfiguration* ,const gchar* ,const gchar* ,gint ,gint ,GError**)) rygel_user_config_real_get_int;
	iface->get_int_list = (GeeArrayList* (*)(RygelConfiguration* ,const gchar* ,const gchar* ,GError**)) rygel_user_config_real_get_int_list;
	iface->get_bool = (gboolean (*)(RygelConfiguration* ,const gchar* ,const gchar* ,GError**)) rygel_user_config_real_get_bool;
}


static void rygel_user_config_instance_init (RygelUserConfig * self) {
}


static void rygel_user_config_finalize (GObject* obj) {
	RygelUserConfig * self;
	self = RYGEL_USER_CONFIG (obj);
	_g_key_file_free0 (self->key_file);
	G_OBJECT_CLASS (rygel_user_config_parent_class)->finalize (obj);
}


/**
 * Manages the user configuration for Rygel.
 */
GType rygel_user_config_get_type (void) {
	static volatile gsize rygel_user_config_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_user_config_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelUserConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_user_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelUserConfig), 0, (GInstanceInitFunc) rygel_user_config_instance_init, NULL };
		static const GInterfaceInfo rygel_configuration_info = { (GInterfaceInitFunc) rygel_user_config_rygel_configuration_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_user_config_type_id;
		rygel_user_config_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelUserConfig", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_user_config_type_id, RYGEL_TYPE_CONFIGURATION, &rygel_configuration_info);
		g_once_init_leave (&rygel_user_config_type_id__volatile, rygel_user_config_type_id);
	}
	return rygel_user_config_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



