/* rygel-media-query-action.c generated by valac 0.11.3, the Vala compiler
 * generated from rygel-media-query-action.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libgupnp-av/gupnp-av.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_MEDIA_QUERY_ACTION (rygel_media_query_action_get_type ())
#define RYGEL_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction))
#define RYGEL_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))
#define RYGEL_IS_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_IS_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_MEDIA_QUERY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))

typedef struct _RygelMediaQueryAction RygelMediaQueryAction;
typedef struct _RygelMediaQueryActionClass RygelMediaQueryActionClass;
typedef struct _RygelMediaQueryActionPrivate RygelMediaQueryActionPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_XBOX_HACKS (rygel_xbox_hacks_get_type ())
#define RYGEL_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacks))
#define RYGEL_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))
#define RYGEL_IS_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_IS_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_XBOX_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))

typedef struct _RygelXBoxHacks RygelXBoxHacks;
typedef struct _RygelXBoxHacksClass RygelXBoxHacksClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaQueryActionRunData RygelMediaQueryActionRunData;
typedef struct _RygelMediaQueryActionFetchMediaObjectData RygelMediaQueryActionFetchMediaObjectData;

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelMediaQueryAction {
	GObject parent_instance;
	RygelMediaQueryActionPrivate * priv;
	gchar* object_id;
	gchar* browse_flag;
	gchar* filter;
	guint index;
	guint requested_count;
	gchar* sort_criteria;
	guint number_returned;
	guint total_matches;
	guint update_id;
	RygelMediaContainer* root_container;
	RygelHTTPServer* http_server;
	guint32 system_update_id;
	GUPnPServiceAction* action;
	GUPnPDIDLLiteWriter* didl_writer;
	RygelXBoxHacks* xbox_hacks;
	gchar* object_id_arg;
};

struct _RygelMediaQueryActionClass {
	GObjectClass parent_class;
	void (*parse_args) (RygelMediaQueryAction* self, GError** error);
	void (*fetch_results) (RygelMediaQueryAction* self, RygelMediaObject* media_object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*fetch_results_finish) (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error);
	void (*handle_error) (RygelMediaQueryAction* self, GError* _error_);
};

struct _RygelMediaQueryActionPrivate {
	GCancellable* _cancellable;
};

struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	gchar* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

typedef enum  {
	RYGEL_XBOX_HACKS_ERROR_NA
} RygelXBoxHacksError;
#define RYGEL_XBOX_HACKS_ERROR rygel_xbox_hacks_error_quark ()
struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	gint child_count;
	guint32 update_id;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaQueryActionRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaQueryAction* self;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* media_object;
	RygelMediaObjects* _tmp1_;
	RygelMediaObjects* results;
	gint _tmp2_;
	GError * err;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelMediaQueryActionFetchMediaObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaQueryAction* self;
	RygelMediaObject* result;
	RygelMediaObject* _tmp0_;
	GCancellable* _tmp1_;
	RygelMediaObject* _tmp2_;
	RygelMediaObject* media_object;
	const gchar* _tmp3_;
	GError* _tmp4_;
	GError * _inner_error_;
};


static gpointer rygel_media_query_action_parent_class = NULL;
static RygelStateMachineIface* rygel_media_query_action_rygel_state_machine_parent_iface = NULL;

GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_media_query_action_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_xbox_hacks_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_QUERY_ACTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionPrivate))
enum  {
	RYGEL_MEDIA_QUERY_ACTION_DUMMY_PROPERTY,
	RYGEL_MEDIA_QUERY_ACTION_CANCELLABLE
};
#define RYGEL_MEDIA_QUERY_ACTION_DEFAULT_SORT_CRITERIA "+dc:title"
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
RygelMediaQueryAction* rygel_media_query_action_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
GQuark rygel_xbox_hacks_error_quark (void);
RygelXBoxHacks* rygel_xbox_hacks_new_for_action (GUPnPServiceAction* action, GError** error);
RygelXBoxHacks* rygel_xbox_hacks_construct_for_action (GType object_type, GUPnPServiceAction* action, GError** error);
static void rygel_media_query_action_real_run_data_free (gpointer _data);
static void rygel_media_query_action_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_query_action_real_run_co (RygelMediaQueryActionRunData* data);
void rygel_media_query_action_parse_args (RygelMediaQueryAction* self, GError** error);
static void rygel_media_query_action_fetch_media_object (RygelMediaQueryAction* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaObject* rygel_media_query_action_fetch_media_object_finish (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error);
static void rygel_media_query_action_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_query_action_fetch_results (RygelMediaQueryAction* self, RygelMediaObject* media_object, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_query_action_fetch_results_finish (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error);
void rygel_media_objects_sort_by_criteria (RygelMediaObjects* self, const gchar* sort_criteria);
void rygel_media_objects_serialize (RygelMediaObjects* self, GUPnPDIDLLiteWriter* didl_writer, RygelHTTPServer* http_server, RygelXBoxHacks* xbox_hacks, GError** error);
static void rygel_media_query_action_conclude (RygelMediaQueryAction* self);
void rygel_media_query_action_handle_error (RygelMediaQueryAction* self, GError* _error_);
static void rygel_media_query_action_real_parse_args (RygelMediaQueryAction* self, GError** error);
GQuark rygel_content_directory_error_quark (void);
void rygel_xbox_hacks_translate_container_id (RygelXBoxHacks* self, RygelMediaQueryAction* action, gchar** container_id);
static void rygel_media_query_action_fetch_media_object_data_free (gpointer _data);
static gboolean rygel_media_query_action_fetch_media_object_co (RygelMediaQueryActionFetchMediaObjectData* data);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void rygel_media_query_action_fetch_media_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_media_query_action_real_handle_error (RygelMediaQueryAction* self, GError* _error_);
static void rygel_media_query_action_finalize (GObject* obj);
static void _vala_rygel_media_query_action_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_query_action_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelMediaQueryAction* rygel_media_query_action_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	RygelMediaQueryAction * self = NULL;
	RygelMediaContainer* _tmp0_;
	RygelMediaContainer* _tmp1_;
	RygelHTTPServer* _tmp2_;
	RygelHTTPServer* _tmp3_;
	GUPnPServiceAction* _tmp4_;
	GUPnPDIDLLiteWriter* _tmp5_ = NULL;
	GUPnPDIDLLiteWriter* _tmp6_;
	RygelXBoxHacks* _tmp7_ = NULL;
	RygelXBoxHacks* _tmp8_;
	RygelXBoxHacks* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (content_dir != NULL, NULL);
	g_return_val_if_fail (action != NULL, NULL);
	self = (RygelMediaQueryAction*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (content_dir->root_container);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->root_container);
	self->root_container = _tmp1_;
	_tmp2_ = _g_object_ref0 (content_dir->http_server);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->http_server);
	self->http_server = _tmp3_;
	self->system_update_id = content_dir->system_update_id;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, content_dir->cancellable);
	_tmp4_ = action;
	action = NULL;
	self->action = _tmp4_;
	_tmp5_ = gupnp_didl_lite_writer_new (NULL);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (self->didl_writer);
	self->didl_writer = _tmp6_;
	_tmp7_ = rygel_xbox_hacks_new_for_action (self->action, &_inner_error_);
	_tmp8_ = _tmp7_;
	if (_inner_error_ != NULL) {
		goto __catch55_g_error;
	}
	_tmp9_ = _tmp8_;
	_g_object_unref0 (self->xbox_hacks);
	self->xbox_hacks = _tmp9_;
	goto __finally55;
	__catch55_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally55:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


static void rygel_media_query_action_real_run_data_free (gpointer _data) {
	RygelMediaQueryActionRunData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelMediaQueryActionRunData, data);
}


static void rygel_media_query_action_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaQueryAction * self;
	RygelMediaQueryActionRunData* _data_;
	self = (RygelMediaQueryAction*) base;
	_data_ = g_slice_new0 (RygelMediaQueryActionRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_query_action_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_query_action_real_run_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_media_query_action_real_run_co (_data_);
}


static void rygel_media_query_action_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelMediaQueryActionRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_media_query_action_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaQueryActionRunData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_media_query_action_real_run_co (data);
}


static gboolean rygel_media_query_action_real_run_co (RygelMediaQueryActionRunData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	rygel_media_query_action_parse_args (data->self, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch56_g_error;
	}
	data->_state_ = 1;
	rygel_media_query_action_fetch_media_object (data->self, rygel_media_query_action_run_ready, data);
	return FALSE;
	_state_1:
	data->_tmp0_ = NULL;
	data->_tmp0_ = rygel_media_query_action_fetch_media_object_finish (data->self, data->_res_, &data->_inner_error_);
	data->media_object = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		goto __catch56_g_error;
	}
	data->_state_ = 2;
	rygel_media_query_action_fetch_results (data->self, data->media_object, rygel_media_query_action_run_ready, data);
	return FALSE;
	_state_2:
	data->_tmp1_ = NULL;
	data->_tmp1_ = rygel_media_query_action_fetch_results_finish (data->self, data->_res_, &data->_inner_error_);
	data->results = data->_tmp1_;
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->media_object);
		goto __catch56_g_error;
	}
	data->_tmp2_ = gee_collection_get_size ((GeeCollection*) data->results);
	data->self->number_returned = (guint) data->_tmp2_;
	if (RYGEL_IS_MEDIA_CONTAINER (data->media_object)) {
		data->self->update_id = (guint) RYGEL_MEDIA_CONTAINER (data->media_object)->update_id;
	} else {
		data->self->update_id = (guint) G_MAXUINT32;
	}
	rygel_media_objects_sort_by_criteria (data->results, data->self->sort_criteria);
	rygel_media_objects_serialize (data->results, data->self->didl_writer, data->self->http_server, data->self->xbox_hacks, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->results);
		_g_object_unref0 (data->media_object);
		goto __catch56_g_error;
	}
	rygel_media_query_action_conclude (data->self);
	_g_object_unref0 (data->results);
	_g_object_unref0 (data->media_object);
	goto __finally56;
	__catch56_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		rygel_media_query_action_handle_error (data->self, data->err);
		_g_error_free0 (data->err);
	}
	__finally56:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_media_query_action_real_parse_args (RygelMediaQueryAction* self, GError** error) {
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	gupnp_service_action_get (self->action, self->object_id_arg, G_TYPE_STRING, &self->object_id, "Filter", G_TYPE_STRING, &self->filter, "StartingIndex", G_TYPE_UINT, &self->index, "RequestedCount", G_TYPE_UINT, &self->requested_count, "SortCriteria", G_TYPE_STRING, &self->sort_criteria, NULL);
	if (self->object_id == NULL) {
		const gchar* _tmp0_ = NULL;
		GError* _tmp1_ = NULL;
		_tmp0_ = _ ("No such object");
		_tmp1_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _tmp0_);
		_inner_error_ = _tmp1_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	if (self->sort_criteria == NULL) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = g_strcmp0 (self->sort_criteria, "") == 0;
	}
	if (_tmp2_) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = g_strdup (RYGEL_MEDIA_QUERY_ACTION_DEFAULT_SORT_CRITERIA);
		_tmp4_ = _tmp3_;
		_g_free0 (self->sort_criteria);
		self->sort_criteria = _tmp4_;
	}
	if (self->xbox_hacks != NULL) {
		rygel_xbox_hacks_translate_container_id (self->xbox_hacks, self, &self->object_id);
	}
}


void rygel_media_query_action_parse_args (RygelMediaQueryAction* self, GError** error) {
	RYGEL_MEDIA_QUERY_ACTION_GET_CLASS (self)->parse_args (self, error);
}


void rygel_media_query_action_fetch_results (RygelMediaQueryAction* self, RygelMediaObject* media_object, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RYGEL_MEDIA_QUERY_ACTION_GET_CLASS (self)->fetch_results (self, media_object, _callback_, _user_data_);
}


RygelMediaObjects* rygel_media_query_action_fetch_results_finish (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error) {
	return RYGEL_MEDIA_QUERY_ACTION_GET_CLASS (self)->fetch_results_finish (self, _res_, error);
}


static void rygel_media_query_action_fetch_media_object_data_free (gpointer _data) {
	RygelMediaQueryActionFetchMediaObjectData* data;
	data = _data;
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (RygelMediaQueryActionFetchMediaObjectData, data);
}


static void rygel_media_query_action_fetch_media_object (RygelMediaQueryAction* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaQueryActionFetchMediaObjectData* _data_;
	_data_ = g_slice_new0 (RygelMediaQueryActionFetchMediaObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_query_action_fetch_media_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_query_action_fetch_media_object_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_media_query_action_fetch_media_object_co (_data_);
}


static RygelMediaObject* rygel_media_query_action_fetch_media_object_finish (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelMediaQueryActionFetchMediaObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_query_action_fetch_media_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaQueryActionFetchMediaObjectData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_media_query_action_fetch_media_object_co (data);
}


static gboolean rygel_media_query_action_fetch_media_object_co (RygelMediaQueryActionFetchMediaObjectData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (g_strcmp0 (data->self->object_id, ((RygelMediaObject*) data->self->root_container)->id) == 0) {
		data->_tmp0_ = _g_object_ref0 ((RygelMediaObject*) data->self->root_container);
		data->result = data->_tmp0_;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	} else {
		g_debug ("rygel-media-query-action.vala:136: searching for object '%s'..", data->self->object_id);
		data->_tmp1_ = NULL;
		data->_tmp1_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
		data->_state_ = 1;
		rygel_media_container_find_object (data->self->root_container, data->self->object_id, data->_tmp1_, rygel_media_query_action_fetch_media_object_ready, data);
		return FALSE;
		_state_1:
		data->_tmp2_ = NULL;
		data->_tmp2_ = rygel_media_container_find_object_finish (data->self->root_container, data->_res_, &data->_inner_error_);
		data->media_object = data->_tmp2_;
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		if (data->media_object == NULL) {
			data->_tmp3_ = NULL;
			data->_tmp3_ = _ ("No such object");
			data->_tmp4_ = NULL;
			data->_tmp4_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, data->_tmp3_);
			data->_inner_error_ = data->_tmp4_;
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->media_object);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		g_debug ("rygel-media-query-action.vala:143: object '%s' found.", data->self->object_id);
		data->result = data->media_object;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_media_query_action_conclude (RygelMediaQueryAction* self) {
	gchar* _tmp0_ = NULL;
	gchar* didl;
	g_return_if_fail (self != NULL);
	gupnp_didl_lite_writer_filter (self->didl_writer, self->filter);
	_tmp0_ = gupnp_didl_lite_writer_get_string (self->didl_writer);
	didl = _tmp0_;
	if (self->update_id == G_MAXUINT32) {
		self->update_id = (guint) self->system_update_id;
	}
	gupnp_service_action_set (self->action, "Result", G_TYPE_STRING, didl, "NumberReturned", G_TYPE_UINT, self->number_returned, "TotalMatches", G_TYPE_UINT, self->total_matches, "UpdateID", G_TYPE_UINT, self->update_id, NULL);
	gupnp_service_action_return (self->action);
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
	_g_free0 (didl);
}


static void rygel_media_query_action_real_handle_error (RygelMediaQueryAction* self, GError* _error_) {
	g_return_if_fail (self != NULL);
	if (_error_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
		gupnp_service_action_return_error (self->action, (guint) _error_->code, _error_->message);
	} else {
		gupnp_service_action_return_error (self->action, (guint) 701, _error_->message);
	}
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
}


void rygel_media_query_action_handle_error (RygelMediaQueryAction* self, GError* _error_) {
	RYGEL_MEDIA_QUERY_ACTION_GET_CLASS (self)->handle_error (self, _error_);
}


static GCancellable* rygel_media_query_action_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelMediaQueryAction* self;
	self = (RygelMediaQueryAction*) base;
	result = self->priv->_cancellable;
	return result;
}


static void rygel_media_query_action_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelMediaQueryAction* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	self = (RygelMediaQueryAction*) base;
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = _tmp1_;
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_media_query_action_class_init (RygelMediaQueryActionClass * klass) {
	rygel_media_query_action_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaQueryActionPrivate));
	RYGEL_MEDIA_QUERY_ACTION_CLASS (klass)->parse_args = rygel_media_query_action_real_parse_args;
	RYGEL_MEDIA_QUERY_ACTION_CLASS (klass)->handle_error = rygel_media_query_action_real_handle_error;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_query_action_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_query_action_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_query_action_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_QUERY_ACTION_CANCELLABLE, "cancellable");
}


static void rygel_media_query_action_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_media_query_action_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*)(RygelStateMachine*)) rygel_media_query_action_real_run;
	iface->run_finish = rygel_media_query_action_real_run_finish;
	iface->get_cancellable = rygel_media_query_action_real_get_cancellable;
	iface->set_cancellable = rygel_media_query_action_real_set_cancellable;
}


static void rygel_media_query_action_instance_init (RygelMediaQueryAction * self) {
	self->priv = RYGEL_MEDIA_QUERY_ACTION_GET_PRIVATE (self);
}


static void rygel_media_query_action_finalize (GObject* obj) {
	RygelMediaQueryAction * self;
	self = RYGEL_MEDIA_QUERY_ACTION (obj);
	_g_free0 (self->object_id);
	_g_free0 (self->browse_flag);
	_g_free0 (self->filter);
	_g_free0 (self->sort_criteria);
	_g_object_unref0 (self->priv->_cancellable);
	_g_object_unref0 (self->root_container);
	_g_object_unref0 (self->http_server);
	_g_object_unref0 (self->didl_writer);
	_g_object_unref0 (self->xbox_hacks);
	_g_free0 (self->object_id_arg);
	G_OBJECT_CLASS (rygel_media_query_action_parent_class)->finalize (obj);
}


/**
 * Base class of Browse and Search actions.
 */
GType rygel_media_query_action_get_type (void) {
	static volatile gsize rygel_media_query_action_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_query_action_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaQueryActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_query_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaQueryAction), 0, (GInstanceInitFunc) rygel_media_query_action_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_media_query_action_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_media_query_action_type_id;
		rygel_media_query_action_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaQueryAction", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (rygel_media_query_action_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_media_query_action_type_id__volatile, rygel_media_query_action_type_id);
	}
	return rygel_media_query_action_type_id__volatile;
}


static void _vala_rygel_media_query_action_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaQueryAction * self;
	self = RYGEL_MEDIA_QUERY_ACTION (object);
	switch (property_id) {
		case RYGEL_MEDIA_QUERY_ACTION_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_media_query_action_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaQueryAction * self;
	self = RYGEL_MEDIA_QUERY_ACTION (object);
	switch (property_id) {
		case RYGEL_MEDIA_QUERY_ACTION_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



