/* rygel-cmdline-config.c generated by valac 0.11.3, the Vala compiler
 * generated from rygel-cmdline-config.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Nokia Corporation.
 * Copyright (C) 2008,2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <config.h>
#include <gst/gst.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;

#define RYGEL_TYPE_LOG_LEVEL (rygel_log_level_get_type ())

#define RYGEL_TYPE_CMDLINE_CONFIG (rygel_cmdline_config_get_type ())
#define RYGEL_CMDLINE_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CMDLINE_CONFIG, RygelCmdlineConfig))
#define RYGEL_CMDLINE_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CMDLINE_CONFIG, RygelCmdlineConfigClass))
#define RYGEL_IS_CMDLINE_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CMDLINE_CONFIG))
#define RYGEL_IS_CMDLINE_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CMDLINE_CONFIG))
#define RYGEL_CMDLINE_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CMDLINE_CONFIG, RygelCmdlineConfigClass))

typedef struct _RygelCmdlineConfig RygelCmdlineConfig;
typedef struct _RygelCmdlineConfigClass RygelCmdlineConfigClass;
typedef struct _RygelCmdlineConfigPrivate RygelCmdlineConfigPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY
} RygelCmdlineConfigError;
#define RYGEL_CMDLINE_CONFIG_ERROR rygel_cmdline_config_error_quark ()
typedef enum  {
	RYGEL_LOG_LEVEL_INVALID = 0,
	RYGEL_LOG_LEVEL_CRITICAL = 1,
	RYGEL_LOG_LEVEL_ERROR = 2,
	RYGEL_LOG_LEVEL_WARNING = 3,
	RYGEL_LOG_LEVEL_INFO = 4,
	RYGEL_LOG_LEVEL_DEFAULT = 4,
	RYGEL_LOG_LEVEL_DEBUG = 5
} RygelLogLevel;

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp3_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp2ts_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_lpcm_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_wmv_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	RygelLogLevel (*get_log_level) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelCmdlineConfig {
	GObject parent_instance;
	RygelCmdlineConfigPrivate * priv;
};

struct _RygelCmdlineConfigClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET,
	RYGEL_CONFIGURATION_ERROR_VALUE_OUT_OF_RANGE
} RygelConfigurationError;
#define RYGEL_CONFIGURATION_ERROR rygel_configuration_error_quark ()

static gpointer rygel_cmdline_config_parent_class = NULL;
static gchar* rygel_cmdline_config_iface;
static gchar* rygel_cmdline_config_iface = NULL;
static gint rygel_cmdline_config_port;
static gint rygel_cmdline_config_port = 0;
static gboolean rygel_cmdline_config_no_transcoding;
static gboolean rygel_cmdline_config_no_transcoding = FALSE;
static gboolean rygel_cmdline_config_no_mp3_trans;
static gboolean rygel_cmdline_config_no_mp3_trans = FALSE;
static gboolean rygel_cmdline_config_no_mp2ts_trans;
static gboolean rygel_cmdline_config_no_mp2ts_trans = FALSE;
static gboolean rygel_cmdline_config_no_lpcm_trans;
static gboolean rygel_cmdline_config_no_lpcm_trans = FALSE;
static gboolean rygel_cmdline_config_no_wmv_trans;
static gboolean rygel_cmdline_config_no_wmv_trans = FALSE;
static gboolean rygel_cmdline_config_disallow_upload;
static gboolean rygel_cmdline_config_disallow_upload = FALSE;
static gboolean rygel_cmdline_config_disallow_deletion;
static gboolean rygel_cmdline_config_disallow_deletion = FALSE;
static RygelLogLevel rygel_cmdline_config_log_level;
static RygelLogLevel rygel_cmdline_config_log_level = RYGEL_LOG_LEVEL_INVALID;
static gchar* rygel_cmdline_config_plugin_path;
static gchar* rygel_cmdline_config_plugin_path = NULL;
static gboolean rygel_cmdline_config_version;
static gboolean rygel_cmdline_config_version = FALSE;
static gchar** rygel_cmdline_config_disabled_plugins;
static gchar** rygel_cmdline_config_disabled_plugins = NULL;
static gchar** rygel_cmdline_config_plugin_titles;
static gchar** rygel_cmdline_config_plugin_titles = NULL;
static gchar** rygel_cmdline_config_plugin_options;
static gchar** rygel_cmdline_config_plugin_options = NULL;
static RygelCmdlineConfig* rygel_cmdline_config_config;
static RygelCmdlineConfig* rygel_cmdline_config_config = NULL;
static RygelConfigurationIface* rygel_cmdline_config_rygel_configuration_parent_iface = NULL;

GQuark rygel_cmdline_config_error_quark (void);
GType rygel_log_level_get_type (void) G_GNUC_CONST;
GType rygel_configuration_get_type (void) G_GNUC_CONST;
GType rygel_cmdline_config_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_CMDLINE_CONFIG_DUMMY_PROPERTY
};
RygelCmdlineConfig* rygel_cmdline_config_get_default (void);
RygelCmdlineConfig* rygel_cmdline_config_new (void);
RygelCmdlineConfig* rygel_cmdline_config_construct (GType object_type);
void rygel_cmdline_config_parse_args (gchar*** args, int* args_length1, GError** error);
static gboolean rygel_cmdline_config_real_get_upnp_enabled (RygelConfiguration* base, GError** error);
GQuark rygel_configuration_error_quark (void);
static gchar* rygel_cmdline_config_real_get_interface (RygelConfiguration* base, GError** error);
static gint rygel_cmdline_config_real_get_port (RygelConfiguration* base, GError** error);
static gboolean rygel_cmdline_config_real_get_transcoding (RygelConfiguration* base, GError** error);
static gboolean rygel_cmdline_config_real_get_mp3_transcoder (RygelConfiguration* base, GError** error);
static gboolean rygel_cmdline_config_real_get_mp2ts_transcoder (RygelConfiguration* base, GError** error);
static gboolean rygel_cmdline_config_real_get_lpcm_transcoder (RygelConfiguration* base, GError** error);
static gboolean rygel_cmdline_config_real_get_wmv_transcoder (RygelConfiguration* base, GError** error);
static gboolean rygel_cmdline_config_real_get_allow_upload (RygelConfiguration* base, GError** error);
static gboolean rygel_cmdline_config_real_get_allow_deletion (RygelConfiguration* base, GError** error);
static RygelLogLevel rygel_cmdline_config_real_get_log_level (RygelConfiguration* base, GError** error);
static gchar* rygel_cmdline_config_real_get_plugin_path (RygelConfiguration* base, GError** error);
static gboolean rygel_cmdline_config_real_get_enabled (RygelConfiguration* base, const gchar* section, GError** error);
static gchar* rygel_cmdline_config_real_get_title (RygelConfiguration* base, const gchar* section, GError** error);
static gchar* rygel_cmdline_config_real_get_string (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static GeeArrayList* rygel_cmdline_config_real_get_string_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static gint rygel_cmdline_config_real_get_int (RygelConfiguration* base, const gchar* section, const gchar* key, gint min, gint max, GError** error);
static GeeArrayList* rygel_cmdline_config_real_get_int_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static gboolean rygel_cmdline_config_real_get_bool (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static void rygel_cmdline_config_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry RYGEL_CMDLINE_CONFIG_options[16] = {{"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &rygel_cmdline_config_version, "Display version number", NULL}, {"network-interface", 'n', 0, G_OPTION_ARG_STRING, &rygel_cmdline_config_iface, "Network Interface", "INTERFACE"}, {"port", 'p', 0, G_OPTION_ARG_INT, &rygel_cmdline_config_port, "Port", "PORT"}, {"disable-transcoding", 't', 0, G_OPTION_ARG_NONE, &rygel_cmdline_config_no_transcoding, "Disable transcoding", NULL}, {"disable-mp3-transcoder", 'm', 0, G_OPTION_ARG_NONE, &rygel_cmdline_config_no_mp3_trans, "Disable MP3 transcoder", NULL}, {"disable-mp2ts-transcoder", 's', 0, G_OPTION_ARG_NONE, &rygel_cmdline_config_no_mp2ts_trans, "Disable mpeg2 transport stream transcoder", NULL}, {"disable-lpcm-transcoder", 'l', 0, G_OPTION_ARG_NONE, &rygel_cmdline_config_no_lpcm_trans, "Disable Linear PCM transcoder", NULL}, {"disable-wmv-transcoder", 'w', 0, G_OPTION_ARG_NONE, &rygel_cmdline_config_no_wmv_trans, "Disable WMV transcoder", NULL}, {"disallow-upload", 'U', 0, G_OPTION_ARG_NONE, &rygel_cmdline_config_disallow_upload, "Disallow upload", NULL}, {"disallow-deletion", 'D', 0, G_OPTION_ARG_NONE, &rygel_cmdline_config_disallow_deletion, "Disallow deletion", NULL}, {"log-level", 'g', 0, G_OPTION_ARG_INT, &rygel_cmdline_config_log_level, "Log level. 1=critical,2=error,3=warning,4=message/info,5=debug", "N"}, {"plugin-path", 'u', 0, G_OPTION_ARG_STRING, &rygel_cmdline_config_plugin_path, "Plugin Path", "PLUGIN_PATH"}, {"disable-plugin", 'd', 0, G_OPTION_ARG_STRING_ARRAY, &rygel_cmdline_config_disabled_plugins, "Disable plugin", "PluginName"}, {"title", 'i', 0, G_OPTION_ARG_STRING_ARRAY, &rygel_cmdline_config_plugin_titles, "Set plugin titles", "PluginName:TITLE"}, {"plugin-option", 'o', 0, G_OPTION_ARG_STRING_ARRAY, &rygel_cmdline_config_plugin_options, "Set plugin options", "PluginName:OPTION:VALUE1[,VALUE2,..]"}, {NULL}};

GQuark rygel_cmdline_config_error_quark (void) {
	return g_quark_from_static_string ("rygel_cmdline_config_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelCmdlineConfig* rygel_cmdline_config_get_default (void) {
	RygelCmdlineConfig* result = NULL;
	RygelCmdlineConfig* _tmp2_;
	if (rygel_cmdline_config_config == NULL) {
		RygelCmdlineConfig* _tmp0_ = NULL;
		RygelCmdlineConfig* _tmp1_;
		_tmp0_ = rygel_cmdline_config_new ();
		_tmp1_ = _tmp0_;
		_g_object_unref0 (rygel_cmdline_config_config);
		rygel_cmdline_config_config = _tmp1_;
	}
	_tmp2_ = _g_object_ref0 (rygel_cmdline_config_config);
	result = _tmp2_;
	return result;
}


void rygel_cmdline_config_parse_args (gchar*** args, int* args_length1, GError** error) {
	gchar* _tmp0_;
	gchar* parameter_string;
	GOptionContext* _tmp1_ = NULL;
	GOptionContext* opt_context;
	GOptionGroup* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_strdup ("- " PACKAGE_NAME);
	parameter_string = _tmp0_;
	_tmp1_ = g_option_context_new (parameter_string);
	opt_context = _tmp1_;
	g_option_context_set_help_enabled (opt_context, TRUE);
	g_option_context_add_main_entries (opt_context, RYGEL_CMDLINE_CONFIG_options, NULL);
	_tmp2_ = gst_init_get_option_group ();
	g_option_context_add_group (opt_context, _tmp2_);
	g_option_context_parse (opt_context, args_length1, args, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == RYGEL_CMDLINE_CONFIG_ERROR) || (_inner_error_->domain == G_OPTION_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_option_context_free0 (opt_context);
			_g_free0 (parameter_string);
			return;
		} else {
			_g_option_context_free0 (opt_context);
			_g_free0 (parameter_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (rygel_cmdline_config_version) {
		GError* _tmp3_ = NULL;
		fprintf (stdout, "%s\n", PACKAGE_STRING);
		_tmp3_ = g_error_new_literal (RYGEL_CMDLINE_CONFIG_ERROR, RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY, "");
		_inner_error_ = _tmp3_;
		if ((_inner_error_->domain == RYGEL_CMDLINE_CONFIG_ERROR) || (_inner_error_->domain == G_OPTION_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_option_context_free0 (opt_context);
			_g_free0 (parameter_string);
			return;
		} else {
			_g_option_context_free0 (opt_context);
			_g_free0 (parameter_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_option_context_free0 (opt_context);
	_g_free0 (parameter_string);
}


static gboolean rygel_cmdline_config_real_get_upnp_enabled (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	GError* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	_tmp0_ = _ ("No value available");
	_tmp1_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp0_);
	_inner_error_ = _tmp1_;
	g_propagate_error (error, _inner_error_);
	return FALSE;
	return result;
}


static gchar* rygel_cmdline_config_real_get_interface (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gchar* result = NULL;
	gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	if (rygel_cmdline_config_iface == NULL) {
		const gchar* _tmp0_ = NULL;
		GError* _tmp1_ = NULL;
		_tmp0_ = _ ("No value available");
		_tmp1_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp0_);
		_inner_error_ = _tmp1_;
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp2_ = g_strdup (rygel_cmdline_config_iface);
	result = _tmp2_;
	return result;
}


static gint rygel_cmdline_config_real_get_port (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gint result = 0;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	if (rygel_cmdline_config_port <= 0) {
		const gchar* _tmp0_ = NULL;
		GError* _tmp1_ = NULL;
		_tmp0_ = _ ("No value available");
		_tmp1_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp0_);
		_inner_error_ = _tmp1_;
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	result = rygel_cmdline_config_port;
	return result;
}


static gboolean rygel_cmdline_config_real_get_transcoding (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	if (!rygel_cmdline_config_no_transcoding) {
		const gchar* _tmp0_ = NULL;
		GError* _tmp1_ = NULL;
		_tmp0_ = _ ("No value available");
		_tmp1_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp0_);
		_inner_error_ = _tmp1_;
		g_propagate_error (error, _inner_error_);
		return FALSE;
	} else {
		result = FALSE;
		return result;
	}
}


static gboolean rygel_cmdline_config_real_get_mp3_transcoder (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	if (!rygel_cmdline_config_no_mp3_trans) {
		const gchar* _tmp0_ = NULL;
		GError* _tmp1_ = NULL;
		_tmp0_ = _ ("No value available");
		_tmp1_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp0_);
		_inner_error_ = _tmp1_;
		g_propagate_error (error, _inner_error_);
		return FALSE;
	} else {
		result = FALSE;
		return result;
	}
}


static gboolean rygel_cmdline_config_real_get_mp2ts_transcoder (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	if (!rygel_cmdline_config_no_mp2ts_trans) {
		const gchar* _tmp0_ = NULL;
		GError* _tmp1_ = NULL;
		_tmp0_ = _ ("No value available");
		_tmp1_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp0_);
		_inner_error_ = _tmp1_;
		g_propagate_error (error, _inner_error_);
		return FALSE;
	} else {
		result = FALSE;
		return result;
	}
}


static gboolean rygel_cmdline_config_real_get_lpcm_transcoder (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	if (!rygel_cmdline_config_no_lpcm_trans) {
		const gchar* _tmp0_ = NULL;
		GError* _tmp1_ = NULL;
		_tmp0_ = _ ("No value available");
		_tmp1_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp0_);
		_inner_error_ = _tmp1_;
		g_propagate_error (error, _inner_error_);
		return FALSE;
	} else {
		result = FALSE;
		return result;
	}
}


static gboolean rygel_cmdline_config_real_get_wmv_transcoder (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	if (!rygel_cmdline_config_no_wmv_trans) {
		const gchar* _tmp0_ = NULL;
		GError* _tmp1_ = NULL;
		_tmp0_ = _ ("No value available");
		_tmp1_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp0_);
		_inner_error_ = _tmp1_;
		g_propagate_error (error, _inner_error_);
		return FALSE;
	} else {
		result = FALSE;
		return result;
	}
}


static gboolean rygel_cmdline_config_real_get_allow_upload (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	if (!rygel_cmdline_config_disallow_upload) {
		const gchar* _tmp0_ = NULL;
		GError* _tmp1_ = NULL;
		_tmp0_ = _ ("No value available");
		_tmp1_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp0_);
		_inner_error_ = _tmp1_;
		g_propagate_error (error, _inner_error_);
		return FALSE;
	} else {
		result = FALSE;
		return result;
	}
}


static gboolean rygel_cmdline_config_real_get_allow_deletion (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	if (!rygel_cmdline_config_disallow_deletion) {
		const gchar* _tmp0_ = NULL;
		GError* _tmp1_ = NULL;
		_tmp0_ = _ ("No value available");
		_tmp1_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp0_);
		_inner_error_ = _tmp1_;
		g_propagate_error (error, _inner_error_);
		return FALSE;
	} else {
		result = FALSE;
		return result;
	}
}


static RygelLogLevel rygel_cmdline_config_real_get_log_level (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	RygelLogLevel result = 0;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	if (rygel_cmdline_config_log_level == RYGEL_LOG_LEVEL_INVALID) {
		const gchar* _tmp0_ = NULL;
		GError* _tmp1_ = NULL;
		_tmp0_ = _ ("No value available");
		_tmp1_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp0_);
		_inner_error_ = _tmp1_;
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	result = rygel_cmdline_config_log_level;
	return result;
}


static gchar* rygel_cmdline_config_real_get_plugin_path (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gchar* result = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	if (rygel_cmdline_config_plugin_path == NULL) {
		GError* _tmp0_ = NULL;
		_tmp0_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
		_inner_error_ = _tmp0_;
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp1_ = g_strdup (rygel_cmdline_config_plugin_path);
	result = _tmp1_;
	return result;
}


static gboolean rygel_cmdline_config_real_get_enabled (RygelConfiguration* base, const gchar* section, GError** error) {
	RygelCmdlineConfig * self;
	gboolean result = FALSE;
	gboolean disabled;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	g_return_val_if_fail (section != NULL, FALSE);
	disabled = FALSE;
	{
		gchar** plugin_collection;
		int plugin_collection_length1;
		int plugin_it;
		plugin_collection = rygel_cmdline_config_disabled_plugins;
		plugin_collection_length1 = _vala_array_length (rygel_cmdline_config_disabled_plugins);
		for (plugin_it = 0; plugin_it < _vala_array_length (rygel_cmdline_config_disabled_plugins); plugin_it = plugin_it + 1) {
			gchar* _tmp0_;
			gchar* plugin;
			_tmp0_ = g_strdup (plugin_collection[plugin_it]);
			plugin = _tmp0_;
			{
				if (g_strcmp0 (plugin, section) == 0) {
					disabled = TRUE;
					_g_free0 (plugin);
					break;
				}
				_g_free0 (plugin);
			}
		}
	}
	if (disabled) {
		result = FALSE;
		return result;
	} else {
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		_tmp1_ = _ ("No value available");
		_tmp2_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp1_);
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
}


static gchar* rygel_cmdline_config_real_get_title (RygelConfiguration* base, const gchar* section, GError** error) {
	RygelCmdlineConfig * self;
	gchar* result = NULL;
	gchar* title;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	title = NULL;
	{
		gchar** plugin_title_collection;
		int plugin_title_collection_length1;
		int plugin_title_it;
		plugin_title_collection = rygel_cmdline_config_plugin_titles;
		plugin_title_collection_length1 = _vala_array_length (rygel_cmdline_config_plugin_titles);
		for (plugin_title_it = 0; plugin_title_it < _vala_array_length (rygel_cmdline_config_plugin_titles); plugin_title_it = plugin_title_it + 1) {
			gchar* _tmp0_;
			gchar* plugin_title;
			_tmp0_ = g_strdup (plugin_title_collection[plugin_title_it]);
			plugin_title = _tmp0_;
			{
				gchar** _tmp1_;
				gchar** _tmp2_ = NULL;
				gint tokens_length1;
				gint _tokens_size_;
				gchar** _tmp3_;
				gchar** tokens;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				_tmp2_ = _tmp1_ = g_strsplit (plugin_title, ":", 2);
				_tmp3_ = _tmp2_;
				tokens_length1 = _vala_array_length (_tmp1_);
				_tokens_size_ = tokens_length1;
				tokens = _tmp3_;
				if (tokens[0] != NULL) {
					_tmp5_ = tokens[1] != NULL;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					_tmp4_ = g_strcmp0 (tokens[0], section) == 0;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					gchar* _tmp6_;
					gchar* _tmp7_;
					_tmp6_ = g_strdup (tokens[1]);
					_tmp7_ = _tmp6_;
					_g_free0 (title);
					title = _tmp7_;
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (plugin_title);
					break;
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (plugin_title);
			}
		}
	}
	if (title != NULL) {
		result = title;
		return result;
	} else {
		const gchar* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		_tmp8_ = _ ("No value available");
		_tmp9_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp8_);
		_inner_error_ = _tmp9_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (title);
		return NULL;
	}
	_g_free0 (title);
}


static gchar* rygel_cmdline_config_real_get_string (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelCmdlineConfig * self;
	gchar* result = NULL;
	gchar* value;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	value = NULL;
	{
		gchar** option_collection;
		int option_collection_length1;
		int option_it;
		option_collection = rygel_cmdline_config_plugin_options;
		option_collection_length1 = _vala_array_length (rygel_cmdline_config_plugin_options);
		for (option_it = 0; option_it < _vala_array_length (rygel_cmdline_config_plugin_options); option_it = option_it + 1) {
			gchar* _tmp0_;
			gchar* option;
			_tmp0_ = g_strdup (option_collection[option_it]);
			option = _tmp0_;
			{
				gchar** _tmp1_;
				gchar** _tmp2_ = NULL;
				gint tokens_length1;
				gint _tokens_size_;
				gchar** _tmp3_;
				gchar** tokens;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				_tmp2_ = _tmp1_ = g_strsplit (option, ":", 3);
				_tmp3_ = _tmp2_;
				tokens_length1 = _vala_array_length (_tmp1_);
				_tokens_size_ = tokens_length1;
				tokens = _tmp3_;
				if (tokens[0] != NULL) {
					_tmp7_ = tokens[1] != NULL;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = tokens[2] != NULL;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					_tmp5_ = g_strcmp0 (tokens[0], section) == 0;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					_tmp4_ = g_strcmp0 (tokens[1], key) == 0;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					gchar* _tmp8_;
					gchar* _tmp9_;
					_tmp8_ = g_strdup (tokens[2]);
					_tmp9_ = _tmp8_;
					_g_free0 (value);
					value = _tmp9_;
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (option);
					break;
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (option);
			}
		}
	}
	if (value != NULL) {
		result = value;
		return result;
	} else {
		const gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		_tmp10_ = _ ("No value available");
		_tmp11_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp10_);
		_inner_error_ = _tmp11_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (value);
		return NULL;
	}
	_g_free0 (value);
}


static GeeArrayList* rygel_cmdline_config_real_get_string_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelCmdlineConfig * self;
	GeeArrayList* result = NULL;
	GeeArrayList* value;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	value = NULL;
	{
		gchar** option_collection;
		int option_collection_length1;
		int option_it;
		option_collection = rygel_cmdline_config_plugin_options;
		option_collection_length1 = _vala_array_length (rygel_cmdline_config_plugin_options);
		for (option_it = 0; option_it < _vala_array_length (rygel_cmdline_config_plugin_options); option_it = option_it + 1) {
			gchar* _tmp0_;
			gchar* option;
			_tmp0_ = g_strdup (option_collection[option_it]);
			option = _tmp0_;
			{
				gchar** _tmp1_;
				gchar** _tmp2_ = NULL;
				gint tokens_length1;
				gint _tokens_size_;
				gchar** _tmp3_;
				gchar** tokens;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				_tmp2_ = _tmp1_ = g_strsplit (option, ":", 3);
				_tmp3_ = _tmp2_;
				tokens_length1 = _vala_array_length (_tmp1_);
				_tokens_size_ = tokens_length1;
				tokens = _tmp3_;
				if (tokens[0] != NULL) {
					_tmp7_ = tokens[1] != NULL;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = tokens[2] != NULL;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					_tmp5_ = g_strcmp0 (tokens[0], section) == 0;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					_tmp4_ = g_strcmp0 (tokens[1], key) == 0;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					GeeArrayList* _tmp8_ = NULL;
					GeeArrayList* _tmp9_;
					gchar** _tmp10_;
					gchar** _tmp11_ = NULL;
					_tmp8_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
					_tmp9_ = _tmp8_;
					_g_object_unref0 (value);
					value = _tmp9_;
					_tmp11_ = _tmp10_ = g_strsplit (tokens[2], ",", -1);
					{
						gchar** val_token_collection;
						int val_token_collection_length1;
						int val_token_it;
						val_token_collection = _tmp11_;
						val_token_collection_length1 = _vala_array_length (_tmp10_);
						for (val_token_it = 0; val_token_it < _vala_array_length (_tmp10_); val_token_it = val_token_it + 1) {
							gchar* _tmp12_;
							gchar* val_token;
							_tmp12_ = g_strdup (val_token_collection[val_token_it]);
							val_token = _tmp12_;
							{
								gee_abstract_collection_add ((GeeAbstractCollection*) value, val_token);
								_g_free0 (val_token);
							}
						}
						val_token_collection = (_vala_array_free (val_token_collection, val_token_collection_length1, (GDestroyNotify) g_free), NULL);
					}
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (option);
					break;
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (option);
			}
		}
	}
	if (value != NULL) {
		result = value;
		return result;
	} else {
		const gchar* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
		_tmp13_ = _ ("No value available");
		_tmp14_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp13_);
		_inner_error_ = _tmp14_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (value);
		return NULL;
	}
	_g_object_unref0 (value);
}


static gint rygel_cmdline_config_real_get_int (RygelConfiguration* base, const gchar* section, const gchar* key, gint min, gint max, GError** error) {
	RygelCmdlineConfig * self;
	gint result = 0;
	gint value;
	gboolean value_set;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	g_return_val_if_fail (section != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	value = 0;
	value_set = FALSE;
	{
		gchar** option_collection;
		int option_collection_length1;
		int option_it;
		option_collection = rygel_cmdline_config_plugin_options;
		option_collection_length1 = _vala_array_length (rygel_cmdline_config_plugin_options);
		for (option_it = 0; option_it < _vala_array_length (rygel_cmdline_config_plugin_options); option_it = option_it + 1) {
			gchar* _tmp0_;
			gchar* option;
			_tmp0_ = g_strdup (option_collection[option_it]);
			option = _tmp0_;
			{
				gchar** _tmp1_;
				gchar** _tmp2_ = NULL;
				gint tokens_length1;
				gint _tokens_size_;
				gchar** _tmp3_;
				gchar** tokens;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				_tmp2_ = _tmp1_ = g_strsplit (option, ":", 3);
				_tmp3_ = _tmp2_;
				tokens_length1 = _vala_array_length (_tmp1_);
				_tokens_size_ = tokens_length1;
				tokens = _tmp3_;
				if (tokens[0] != NULL) {
					_tmp7_ = tokens[1] != NULL;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = tokens[2] != NULL;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					_tmp5_ = g_strcmp0 (tokens[0], section) == 0;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					_tmp4_ = g_strcmp0 (tokens[1], key) == 0;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					gint _tmp8_;
					gboolean _tmp9_ = FALSE;
					_tmp8_ = atoi (tokens[2]);
					value = _tmp8_;
					if (value >= min) {
						_tmp9_ = value <= max;
					} else {
						_tmp9_ = FALSE;
					}
					if (_tmp9_) {
						value_set = TRUE;
					}
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (option);
					break;
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (option);
			}
		}
	}
	if (value_set) {
		result = value;
		return result;
	} else {
		const gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		_tmp10_ = _ ("No value available");
		_tmp11_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp10_);
		_inner_error_ = _tmp11_;
		g_propagate_error (error, _inner_error_);
		return 0;
	}
}


static GeeArrayList* rygel_cmdline_config_real_get_int_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelCmdlineConfig * self;
	GeeArrayList* result = NULL;
	GeeArrayList* value;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	value = NULL;
	{
		gchar** option_collection;
		int option_collection_length1;
		int option_it;
		option_collection = rygel_cmdline_config_plugin_options;
		option_collection_length1 = _vala_array_length (rygel_cmdline_config_plugin_options);
		for (option_it = 0; option_it < _vala_array_length (rygel_cmdline_config_plugin_options); option_it = option_it + 1) {
			gchar* _tmp0_;
			gchar* option;
			_tmp0_ = g_strdup (option_collection[option_it]);
			option = _tmp0_;
			{
				gchar** _tmp1_;
				gchar** _tmp2_ = NULL;
				gint tokens_length1;
				gint _tokens_size_;
				gchar** _tmp3_;
				gchar** tokens;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				_tmp2_ = _tmp1_ = g_strsplit (option, ":", 3);
				_tmp3_ = _tmp2_;
				tokens_length1 = _vala_array_length (_tmp1_);
				_tokens_size_ = tokens_length1;
				tokens = _tmp3_;
				if (tokens[0] != NULL) {
					_tmp7_ = tokens[1] != NULL;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = tokens[2] != NULL;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					_tmp5_ = g_strcmp0 (tokens[0], section) == 0;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					_tmp4_ = g_strcmp0 (tokens[1], key) == 0;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					GeeArrayList* _tmp8_ = NULL;
					GeeArrayList* _tmp9_;
					gchar** _tmp10_;
					gchar** _tmp11_ = NULL;
					_tmp8_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL);
					_tmp9_ = _tmp8_;
					_g_object_unref0 (value);
					value = _tmp9_;
					_tmp11_ = _tmp10_ = g_strsplit (tokens[2], ",", -1);
					{
						gchar** val_token_collection;
						int val_token_collection_length1;
						int val_token_it;
						val_token_collection = _tmp11_;
						val_token_collection_length1 = _vala_array_length (_tmp10_);
						for (val_token_it = 0; val_token_it < _vala_array_length (_tmp10_); val_token_it = val_token_it + 1) {
							gchar* _tmp12_;
							gchar* val_token;
							_tmp12_ = g_strdup (val_token_collection[val_token_it]);
							val_token = _tmp12_;
							{
								gint _tmp13_;
								_tmp13_ = atoi (val_token);
								gee_abstract_collection_add ((GeeAbstractCollection*) value, GINT_TO_POINTER (_tmp13_));
								_g_free0 (val_token);
							}
						}
						val_token_collection = (_vala_array_free (val_token_collection, val_token_collection_length1, (GDestroyNotify) g_free), NULL);
					}
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (option);
					break;
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (option);
			}
		}
	}
	if (value != NULL) {
		result = value;
		return result;
	} else {
		const gchar* _tmp14_ = NULL;
		GError* _tmp15_ = NULL;
		_tmp14_ = _ ("No value available");
		_tmp15_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp14_);
		_inner_error_ = _tmp15_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (value);
		return NULL;
	}
	_g_object_unref0 (value);
}


static gboolean string_to_bool (const gchar* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (g_strcmp0 (self, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static gboolean rygel_cmdline_config_real_get_bool (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelCmdlineConfig * self;
	gboolean result = FALSE;
	gboolean value;
	gboolean value_set;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	g_return_val_if_fail (section != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	value = FALSE;
	value_set = FALSE;
	{
		gchar** option_collection;
		int option_collection_length1;
		int option_it;
		option_collection = rygel_cmdline_config_plugin_options;
		option_collection_length1 = _vala_array_length (rygel_cmdline_config_plugin_options);
		for (option_it = 0; option_it < _vala_array_length (rygel_cmdline_config_plugin_options); option_it = option_it + 1) {
			gchar* _tmp0_;
			gchar* option;
			_tmp0_ = g_strdup (option_collection[option_it]);
			option = _tmp0_;
			{
				gchar** _tmp1_;
				gchar** _tmp2_ = NULL;
				gint tokens_length1;
				gint _tokens_size_;
				gchar** _tmp3_;
				gchar** tokens;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				_tmp2_ = _tmp1_ = g_strsplit (option, ":", 3);
				_tmp3_ = _tmp2_;
				tokens_length1 = _vala_array_length (_tmp1_);
				_tokens_size_ = tokens_length1;
				tokens = _tmp3_;
				if (tokens[0] != NULL) {
					_tmp7_ = tokens[1] != NULL;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = tokens[2] != NULL;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					_tmp5_ = g_strcmp0 (tokens[0], section) == 0;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					_tmp4_ = g_strcmp0 (tokens[1], key) == 0;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					gboolean _tmp8_;
					_tmp8_ = string_to_bool (tokens[2]);
					value = _tmp8_;
					value_set = TRUE;
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (option);
					break;
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (option);
			}
		}
	}
	if (value_set) {
		result = value;
		return result;
	} else {
		const gchar* _tmp9_ = NULL;
		GError* _tmp10_ = NULL;
		_tmp9_ = _ ("No value available");
		_tmp10_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp9_);
		_inner_error_ = _tmp10_;
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
}


RygelCmdlineConfig* rygel_cmdline_config_construct (GType object_type) {
	RygelCmdlineConfig * self = NULL;
	self = (RygelCmdlineConfig*) g_object_new (object_type, NULL);
	return self;
}


RygelCmdlineConfig* rygel_cmdline_config_new (void) {
	return rygel_cmdline_config_construct (RYGEL_TYPE_CMDLINE_CONFIG);
}


static void rygel_cmdline_config_class_init (RygelCmdlineConfigClass * klass) {
	rygel_cmdline_config_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_cmdline_config_finalize;
}


static void rygel_cmdline_config_rygel_configuration_interface_init (RygelConfigurationIface * iface) {
	rygel_cmdline_config_rygel_configuration_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_upnp_enabled = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_cmdline_config_real_get_upnp_enabled;
	iface->get_interface = (gchar* (*)(RygelConfiguration* ,GError**)) rygel_cmdline_config_real_get_interface;
	iface->get_port = (gint (*)(RygelConfiguration* ,GError**)) rygel_cmdline_config_real_get_port;
	iface->get_transcoding = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_cmdline_config_real_get_transcoding;
	iface->get_mp3_transcoder = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_cmdline_config_real_get_mp3_transcoder;
	iface->get_mp2ts_transcoder = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_cmdline_config_real_get_mp2ts_transcoder;
	iface->get_lpcm_transcoder = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_cmdline_config_real_get_lpcm_transcoder;
	iface->get_wmv_transcoder = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_cmdline_config_real_get_wmv_transcoder;
	iface->get_allow_upload = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_cmdline_config_real_get_allow_upload;
	iface->get_allow_deletion = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_cmdline_config_real_get_allow_deletion;
	iface->get_log_level = (RygelLogLevel (*)(RygelConfiguration* ,GError**)) rygel_cmdline_config_real_get_log_level;
	iface->get_plugin_path = (gchar* (*)(RygelConfiguration* ,GError**)) rygel_cmdline_config_real_get_plugin_path;
	iface->get_enabled = (gboolean (*)(RygelConfiguration* ,const gchar* ,GError**)) rygel_cmdline_config_real_get_enabled;
	iface->get_title = (gchar* (*)(RygelConfiguration* ,const gchar* ,GError**)) rygel_cmdline_config_real_get_title;
	iface->get_string = (gchar* (*)(RygelConfiguration* ,const gchar* ,const gchar* ,GError**)) rygel_cmdline_config_real_get_string;
	iface->get_string_list = (GeeArrayList* (*)(RygelConfiguration* ,const gchar* ,const gchar* ,GError**)) rygel_cmdline_config_real_get_string_list;
	iface->get_int = (gint (*)(RygelConfiguration* ,const gchar* ,const gchar* ,gint ,gint ,GError**)) rygel_cmdline_config_real_get_int;
	iface->get_int_list = (GeeArrayList* (*)(RygelConfiguration* ,const gchar* ,const gchar* ,GError**)) rygel_cmdline_config_real_get_int_list;
	iface->get_bool = (gboolean (*)(RygelConfiguration* ,const gchar* ,const gchar* ,GError**)) rygel_cmdline_config_real_get_bool;
}


static void rygel_cmdline_config_instance_init (RygelCmdlineConfig * self) {
}


static void rygel_cmdline_config_finalize (GObject* obj) {
	RygelCmdlineConfig * self;
	self = RYGEL_CMDLINE_CONFIG (obj);
	G_OBJECT_CLASS (rygel_cmdline_config_parent_class)->finalize (obj);
}


/**
 * Manages configuration from Commandline arguments.
 */
GType rygel_cmdline_config_get_type (void) {
	static volatile gsize rygel_cmdline_config_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_cmdline_config_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelCmdlineConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_cmdline_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelCmdlineConfig), 0, (GInstanceInitFunc) rygel_cmdline_config_instance_init, NULL };
		static const GInterfaceInfo rygel_configuration_info = { (GInterfaceInitFunc) rygel_cmdline_config_rygel_configuration_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_cmdline_config_type_id;
		rygel_cmdline_config_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelCmdlineConfig", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_cmdline_config_type_id, RYGEL_TYPE_CONFIGURATION, &rygel_configuration_info);
		g_once_init_leave (&rygel_cmdline_config_type_id__volatile, rygel_cmdline_config_type_id);
	}
	return rygel_cmdline_config_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



