/* rygel-rendering-control.c generated by valac 0.11.2, the Vala compiler
 * generated from rygel-rendering-control.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_RENDERING_CONTROL (rygel_rendering_control_get_type ())
#define RYGEL_RENDERING_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControl))
#define RYGEL_RENDERING_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControlClass))
#define RYGEL_IS_RENDERING_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RENDERING_CONTROL))
#define RYGEL_IS_RENDERING_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RENDERING_CONTROL))
#define RYGEL_RENDERING_CONTROL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControlClass))

typedef struct _RygelRenderingControl RygelRenderingControl;
typedef struct _RygelRenderingControlClass RygelRenderingControlClass;
typedef struct _RygelRenderingControlPrivate RygelRenderingControlPrivate;

#define RYGEL_TYPE_CHANGE_LOG (rygel_change_log_get_type ())
#define RYGEL_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLog))
#define RYGEL_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))
#define RYGEL_IS_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_IS_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_CHANGE_LOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))

typedef struct _RygelChangeLog RygelChangeLog;
typedef struct _RygelChangeLogClass RygelChangeLogClass;

#define RYGEL_TYPE_MEDIA_PLAYER (rygel_media_player_get_type ())
#define RYGEL_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayer))
#define RYGEL_IS_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_PLAYER))
#define RYGEL_MEDIA_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayerIface))

typedef struct _RygelMediaPlayer RygelMediaPlayer;
typedef struct _RygelMediaPlayerIface RygelMediaPlayerIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;

#define RYGEL_TYPE_MEDIA_RENDERER_PLUGIN (rygel_media_renderer_plugin_get_type ())
#define RYGEL_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPlugin))
#define RYGEL_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_MEDIA_RENDERER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))

typedef struct _RygelMediaRendererPlugin RygelMediaRendererPlugin;
typedef struct _RygelMediaRendererPluginClass RygelMediaRendererPluginClass;

struct _RygelRenderingControl {
	GUPnPService parent_instance;
	RygelRenderingControlPrivate * priv;
};

struct _RygelRenderingControlClass {
	GUPnPServiceClass parent_class;
};

struct _RygelMediaPlayerIface {
	GTypeInterface parent_iface;
	gboolean (*seek) (RygelMediaPlayer* self, GstClockTime time);
	gchar** (*get_protocols) (RygelMediaPlayer* self, int* result_length1);
	gchar** (*get_mime_types) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_state) (RygelMediaPlayer* self);
	void (*set_playback_state) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_uri) (RygelMediaPlayer* self);
	void (*set_uri) (RygelMediaPlayer* self, const gchar* value);
	gdouble (*get_volume) (RygelMediaPlayer* self);
	void (*set_volume) (RygelMediaPlayer* self, gdouble value);
	gint64 (*get_duration) (RygelMediaPlayer* self);
	gint64 (*get_position) (RygelMediaPlayer* self);
};

struct _RygelRenderingControlPrivate {
	gboolean _mute;
	guint _volume;
	gchar* preset_name_list;
	RygelChangeLog* changelog;
	RygelMediaPlayer* player;
};


static gpointer rygel_rendering_control_parent_class = NULL;

GType rygel_rendering_control_get_type (void) G_GNUC_CONST;
GType rygel_change_log_get_type (void) G_GNUC_CONST;
GType rygel_media_player_get_type (void) G_GNUC_CONST;
#define RYGEL_RENDERING_CONTROL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControlPrivate))
enum  {
	RYGEL_RENDERING_CONTROL_DUMMY_PROPERTY,
	RYGEL_RENDERING_CONTROL_MUTE,
	RYGEL_RENDERING_CONTROL_VOLUME
};
#define RYGEL_RENDERING_CONTROL_UPNP_ID "urn:upnp-org:serviceId:RenderingControl"
#define RYGEL_RENDERING_CONTROL_UPNP_TYPE "urn:schemas-upnp-org:service:RenderingControl:2"
#define RYGEL_RENDERING_CONTROL_DESCRIPTION_PATH "xml/RenderingControl2.xml"
#define RYGEL_RENDERING_CONTROL_LAST_CHANGE_NS "urn:schemas-upnp-org:metadata-1-0/RCS/"
static void rygel_rendering_control_real_constructed (GObject* base);
RygelChangeLog* rygel_change_log_new (GUPnPService* service, const gchar* service_ns);
RygelChangeLog* rygel_change_log_construct (GType object_type, GUPnPService* service, const gchar* service_ns);
static RygelMediaPlayer* rygel_rendering_control_get_player (RygelRenderingControl* self);
static void rygel_rendering_control_query_last_change_cb (RygelRenderingControl* self, GUPnPService* service, const gchar* variable, GValue* value);
static void _rygel_rendering_control_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_rendering_control_list_presets_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_rendering_control_list_presets_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_rendering_control_select_preset_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_rendering_control_select_preset_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_rendering_control_get_mute_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_rendering_control_get_mute_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_rendering_control_set_mute_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_rendering_control_set_mute_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_rendering_control_get_volume_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_rendering_control_get_volume_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_rendering_control_set_volume_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_rendering_control_set_volume_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
guint rygel_volume_to_percentage (gdouble volume);
gdouble rygel_media_player_get_volume (RygelMediaPlayer* self);
gboolean rygel_rendering_control_get_mute (RygelRenderingControl* self);
void rygel_change_log_log_with_channel (RygelChangeLog* self, const gchar* variable, const gchar* value, const gchar* channel);
guint rygel_rendering_control_get_volume (RygelRenderingControl* self);
gchar* rygel_change_log_finish (RygelChangeLog* self);
GType rygel_plugin_get_type (void) G_GNUC_CONST;
GType rygel_media_renderer_plugin_get_type (void) G_GNUC_CONST;
RygelMediaPlayer* rygel_media_renderer_plugin_get_player (RygelMediaRendererPlugin* self);
static gboolean rygel_rendering_control_check_instance_id (RygelRenderingControl* self, GUPnPServiceAction* action);
static gboolean rygel_rendering_control_check_channel (RygelRenderingControl* self, GUPnPServiceAction* action);
void rygel_rendering_control_set_mute (RygelRenderingControl* self, gboolean value);
void rygel_rendering_control_set_volume (RygelRenderingControl* self, guint value);
RygelRenderingControl* rygel_rendering_control_new (void);
RygelRenderingControl* rygel_rendering_control_construct (GType object_type);
void rygel_media_player_set_volume (RygelMediaPlayer* self, gdouble value);
gdouble rygel_volume_from_percentage (guint percentage);
static void rygel_rendering_control_finalize (GObject* obj);
static void _vala_rygel_rendering_control_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_rendering_control_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _rygel_rendering_control_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
	rygel_rendering_control_query_last_change_cb (self, _sender, variable, value);
}


static void _rygel_rendering_control_list_presets_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_rendering_control_list_presets_cb (self, _sender, action);
}


static void _rygel_rendering_control_select_preset_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_rendering_control_select_preset_cb (self, _sender, action);
}


static void _rygel_rendering_control_get_mute_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_rendering_control_get_mute_cb (self, _sender, action);
}


static void _rygel_rendering_control_set_mute_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_rendering_control_set_mute_cb (self, _sender, action);
}


static void _rygel_rendering_control_get_volume_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_rendering_control_get_volume_cb (self, _sender, action);
}


static void _rygel_rendering_control_set_volume_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_rendering_control_set_volume_cb (self, _sender, action);
}


static void rygel_rendering_control_real_constructed (GObject* base) {
	RygelRenderingControl * self;
	RygelChangeLog* _tmp0_ = NULL;
	RygelChangeLog* _tmp1_;
	RygelMediaPlayer* _tmp2_ = NULL;
	RygelMediaPlayer* _tmp3_;
	gdouble _tmp4_;
	guint _tmp5_;
	self = (RygelRenderingControl*) base;
	_tmp0_ = rygel_change_log_new ((GUPnPService*) self, RYGEL_RENDERING_CONTROL_LAST_CHANGE_NS);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->changelog);
	self->priv->changelog = _tmp1_;
	_tmp2_ = rygel_rendering_control_get_player (self);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->player);
	self->priv->player = _tmp3_;
	g_signal_connect_object ((GUPnPService*) self, "query-variable::LastChange", (GCallback) _rygel_rendering_control_query_last_change_cb_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::ListPresets", (GCallback) _rygel_rendering_control_list_presets_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SelectPreset", (GCallback) _rygel_rendering_control_select_preset_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetMute", (GCallback) _rygel_rendering_control_get_mute_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SetMute", (GCallback) _rygel_rendering_control_set_mute_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetVolume", (GCallback) _rygel_rendering_control_get_volume_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SetVolume", (GCallback) _rygel_rendering_control_set_volume_cb_gupnp_service_action_invoked, self, 0);
	_tmp4_ = rygel_media_player_get_volume (self->priv->player);
	_tmp5_ = rygel_volume_to_percentage (_tmp4_);
	self->priv->_volume = _tmp5_;
}


static void rygel_rendering_control_query_last_change_cb (RygelRenderingControl* self, GUPnPService* service, const gchar* variable, GValue* value) {
	RygelChangeLog* _tmp0_ = NULL;
	RygelChangeLog* log;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	guint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (variable != NULL);
	_tmp0_ = rygel_change_log_new (NULL, RYGEL_RENDERING_CONTROL_LAST_CHANGE_NS);
	log = _tmp0_;
	_tmp1_ = NULL;
	_tmp2_ = rygel_rendering_control_get_mute (self);
	if (_tmp2_) {
		_tmp1_ = "1";
	} else {
		_tmp1_ = "0";
	}
	rygel_change_log_log_with_channel (log, "Mute", _tmp1_, "Master");
	_tmp3_ = rygel_rendering_control_get_volume (self);
	_tmp4_ = g_strdup_printf ("%u", _tmp3_);
	_tmp5_ = _tmp4_;
	rygel_change_log_log_with_channel (log, "Volume", _tmp5_, "Master");
	_g_free0 (_tmp5_);
	g_value_init (value, G_TYPE_STRING);
	_tmp6_ = rygel_change_log_finish (log);
	_tmp7_ = _tmp6_;
	g_value_set_string (value, _tmp7_);
	_g_free0 (_tmp7_);
	_g_object_unref0 (log);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static RygelMediaPlayer* rygel_rendering_control_get_player (RygelRenderingControl* self) {
	RygelMediaPlayer* result = NULL;
	GUPnPRootDevice* _tmp0_ = NULL;
	GUPnPRootDevice* _tmp1_;
	GUPnPResourceFactory* _tmp2_ = NULL;
	GUPnPResourceFactory* _tmp3_;
	RygelMediaRendererPlugin* _tmp4_;
	RygelMediaRendererPlugin* _tmp5_;
	RygelMediaRendererPlugin* plugin;
	RygelMediaPlayer* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = (g_object_get ((GUPnPService*) self, "root-device", &_tmp0_, NULL), _tmp0_);
	_tmp2_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp1_);
	_tmp4_ = _g_object_ref0 ((_tmp3_ = _tmp2_, RYGEL_IS_MEDIA_RENDERER_PLUGIN (_tmp3_) ? ((RygelMediaRendererPlugin*) _tmp3_) : NULL));
	plugin = (_tmp5_ = _tmp4_, _g_object_unref0 (_tmp1_), _tmp5_);
	_tmp6_ = rygel_media_renderer_plugin_get_player (plugin);
	result = _tmp6_;
	_g_object_unref0 (plugin);
	return result;
}


static gboolean rygel_rendering_control_check_instance_id (RygelRenderingControl* self, GUPnPServiceAction* action) {
	gboolean result = FALSE;
	guint instance_id = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (action != NULL, FALSE);
	gupnp_service_action_get (action, "InstanceID", G_TYPE_UINT, &instance_id, NULL);
	if (instance_id != 0) {
		const gchar* _tmp0_ = NULL;
		_tmp0_ = _ ("Invalid InstanceID");
		gupnp_service_action_return_error (action, (guint) 702, _tmp0_);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static void rygel_rendering_control_list_presets_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = rygel_rendering_control_check_instance_id (self, action);
	if (!_tmp0_) {
		return;
	}
	gupnp_service_action_set (action, "CurrentPresetNameList", G_TYPE_STRING, self->priv->preset_name_list, NULL);
	gupnp_service_action_return (action);
}


static void rygel_rendering_control_select_preset_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action) {
	gboolean _tmp0_;
	gchar* preset_name;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = rygel_rendering_control_check_instance_id (self, action);
	if (!_tmp0_) {
		return;
	}
	preset_name = NULL;
	gupnp_service_action_get (action, "PresetName", G_TYPE_STRING, &preset_name, NULL);
	if (g_strcmp0 (preset_name, "") != 0) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = _ ("Invalid Name");
		gupnp_service_action_return_error (action, (guint) 701, _tmp1_);
		_g_free0 (preset_name);
		return;
	}
	gupnp_service_action_return (action);
	_g_free0 (preset_name);
}


static gboolean rygel_rendering_control_check_channel (RygelRenderingControl* self, GUPnPServiceAction* action) {
	gboolean result = FALSE;
	gchar* channel;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (action != NULL, FALSE);
	channel = NULL;
	gupnp_service_action_get (action, "Channel", G_TYPE_STRING, &channel, NULL);
	if (g_strcmp0 (channel, "Master") != 0) {
		const gchar* _tmp0_ = NULL;
		_tmp0_ = _ ("Action Failed");
		gupnp_service_action_return_error (action, (guint) 501, _tmp0_);
		result = FALSE;
		_g_free0 (channel);
		return result;
	}
	result = TRUE;
	_g_free0 (channel);
	return result;
}


static void rygel_rendering_control_get_mute_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = rygel_rendering_control_check_instance_id (self, action);
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = rygel_rendering_control_check_channel (self, action);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = rygel_rendering_control_get_mute (self);
	gupnp_service_action_set (action, "CurrentMute", G_TYPE_BOOLEAN, _tmp2_, NULL);
	gupnp_service_action_return (action);
}


static void rygel_rendering_control_set_mute_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean mute = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = rygel_rendering_control_check_instance_id (self, action);
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = rygel_rendering_control_check_channel (self, action);
	if (!_tmp1_) {
		return;
	}
	gupnp_service_action_get (action, "DesiredMute", G_TYPE_BOOLEAN, &mute, NULL);
	rygel_rendering_control_set_mute (self, mute);
	gupnp_service_action_return (action);
}


static void rygel_rendering_control_get_volume_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = rygel_rendering_control_check_instance_id (self, action);
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = rygel_rendering_control_check_channel (self, action);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = rygel_rendering_control_get_volume (self);
	gupnp_service_action_set (action, "CurrentVolume", G_TYPE_UINT, _tmp2_, NULL);
	gupnp_service_action_return (action);
}


static void rygel_rendering_control_set_volume_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	guint volume = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = rygel_rendering_control_check_instance_id (self, action);
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = rygel_rendering_control_check_channel (self, action);
	if (!_tmp1_) {
		return;
	}
	gupnp_service_action_get (action, "DesiredVolume", G_TYPE_UINT, &volume, NULL);
	if (volume > 100) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = _ ("Action Failed");
		gupnp_service_action_return_error (action, (guint) 501, _tmp2_);
		return;
	}
	rygel_rendering_control_set_volume (self, volume);
	gupnp_service_action_return (action);
}


RygelRenderingControl* rygel_rendering_control_construct (GType object_type) {
	RygelRenderingControl * self = NULL;
	self = (RygelRenderingControl*) g_object_new (object_type, NULL);
	return self;
}


RygelRenderingControl* rygel_rendering_control_new (void) {
	return rygel_rendering_control_construct (RYGEL_TYPE_RENDERING_CONTROL);
}


gboolean rygel_rendering_control_get_mute (RygelRenderingControl* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_mute;
	return result;
}


void rygel_rendering_control_set_mute (RygelRenderingControl* self, gboolean value) {
	const gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	self->priv->_mute = value;
	if (self->priv->_mute) {
		rygel_media_player_set_volume (self->priv->player, (gdouble) 0);
	} else {
		guint _tmp0_;
		gdouble _tmp1_;
		_tmp0_ = rygel_rendering_control_get_volume (self);
		_tmp1_ = rygel_volume_from_percentage (_tmp0_);
		rygel_media_player_set_volume (self->priv->player, _tmp1_);
	}
	_tmp2_ = NULL;
	_tmp3_ = rygel_rendering_control_get_mute (self);
	if (_tmp3_) {
		_tmp2_ = "1";
	} else {
		_tmp2_ = "0";
	}
	rygel_change_log_log_with_channel (self->priv->changelog, "Mute", _tmp2_, "Master");
	g_object_notify ((GObject *) self, "mute");
}


guint rygel_rendering_control_get_volume (RygelRenderingControl* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_volume;
	return result;
}


void rygel_rendering_control_set_volume (RygelRenderingControl* self, guint value) {
	gboolean _tmp0_;
	guint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	self->priv->_volume = value;
	_tmp0_ = rygel_rendering_control_get_mute (self);
	if (!_tmp0_) {
		guint _tmp1_;
		gdouble _tmp2_;
		_tmp1_ = rygel_rendering_control_get_volume (self);
		_tmp2_ = rygel_volume_from_percentage (_tmp1_);
		rygel_media_player_set_volume (self->priv->player, _tmp2_);
	}
	_tmp3_ = rygel_rendering_control_get_volume (self);
	_tmp4_ = g_strdup_printf ("%u", _tmp3_);
	_tmp5_ = _tmp4_;
	rygel_change_log_log_with_channel (self->priv->changelog, "Volume", _tmp5_, "Master");
	_g_free0 (_tmp5_);
	g_object_notify ((GObject *) self, "volume");
}


static void rygel_rendering_control_class_init (RygelRenderingControlClass * klass) {
	rygel_rendering_control_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelRenderingControlPrivate));
	G_OBJECT_CLASS (klass)->constructed = rygel_rendering_control_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_rendering_control_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_rendering_control_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_rendering_control_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_RENDERING_CONTROL_MUTE, g_param_spec_boolean ("mute", "mute", "mute", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_RENDERING_CONTROL_VOLUME, g_param_spec_uint ("volume", "volume", "volume", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_rendering_control_instance_init (RygelRenderingControl * self) {
	gchar* _tmp0_;
	self->priv = RYGEL_RENDERING_CONTROL_GET_PRIVATE (self);
	self->priv->_mute = FALSE;
	self->priv->_volume = (guint) 0;
	_tmp0_ = g_strdup ("");
	self->priv->preset_name_list = _tmp0_;
}


static void rygel_rendering_control_finalize (GObject* obj) {
	RygelRenderingControl * self;
	self = RYGEL_RENDERING_CONTROL (obj);
	_g_free0 (self->priv->preset_name_list);
	_g_object_unref0 (self->priv->changelog);
	_g_object_unref0 (self->priv->player);
	G_OBJECT_CLASS (rygel_rendering_control_parent_class)->finalize (obj);
}


GType rygel_rendering_control_get_type (void) {
	static volatile gsize rygel_rendering_control_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_rendering_control_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelRenderingControlClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_rendering_control_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelRenderingControl), 0, (GInstanceInitFunc) rygel_rendering_control_instance_init, NULL };
		GType rygel_rendering_control_type_id;
		rygel_rendering_control_type_id = g_type_register_static (GUPNP_TYPE_SERVICE, "RygelRenderingControl", &g_define_type_info, 0);
		g_once_init_leave (&rygel_rendering_control_type_id__volatile, rygel_rendering_control_type_id);
	}
	return rygel_rendering_control_type_id__volatile;
}


static void _vala_rygel_rendering_control_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelRenderingControl * self;
	self = RYGEL_RENDERING_CONTROL (object);
	switch (property_id) {
		case RYGEL_RENDERING_CONTROL_MUTE:
		g_value_set_boolean (value, rygel_rendering_control_get_mute (self));
		break;
		case RYGEL_RENDERING_CONTROL_VOLUME:
		g_value_set_uint (value, rygel_rendering_control_get_volume (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_rendering_control_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelRenderingControl * self;
	self = RYGEL_RENDERING_CONTROL (object);
	switch (property_id) {
		case RYGEL_RENDERING_CONTROL_MUTE:
		rygel_rendering_control_set_mute (self, g_value_get_boolean (value));
		break;
		case RYGEL_RENDERING_CONTROL_VOLUME:
		rygel_rendering_control_set_volume (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



