/* rygel-media-export-database.c generated by valac 0.11.2, the Vala compiler
 * generated from rygel-media-export-database.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>


#define RYGEL_MEDIA_EXPORT_TYPE_DATABASE (rygel_media_export_database_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabase))
#define RYGEL_MEDIA_EXPORT_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabaseClass))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE))
#define RYGEL_MEDIA_EXPORT_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabaseClass))

typedef struct _RygelMediaExportDatabase RygelMediaExportDatabase;
typedef struct _RygelMediaExportDatabaseClass RygelMediaExportDatabaseClass;
typedef struct _RygelMediaExportDatabasePrivate RygelMediaExportDatabasePrivate;
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
struct _RygelMediaExportDatabase {
	GObject parent_instance;
	RygelMediaExportDatabasePrivate * priv;
};

struct _RygelMediaExportDatabaseClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportDatabasePrivate {
	sqlite3* db;
};

typedef gboolean (*RygelMediaExportDatabaseRowCallback) (sqlite3_stmt* stmt, void* user_data);

static gpointer rygel_media_export_database_parent_class = NULL;

GQuark rygel_media_export_database_error_quark (void);
GType rygel_media_export_database_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_DATABASE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabasePrivate))
enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_DUMMY_PROPERTY
};
static void rygel_media_export_database_utf8_contains (sqlite3_context* context, sqlite3_value** args, int args_length1);
static gint rygel_media_export_database_utf8_collate (gint alen, void* a, gint blen, void* b);
RygelMediaExportDatabase* rygel_media_export_database_new (const gchar* name, GError** error);
RygelMediaExportDatabase* rygel_media_export_database_construct (GType object_type, const gchar* name, GError** error);
static void _rygel_media_export_database_utf8_contains_sqlite_user_func_callback (sqlite3_context* context, int values_length1, sqlite3_value** values);
static gint _rygel_media_export_database_utf8_collate_sqlite_compare_callback (gpointer self, gint alen, void* a, gint blen, void* b);
gint rygel_media_export_database_exec (RygelMediaExportDatabase* self, const gchar* sql, GValue* values, int values_length1, RygelMediaExportDatabaseRowCallback callback, void* callback_target, GCancellable* cancellable, GError** error);
static sqlite3_stmt* rygel_media_export_database_prepare_statement (RygelMediaExportDatabase* self, const gchar* sql, GValue* values, int values_length1, GError** error);
void rygel_media_export_database_analyze (RygelMediaExportDatabase* self);
void rygel_media_export_database_null (GValue* result);
void rygel_media_export_database_begin (RygelMediaExportDatabase* self, GError** error);
static void rygel_media_export_database_single_statement (RygelMediaExportDatabase* self, const gchar* sql, GError** error);
void rygel_media_export_database_commit (RygelMediaExportDatabase* self, GError** error);
void rygel_media_export_database_rollback (RygelMediaExportDatabase* self);
static void rygel_media_export_database_finalize (GObject* obj);


GQuark rygel_media_export_database_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_export_database_error-quark");
}


static void rygel_media_export_database_utf8_contains (sqlite3_context* context, sqlite3_value** args, int args_length1) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* pattern;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_;
	g_return_if_fail (context != NULL);
	g_return_if_fail (args_length1 == 2);
	_tmp0_ = sqlite3_value_text (args[1]);
	if (_tmp0_ == NULL) {
		sqlite3_result_int (context, 0);
		return;
	}
	_tmp1_ = sqlite3_value_text (args[0]);
	_tmp2_ = g_regex_escape_string (_tmp1_, -1);
	pattern = _tmp2_;
	_tmp3_ = sqlite3_value_text (args[1]);
	_tmp4_ = g_regex_match_simple (pattern, _tmp3_, G_REGEX_CASELESS, 0);
	if (_tmp4_) {
		sqlite3_result_int (context, 1);
	} else {
		sqlite3_result_int (context, 0);
	}
	_g_free0 (pattern);
}


static gint rygel_media_export_database_utf8_collate (gint alen, void* a, gint blen, void* b) {
	gint result = 0;
	gint _a_length1;
	gint __a_size_;
	guint8* _tmp0_;
	guint8* _a;
	gint _b_length1;
	gint __b_size_;
	guint8* _tmp1_;
	guint8* _b;
	gchar* _tmp2_ = NULL;
	gchar* str_a;
	gchar* _tmp3_ = NULL;
	gchar* str_b;
	gint _tmp4_;
	_tmp0_ = (guint8*) a;
	_a_length1 = -1;
	__a_size_ = _a_length1;
	_a = _tmp0_;
	_a_length1 = alen;
	_tmp1_ = (guint8*) b;
	_b_length1 = -1;
	__b_size_ = _b_length1;
	_b = _tmp1_;
	_b_length1 = blen;
	_tmp2_ = g_utf8_casefold ((const gchar*) _a, (gssize) (-1));
	str_a = _tmp2_;
	_tmp3_ = g_utf8_casefold ((const gchar*) _b, (gssize) (-1));
	str_b = _tmp3_;
	_tmp4_ = g_utf8_collate (str_a, str_b);
	result = _tmp4_;
	_g_free0 (str_b);
	_g_free0 (str_a);
	return result;
}


/**
     * Open a database in the user's cache directory as defined by XDG
     *
     * @param name of the database, used to build full path
     * (<cache-dir>/rygel/<name>.db)
     */
static gint _sqlite3_exec (sqlite3* self, const gchar* sql, sqlite3_callback sqlite3_callback, void* sqlite3_callback_target, gchar** errmsg) {
	gchar* _errmsg = NULL;
	gint result = 0;
	const gchar* sqlite_errmsg;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_;
	gint ec;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	sqlite_errmsg = NULL;
	_tmp1_ = sqlite3_exec (self, sql, sqlite3_callback, sqlite3_callback_target, (char**) (&_tmp0_));
	sqlite_errmsg = _tmp0_;
	ec = _tmp1_;
	if ((&_errmsg) != NULL) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = g_strdup (sqlite_errmsg);
		_tmp3_ = _tmp2_;
		_g_free0 (_errmsg);
		_errmsg = _tmp3_;
	}
	sqlite3_free ((void*) sqlite_errmsg);
	result = ec;
	if (errmsg) {
		*errmsg = _errmsg;
	} else {
		_g_free0 (_errmsg);
	}
	return result;
}


static void _rygel_media_export_database_utf8_contains_sqlite_user_func_callback (sqlite3_context* context, int values_length1, sqlite3_value** values) {
	rygel_media_export_database_utf8_contains (context, values, values_length1);
}


static gint _rygel_media_export_database_utf8_collate_sqlite_compare_callback (gpointer self, gint alen, void* a, gint blen, void* b) {
	gint result;
	result = rygel_media_export_database_utf8_collate (alen, a, blen, b);
	return result;
}


RygelMediaExportDatabase* rygel_media_export_database_construct (GType object_type, const gchar* name, GError** error) {
	RygelMediaExportDatabase * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* dirname;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* db_file;
	sqlite3* _tmp6_ = NULL;
	gint _tmp7_;
	gint rc;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (RygelMediaExportDatabase*) g_object_new (object_type, NULL);
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "rygel", NULL);
	dirname = _tmp1_;
	g_mkdir_with_parents (dirname, 0750);
	_tmp2_ = g_strdup_printf ("%s.db", name);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_build_filename (dirname, _tmp3_, NULL);
	db_file = (_tmp5_ = _tmp4_, _g_free0 (_tmp3_), _tmp5_);
	g_debug ("rygel-media-export-database.vala:90: Using database file %s", db_file);
	_tmp7_ = sqlite3_open (db_file, &_tmp6_);
	_sqlite3_close0 (self->priv->db);
	self->priv->db = _tmp6_;
	rc = _tmp7_;
	if (rc != SQLITE_OK) {
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GError* _tmp10_ = NULL;
		_tmp8_ = _ ("Failed to open database: %d (%s)");
		_tmp9_ = sqlite3_errmsg (self->priv->db);
		_tmp10_ = g_error_new (RYGEL_MEDIA_EXPORT_DATABASE_ERROR, RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR, _tmp8_, rc, _tmp9_);
		_inner_error_ = _tmp10_;
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (db_file);
			_g_free0 (dirname);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (db_file);
			_g_free0 (dirname);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_sqlite3_exec (self->priv->db, "PRAGMA cache_size = 32768", NULL, NULL, NULL);
	_sqlite3_exec (self->priv->db, "PRAGMA synchronous = OFF", NULL, NULL, NULL);
	_sqlite3_exec (self->priv->db, "PRAGMA temp_store = MEMORY", NULL, NULL, NULL);
	_sqlite3_exec (self->priv->db, "PRAGMA count_changes = OFF", NULL, NULL, NULL);
	sqlite3_create_function (self->priv->db, "contains", 2, SQLITE_UTF8, NULL, _rygel_media_export_database_utf8_contains_sqlite_user_func_callback, NULL, NULL);
	sqlite3_create_collation (self->priv->db, "CASEFOLD", SQLITE_UTF8, NULL, (int (*)(void *, int,  const void *, int,  const void *)) _rygel_media_export_database_utf8_collate_sqlite_compare_callback);
	_g_free0 (db_file);
	_g_free0 (dirname);
	return self;
}


RygelMediaExportDatabase* rygel_media_export_database_new (const gchar* name, GError** error) {
	return rygel_media_export_database_construct (RYGEL_MEDIA_EXPORT_TYPE_DATABASE, name, error);
}


/**
     * Execute a cancellable SQL statement.
     *
     * The supplied values are bound to the SQL statement and the RowCallback
     * is called on every row of the resultset.
     *
     * @param sql statement to execute
     * @param values array of values to bind to the SQL statement or null if
     * none
     * @param callback to call on each row of the result set or null if none
     * necessary
     * @param cancellable to cancel the running query or null if none
     * necessary
     */
gint rygel_media_export_database_exec (RygelMediaExportDatabase* self, const gchar* sql, GValue* values, int values_length1, RygelMediaExportDatabaseRowCallback callback, void* callback_target, GCancellable* cancellable, GError** error) {
	gint result = 0;
	gint rc = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp8_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	if (values == NULL) {
		_tmp1_ = callback == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = cancellable == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp2_;
		_tmp2_ = _sqlite3_exec (self->priv->db, sql, NULL, NULL, NULL);
		rc = _tmp2_;
	} else {
		sqlite3_stmt* _tmp3_ = NULL;
		sqlite3_stmt* statement;
		_tmp3_ = rygel_media_export_database_prepare_statement (self, sql, values, values_length1, &_inner_error_);
		statement = _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		while (TRUE) {
			gint _tmp4_;
			gboolean _tmp5_ = FALSE;
			_tmp4_ = sqlite3_step (statement);
			rc = _tmp4_;
			if (!(rc == SQLITE_ROW)) {
				break;
			}
			if (cancellable != NULL) {
				gboolean _tmp6_;
				_tmp6_ = g_cancellable_is_cancelled (cancellable);
				_tmp5_ = _tmp6_;
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				break;
			}
			if (callback != NULL) {
				gboolean _tmp7_;
				_tmp7_ = callback (statement, callback_target);
				if (!_tmp7_) {
					rc = SQLITE_DONE;
					break;
				}
			}
		}
		_sqlite3_finalize0 (statement);
	}
	if (rc != SQLITE_DONE) {
		_tmp8_ = rc != SQLITE_OK;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		const gchar* _tmp9_ = NULL;
		GError* _tmp10_ = NULL;
		_tmp9_ = sqlite3_errmsg (self->priv->db);
		_tmp10_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_DATABASE_ERROR, RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR, _tmp9_);
		_inner_error_ = _tmp10_;
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = rc;
	return result;
}


/**
     * Analyze triggers of database
     */
void rygel_media_export_database_analyze (RygelMediaExportDatabase* self) {
	g_return_if_fail (self != NULL);
	_sqlite3_exec (self->priv->db, "ANALYZE", NULL, NULL, NULL);
}


/**
     * Special GValue to pass to exec or prepare_statement to bind a column to
     * NULL
     */
void rygel_media_export_database_null (GValue* result) {
	GValue v = {0};
	g_value_init (&v, G_TYPE_POINTER);
	g_value_set_pointer (&v, NULL);
	*result = v;
	return;
}


/**
     * Start a transaction
     */
void rygel_media_export_database_begin (RygelMediaExportDatabase* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	rygel_media_export_database_single_statement (self, "BEGIN", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
     * Commit a transaction
     */
void rygel_media_export_database_commit (RygelMediaExportDatabase* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	rygel_media_export_database_single_statement (self, "COMMIT", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
     * Rollback a transaction
     */
void rygel_media_export_database_rollback (RygelMediaExportDatabase* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	rygel_media_export_database_single_statement (self, "ROLLBACK", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch2_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	goto __finally2;
	__catch2_rygel_media_export_database_error:
	{
		GError * _error_;
		const gchar* _tmp0_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp0_ = _ ("Failed to roll back transaction: %s");
		g_critical (_tmp0_, _error_->message);
		_g_error_free0 (_error_);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
     * Execute a single SQL statement and throw an exception on error
     *
     * @param sql SQL statement to execute
     * @throws DatabaseError if SQL statement fails
     */
static void rygel_media_export_database_single_statement (RygelMediaExportDatabase* self, const gchar* sql, GError** error) {
	gint _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_tmp0_ = _sqlite3_exec (self->priv->db, sql, NULL, NULL, NULL);
	if (_tmp0_ != SQLITE_OK) {
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		_tmp1_ = sqlite3_errmsg (self->priv->db);
		_tmp2_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_DATABASE_ERROR, RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR, _tmp1_);
		_inner_error_ = _tmp2_;
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
     * Prepare a SQLite statement from a SQL string
     *
     * This function uses the type of the GValue passed in values to determine
     * which _bind function to use.
     *
     * Supported types are: int, long, int64, uint64, string and pointer.
     * @note the only pointer supported is the null pointer as provided by
     * Database.@null. This is a special value to bind a column to NULL
     *
     * @param sql statement to execute
     * @param values array of values to bind to the SQL statement or null if
     * none
     */
static sqlite3_stmt* rygel_media_export_database_prepare_statement (RygelMediaExportDatabase* self, const gchar* sql, GValue* values, int values_length1, GError** error) {
	sqlite3_stmt* result = NULL;
	sqlite3_stmt* statement;
	sqlite3_stmt* _tmp0_ = NULL;
	gint _tmp1_;
	gint rc;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sql != NULL, NULL);
	statement = NULL;
	_tmp1_ = sqlite3_prepare_v2 (self->priv->db, sql, -1, &_tmp0_, NULL);
	_sqlite3_finalize0 (statement);
	statement = _tmp0_;
	rc = _tmp1_;
	if (rc != SQLITE_OK) {
		const gchar* _tmp2_ = NULL;
		GError* _tmp3_ = NULL;
		_tmp2_ = sqlite3_errmsg (self->priv->db);
		_tmp3_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_DATABASE_ERROR, RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR, _tmp2_);
		_inner_error_ = _tmp3_;
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_sqlite3_finalize0 (statement);
			return NULL;
		} else {
			_sqlite3_finalize0 (statement);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (values != NULL) {
		{
			gint i;
			i = 0;
			{
				gboolean _tmp4_;
				_tmp4_ = TRUE;
				while (TRUE) {
					GValue _tmp5_;
					gboolean _tmp6_;
					if (!_tmp4_) {
						i++;
					}
					_tmp4_ = FALSE;
					if (!(i < values_length1)) {
						break;
					}
					_tmp6_ = G_VALUE_HOLDS ((_tmp5_ = values[i], &_tmp5_), G_TYPE_INT);
					if (_tmp6_) {
						GValue _tmp7_;
						gint _tmp8_;
						gint _tmp9_;
						_tmp8_ = g_value_get_int ((_tmp7_ = values[i], &_tmp7_));
						_tmp9_ = sqlite3_bind_int (statement, i + 1, _tmp8_);
						rc = _tmp9_;
					} else {
						GValue _tmp10_;
						gboolean _tmp11_;
						_tmp11_ = G_VALUE_HOLDS ((_tmp10_ = values[i], &_tmp10_), G_TYPE_INT64);
						if (_tmp11_) {
							GValue _tmp12_;
							gint64 _tmp13_;
							gint _tmp14_;
							_tmp13_ = g_value_get_int64 ((_tmp12_ = values[i], &_tmp12_));
							_tmp14_ = sqlite3_bind_int64 (statement, i + 1, _tmp13_);
							rc = _tmp14_;
						} else {
							GValue _tmp15_;
							gboolean _tmp16_;
							_tmp16_ = G_VALUE_HOLDS ((_tmp15_ = values[i], &_tmp15_), G_TYPE_UINT64);
							if (_tmp16_) {
								GValue _tmp17_;
								guint64 _tmp18_;
								gint _tmp19_;
								_tmp18_ = g_value_get_uint64 ((_tmp17_ = values[i], &_tmp17_));
								_tmp19_ = sqlite3_bind_int64 (statement, i + 1, (gint64) _tmp18_);
								rc = _tmp19_;
							} else {
								GValue _tmp20_;
								gboolean _tmp21_;
								_tmp21_ = G_VALUE_HOLDS ((_tmp20_ = values[i], &_tmp20_), G_TYPE_LONG);
								if (_tmp21_) {
									GValue _tmp22_;
									glong _tmp23_;
									gint _tmp24_;
									_tmp23_ = g_value_get_long ((_tmp22_ = values[i], &_tmp22_));
									_tmp24_ = sqlite3_bind_int64 (statement, i + 1, (gint64) _tmp23_);
									rc = _tmp24_;
								} else {
									GValue _tmp25_;
									gboolean _tmp26_;
									_tmp26_ = G_VALUE_HOLDS ((_tmp25_ = values[i], &_tmp25_), G_TYPE_STRING);
									if (_tmp26_) {
										GValue _tmp27_;
										const gchar* _tmp28_ = NULL;
										gchar* _tmp29_;
										gint _tmp30_;
										_tmp28_ = g_value_get_string ((_tmp27_ = values[i], &_tmp27_));
										_tmp29_ = g_strdup (_tmp28_);
										_tmp30_ = sqlite3_bind_text (statement, i + 1, _tmp29_, -1, g_free);
										rc = _tmp30_;
									} else {
										GValue _tmp31_;
										gboolean _tmp32_;
										_tmp32_ = G_VALUE_HOLDS ((_tmp31_ = values[i], &_tmp31_), G_TYPE_POINTER);
										if (_tmp32_) {
											GValue _tmp33_;
											void* _tmp34_ = NULL;
											_tmp34_ = g_value_peek_pointer ((_tmp33_ = values[i], &_tmp33_));
											if (_tmp34_ == NULL) {
												gint _tmp35_;
												_tmp35_ = sqlite3_bind_null (statement, i + 1);
												rc = _tmp35_;
											} else {
												g_assert_not_reached ();
											}
										} else {
											GValue _tmp36_;
											GType _tmp37_;
											GType t;
											const gchar* _tmp38_ = NULL;
											const gchar* _tmp39_ = NULL;
											_tmp37_ = G_VALUE_TYPE ((_tmp36_ = values[i], &_tmp36_));
											t = _tmp37_;
											_tmp38_ = _ ("Unsupported type %s");
											_tmp39_ = g_type_name (t);
											g_warning (_tmp38_, _tmp39_);
											g_assert_not_reached ();
										}
									}
								}
							}
						}
					}
					if (rc != SQLITE_OK) {
						const gchar* _tmp40_ = NULL;
						GError* _tmp41_ = NULL;
						_tmp40_ = sqlite3_errmsg (self->priv->db);
						_tmp41_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_DATABASE_ERROR, RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR, _tmp40_);
						_inner_error_ = _tmp41_;
						if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_sqlite3_finalize0 (statement);
							return NULL;
						} else {
							_sqlite3_finalize0 (statement);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
				}
			}
		}
	}
	result = statement;
	return result;
}


static void rygel_media_export_database_class_init (RygelMediaExportDatabaseClass * klass) {
	rygel_media_export_database_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportDatabasePrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_database_finalize;
}


static void rygel_media_export_database_instance_init (RygelMediaExportDatabase * self) {
	self->priv = RYGEL_MEDIA_EXPORT_DATABASE_GET_PRIVATE (self);
}


static void rygel_media_export_database_finalize (GObject* obj) {
	RygelMediaExportDatabase * self;
	self = RYGEL_MEDIA_EXPORT_DATABASE (obj);
	_sqlite3_close0 (self->priv->db);
	G_OBJECT_CLASS (rygel_media_export_database_parent_class)->finalize (obj);
}


/**
 * This class is a thin wrapper around SQLite's database object.
 *
 * It adds statement preparation based on GValue and a cancellable exec
 * function.
 */
GType rygel_media_export_database_get_type (void) {
	static volatile gsize rygel_media_export_database_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_database_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportDatabaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_database_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportDatabase), 0, (GInstanceInitFunc) rygel_media_export_database_instance_init, NULL };
		GType rygel_media_export_database_type_id;
		rygel_media_export_database_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportDatabase", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_database_type_id__volatile, rygel_media_export_database_type_id);
	}
	return rygel_media_export_database_type_id__volatile;
}



