/* rygel-user-config.c generated by valac 0.11.2, the Vala compiler
 * generated from rygel-user-config.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Nokia Corporation.
 * Copyright (C) 2008,2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <config.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>


#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;

#define RYGEL_TYPE_LOG_LEVEL (rygel_log_level_get_type ())

#define RYGEL_TYPE_USER_CONFIG (rygel_user_config_get_type ())
#define RYGEL_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_USER_CONFIG, RygelUserConfig))
#define RYGEL_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_USER_CONFIG, RygelUserConfigClass))
#define RYGEL_IS_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_USER_CONFIG))
#define RYGEL_IS_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_USER_CONFIG))
#define RYGEL_USER_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_USER_CONFIG, RygelUserConfigClass))

typedef struct _RygelUserConfig RygelUserConfig;
typedef struct _RygelUserConfigClass RygelUserConfigClass;
typedef struct _RygelUserConfigPrivate RygelUserConfigPrivate;
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define FREE_DESKTOP_TYPE_DBUS_OBJECT (free_desktop_dbus_object_get_type ())
#define FREE_DESKTOP_DBUS_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FREE_DESKTOP_TYPE_DBUS_OBJECT, FreeDesktopDBusObject))
#define FREE_DESKTOP_IS_DBUS_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FREE_DESKTOP_TYPE_DBUS_OBJECT))
#define FREE_DESKTOP_DBUS_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FREE_DESKTOP_TYPE_DBUS_OBJECT, FreeDesktopDBusObjectIface))

typedef struct _FreeDesktopDBusObject FreeDesktopDBusObject;
typedef struct _FreeDesktopDBusObjectIface FreeDesktopDBusObjectIface;

#define FREE_DESKTOP_TYPE_DBUS_OBJECT_PROXY (free_desktop_dbus_object_proxy_get_type ())

#define RYGEL_TYPE_DBUS_INTERFACE (rygel_dbus_interface_get_type ())
#define RYGEL_DBUS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DBUS_INTERFACE, RygelDBusInterface))
#define RYGEL_IS_DBUS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DBUS_INTERFACE))
#define RYGEL_DBUS_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DBUS_INTERFACE, RygelDBusInterfaceIface))

typedef struct _RygelDBusInterface RygelDBusInterface;
typedef struct _RygelDBusInterfaceIface RygelDBusInterfaceIface;

#define RYGEL_TYPE_DBUS_INTERFACE_PROXY (rygel_dbus_interface_proxy_get_type ())

typedef enum  {
	RYGEL_LOG_LEVEL_INVALID = 0,
	RYGEL_LOG_LEVEL_CRITICAL = 1,
	RYGEL_LOG_LEVEL_ERROR = 2,
	RYGEL_LOG_LEVEL_WARNING = 3,
	RYGEL_LOG_LEVEL_INFO = 4,
	RYGEL_LOG_LEVEL_DEFAULT = 4,
	RYGEL_LOG_LEVEL_DEBUG = 5
} RygelLogLevel;

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp3_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp2ts_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_lpcm_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_wmv_transcoder) (RygelConfiguration* self, GError** error);
	RygelLogLevel (*get_log_level) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelUserConfig {
	GObject parent_instance;
	RygelUserConfigPrivate * priv;
	GKeyFile* key_file;
};

struct _RygelUserConfigClass {
	GObjectClass parent_class;
};

struct _RygelUserConfigPrivate {
	gboolean read_only;
};

typedef enum  {
	RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET,
	RYGEL_CONFIGURATION_ERROR_VALUE_OUT_OF_RANGE
} RygelConfigurationError;
#define RYGEL_CONFIGURATION_ERROR rygel_configuration_error_quark ()
struct _FreeDesktopDBusObjectIface {
	GTypeInterface parent_iface;
	guint32 (*request_name) (FreeDesktopDBusObject* self, const gchar* name, guint32 flags, GError** error);
	guint32 (*start_service_by_name) (FreeDesktopDBusObject* self, const gchar* name, guint32 flags, GError** error);
	void (*list_names) (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*list_names_finish) (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
	void (*list_activatable_names) (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*list_activatable_names_finish) (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
};

struct _RygelDBusInterfaceIface {
	GTypeInterface parent_iface;
	void (*shutdown) (RygelDBusInterface* self, GError** error);
};


static gpointer rygel_user_config_parent_class = NULL;
static RygelUserConfig* rygel_user_config_config;
static RygelUserConfig* rygel_user_config_config = NULL;
static RygelConfigurationIface* rygel_user_config_rygel_configuration_parent_iface = NULL;

GType rygel_log_level_get_type (void) G_GNUC_CONST;
GType rygel_configuration_get_type (void) G_GNUC_CONST;
GType rygel_user_config_get_type (void) G_GNUC_CONST;
#define RYGEL_USER_CONFIG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_USER_CONFIG, RygelUserConfigPrivate))
enum  {
	RYGEL_USER_CONFIG_DUMMY_PROPERTY
};
#define RYGEL_USER_CONFIG_CONFIG_FILE "rygel.conf"
#define RYGEL_USER_CONFIG_IFACE_KEY "interface"
#define RYGEL_USER_CONFIG_PORT_KEY "port"
#define RYGEL_USER_CONFIG_ENABLED_KEY "enabled"
#define RYGEL_USER_CONFIG_TITLE_KEY "title"
#define RYGEL_USER_CONFIG_TRANSCODING_KEY "enable-transcoding"
#define RYGEL_USER_CONFIG_MP3_TRANSCODER_KEY "enable-mp3-transcoder"
#define RYGEL_USER_CONFIG_MP2TS_TRANSCODER_KEY "enable-mp2ts-transcoder"
#define RYGEL_USER_CONFIG_LPCM_TRANSCODER_KEY "enable-lpcm-transcoder"
#define RYGEL_USER_CONFIG_WMV_TRANSCODER_KEY "enable-wmv-transcoder"
#define RYGEL_USER_CONFIG_LOG_LEVEL_KEY "log-level"
#define RYGEL_USER_CONFIG_PLUGIN_PATH_KEY "plugin-path"
#define RYGEL_USER_CONFIG_RYGEL_SERVICE "org.gnome.Rygel1"
#define RYGEL_USER_CONFIG_RYGEL_PATH "/org/gnome/Rygel1"
#define RYGEL_USER_CONFIG_RYGEL_INTERFACE "org.gnome.Rygel1"
static gboolean rygel_user_config_real_get_upnp_enabled (RygelConfiguration* base, GError** error);
gboolean rygel_configuration_get_bool (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
void rygel_user_config_set_upnp_enabled (RygelUserConfig* self, gboolean value);
gboolean rygel_configuration_get_upnp_enabled (RygelConfiguration* self, GError** error);
static void rygel_user_config_enable_upnp (RygelUserConfig* self, gboolean enable);
static gchar* rygel_user_config_real_get_interface (RygelConfiguration* base, GError** error);
gchar* rygel_configuration_get_string (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
void rygel_user_config_set_interface (RygelUserConfig* self, const gchar* value);
void rygel_user_config_set_string (RygelUserConfig* self, const gchar* section, const gchar* key, const gchar* value);
static gint rygel_user_config_real_get_port (RygelConfiguration* base, GError** error);
gint rygel_configuration_get_int (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
void rygel_user_config_set_port (RygelUserConfig* self, gint value);
void rygel_user_config_set_int (RygelUserConfig* self, const gchar* section, const gchar* key, gint value);
static gboolean rygel_user_config_real_get_transcoding (RygelConfiguration* base, GError** error);
void rygel_user_config_set_transcoding (RygelUserConfig* self, gboolean value);
void rygel_user_config_set_bool (RygelUserConfig* self, const gchar* section, const gchar* key, gboolean value);
static gboolean rygel_user_config_real_get_mp3_transcoder (RygelConfiguration* base, GError** error);
void rygel_user_config_set_mp3_transcoder (RygelUserConfig* self, gboolean value);
static gboolean rygel_user_config_real_get_mp2ts_transcoder (RygelConfiguration* base, GError** error);
void rygel_user_config_set_mp2ts_transcoder (RygelUserConfig* self, gboolean value);
static gboolean rygel_user_config_real_get_lpcm_transcoder (RygelConfiguration* base, GError** error);
void rygel_user_config_set_lpcm_transcoder (RygelUserConfig* self, gboolean value);
static gboolean rygel_user_config_real_get_wmv_transcoder (RygelConfiguration* base, GError** error);
void rygel_user_config_set_wmv_transcoder (RygelUserConfig* self, gboolean value);
static RygelLogLevel rygel_user_config_real_get_log_level (RygelConfiguration* base, GError** error);
static gchar* rygel_user_config_real_get_plugin_path (RygelConfiguration* base, GError** error);
RygelUserConfig* rygel_user_config_get_default (GError** error);
RygelUserConfig* rygel_user_config_new (gboolean read_only, GError** error);
RygelUserConfig* rygel_user_config_construct (GType object_type, gboolean read_only, GError** error);
void rygel_user_config_save (RygelUserConfig* self);
static gboolean rygel_user_config_real_get_enabled (RygelConfiguration* base, const gchar* section, GError** error);
static gchar* rygel_user_config_real_get_title (RygelConfiguration* base, const gchar* section, GError** error);
static gchar* rygel_user_config_real_get_string (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
GQuark rygel_configuration_error_quark (void);
static GeeArrayList* rygel_user_config_real_get_string_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static gint rygel_user_config_real_get_int (RygelConfiguration* base, const gchar* section, const gchar* key, gint min, gint max, GError** error);
static GeeArrayList* rygel_user_config_real_get_int_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static gboolean rygel_user_config_real_get_bool (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
void rygel_user_config_set_string_list (RygelUserConfig* self, const gchar* section, const gchar* key, GeeArrayList* str_list);
static void rygel_user_config_ensure_dir_exists (RygelUserConfig* self, const gchar* dir_path, GError** error);
#define FREE_DESKTOP_DBUS_SERVICE "org.freedesktop.DBus"
#define FREE_DESKTOP_DBUS_OBJECT "/org/freedesktop/DBus"
GType free_desktop_dbus_object_proxy_get_type (void) G_GNUC_CONST;
guint free_desktop_dbus_object_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType free_desktop_dbus_object_get_type (void) G_GNUC_CONST;
guint32 free_desktop_dbus_object_start_service_by_name (FreeDesktopDBusObject* self, const gchar* name, guint32 flags, GError** error);
#define RYGEL_DBUS_INTERFACE_SERVICE_NAME "org.gnome.Rygel1"
gboolean rygel_configuration_get_enabled (RygelConfiguration* self, const gchar* section, GError** error);
#define RYGEL_DBUS_INTERFACE_OBJECT_PATH "/org/gnome/Rygel1"
GType rygel_dbus_interface_proxy_get_type (void) G_GNUC_CONST;
guint rygel_dbus_interface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType rygel_dbus_interface_get_type (void) G_GNUC_CONST;
void rygel_dbus_interface_shutdown (RygelDBusInterface* self, GError** error);
static void rygel_user_config_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gboolean rygel_user_config_real_get_upnp_enabled (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_ENABLED_KEY, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp1_;
	return result;
}


void rygel_user_config_set_upnp_enabled (RygelUserConfig* self, gboolean value) {
	gboolean enabled;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	enabled = FALSE;
	_tmp0_ = rygel_configuration_get_upnp_enabled ((RygelConfiguration*) self, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	enabled = _tmp1_;
	goto __finally0;
	__catch0_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	if (value != enabled) {
		rygel_user_config_enable_upnp (self, value);
	}
}


static gchar* rygel_user_config_real_get_interface (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp0_ = rygel_configuration_get_string ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_IFACE_KEY, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp1_;
	return result;
}


void rygel_user_config_set_interface (RygelUserConfig* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	rygel_user_config_set_string (self, "general", RYGEL_USER_CONFIG_IFACE_KEY, value);
}


static gint rygel_user_config_real_get_port (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp0_ = rygel_configuration_get_int ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_PORT_KEY, (gint) 0U, (gint) G_MAXUINT16, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	result = _tmp1_;
	return result;
}


void rygel_user_config_set_port (RygelUserConfig* self, gint value) {
	g_return_if_fail (self != NULL);
	rygel_user_config_set_int (self, "general", RYGEL_USER_CONFIG_PORT_KEY, value);
}


static gboolean rygel_user_config_real_get_transcoding (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_TRANSCODING_KEY, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp1_;
	return result;
}


void rygel_user_config_set_transcoding (RygelUserConfig* self, gboolean value) {
	g_return_if_fail (self != NULL);
	rygel_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_TRANSCODING_KEY, value);
}


static gboolean rygel_user_config_real_get_mp3_transcoder (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_MP3_TRANSCODER_KEY, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp1_;
	return result;
}


void rygel_user_config_set_mp3_transcoder (RygelUserConfig* self, gboolean value) {
	g_return_if_fail (self != NULL);
	rygel_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_MP3_TRANSCODER_KEY, value);
}


static gboolean rygel_user_config_real_get_mp2ts_transcoder (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_MP2TS_TRANSCODER_KEY, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp1_;
	return result;
}


void rygel_user_config_set_mp2ts_transcoder (RygelUserConfig* self, gboolean value) {
	g_return_if_fail (self != NULL);
	rygel_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_MP2TS_TRANSCODER_KEY, value);
}


static gboolean rygel_user_config_real_get_lpcm_transcoder (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_LPCM_TRANSCODER_KEY, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp1_;
	return result;
}


void rygel_user_config_set_lpcm_transcoder (RygelUserConfig* self, gboolean value) {
	g_return_if_fail (self != NULL);
	rygel_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_LPCM_TRANSCODER_KEY, value);
}


static gboolean rygel_user_config_real_get_wmv_transcoder (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_WMV_TRANSCODER_KEY, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp1_;
	return result;
}


void rygel_user_config_set_wmv_transcoder (RygelUserConfig* self, gboolean value) {
	g_return_if_fail (self != NULL);
	rygel_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_WMV_TRANSCODER_KEY, value);
}


static RygelLogLevel rygel_user_config_real_get_log_level (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	RygelLogLevel result = 0;
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp0_ = rygel_configuration_get_int ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_LOG_LEVEL_KEY, (gint) RYGEL_LOG_LEVEL_INVALID, (gint) RYGEL_LOG_LEVEL_DEBUG, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	result = (RygelLogLevel) _tmp1_;
	return result;
}


static gchar* rygel_user_config_real_get_plugin_path (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp0_ = rygel_configuration_get_string ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_PLUGIN_PATH_KEY, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp1_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelUserConfig* rygel_user_config_get_default (GError** error) {
	RygelUserConfig* result = NULL;
	RygelUserConfig* _tmp3_;
	GError * _inner_error_ = NULL;
	if (rygel_user_config_config == NULL) {
		RygelUserConfig* _tmp0_ = NULL;
		RygelUserConfig* _tmp1_;
		RygelUserConfig* _tmp2_;
		_tmp0_ = rygel_user_config_new (TRUE, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		_tmp2_ = _tmp1_;
		_g_object_unref0 (rygel_user_config_config);
		rygel_user_config_config = _tmp2_;
	}
	_tmp3_ = _g_object_ref0 (rygel_user_config_config);
	result = _tmp3_;
	return result;
}


RygelUserConfig* rygel_user_config_construct (GType object_type, gboolean read_only, GError** error) {
	RygelUserConfig * self = NULL;
	GKeyFile* _tmp0_ = NULL;
	GKeyFile* _tmp1_;
	gchar** _tmp2_ = NULL;
	gint dirs_length1;
	gint _dirs_size_;
	gchar** _tmp3_;
	gchar** dirs;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* path;
	gchar* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) g_object_new (object_type, NULL);
	self->priv->read_only = read_only;
	_tmp0_ = g_key_file_new ();
	_tmp1_ = _tmp0_;
	_g_key_file_free0 (self->key_file);
	self->key_file = _tmp1_;
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp3_ = _tmp2_;
	dirs_length1 = 2;
	_dirs_size_ = dirs_length1;
	dirs = _tmp3_;
	_tmp4_ = g_get_user_config_dir ();
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (dirs[0]);
	dirs[0] = _tmp6_;
	_tmp7_ = g_strdup (SYS_CONFIG_DIR);
	_tmp8_ = _tmp7_;
	_g_free0 (dirs[1]);
	dirs[1] = _tmp8_;
	path = NULL;
	g_key_file_load_from_dirs (self->key_file, RYGEL_USER_CONFIG_CONFIG_FILE, dirs, &_tmp9_, G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error_);
	_g_free0 (path);
	path = _tmp9_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (path);
		dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		return NULL;
	}
	g_debug ("rygel-user-config.vala:159: Loaded user configuration from file '%s'", path);
	_g_free0 (path);
	dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


RygelUserConfig* rygel_user_config_new (gboolean read_only, GError** error) {
	return rygel_user_config_construct (RYGEL_TYPE_USER_CONFIG, read_only, error);
}


void rygel_user_config_save (RygelUserConfig* self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* path;
	gsize length = 0UL;
	gsize _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* data;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (!self->priv->read_only);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_build_filename (_tmp0_, RYGEL_USER_CONFIG_CONFIG_FILE, NULL);
	path = _tmp1_;
	_tmp3_ = g_key_file_to_data (self->key_file, &_tmp2_, NULL);
	length = _tmp2_;
	data = _tmp3_;
	g_file_set_contents (path, data, (gssize) ((glong) length), &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_FILE_ERROR) {
			goto __catch1_g_file_error;
		}
		_g_free0 (data);
		_g_free0 (path);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	goto __finally1;
	__catch1_g_file_error:
	{
		GError * err;
		const gchar* _tmp4_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = _ ("Failed to save configuration data to file '%s': %s");
		g_critical (_tmp4_, path, err->message);
		_g_error_free0 (err);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_free0 (data);
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (data);
	_g_free0 (path);
}


static gboolean rygel_user_config_real_get_enabled (RygelConfiguration* base, const gchar* section, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	g_return_val_if_fail (section != NULL, FALSE);
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, section, RYGEL_USER_CONFIG_ENABLED_KEY, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp1_;
	return result;
}


static gchar* rygel_user_config_real_get_title (RygelConfiguration* base, const gchar* section, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	_tmp0_ = rygel_configuration_get_string ((RygelConfiguration*) self, section, RYGEL_USER_CONFIG_TITLE_KEY, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp1_;
	return result;
}


static gchar* rygel_user_config_real_get_string (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* val;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = g_key_file_get_string (self->key_file, section, key, &_inner_error_);
	val = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	if (val == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_strcmp0 (val, "") == 0;
	}
	if (_tmp1_) {
		const gchar* _tmp2_ = NULL;
		GError* _tmp3_ = NULL;
		_tmp2_ = _ ("No value available for '%s'");
		_tmp3_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp2_, key);
		_inner_error_ = _tmp3_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (val);
		return NULL;
	}
	result = val;
	return result;
}


static GeeArrayList* rygel_user_config_real_get_string_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelUserConfig * self;
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* str_list;
	gsize _tmp1_;
	gchar** _tmp2_ = NULL;
	gint strings_length1;
	gint _strings_size_;
	gchar** _tmp3_;
	gchar** strings;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	str_list = _tmp0_;
	_tmp2_ = g_key_file_get_string_list (self->key_file, section, key, &_tmp1_, &_inner_error_);
	_tmp3_ = _tmp2_;
	strings_length1 = _tmp1_;
	_strings_size_ = strings_length1;
	strings = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (str_list);
		return NULL;
	}
	{
		gchar** str_collection;
		int str_collection_length1;
		int str_it;
		str_collection = strings;
		str_collection_length1 = strings_length1;
		for (str_it = 0; str_it < strings_length1; str_it = str_it + 1) {
			gchar* _tmp4_;
			gchar* str;
			_tmp4_ = g_strdup (str_collection[str_it]);
			str = _tmp4_;
			{
				gee_abstract_collection_add ((GeeAbstractCollection*) str_list, str);
				_g_free0 (str);
			}
		}
	}
	result = str_list;
	strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gint rygel_user_config_real_get_int (RygelConfiguration* base, const gchar* section, const gchar* key, gint min, gint max, GError** error) {
	RygelUserConfig * self;
	gint result = 0;
	gint _tmp0_;
	gint val;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	g_return_val_if_fail (section != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	_tmp0_ = g_key_file_get_integer (self->key_file, section, key, &_inner_error_);
	val = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	if (val == 0) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = val < min;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = val > max;
	}
	if (_tmp1_) {
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		_tmp3_ = _ ("Value of '%s' out of range");
		_tmp4_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_VALUE_OUT_OF_RANGE, _tmp3_, key);
		_inner_error_ = _tmp4_;
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	result = val;
	return result;
}


static GeeArrayList* rygel_user_config_real_get_int_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelUserConfig * self;
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* int_list;
	gsize _tmp1_;
	gint* _tmp2_ = NULL;
	gint ints_length1;
	gint _ints_size_;
	gint* _tmp3_;
	gint* ints;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL);
	int_list = _tmp0_;
	_tmp2_ = g_key_file_get_integer_list (self->key_file, section, key, &_tmp1_, &_inner_error_);
	_tmp3_ = _tmp2_;
	ints_length1 = _tmp1_;
	_ints_size_ = ints_length1;
	ints = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (int_list);
		return NULL;
	}
	{
		gint* num_collection;
		int num_collection_length1;
		int num_it;
		num_collection = ints;
		num_collection_length1 = ints_length1;
		for (num_it = 0; num_it < ints_length1; num_it = num_it + 1) {
			gint num;
			num = num_collection[num_it];
			{
				gee_abstract_collection_add ((GeeAbstractCollection*) int_list, GINT_TO_POINTER (num));
			}
		}
	}
	result = int_list;
	ints = (g_free (ints), NULL);
	return result;
}


static gboolean rygel_user_config_real_get_bool (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	g_return_val_if_fail (section != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = g_key_file_get_boolean (self->key_file, section, key, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp1_;
	return result;
}


void rygel_user_config_set_string (RygelUserConfig* self, const gchar* section, const gchar* key, const gchar* value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	g_key_file_set_string (self->key_file, section, key, value);
}


void rygel_user_config_set_string_list (RygelUserConfig* self, const gchar* section, const gchar* key, GeeArrayList* str_list) {
	gint _tmp0_;
	gchar** _tmp1_ = NULL;
	gint strings_length1;
	gint _strings_size_;
	gchar** _tmp2_;
	gchar** strings;
	gint i;
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (str_list != NULL);
	_tmp0_ = gee_collection_get_size ((GeeCollection*) str_list);
	_tmp1_ = g_new0 (gchar*, _tmp0_ + 1);
	_tmp2_ = _tmp1_;
	strings_length1 = _tmp0_;
	_strings_size_ = strings_length1;
	strings = _tmp2_;
	i = 0;
	{
		GeeArrayList* _tmp3_;
		GeeArrayList* _str_list;
		gint _tmp4_;
		gint _str_size;
		gint _str_index;
		_tmp3_ = _g_object_ref0 (str_list);
		_str_list = _tmp3_;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _str_list);
		_str_size = _tmp4_;
		_str_index = -1;
		while (TRUE) {
			gpointer _tmp5_ = NULL;
			gchar* str;
			_str_index = _str_index + 1;
			if (!(_str_index < _str_size)) {
				break;
			}
			_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _str_list, _str_index);
			str = (gchar*) _tmp5_;
			if (g_strcmp0 (str, "") != 0) {
				gchar* _tmp6_;
				gchar* *_tmp7_;
				gchar* _tmp8_;
				_tmp6_ = g_strdup (str);
				_tmp7_ = &strings[i++];
				_tmp8_ = _tmp6_;
				_g_free0 ((*_tmp7_));
				(*_tmp7_) = _tmp8_;
			}
			_g_free0 (str);
		}
		_g_object_unref0 (_str_list);
	}
	g_key_file_set_string_list (self->key_file, section, key, (const gchar* const*) strings, strings_length1);
	strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
}


void rygel_user_config_set_int (RygelUserConfig* self, const gchar* section, const gchar* key, gint value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	g_return_if_fail (key != NULL);
	g_key_file_set_integer (self->key_file, section, key, value);
}


void rygel_user_config_set_bool (RygelUserConfig* self, const gchar* section, const gchar* key, gboolean value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	g_return_if_fail (key != NULL);
	g_key_file_set_boolean (self->key_file, section, key, value);
}


static void rygel_user_config_enable_upnp (RygelUserConfig* self, gboolean enable) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* config_dir;
	gchar* _tmp2_ = NULL;
	gchar* dest_dir;
	gchar* _tmp3_ = NULL;
	gchar* dest_path;
	GFile* _tmp4_ = NULL;
	GFile* dest;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	config_dir = _tmp1_;
	rygel_user_config_ensure_dir_exists (self, config_dir, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (config_dir);
		goto __catch2_g_error;
	}
	_tmp2_ = g_build_filename (config_dir, "autostart", NULL);
	dest_dir = _tmp2_;
	rygel_user_config_ensure_dir_exists (self, dest_dir, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (dest_dir);
		_g_free0 (config_dir);
		goto __catch2_g_error;
	}
	_tmp3_ = g_build_filename (dest_dir, "rygel.desktop", NULL);
	dest_path = _tmp3_;
	_tmp4_ = g_file_new_for_path (dest_path);
	dest = _tmp4_;
	if (enable) {
		FreeDesktopDBusObject* dbus;
		gchar* _tmp5_ = NULL;
		gchar* source_path;
		dbus = (FreeDesktopDBusObject*) g_initable_new (FREE_DESKTOP_TYPE_DBUS_OBJECT_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", FREE_DESKTOP_DBUS_SERVICE, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", FREE_DESKTOP_DBUS_OBJECT, "g-interface-name", "org.freedesktop.DBus", NULL);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dest);
			_g_free0 (dest_path);
			_g_free0 (dest_dir);
			_g_free0 (config_dir);
			goto __catch2_g_error;
		}
		free_desktop_dbus_object_start_service_by_name (dbus, RYGEL_DBUS_INTERFACE_SERVICE_NAME, (guint32) 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dbus);
			_g_object_unref0 (dest);
			_g_free0 (dest_path);
			_g_free0 (dest_dir);
			_g_free0 (config_dir);
			goto __catch2_g_error;
		}
		_tmp5_ = g_build_filename (DESKTOP_DIR, "rygel.desktop", NULL);
		source_path = _tmp5_;
		g_file_make_symbolic_link (dest, source_path, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
				goto __catch3_g_io_error_exists;
			}
			goto __finally3;
		}
		goto __finally3;
		__catch3_g_io_error_exists:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (err);
		}
		__finally3:
		if (_inner_error_ != NULL) {
			_g_free0 (source_path);
			_g_object_unref0 (dbus);
			_g_object_unref0 (dest);
			_g_free0 (dest_path);
			_g_free0 (dest_dir);
			_g_free0 (config_dir);
			goto __catch2_g_error;
		}
		rygel_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_ENABLED_KEY, TRUE);
		_g_free0 (source_path);
		_g_object_unref0 (dbus);
	} else {
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = rygel_configuration_get_enabled ((RygelConfiguration*) self, "general", &_inner_error_);
		_tmp7_ = _tmp6_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dest);
			_g_free0 (dest_path);
			_g_free0 (dest_dir);
			_g_free0 (config_dir);
			goto __catch2_g_error;
		}
		if (_tmp7_) {
			RygelDBusInterface* rygel_proxy;
			rygel_proxy = (RygelDBusInterface*) g_initable_new (RYGEL_TYPE_DBUS_INTERFACE_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", RYGEL_DBUS_INTERFACE_SERVICE_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", RYGEL_DBUS_INTERFACE_OBJECT_PATH, "g-interface-name", "org.gnome.Rygel1", NULL);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (dest);
				_g_free0 (dest_path);
				_g_free0 (dest_dir);
				_g_free0 (config_dir);
				goto __catch2_g_error;
			}
			rygel_dbus_interface_shutdown (rygel_proxy, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (rygel_proxy);
				_g_object_unref0 (dest);
				_g_free0 (dest_path);
				_g_free0 (dest_dir);
				_g_free0 (config_dir);
				goto __catch2_g_error;
			}
			_g_object_unref0 (rygel_proxy);
		}
		g_file_delete (dest, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
				goto __catch4_g_io_error_not_found;
			}
			goto __finally4;
		}
		goto __finally4;
		__catch4_g_io_error_not_found:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (err);
		}
		__finally4:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dest);
			_g_free0 (dest_path);
			_g_free0 (dest_dir);
			_g_free0 (config_dir);
			goto __catch2_g_error;
		}
		rygel_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_ENABLED_KEY, FALSE);
	}
	_g_object_unref0 (dest);
	_g_free0 (dest_path);
	_g_free0 (dest_dir);
	_g_free0 (config_dir);
	goto __finally2;
	__catch2_g_error:
	{
		GError * err;
		gchar* message;
		err = _inner_error_;
		_inner_error_ = NULL;
		message = NULL;
		if (enable) {
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp8_ = _ ("Failed to start Rygel service: %s");
			_tmp9_ = g_strdup (_tmp8_);
			_tmp10_ = _tmp9_;
			_g_free0 (message);
			message = _tmp10_;
		} else {
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp11_ = _ ("Failed to stop Rygel service: %s");
			_tmp12_ = g_strdup (_tmp11_);
			_tmp13_ = _tmp12_;
			_g_free0 (message);
			message = _tmp13_;
		}
		g_warning (message, err->message);
		_g_free0 (message);
		_g_error_free0 (err);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_user_config_ensure_dir_exists (RygelUserConfig* self, const gchar* dir_path, GError** error) {
	GFile* _tmp0_ = NULL;
	GFile* dir;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir_path != NULL);
	_tmp0_ = g_file_new_for_path (dir_path);
	dir = _tmp0_;
	g_file_make_directory (dir, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
			goto __catch5_g_io_error_exists;
		}
		goto __finally5;
	}
	goto __finally5;
	__catch5_g_io_error_exists:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (dir);
		return;
	}
	_g_object_unref0 (dir);
}


static void rygel_user_config_class_init (RygelUserConfigClass * klass) {
	rygel_user_config_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelUserConfigPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_user_config_finalize;
}


static void rygel_user_config_rygel_configuration_interface_init (RygelConfigurationIface * iface) {
	rygel_user_config_rygel_configuration_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_upnp_enabled = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_user_config_real_get_upnp_enabled;
	iface->get_interface = (gchar* (*)(RygelConfiguration* ,GError**)) rygel_user_config_real_get_interface;
	iface->get_port = (gint (*)(RygelConfiguration* ,GError**)) rygel_user_config_real_get_port;
	iface->get_transcoding = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_user_config_real_get_transcoding;
	iface->get_mp3_transcoder = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_user_config_real_get_mp3_transcoder;
	iface->get_mp2ts_transcoder = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_user_config_real_get_mp2ts_transcoder;
	iface->get_lpcm_transcoder = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_user_config_real_get_lpcm_transcoder;
	iface->get_wmv_transcoder = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_user_config_real_get_wmv_transcoder;
	iface->get_log_level = (RygelLogLevel (*)(RygelConfiguration* ,GError**)) rygel_user_config_real_get_log_level;
	iface->get_plugin_path = (gchar* (*)(RygelConfiguration* ,GError**)) rygel_user_config_real_get_plugin_path;
	iface->get_enabled = (gboolean (*)(RygelConfiguration* ,const gchar* ,GError**)) rygel_user_config_real_get_enabled;
	iface->get_title = (gchar* (*)(RygelConfiguration* ,const gchar* ,GError**)) rygel_user_config_real_get_title;
	iface->get_string = (gchar* (*)(RygelConfiguration* ,const gchar* ,const gchar* ,GError**)) rygel_user_config_real_get_string;
	iface->get_string_list = (GeeArrayList* (*)(RygelConfiguration* ,const gchar* ,const gchar* ,GError**)) rygel_user_config_real_get_string_list;
	iface->get_int = (gint (*)(RygelConfiguration* ,const gchar* ,const gchar* ,gint ,gint ,GError**)) rygel_user_config_real_get_int;
	iface->get_int_list = (GeeArrayList* (*)(RygelConfiguration* ,const gchar* ,const gchar* ,GError**)) rygel_user_config_real_get_int_list;
	iface->get_bool = (gboolean (*)(RygelConfiguration* ,const gchar* ,const gchar* ,GError**)) rygel_user_config_real_get_bool;
}


static void rygel_user_config_instance_init (RygelUserConfig * self) {
	self->priv = RYGEL_USER_CONFIG_GET_PRIVATE (self);
}


static void rygel_user_config_finalize (GObject* obj) {
	RygelUserConfig * self;
	self = RYGEL_USER_CONFIG (obj);
	_g_key_file_free0 (self->key_file);
	G_OBJECT_CLASS (rygel_user_config_parent_class)->finalize (obj);
}


/**
 * Manages the user configuration for Rygel.
 */
GType rygel_user_config_get_type (void) {
	static volatile gsize rygel_user_config_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_user_config_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelUserConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_user_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelUserConfig), 0, (GInstanceInitFunc) rygel_user_config_instance_init, NULL };
		static const GInterfaceInfo rygel_configuration_info = { (GInterfaceInitFunc) rygel_user_config_rygel_configuration_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_user_config_type_id;
		rygel_user_config_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelUserConfig", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_user_config_type_id, RYGEL_TYPE_CONFIGURATION, &rygel_configuration_info);
		g_once_init_leave (&rygel_user_config_type_id__volatile, rygel_user_config_type_id);
	}
	return rygel_user_config_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



