/* rygel-item-destroyer.c generated by valac 0.11.2, the Vala compiler
 * generated from rygel-item-destroyer.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <glib/gi18n-lib.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_ITEM_DESTROYER (rygel_item_destroyer_get_type ())
#define RYGEL_ITEM_DESTROYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyer))
#define RYGEL_ITEM_DESTROYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyerClass))
#define RYGEL_IS_ITEM_DESTROYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_DESTROYER))
#define RYGEL_IS_ITEM_DESTROYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_DESTROYER))
#define RYGEL_ITEM_DESTROYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyerClass))

typedef struct _RygelItemDestroyer RygelItemDestroyer;
typedef struct _RygelItemDestroyerClass RygelItemDestroyerClass;
typedef struct _RygelItemDestroyerPrivate RygelItemDestroyerPrivate;

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelItemDestroyerRunData RygelItemDestroyerRunData;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_WRITABLE_CONTAINER (rygel_writable_container_get_type ())
#define RYGEL_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainer))
#define RYGEL_IS_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_WRITABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerIface))

typedef struct _RygelWritableContainer RygelWritableContainer;
typedef struct _RygelWritableContainerIface RygelWritableContainerIface;
typedef struct _RygelItemDestroyerRemoveObjectData RygelItemDestroyerRemoveObjectData;
typedef struct _RygelItemDestroyerFetchObjectData RygelItemDestroyerFetchObjectData;

typedef enum  {
	RYGEL_ITEM_DESTROYER_ERROR_PARSE
} RygelItemDestroyerError;
#define RYGEL_ITEM_DESTROYER_ERROR rygel_item_destroyer_error_quark ()
struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelItemDestroyer {
	GObject parent_instance;
	RygelItemDestroyerPrivate * priv;
};

struct _RygelItemDestroyerClass {
	GObjectClass parent_class;
};

struct _RygelItemDestroyerPrivate {
	gchar* object_id;
	RygelContentDirectory* content_dir;
	GUPnPServiceAction* action;
	GCancellable* _cancellable;
};

struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	gchar* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelItemDestroyerRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemDestroyer* self;
	const gchar* _tmp0_;
	GError* _tmp1_;
	const gchar* _tmp2_;
	GError * _error_;
	const gchar* _tmp3_;
	GError * _inner_error_;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelWritableContainerIface {
	GTypeInterface parent_iface;
	void (*add_item) (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_item) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	GeeArrayList* (*get_create_classes) (RygelWritableContainer* self);
	void (*set_create_classes) (RygelWritableContainer* self, GeeArrayList* value);
};

struct _RygelItemDestroyerRemoveObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemDestroyer* self;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* media_object;
	gboolean _tmp1_;
	RygelMediaObject* _tmp2_;
	gboolean _tmp3_;
	RygelMediaContainer* _tmp4_;
	RygelWritableContainer* _tmp5_;
	RygelWritableContainer* parent;
	GCancellable* _tmp6_;
	GCancellable* _tmp7_;
	GeeArrayList* _tmp8_;
	GeeArrayList* writables;
	GeeArrayList* _tmp9_;
	GeeArrayList* _file_list;
	gint _tmp10_;
	gint _file_size;
	gint _file_index;
	gpointer _tmp11_;
	GFile* file;
	GCancellable* _tmp12_;
	GError * _inner_error_;
};

struct _RygelItemDestroyerFetchObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemDestroyer* self;
	RygelMediaObject* result;
	GCancellable* _tmp0_;
	RygelMediaObject* _tmp1_;
	RygelMediaObject* media_object;
	const gchar* _tmp2_;
	GError* _tmp3_;
	GUPnPOCMFlags _tmp4_;
	const gchar* _tmp5_;
	GError* _tmp6_;
	gboolean _tmp7_;
	const gchar* _tmp8_;
	GError* _tmp9_;
	GError * _inner_error_;
};


static gpointer rygel_item_destroyer_parent_class = NULL;
static RygelStateMachineIface* rygel_item_destroyer_rygel_state_machine_parent_iface = NULL;

GQuark rygel_item_destroyer_error_quark (void);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_item_destroyer_get_type (void) G_GNUC_CONST;
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
#define RYGEL_ITEM_DESTROYER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyerPrivate))
enum  {
	RYGEL_ITEM_DESTROYER_DUMMY_PROPERTY,
	RYGEL_ITEM_DESTROYER_CANCELLABLE
};
RygelItemDestroyer* rygel_item_destroyer_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelItemDestroyer* rygel_item_destroyer_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
static void rygel_item_destroyer_real_run_data_free (gpointer _data);
static void rygel_item_destroyer_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_item_destroyer_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_item_destroyer_real_run_co (RygelItemDestroyerRunData* data);
GQuark rygel_content_directory_error_quark (void);
static void rygel_item_destroyer_remove_object (RygelItemDestroyer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_item_destroyer_remove_object_finish (RygelItemDestroyer* self, GAsyncResult* _res_, GError** error);
static void rygel_item_destroyer_remove_object_data_free (gpointer _data);
static void rygel_item_destroyer_remove_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_item_destroyer_remove_object_co (RygelItemDestroyerRemoveObjectData* data);
static void rygel_item_destroyer_fetch_object (RygelItemDestroyer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaObject* rygel_item_destroyer_fetch_object_finish (RygelItemDestroyer* self, GAsyncResult* _res_, GError** error);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
gboolean rygel_media_item_get_place_holder (RygelMediaItem* self);
GType rygel_writable_container_get_type (void) G_GNUC_CONST;
void rygel_writable_container_remove_item (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_writable_container_remove_item_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
void rygel_media_object_get_writables (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GeeArrayList* rygel_media_object_get_writables_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
static void rygel_item_destroyer_fetch_object_data_free (gpointer _data);
static void rygel_item_destroyer_fetch_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_item_destroyer_fetch_object_co (RygelItemDestroyerFetchObjectData* data);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
gboolean rygel_media_object_get_restricted (RygelMediaObject* self);
static void rygel_item_destroyer_finalize (GObject* obj);
static void _vala_rygel_item_destroyer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_item_destroyer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark rygel_item_destroyer_error_quark (void) {
	return g_quark_from_static_string ("rygel_item_destroyer_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelItemDestroyer* rygel_item_destroyer_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	RygelItemDestroyer * self = NULL;
	RygelContentDirectory* _tmp0_;
	RygelContentDirectory* _tmp1_;
	GUPnPServiceAction* _tmp2_;
	g_return_val_if_fail (content_dir != NULL, NULL);
	g_return_val_if_fail (action != NULL, NULL);
	self = (RygelItemDestroyer*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (content_dir);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->content_dir);
	self->priv->content_dir = _tmp1_;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, content_dir->cancellable);
	_tmp2_ = action;
	action = NULL;
	self->priv->action = _tmp2_;
	return self;
}


RygelItemDestroyer* rygel_item_destroyer_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	return rygel_item_destroyer_construct (RYGEL_TYPE_ITEM_DESTROYER, content_dir, action);
}


static void rygel_item_destroyer_real_run_data_free (gpointer _data) {
	RygelItemDestroyerRunData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelItemDestroyerRunData, data);
}


static void rygel_item_destroyer_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemDestroyer * self;
	RygelItemDestroyerRunData* _data_;
	self = (RygelItemDestroyer*) base;
	_data_ = g_slice_new0 (RygelItemDestroyerRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_destroyer_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_destroyer_real_run_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_item_destroyer_real_run_co (_data_);
}


static void rygel_item_destroyer_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelItemDestroyerRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_item_destroyer_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemDestroyerRunData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_item_destroyer_real_run_co (data);
}


static gboolean rygel_item_destroyer_real_run_co (RygelItemDestroyerRunData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	gupnp_service_action_get (data->self->priv->action, "ObjectID", G_TYPE_STRING, &data->self->priv->object_id, NULL);
	if (data->self->priv->object_id == NULL) {
		data->_tmp0_ = NULL;
		data->_tmp0_ = _ ("No such object");
		data->_tmp1_ = NULL;
		data->_tmp1_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, data->_tmp0_);
		data->_inner_error_ = data->_tmp1_;
		goto __catch55_g_error;
	}
	data->_state_ = 1;
	rygel_item_destroyer_remove_object (data->self, rygel_item_destroyer_run_ready, data);
	return FALSE;
	_state_1:
	rygel_item_destroyer_remove_object_finish (data->self, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch55_g_error;
	}
	gupnp_service_action_return (data->self->priv->action);
	data->_tmp2_ = NULL;
	data->_tmp2_ = _ ("Successfully destroyed object '%s'");
	g_debug (data->_tmp2_, data->self->priv->object_id);
	goto __finally55;
	__catch55_g_error:
	{
		data->_error_ = data->_inner_error_;
		data->_inner_error_ = NULL;
		if (data->_error_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
			gupnp_service_action_return_error (data->self->priv->action, (guint) data->_error_->code, data->_error_->message);
		} else {
			gupnp_service_action_return_error (data->self->priv->action, (guint) 701, data->_error_->message);
		}
		data->_tmp3_ = NULL;
		data->_tmp3_ = _ ("Failed to destroy object '%s': %s");
		g_warning (data->_tmp3_, data->self->priv->object_id, data->_error_->message);
		_g_error_free0 (data->_error_);
	}
	__finally55:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	g_signal_emit_by_name ((RygelStateMachine*) data->self, "completed");
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_item_destroyer_remove_object_data_free (gpointer _data) {
	RygelItemDestroyerRemoveObjectData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelItemDestroyerRemoveObjectData, data);
}


static void rygel_item_destroyer_remove_object (RygelItemDestroyer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemDestroyerRemoveObjectData* _data_;
	_data_ = g_slice_new0 (RygelItemDestroyerRemoveObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_destroyer_remove_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_destroyer_remove_object_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_item_destroyer_remove_object_co (_data_);
}


static void rygel_item_destroyer_remove_object_finish (RygelItemDestroyer* self, GAsyncResult* _res_, GError** error) {
	RygelItemDestroyerRemoveObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_item_destroyer_remove_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemDestroyerRemoveObjectData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_item_destroyer_remove_object_co (data);
}


static gboolean rygel_item_destroyer_remove_object_co (RygelItemDestroyerRemoveObjectData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_state_ = 1;
	rygel_item_destroyer_fetch_object (data->self, rygel_item_destroyer_remove_object_ready, data);
	return FALSE;
	_state_1:
	data->_tmp0_ = NULL;
	data->_tmp0_ = rygel_item_destroyer_fetch_object_finish (data->self, data->_res_, &data->_inner_error_);
	data->media_object = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (RYGEL_IS_MEDIA_ITEM (data->media_object)) {
		data->_tmp3_ = rygel_media_item_get_place_holder ((data->_tmp2_ = data->media_object, RYGEL_IS_MEDIA_ITEM (data->_tmp2_) ? ((RygelMediaItem*) data->_tmp2_) : NULL));
		data->_tmp1_ = data->_tmp3_;
	} else {
		data->_tmp1_ = FALSE;
	}
	if (data->_tmp1_) {
		data->_tmp5_ = _g_object_ref0 ((data->_tmp4_ = data->media_object->parent, RYGEL_IS_WRITABLE_CONTAINER (data->_tmp4_) ? ((RygelWritableContainer*) data->_tmp4_) : NULL));
		data->parent = data->_tmp5_;
		data->_tmp6_ = NULL;
		data->_tmp6_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
		data->_state_ = 2;
		rygel_writable_container_remove_item (data->parent, data->self->priv->object_id, data->_tmp6_, rygel_item_destroyer_remove_object_ready, data);
		return FALSE;
		_state_2:
		rygel_writable_container_remove_item_finish (data->parent, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->parent);
			_g_object_unref0 (data->media_object);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		_g_object_unref0 (data->parent);
	} else {
		data->_tmp7_ = NULL;
		data->_tmp7_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
		data->_state_ = 3;
		rygel_media_object_get_writables (data->media_object, data->_tmp7_, rygel_item_destroyer_remove_object_ready, data);
		return FALSE;
		_state_3:
		data->_tmp8_ = NULL;
		data->_tmp8_ = rygel_media_object_get_writables_finish (data->media_object, data->_res_, &data->_inner_error_);
		data->writables = data->_tmp8_;
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->media_object);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		{
			data->_tmp9_ = _g_object_ref0 (data->writables);
			data->_file_list = data->_tmp9_;
			data->_tmp10_ = gee_collection_get_size ((GeeCollection*) data->_file_list);
			data->_file_size = data->_tmp10_;
			data->_file_index = -1;
			while (TRUE) {
				data->_file_index = data->_file_index + 1;
				if (!(data->_file_index < data->_file_size)) {
					break;
				}
				data->_tmp11_ = NULL;
				data->_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) data->_file_list, data->_file_index);
				data->file = (GFile*) data->_tmp11_;
				data->_tmp12_ = NULL;
				data->_tmp12_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
				g_file_delete (data->file, data->_tmp12_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_object_unref0 (data->file);
					_g_object_unref0 (data->_file_list);
					_g_object_unref0 (data->writables);
					_g_object_unref0 (data->media_object);
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
				_g_object_unref0 (data->file);
			}
			_g_object_unref0 (data->_file_list);
		}
		_g_object_unref0 (data->writables);
	}
	_g_object_unref0 (data->media_object);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_item_destroyer_fetch_object_data_free (gpointer _data) {
	RygelItemDestroyerFetchObjectData* data;
	data = _data;
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (RygelItemDestroyerFetchObjectData, data);
}


static void rygel_item_destroyer_fetch_object (RygelItemDestroyer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemDestroyerFetchObjectData* _data_;
	_data_ = g_slice_new0 (RygelItemDestroyerFetchObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_destroyer_fetch_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_destroyer_fetch_object_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_item_destroyer_fetch_object_co (_data_);
}


static RygelMediaObject* rygel_item_destroyer_fetch_object_finish (RygelItemDestroyer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelItemDestroyerFetchObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_item_destroyer_fetch_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemDestroyerFetchObjectData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_item_destroyer_fetch_object_co (data);
}


static gboolean rygel_item_destroyer_fetch_object_co (RygelItemDestroyerFetchObjectData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
	data->_state_ = 1;
	rygel_media_container_find_object (data->self->priv->content_dir->root_container, data->self->priv->object_id, data->_tmp0_, rygel_item_destroyer_fetch_object_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = NULL;
	data->_tmp1_ = rygel_media_container_find_object_finish (data->self->priv->content_dir->root_container, data->_res_, &data->_inner_error_);
	data->media_object = data->_tmp1_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->media_object == NULL) {
		data->_tmp2_ = NULL;
		data->_tmp2_ = _ ("No such object");
		data->_tmp3_ = NULL;
		data->_tmp3_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, data->_tmp2_);
		data->_inner_error_ = data->_tmp3_;
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->media_object);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	} else {
		data->_tmp4_ = rygel_media_object_get_ocm_flags (data->media_object);
		if (!((data->_tmp4_ & GUPNP_OCM_FLAGS_DESTROYABLE) == GUPNP_OCM_FLAGS_DESTROYABLE)) {
			data->_tmp5_ = NULL;
			data->_tmp5_ = _ ("Removal of object %s not allowed");
			data->_tmp6_ = NULL;
			data->_tmp6_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT, data->_tmp5_, data->media_object->id);
			data->_inner_error_ = data->_tmp6_;
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->media_object);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			data->_tmp7_ = rygel_media_object_get_restricted ((RygelMediaObject*) data->media_object->parent);
			if (data->_tmp7_) {
				data->_tmp8_ = NULL;
				data->_tmp8_ = _ ("Object removal from %s not allowed");
				data->_tmp9_ = NULL;
				data->_tmp9_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, data->_tmp8_, data->media_object->id);
				data->_inner_error_ = data->_tmp9_;
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->media_object);
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
	}
	data->result = data->media_object;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->media_object);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static GCancellable* rygel_item_destroyer_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelItemDestroyer* self;
	self = (RygelItemDestroyer*) base;
	result = self->priv->_cancellable;
	return result;
}


static void rygel_item_destroyer_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelItemDestroyer* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	self = (RygelItemDestroyer*) base;
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = _tmp1_;
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_item_destroyer_class_init (RygelItemDestroyerClass * klass) {
	rygel_item_destroyer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelItemDestroyerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_item_destroyer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_item_destroyer_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_item_destroyer_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_ITEM_DESTROYER_CANCELLABLE, "cancellable");
}


static void rygel_item_destroyer_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_item_destroyer_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*)(RygelStateMachine*)) rygel_item_destroyer_real_run;
	iface->run_finish = rygel_item_destroyer_real_run_finish;
	iface->get_cancellable = rygel_item_destroyer_real_get_cancellable;
	iface->set_cancellable = rygel_item_destroyer_real_set_cancellable;
}


static void rygel_item_destroyer_instance_init (RygelItemDestroyer * self) {
	self->priv = RYGEL_ITEM_DESTROYER_GET_PRIVATE (self);
}


static void rygel_item_destroyer_finalize (GObject* obj) {
	RygelItemDestroyer * self;
	self = RYGEL_ITEM_DESTROYER (obj);
	_g_free0 (self->priv->object_id);
	_g_object_unref0 (self->priv->content_dir);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_item_destroyer_parent_class)->finalize (obj);
}


/**
 * DestroyObject action implementation.
 */
GType rygel_item_destroyer_get_type (void) {
	static volatile gsize rygel_item_destroyer_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_item_destroyer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelItemDestroyerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_item_destroyer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelItemDestroyer), 0, (GInstanceInitFunc) rygel_item_destroyer_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_item_destroyer_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_item_destroyer_type_id;
		rygel_item_destroyer_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelItemDestroyer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_item_destroyer_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_item_destroyer_type_id__volatile, rygel_item_destroyer_type_id);
	}
	return rygel_item_destroyer_type_id__volatile;
}


static void _vala_rygel_item_destroyer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelItemDestroyer * self;
	self = RYGEL_ITEM_DESTROYER (object);
	switch (property_id) {
		case RYGEL_ITEM_DESTROYER_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_item_destroyer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelItemDestroyer * self;
	self = RYGEL_ITEM_DESTROYER (object);
	switch (property_id) {
		case RYGEL_ITEM_DESTROYER_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



