/* rygel-external-item-factory.c generated by valac 0.10.0, the Vala compiler
 * generated from rygel-external-item-factory.vala, do not modify */

/*
 * Copyright (C) 2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009,2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <rygel.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_EXTERNAL_TYPE_ITEM_FACTORY (rygel_external_item_factory_get_type ())
#define RYGEL_EXTERNAL_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY, RygelExternalItemFactory))
#define RYGEL_EXTERNAL_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY, RygelExternalItemFactoryClass))
#define RYGEL_EXTERNAL_IS_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY))
#define RYGEL_EXTERNAL_IS_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY))
#define RYGEL_EXTERNAL_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY, RygelExternalItemFactoryClass))

typedef struct _RygelExternalItemFactory RygelExternalItemFactory;
typedef struct _RygelExternalItemFactoryClass RygelExternalItemFactoryClass;
typedef struct _RygelExternalItemFactoryPrivate RygelExternalItemFactoryPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER (rygel_external_dummy_container_get_type ())
#define RYGEL_EXTERNAL_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER, RygelExternalDummyContainer))
#define RYGEL_EXTERNAL_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER, RygelExternalDummyContainerClass))
#define RYGEL_EXTERNAL_IS_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER))
#define RYGEL_EXTERNAL_IS_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER))
#define RYGEL_EXTERNAL_DUMMY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER, RygelExternalDummyContainerClass))

typedef struct _RygelExternalDummyContainer RygelExternalDummyContainer;
typedef struct _RygelExternalDummyContainerClass RygelExternalDummyContainerClass;
typedef struct _RygelExternalItemFactoryCreateData RygelExternalItemFactoryCreateData;

#define RYGEL_EXTERNAL_TYPE_ALBUM_ART_FACTORY (rygel_external_album_art_factory_get_type ())
#define RYGEL_EXTERNAL_ALBUM_ART_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_ALBUM_ART_FACTORY, RygelExternalAlbumArtFactory))
#define RYGEL_EXTERNAL_ALBUM_ART_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_ALBUM_ART_FACTORY, RygelExternalAlbumArtFactoryClass))
#define RYGEL_EXTERNAL_IS_ALBUM_ART_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_ALBUM_ART_FACTORY))
#define RYGEL_EXTERNAL_IS_ALBUM_ART_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_ALBUM_ART_FACTORY))
#define RYGEL_EXTERNAL_ALBUM_ART_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_ALBUM_ART_FACTORY, RygelExternalAlbumArtFactoryClass))

typedef struct _RygelExternalAlbumArtFactory RygelExternalAlbumArtFactory;
typedef struct _RygelExternalAlbumArtFactoryClass RygelExternalAlbumArtFactoryClass;
#define _rygel_external_album_art_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_external_album_art_factory_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
typedef struct _RygelExternalItemFactorySetMusicMetadataData RygelExternalItemFactorySetMusicMetadataData;

#define RYGEL_EXTERNAL_TYPE_THUMBNAIL_FACTORY (rygel_external_thumbnail_factory_get_type ())
#define RYGEL_EXTERNAL_THUMBNAIL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_THUMBNAIL_FACTORY, RygelExternalThumbnailFactory))
#define RYGEL_EXTERNAL_THUMBNAIL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_THUMBNAIL_FACTORY, RygelExternalThumbnailFactoryClass))
#define RYGEL_EXTERNAL_IS_THUMBNAIL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_THUMBNAIL_FACTORY))
#define RYGEL_EXTERNAL_IS_THUMBNAIL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_THUMBNAIL_FACTORY))
#define RYGEL_EXTERNAL_THUMBNAIL_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_THUMBNAIL_FACTORY, RygelExternalThumbnailFactoryClass))

typedef struct _RygelExternalThumbnailFactory RygelExternalThumbnailFactory;
typedef struct _RygelExternalThumbnailFactoryClass RygelExternalThumbnailFactoryClass;
#define _rygel_external_thumbnail_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_external_thumbnail_factory_unref (var), NULL)))
typedef struct _RygelExternalItemFactorySetVisualMetadataData RygelExternalItemFactorySetVisualMetadataData;
typedef struct _RygelExternalItemFactorySetVideoMetadataData RygelExternalItemFactorySetVideoMetadataData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelExternalParamSpecItemFactory RygelExternalParamSpecItemFactory;

struct _RygelExternalItemFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelExternalItemFactoryPrivate * priv;
};

struct _RygelExternalItemFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelExternalItemFactory *self);
};

struct _RygelExternalItemFactoryCreateData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalItemFactory* self;
	char* id;
	char* type;
	char* title;
	GHashTable* props;
	char* service_name;
	char* host_ip;
	RygelMediaContainer* parent;
	RygelMediaItem* result;
	RygelMediaItem* item;
	RygelMediaItem* _tmp0_;
	RygelMediaItem* _tmp1_;
	RygelMediaItem* _tmp2_;
	RygelMediaItem* _tmp3_;
	RygelMediaItem* _tmp4_;
	RygelMediaItem* _tmp5_;
	RygelMediaItem* _tmp6_;
	RygelMediaItem* _tmp7_;
	GError * _inner_error_;
};

struct _RygelExternalItemFactorySetMusicMetadataData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalItemFactory* self;
	RygelMusicItem* music;
	GHashTable* props;
	char* service_name;
	char* host_ip;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	GVariant* value;
	RygelExternalAlbumArtFactory* cover_factory;
	RygelThumbnail* _tmp3_;
	RygelThumbnail* _tmp4_;
	GError * _inner_error_;
};

struct _RygelExternalItemFactorySetVisualMetadataData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalItemFactory* self;
	RygelVisualItem* visual;
	GHashTable* props;
	char* service_name;
	char* host_ip;
	GVariant* value;
	RygelExternalThumbnailFactory* factory;
	RygelThumbnail* thumbnail;
	GError * _inner_error_;
};

struct _RygelExternalItemFactorySetVideoMetadataData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalItemFactory* self;
	RygelVideoItem* video;
	GHashTable* props;
	char* service_name;
	char* host_ip;
	GError * _inner_error_;
};

struct _RygelExternalParamSpecItemFactory {
	GParamSpec parent_instance;
};


static gpointer rygel_external_item_factory_parent_class = NULL;

gpointer rygel_external_item_factory_ref (gpointer instance);
void rygel_external_item_factory_unref (gpointer instance);
GParamSpec* rygel_external_param_spec_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_external_value_set_item_factory (GValue* value, gpointer v_object);
void rygel_external_value_take_item_factory (GValue* value, gpointer v_object);
gpointer rygel_external_value_get_item_factory (const GValue* value);
GType rygel_external_item_factory_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_EXTERNAL_ITEM_FACTORY_DUMMY_PROPERTY
};
static void rygel_external_item_factory_create_data_free (gpointer _data);
static void rygel_external_item_factory_create_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_external_item_factory_create (RygelExternalItemFactory* self, const char* id, const char* type, const char* title, GHashTable* props, const char* service_name, const char* host_ip, RygelMediaContainer* parent, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaItem* rygel_external_item_factory_create_finish (RygelExternalItemFactory* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_external_item_factory_create_co (RygelExternalItemFactoryCreateData* data);
static void rygel_external_item_factory_set_audio_metadata (RygelExternalItemFactory* self, RygelAudioItem* audio, GHashTable* props, const char* service_name, const char* host_ip, GError** error);
static void rygel_external_item_factory_set_music_metadata (RygelExternalItemFactory* self, RygelMusicItem* music, GHashTable* props, const char* service_name, const char* host_ip, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_external_item_factory_set_music_metadata_finish (RygelExternalItemFactory* self, GAsyncResult* _res_, GError** error);
static void rygel_external_item_factory_set_video_metadata (RygelExternalItemFactory* self, RygelVideoItem* video, GHashTable* props, const char* service_name, const char* host_ip, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_external_item_factory_set_video_metadata_finish (RygelExternalItemFactory* self, GAsyncResult* _res_, GError** error);
static void rygel_external_item_factory_set_visual_metadata (RygelExternalItemFactory* self, RygelVisualItem* visual, GHashTable* props, const char* service_name, const char* host_ip, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_external_item_factory_set_visual_metadata_finish (RygelExternalItemFactory* self, GAsyncResult* _res_, GError** error);
static void rygel_external_item_factory_set_generic_metadata (RygelExternalItemFactory* self, RygelMediaItem* item, GHashTable* props, const char* service_name, const char* host_ip);
GType rygel_external_dummy_container_get_type (void) G_GNUC_CONST;
static void rygel_external_item_factory_set_music_metadata_data_free (gpointer _data);
static void rygel_external_item_factory_set_music_metadata_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_external_item_factory_set_music_metadata_co (RygelExternalItemFactorySetMusicMetadataData* data);
static char* rygel_external_item_factory_get_string (RygelExternalItemFactory* self, GHashTable* props, const char* prop);
RygelExternalAlbumArtFactory* rygel_external_album_art_factory_new (void);
RygelExternalAlbumArtFactory* rygel_external_album_art_factory_construct (GType object_type);
gpointer rygel_external_album_art_factory_ref (gpointer instance);
void rygel_external_album_art_factory_unref (gpointer instance);
GParamSpec* rygel_external_param_spec_album_art_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_external_value_set_album_art_factory (GValue* value, gpointer v_object);
void rygel_external_value_take_album_art_factory (GValue* value, gpointer v_object);
gpointer rygel_external_value_get_album_art_factory (const GValue* value);
GType rygel_external_album_art_factory_get_type (void) G_GNUC_CONST;
void rygel_external_album_art_factory_create (RygelExternalAlbumArtFactory* self, const char* service_name, const char* object_path, const char* host_ip, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelThumbnail* rygel_external_album_art_factory_create_finish (RygelExternalAlbumArtFactory* self, GAsyncResult* _res_, GError** error);
static const char* _variant_get10 (GVariant* value);
static gint rygel_external_item_factory_get_int (RygelExternalItemFactory* self, GHashTable* props, const char* prop);
static void rygel_external_item_factory_set_visual_metadata_data_free (gpointer _data);
static void rygel_external_item_factory_set_visual_metadata_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_external_item_factory_set_visual_metadata_co (RygelExternalItemFactorySetVisualMetadataData* data);
RygelExternalThumbnailFactory* rygel_external_thumbnail_factory_new (void);
RygelExternalThumbnailFactory* rygel_external_thumbnail_factory_construct (GType object_type);
gpointer rygel_external_thumbnail_factory_ref (gpointer instance);
void rygel_external_thumbnail_factory_unref (gpointer instance);
GParamSpec* rygel_external_param_spec_thumbnail_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_external_value_set_thumbnail_factory (GValue* value, gpointer v_object);
void rygel_external_value_take_thumbnail_factory (GValue* value, gpointer v_object);
gpointer rygel_external_value_get_thumbnail_factory (const GValue* value);
GType rygel_external_thumbnail_factory_get_type (void) G_GNUC_CONST;
void rygel_external_thumbnail_factory_create (RygelExternalThumbnailFactory* self, const char* service_name, const char* object_path, const char* host_ip, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelThumbnail* rygel_external_thumbnail_factory_create_finish (RygelExternalThumbnailFactory* self, GAsyncResult* _res_, GError** error);
static const char* _variant_get11 (GVariant* value);
static void rygel_external_item_factory_set_video_metadata_data_free (gpointer _data);
static void rygel_external_item_factory_set_video_metadata_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_external_item_factory_set_video_metadata_co (RygelExternalItemFactorySetVideoMetadataData* data);
static char** _variant_get12 (GVariant* value, int* result_length1);
static char** _vala_array_dup2 (char** self, int length);
static gint64 _variant_get13 (GVariant* value);
static const char* _variant_get14 (GVariant* value);
static gint _variant_get15 (GVariant* value);
RygelExternalItemFactory* rygel_external_item_factory_new (void);
RygelExternalItemFactory* rygel_external_item_factory_construct (GType object_type);
static void rygel_external_item_factory_finalize (RygelExternalItemFactory* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



static void rygel_external_item_factory_create_data_free (gpointer _data) {
	RygelExternalItemFactoryCreateData* data;
	data = _data;
	_g_free0 (data->id);
	_g_free0 (data->type);
	_g_free0 (data->title);
	_g_hash_table_unref0 (data->props);
	_g_free0 (data->service_name);
	_g_free0 (data->host_ip);
	_g_object_unref0 (data->parent);
	_g_object_unref0 (data->result);
	rygel_external_item_factory_unref (data->self);
	g_slice_free (RygelExternalItemFactoryCreateData, data);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void rygel_external_item_factory_create (RygelExternalItemFactory* self, const char* id, const char* type, const char* title, GHashTable* props, const char* service_name, const char* host_ip, RygelMediaContainer* parent, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalItemFactoryCreateData* _data_;
	_data_ = g_slice_new0 (RygelExternalItemFactoryCreateData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_external_item_factory_create);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_item_factory_create_data_free);
	_data_->self = rygel_external_item_factory_ref (self);
	_data_->id = g_strdup (id);
	_data_->type = g_strdup (type);
	_data_->title = g_strdup (title);
	_data_->props = _g_hash_table_ref0 (props);
	_data_->service_name = g_strdup (service_name);
	_data_->host_ip = g_strdup (host_ip);
	_data_->parent = _g_object_ref0 (parent);
	rygel_external_item_factory_create_co (_data_);
}


RygelMediaItem* rygel_external_item_factory_create_finish (RygelExternalItemFactory* self, GAsyncResult* _res_, GError** error) {
	RygelMediaItem* result;
	RygelExternalItemFactoryCreateData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_external_item_factory_create_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalItemFactoryCreateData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_external_item_factory_create_co (data);
}


static gboolean rygel_external_item_factory_create_co (RygelExternalItemFactoryCreateData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 12:
		goto _state_12;
		case 13:
		goto _state_13;
		case 14:
		goto _state_14;
	}
	_state_0:
#line 42 "rygel-external-item-factory.vala"
	if (g_str_has_prefix (data->type, "audio")) {
#line 43 "rygel-external-item-factory.vala"
		data->item = (data->_tmp0_ = (RygelMediaItem*) rygel_audio_item_new (data->id, data->parent, data->title, RYGEL_AUDIO_ITEM_UPNP_CLASS), _g_object_unref0 (data->item), data->_tmp0_);
#line 45 "rygel-external-item-factory.vala"
		rygel_external_item_factory_set_audio_metadata (data->self, (data->_tmp1_ = data->item, RYGEL_IS_AUDIO_ITEM (data->_tmp1_) ? ((RygelAudioItem*) data->_tmp1_) : NULL), data->props, data->service_name, data->host_ip, &data->_inner_error_);
#line 339 "rygel-external-item-factory.c"
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->item);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
	} else {
#line 49 "rygel-external-item-factory.vala"
		if (g_str_has_prefix (data->type, "music")) {
#line 50 "rygel-external-item-factory.vala"
			data->item = (data->_tmp2_ = (RygelMediaItem*) rygel_music_item_new (data->id, data->parent, data->title, RYGEL_MUSIC_ITEM_UPNP_CLASS), _g_object_unref0 (data->item), data->_tmp2_);
#line 359 "rygel-external-item-factory.c"
			data->_state_ = 12;
			rygel_external_item_factory_set_music_metadata (data->self, (data->_tmp3_ = data->item, RYGEL_IS_MUSIC_ITEM (data->_tmp3_) ? ((RygelMusicItem*) data->_tmp3_) : NULL), data->props, data->service_name, data->host_ip, rygel_external_item_factory_create_ready, data);
			return FALSE;
			_state_12:
#line 52 "rygel-external-item-factory.vala"
			rygel_external_item_factory_set_music_metadata_finish (data->self, data->_res_, &data->_inner_error_);
#line 366 "rygel-external-item-factory.c"
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->item);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
		} else {
#line 56 "rygel-external-item-factory.vala"
			if (g_str_has_prefix (data->type, "video")) {
#line 57 "rygel-external-item-factory.vala"
				data->item = (data->_tmp4_ = (RygelMediaItem*) rygel_video_item_new (data->id, data->parent, data->title, RYGEL_VIDEO_ITEM_UPNP_CLASS), _g_object_unref0 (data->item), data->_tmp4_);
#line 386 "rygel-external-item-factory.c"
				data->_state_ = 13;
				rygel_external_item_factory_set_video_metadata (data->self, (data->_tmp5_ = data->item, RYGEL_IS_VIDEO_ITEM (data->_tmp5_) ? ((RygelVideoItem*) data->_tmp5_) : NULL), data->props, data->service_name, data->host_ip, rygel_external_item_factory_create_ready, data);
				return FALSE;
				_state_13:
#line 59 "rygel-external-item-factory.vala"
				rygel_external_item_factory_set_video_metadata_finish (data->self, data->_res_, &data->_inner_error_);
#line 393 "rygel-external-item-factory.c"
				if (data->_inner_error_ != NULL) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_object_unref0 (data->item);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				}
			} else {
#line 64 "rygel-external-item-factory.vala"
				data->item = (data->_tmp6_ = (RygelMediaItem*) rygel_image_item_new (data->id, data->parent, data->title, RYGEL_IMAGE_ITEM_UPNP_CLASS), _g_object_unref0 (data->item), data->_tmp6_);
#line 411 "rygel-external-item-factory.c"
				data->_state_ = 14;
				rygel_external_item_factory_set_visual_metadata (data->self, (data->_tmp7_ = data->item, RYGEL_IS_VISUAL_ITEM (data->_tmp7_) ? ((RygelVisualItem*) data->_tmp7_) : NULL), data->props, data->service_name, data->host_ip, rygel_external_item_factory_create_ready, data);
				return FALSE;
				_state_14:
#line 66 "rygel-external-item-factory.vala"
				rygel_external_item_factory_set_visual_metadata_finish (data->self, data->_res_, &data->_inner_error_);
#line 418 "rygel-external-item-factory.c"
				if (data->_inner_error_ != NULL) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_object_unref0 (data->item);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				}
			}
		}
	}
#line 72 "rygel-external-item-factory.vala"
	rygel_external_item_factory_set_generic_metadata (data->self, data->item, data->props, data->service_name, data->host_ip);
#line 74 "rygel-external-item-factory.vala"
	if (RYGEL_EXTERNAL_IS_DUMMY_CONTAINER (data->parent)) {
#line 75 "rygel-external-item-factory.vala"
		rygel_media_object_set_parent_ref ((RygelMediaObject*) data->item, data->parent);
#line 442 "rygel-external-item-factory.c"
	}
	data->result = data->item;
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_object_unref0 (data->item);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void rygel_external_item_factory_set_music_metadata_data_free (gpointer _data) {
	RygelExternalItemFactorySetMusicMetadataData* data;
	data = _data;
	_g_object_unref0 (data->music);
	_g_hash_table_unref0 (data->props);
	_g_free0 (data->service_name);
	_g_free0 (data->host_ip);
	rygel_external_item_factory_unref (data->self);
	g_slice_free (RygelExternalItemFactorySetMusicMetadataData, data);
}


static void rygel_external_item_factory_set_music_metadata (RygelExternalItemFactory* self, RygelMusicItem* music, GHashTable* props, const char* service_name, const char* host_ip, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalItemFactorySetMusicMetadataData* _data_;
	_data_ = g_slice_new0 (RygelExternalItemFactorySetMusicMetadataData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_external_item_factory_set_music_metadata);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_item_factory_set_music_metadata_data_free);
	_data_->self = rygel_external_item_factory_ref (self);
	_data_->music = _g_object_ref0 (music);
	_data_->props = _g_hash_table_ref0 (props);
	_data_->service_name = g_strdup (service_name);
	_data_->host_ip = g_strdup (host_ip);
	rygel_external_item_factory_set_music_metadata_co (_data_);
}


static void rygel_external_item_factory_set_music_metadata_finish (RygelExternalItemFactory* self, GAsyncResult* _res_, GError** error) {
	RygelExternalItemFactorySetMusicMetadataData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_external_item_factory_set_music_metadata_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalItemFactorySetMusicMetadataData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_external_item_factory_set_music_metadata_co (data);
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static const char* _variant_get10 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static gboolean rygel_external_item_factory_set_music_metadata_co (RygelExternalItemFactorySetMusicMetadataData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 15:
		goto _state_15;
	}
	_state_0:
#line 87 "rygel-external-item-factory.vala"
	data->music->artist = (data->_tmp0_ = rygel_external_item_factory_get_string (data->self, data->props, "Artist"), _g_free0 (data->music->artist), data->_tmp0_);
#line 88 "rygel-external-item-factory.vala"
	data->music->album = (data->_tmp1_ = rygel_external_item_factory_get_string (data->self, data->props, "Album"), _g_free0 (data->music->album), data->_tmp1_);
#line 89 "rygel-external-item-factory.vala"
	data->music->genre = (data->_tmp2_ = rygel_external_item_factory_get_string (data->self, data->props, "Genre"), _g_free0 (data->music->genre), data->_tmp2_);
#line 536 "rygel-external-item-factory.c"
	data->value = _g_variant_ref0 ((GVariant*) g_hash_table_lookup (data->props, "AlbumArt"));
#line 92 "rygel-external-item-factory.vala"
	if (data->value != NULL) {
#line 540 "rygel-external-item-factory.c"
		data->cover_factory = rygel_external_album_art_factory_new ();
		data->_state_ = 15;
		rygel_external_album_art_factory_create (data->cover_factory, _variant_get10 (data->value), data->service_name, data->host_ip, rygel_external_item_factory_set_music_metadata_ready, data);
		return FALSE;
		_state_15:
		data->_tmp3_ = rygel_external_album_art_factory_create_finish (data->cover_factory, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_rygel_external_album_art_factory_unref0 (data->cover_factory);
			_g_variant_unref0 (data->value);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
#line 95 "rygel-external-item-factory.vala"
		data->music->album_art = (data->_tmp4_ = data->_tmp3_, _rygel_icon_info_unref0 (data->music->album_art), data->_tmp4_);
#line 564 "rygel-external-item-factory.c"
		_rygel_external_album_art_factory_unref0 (data->cover_factory);
	}
#line 100 "rygel-external-item-factory.vala"
	rygel_external_item_factory_set_audio_metadata (data->self, (RygelAudioItem*) data->music, data->props, data->service_name, data->host_ip, &data->_inner_error_);
#line 569 "rygel-external-item-factory.c"
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_variant_unref0 (data->value);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	_g_variant_unref0 (data->value);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 103 "rygel-external-item-factory.vala"
static void rygel_external_item_factory_set_audio_metadata (RygelExternalItemFactory* self, RygelAudioItem* audio, GHashTable* props, const char* service_name, const char* host_ip, GError** error) {
#line 103 "rygel-external-item-factory.vala"
	g_return_if_fail (self != NULL);
#line 103 "rygel-external-item-factory.vala"
	g_return_if_fail (audio != NULL);
#line 103 "rygel-external-item-factory.vala"
	g_return_if_fail (props != NULL);
#line 103 "rygel-external-item-factory.vala"
	g_return_if_fail (service_name != NULL);
#line 103 "rygel-external-item-factory.vala"
	g_return_if_fail (host_ip != NULL);
#line 108 "rygel-external-item-factory.vala"
	audio->duration = (glong) rygel_external_item_factory_get_int (self, props, "Duration");
#line 109 "rygel-external-item-factory.vala"
	audio->bitrate = rygel_external_item_factory_get_int (self, props, "Bitrate");
#line 110 "rygel-external-item-factory.vala"
	audio->sample_freq = rygel_external_item_factory_get_int (self, props, "SampleRate");
#line 111 "rygel-external-item-factory.vala"
	audio->bits_per_sample = rygel_external_item_factory_get_int (self, props, "BitsPerSample");
#line 617 "rygel-external-item-factory.c"
}


static void rygel_external_item_factory_set_visual_metadata_data_free (gpointer _data) {
	RygelExternalItemFactorySetVisualMetadataData* data;
	data = _data;
	_g_object_unref0 (data->visual);
	_g_hash_table_unref0 (data->props);
	_g_free0 (data->service_name);
	_g_free0 (data->host_ip);
	rygel_external_item_factory_unref (data->self);
	g_slice_free (RygelExternalItemFactorySetVisualMetadataData, data);
}


static void rygel_external_item_factory_set_visual_metadata (RygelExternalItemFactory* self, RygelVisualItem* visual, GHashTable* props, const char* service_name, const char* host_ip, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalItemFactorySetVisualMetadataData* _data_;
	_data_ = g_slice_new0 (RygelExternalItemFactorySetVisualMetadataData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_external_item_factory_set_visual_metadata);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_item_factory_set_visual_metadata_data_free);
	_data_->self = rygel_external_item_factory_ref (self);
	_data_->visual = _g_object_ref0 (visual);
	_data_->props = _g_hash_table_ref0 (props);
	_data_->service_name = g_strdup (service_name);
	_data_->host_ip = g_strdup (host_ip);
	rygel_external_item_factory_set_visual_metadata_co (_data_);
}


static void rygel_external_item_factory_set_visual_metadata_finish (RygelExternalItemFactory* self, GAsyncResult* _res_, GError** error) {
	RygelExternalItemFactorySetVisualMetadataData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_external_item_factory_set_visual_metadata_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalItemFactorySetVisualMetadataData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_external_item_factory_set_visual_metadata_co (data);
}


static const char* _variant_get11 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static gboolean rygel_external_item_factory_set_visual_metadata_co (RygelExternalItemFactorySetVisualMetadataData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 16:
		goto _state_16;
	}
	_state_0:
#line 120 "rygel-external-item-factory.vala"
	rygel_visual_item_set_width (data->visual, rygel_external_item_factory_get_int (data->self, data->props, "Width"));
#line 121 "rygel-external-item-factory.vala"
	rygel_visual_item_set_height (data->visual, rygel_external_item_factory_get_int (data->self, data->props, "Height"));
#line 122 "rygel-external-item-factory.vala"
	rygel_visual_item_set_color_depth (data->visual, rygel_external_item_factory_get_int (data->self, data->props, "ColorDepth"));
#line 123 "rygel-external-item-factory.vala"
	rygel_visual_item_set_pixel_width (data->visual, rygel_external_item_factory_get_int (data->self, data->props, "PixelWidth"));
#line 124 "rygel-external-item-factory.vala"
	rygel_visual_item_set_pixel_height (data->visual, rygel_external_item_factory_get_int (data->self, data->props, "PixelHeight"));
#line 689 "rygel-external-item-factory.c"
	data->value = _g_variant_ref0 ((GVariant*) g_hash_table_lookup (data->props, "Thumbnail"));
#line 127 "rygel-external-item-factory.vala"
	if (data->value != NULL) {
#line 693 "rygel-external-item-factory.c"
		data->factory = rygel_external_thumbnail_factory_new ();
		data->_state_ = 16;
		rygel_external_thumbnail_factory_create (data->factory, _variant_get11 (data->value), data->service_name, data->host_ip, rygel_external_item_factory_set_visual_metadata_ready, data);
		return FALSE;
		_state_16:
		data->thumbnail = rygel_external_thumbnail_factory_create_finish (data->factory, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_rygel_external_thumbnail_factory_unref0 (data->factory);
			_g_variant_unref0 (data->value);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
#line 132 "rygel-external-item-factory.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) rygel_visual_item_get_thumbnails (data->visual), data->thumbnail);
#line 717 "rygel-external-item-factory.c"
		_rygel_icon_info_unref0 (data->thumbnail);
		_rygel_external_thumbnail_factory_unref0 (data->factory);
	}
	_g_variant_unref0 (data->value);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void rygel_external_item_factory_set_video_metadata_data_free (gpointer _data) {
	RygelExternalItemFactorySetVideoMetadataData* data;
	data = _data;
	_g_object_unref0 (data->video);
	_g_hash_table_unref0 (data->props);
	_g_free0 (data->service_name);
	_g_free0 (data->host_ip);
	rygel_external_item_factory_unref (data->self);
	g_slice_free (RygelExternalItemFactorySetVideoMetadataData, data);
}


static void rygel_external_item_factory_set_video_metadata (RygelExternalItemFactory* self, RygelVideoItem* video, GHashTable* props, const char* service_name, const char* host_ip, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalItemFactorySetVideoMetadataData* _data_;
	_data_ = g_slice_new0 (RygelExternalItemFactorySetVideoMetadataData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_external_item_factory_set_video_metadata);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_item_factory_set_video_metadata_data_free);
	_data_->self = rygel_external_item_factory_ref (self);
	_data_->video = _g_object_ref0 (video);
	_data_->props = _g_hash_table_ref0 (props);
	_data_->service_name = g_strdup (service_name);
	_data_->host_ip = g_strdup (host_ip);
	rygel_external_item_factory_set_video_metadata_co (_data_);
}


static void rygel_external_item_factory_set_video_metadata_finish (RygelExternalItemFactory* self, GAsyncResult* _res_, GError** error) {
	RygelExternalItemFactorySetVideoMetadataData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_external_item_factory_set_video_metadata_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalItemFactorySetVideoMetadataData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_external_item_factory_set_video_metadata_co (data);
}


static gboolean rygel_external_item_factory_set_video_metadata_co (RygelExternalItemFactorySetVideoMetadataData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 17:
		goto _state_17;
	}
	_state_0:
	data->_state_ = 17;
	rygel_external_item_factory_set_visual_metadata (data->self, (RygelVisualItem*) data->video, data->props, data->service_name, data->host_ip, rygel_external_item_factory_set_video_metadata_ready, data);
	return FALSE;
	_state_17:
#line 142 "rygel-external-item-factory.vala"
	rygel_external_item_factory_set_visual_metadata_finish (data->self, data->_res_, &data->_inner_error_);
#line 793 "rygel-external-item-factory.c"
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
#line 143 "rygel-external-item-factory.vala"
	rygel_external_item_factory_set_audio_metadata (data->self, (RygelAudioItem*) data->video, data->props, data->service_name, data->host_ip, &data->_inner_error_);
#line 809 "rygel-external-item-factory.c"
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static char** _variant_get12 (GVariant* value, int* result_length1) {
	char** _tmp2_;
	int _tmp2__length;
	int _tmp2__size;
	int _tmp2__length1;
	GVariantIter _tmp3_;
	GVariant* _tmp4_;
	_tmp2_ = g_new (char*, 5);
	_tmp2__length = 0;
	_tmp2__size = 4;
	_tmp2__length1 = 0;
	g_variant_iter_init (&_tmp3_, value);
	for (; _tmp4_ = g_variant_iter_next_value (&_tmp3_); _tmp2__length1++) {
		if (_tmp2__size == _tmp2__length) {
			_tmp2__size = 2 * _tmp2__size;
			_tmp2_ = g_renew (char*, _tmp2_, _tmp2__size + 1);
		}
		_tmp2_[_tmp2__length++] = g_variant_dup_string (_tmp4_, NULL);
		g_variant_unref (_tmp4_);
	}
	*result_length1 = _tmp2__length1;
	_tmp2_[_tmp2__length] = NULL;
	return _tmp2_;
}


static char** _vala_array_dup2 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


#line 1177 "glib-2.0.vapi"
static char* string_replace (const char* self, const char* old, const char* replacement) {
#line 874 "rygel-external-item-factory.c"
	char* result = NULL;
	GError * _inner_error_ = NULL;
#line 1177 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1177 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1177 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 883 "rygel-external-item-factory.c"
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
#line 1179 "glib-2.0.vapi"
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
#line 891 "rygel-external-item-factory.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 1180 "glib-2.0.vapi"
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
#line 902 "rygel-external-item-factory.c"
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
#line 1180 "glib-2.0.vapi"
		return result;
#line 917 "rygel-external-item-factory.c"
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 1182 "glib-2.0.vapi"
			g_assert_not_reached ();
#line 928 "rygel-external-item-factory.c"
			_g_error_free0 (e);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gint64 _variant_get13 (GVariant* value) {
	return g_variant_get_int64 (value);
}


#line 146 "rygel-external-item-factory.vala"
static void rygel_external_item_factory_set_generic_metadata (RygelExternalItemFactory* self, RygelMediaItem* item, GHashTable* props, const char* service_name, const char* host_ip) {
#line 948 "rygel-external-item-factory.c"
	char* _tmp0_;
	gint uris_length1;
	gint _uris_size_;
	char** _tmp6_;
	gint _tmp1_;
	char** _tmp5_;
	char** uris;
	char* _tmp9_;
	GVariant* value;
	char* _tmp10_;
#line 146 "rygel-external-item-factory.vala"
	g_return_if_fail (self != NULL);
#line 146 "rygel-external-item-factory.vala"
	g_return_if_fail (item != NULL);
#line 146 "rygel-external-item-factory.vala"
	g_return_if_fail (props != NULL);
#line 146 "rygel-external-item-factory.vala"
	g_return_if_fail (service_name != NULL);
#line 146 "rygel-external-item-factory.vala"
	g_return_if_fail (host_ip != NULL);
#line 150 "rygel-external-item-factory.vala"
	item->mime_type = (_tmp0_ = rygel_external_item_factory_get_string (self, props, "MIMEType"), _g_free0 (item->mime_type), _tmp0_);
#line 971 "rygel-external-item-factory.c"
	uris = (_tmp6_ = (_tmp5_ = _variant_get12 ((GVariant*) g_hash_table_lookup (props, "URLs"), &_tmp1_), (_tmp5_ == NULL) ? ((gpointer) _tmp5_) : _vala_array_dup2 (_tmp5_, _tmp1_)), uris_length1 = _tmp1_, _uris_size_ = uris_length1, _tmp6_);
#line 153 "rygel-external-item-factory.vala"
	if (uris != NULL) {
#line 975 "rygel-external-item-factory.c"
		{
			gint i;
#line 154 "rygel-external-item-factory.vala"
			i = 0;
#line 980 "rygel-external-item-factory.c"
			{
				gboolean _tmp7_;
#line 154 "rygel-external-item-factory.vala"
				_tmp7_ = TRUE;
#line 154 "rygel-external-item-factory.vala"
				while (TRUE) {
#line 987 "rygel-external-item-factory.c"
					char* _tmp8_;
#line 154 "rygel-external-item-factory.vala"
					if (!_tmp7_) {
#line 154 "rygel-external-item-factory.vala"
						i++;
#line 993 "rygel-external-item-factory.c"
					}
#line 154 "rygel-external-item-factory.vala"
					_tmp7_ = FALSE;
#line 154 "rygel-external-item-factory.vala"
					if (!(uris[i] != NULL)) {
#line 154 "rygel-external-item-factory.vala"
						break;
#line 1001 "rygel-external-item-factory.c"
					}
#line 155 "rygel-external-item-factory.vala"
					rygel_media_item_add_uri (item, _tmp8_ = string_replace (uris[i], "@ADDRESS@", host_ip));
#line 1005 "rygel-external-item-factory.c"
					_g_free0 (_tmp8_);
				}
			}
		}
	}
#line 161 "rygel-external-item-factory.vala"
	item->dlna_profile = (_tmp9_ = rygel_external_item_factory_get_string (self, props, "DLNAProfile"), _g_free0 (item->dlna_profile), _tmp9_);
#line 163 "rygel-external-item-factory.vala"
	value = _g_variant_ref0 ((GVariant*) g_hash_table_lookup (props, "Size"));
#line 164 "rygel-external-item-factory.vala"
	if (value != NULL) {
#line 165 "rygel-external-item-factory.vala"
		rygel_media_item_set_size (item, _variant_get13 (value));
#line 1019 "rygel-external-item-factory.c"
	}
#line 168 "rygel-external-item-factory.vala"
	item->date = (_tmp10_ = rygel_external_item_factory_get_string (self, props, "Date"), _g_free0 (item->date), _tmp10_);
#line 1023 "rygel-external-item-factory.c"
	_g_variant_unref0 (value);
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
}


static const char* _variant_get14 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


#line 171 "rygel-external-item-factory.vala"
static char* rygel_external_item_factory_get_string (RygelExternalItemFactory* self, GHashTable* props, const char* prop) {
#line 1036 "rygel-external-item-factory.c"
	char* result = NULL;
	GVariant* value;
#line 171 "rygel-external-item-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 171 "rygel-external-item-factory.vala"
	g_return_val_if_fail (props != NULL, NULL);
#line 171 "rygel-external-item-factory.vala"
	g_return_val_if_fail (prop != NULL, NULL);
#line 172 "rygel-external-item-factory.vala"
	value = _g_variant_ref0 ((GVariant*) g_hash_table_lookup (props, prop));
#line 174 "rygel-external-item-factory.vala"
	if (value != NULL) {
#line 1049 "rygel-external-item-factory.c"
		result = g_strdup (_variant_get14 (value));
		_g_variant_unref0 (value);
#line 175 "rygel-external-item-factory.vala"
		return result;
#line 1054 "rygel-external-item-factory.c"
	} else {
		result = NULL;
		_g_variant_unref0 (value);
#line 177 "rygel-external-item-factory.vala"
		return result;
#line 1060 "rygel-external-item-factory.c"
	}
	_g_variant_unref0 (value);
}


static gint _variant_get15 (GVariant* value) {
	return g_variant_get_int32 (value);
}


#line 181 "rygel-external-item-factory.vala"
static gint rygel_external_item_factory_get_int (RygelExternalItemFactory* self, GHashTable* props, const char* prop) {
#line 1073 "rygel-external-item-factory.c"
	gint result = 0;
	GVariant* value;
#line 181 "rygel-external-item-factory.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 181 "rygel-external-item-factory.vala"
	g_return_val_if_fail (props != NULL, 0);
#line 181 "rygel-external-item-factory.vala"
	g_return_val_if_fail (prop != NULL, 0);
#line 182 "rygel-external-item-factory.vala"
	value = _g_variant_ref0 ((GVariant*) g_hash_table_lookup (props, prop));
#line 184 "rygel-external-item-factory.vala"
	if (value != NULL) {
#line 1086 "rygel-external-item-factory.c"
		result = _variant_get15 (value);
		_g_variant_unref0 (value);
#line 185 "rygel-external-item-factory.vala"
		return result;
#line 1091 "rygel-external-item-factory.c"
	} else {
		result = -1;
		_g_variant_unref0 (value);
#line 187 "rygel-external-item-factory.vala"
		return result;
#line 1097 "rygel-external-item-factory.c"
	}
	_g_variant_unref0 (value);
}


#line 31 "rygel-external-item-factory.vala"
RygelExternalItemFactory* rygel_external_item_factory_construct (GType object_type) {
#line 1105 "rygel-external-item-factory.c"
	RygelExternalItemFactory* self;
	self = (RygelExternalItemFactory*) g_type_create_instance (object_type);
	return self;
}


#line 31 "rygel-external-item-factory.vala"
RygelExternalItemFactory* rygel_external_item_factory_new (void) {
#line 31 "rygel-external-item-factory.vala"
	return rygel_external_item_factory_construct (RYGEL_EXTERNAL_TYPE_ITEM_FACTORY);
#line 1116 "rygel-external-item-factory.c"
}


static void rygel_external_value_item_factory_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_external_value_item_factory_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_external_item_factory_unref (value->data[0].v_pointer);
	}
}


static void rygel_external_value_item_factory_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_external_item_factory_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_external_value_item_factory_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_external_value_item_factory_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelExternalItemFactory* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_external_item_factory_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_external_value_item_factory_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelExternalItemFactory** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_external_item_factory_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_external_param_spec_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelExternalParamSpecItemFactory* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_EXTERNAL_TYPE_ITEM_FACTORY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_external_value_get_item_factory (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_EXTERNAL_TYPE_ITEM_FACTORY), NULL);
	return value->data[0].v_pointer;
}


void rygel_external_value_set_item_factory (GValue* value, gpointer v_object) {
	RygelExternalItemFactory* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_EXTERNAL_TYPE_ITEM_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_EXTERNAL_TYPE_ITEM_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_external_item_factory_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_external_item_factory_unref (old);
	}
}


void rygel_external_value_take_item_factory (GValue* value, gpointer v_object) {
	RygelExternalItemFactory* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_EXTERNAL_TYPE_ITEM_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_EXTERNAL_TYPE_ITEM_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_external_item_factory_unref (old);
	}
}


static void rygel_external_item_factory_class_init (RygelExternalItemFactoryClass * klass) {
	rygel_external_item_factory_parent_class = g_type_class_peek_parent (klass);
	RYGEL_EXTERNAL_ITEM_FACTORY_CLASS (klass)->finalize = rygel_external_item_factory_finalize;
}


static void rygel_external_item_factory_instance_init (RygelExternalItemFactory * self) {
	self->ref_count = 1;
}


static void rygel_external_item_factory_finalize (RygelExternalItemFactory* obj) {
	RygelExternalItemFactory * self;
	self = RYGEL_EXTERNAL_ITEM_FACTORY (obj);
}


/**
 * Creates item for external plugins.
 */
GType rygel_external_item_factory_get_type (void) {
	static volatile gsize rygel_external_item_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_external_item_factory_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_external_value_item_factory_init, rygel_external_value_item_factory_free_value, rygel_external_value_item_factory_copy_value, rygel_external_value_item_factory_peek_pointer, "p", rygel_external_value_item_factory_collect_value, "p", rygel_external_value_item_factory_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelExternalItemFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_external_item_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelExternalItemFactory), 0, (GInstanceInitFunc) rygel_external_item_factory_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_external_item_factory_type_id;
		rygel_external_item_factory_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelExternalItemFactory", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_external_item_factory_type_id__volatile, rygel_external_item_factory_type_id);
	}
	return rygel_external_item_factory_type_id__volatile;
}


gpointer rygel_external_item_factory_ref (gpointer instance) {
	RygelExternalItemFactory* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_external_item_factory_unref (gpointer instance) {
	RygelExternalItemFactory* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_EXTERNAL_ITEM_FACTORY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




