/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Type;
import org.gnu.glib.Handle;

/**
 * The Fixed container enables your program to place widgets at a
 * fixed location with fixed sizes in pixels and to move widgets from 
 * one location to another.  Most applications should not use this container.
 * This container could result in truncated text, overlapping widgets and
 * other display bugs as the user changes their themes, fonts, or preferences.
 */
public class Fixed extends Container 
{

	/**
	 * Construct a new Fixed object.
	 */
	public Fixed() {
		super(gtk_fixed_new());
	}
	
	/**
	 * Construct a new Fixed from a handle to a native resource.
	 */
	public Fixed(Handle handle) {
	    super(handle);
	}
    
    /**
     * Internal static factory method to be used by Java-Gnome only.
     */
    public static Fixed getFixed(Handle handle) {
        if (handle == null)
            return null;
        
        Fixed obj = (Fixed) getGObjectFromHandle(handle);
        if (obj == null)
            obj = new Fixed(handle);
        
        return obj;
    }
	
	/**
	 * Add a Widget to the Fixed at the specified location.
	 */
	public void putWidget(Widget widget, int x, int y) {
		Fixed.gtk_fixed_put(getHandle(), widget.getHandle(), x, y);
	}
	
	/**
	 * Move a widget to a new location.
	 */
	public void moveWidget(Widget widget, int x, int y) {
		Fixed.gtk_fixed_move(getHandle(), widget.getHandle(), x, y);
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_fixed_get_type());
	}


    native static final protected int gtk_fixed_get_type ();
    native static final protected Handle gtk_fixed_new ();
    native static final protected void gtk_fixed_put (Handle fixed, Handle widget, int x, int y);
    native static final protected void gtk_fixed_move (Handle fixed, Handle widget, int x, int y);
    native static final protected void gtk_fixed_set_has_window (Handle fixed, boolean hasWindow);
    native static final protected boolean gtk_fixed_get_has_window (Handle fixed);

}

