/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.gdk.Pixbuf;
import org.gnu.glib.Type;
import org.gnu.glib.Handle;

/**
 * A {@link CellRenderer} for pixbufs.
 */
public class CellRendererPixbuf extends CellRenderer 
{
	/** 
	 * Creates a new CellRendererPixbuf
	 */
	public CellRendererPixbuf(){
		super(gtk_cell_renderer_pixbuf_new ());
	}

	/**
	 * Attributes for the CellRenderer
	 */
	public static class Attribute extends CellRendererAttribute{
		private Attribute(String attr){
			super(attr);
		}
		/** The pixbuf to render. */
		public static final Attribute PIXBUF = new Attribute("pixbuf");
		/** Pixbuf for open expander. */
		public static final Attribute PIXBUF_EXPANDER_OPEN = new Attribute("pixbuf-expander-open");
		/** Pixbuf for closed expander. */
		public static final Attribute PIXBUF_EXPANDER_CLOSED = new Attribute("pixbuf-expander-closed");
		/** The stock icon to render.  */
		public static final Attribute STOCK_ID = new Attribute("stock-id");
		/** The size of the rendered icon.  */
		public static final Attribute STOCK_SIZE = new Attribute("stock-size");
		
	}

	/**
	 */
	public void setPixbuf(Pixbuf pixbuf){
		gtk_setPixbuf(getHandle(), pixbuf.getHandle());
	}

	/**
	 */
	public void setPixbufExpanderOpen(Pixbuf pixbuf){
		gtk_setPixbufOpen(getHandle(), pixbuf.getHandle());
	}
		

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_cell_renderer_pixbuf_get_type());
	}


    native static final protected int gtk_cell_renderer_pixbuf_get_type ();
    native static final protected Handle gtk_cell_renderer_pixbuf_new ();
	native static final protected int gtk_setPixbuf(Handle cr, Handle pixbuf);
	native static final protected int gtk_setPixbufOpen(Handle cr, Handle pixbuf);

}

