/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Handle;

/**
 *
 */
public class CellRendererCombo extends CellRendererText {
	
	public CellRendererCombo() {
		super(gtk_cell_renderer_combo_new());
	}
	
	public TreeModel getModel() {
		return TreeModel.getTreeModel(getModel(getHandle()));
	}
	
	public void setModel(TreeModel model) {
		setModel(getHandle(), model.getHandle());
	}
	
	public int getTextColumn() {
		return getTextColumn(getHandle());
	}
	
	public void setTextColumn(int column) {
		setTextColumn(getHandle(), column);
	}
	
	public boolean getHasEntry() {
		return getHasEntry(getHandle());
	}
	
	public void setHasEntry(boolean hasEntry) {
		setHasEntry(getHandle(), hasEntry);
	}

    native static final protected Handle getModel(Handle renderer);
    native static final protected void setModel(Handle renderer, Handle model);
    native static final protected int getTextColumn(Handle renderer);
    native static final protected void setTextColumn(Handle renderer, int textColumn);
    native static final protected boolean getHasEntry(Handle renderer);
    native static final protected void setHasEntry(Handle renderer, boolean hasEntry);
    native static final protected int gtk_cell_renderer_combo_get_type();
    native static final protected Handle gtk_cell_renderer_combo_new();

}
