/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;
import org.gnu.atk.AtkObject;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
/**
 *
 */
public class Accessible extends AtkObject 
{
	
	public Accessible(Handle handle) {
		super(handle);
	}
	
	public Widget getWidget() {
		Handle hndl = getWidget(getHandle());
		if (null == hndl)
			return null;
		GObject obj = getGObjectFromHandle(hndl);
		if (null != obj)
			return (Widget)obj;
		return new Widget(hndl);
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_accessible_get_type());
	}
	

    native static final protected Handle getWidget (Handle cptr);
    native static final protected int gtk_accessible_get_type ();

}

