/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
/**
 *
 */
public class PixbufLoader extends GObject 
{
	/**
	 * Construct a new PixbufLoader
	 */
	public PixbufLoader() {
		super(gdk_pixbuf_loader_new());
	}
	
	/**
	 * Construct a new PixbufLoader
	 */
	public PixbufLoader(String imageType) {
		super(gdk_pixbuf_loader_new_with_type(imageType, 0));
	}
	
	public boolean write(byte[] buffer) {
		int error = 0;
		return gdk_pixbuf_loader_write(getHandle(), buffer, buffer.length, error);
	}
	
	public Pixbuf getPixbuf() {
	    Handle hndl = gdk_pixbuf_loader_get_pixbuf(getHandle());
		GObject obj = retrieveGObject(hndl);
		if (null != obj)
			return (Pixbuf)obj;
		return new Pixbuf(hndl);
	}
	
	public PixbufAnimation getPixbufAnimation() {
		return new PixbufAnimation(gdk_pixbuf_loader_get_animation(getHandle()));
	}
	
	public boolean close() {
		int error = 0;
		return gdk_pixbuf_loader_close(getHandle(), error);
	}
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gdk_pixbuf_loader_get_type ();
    native static final protected Handle gdk_pixbuf_loader_new ();
    native static final protected Handle gdk_pixbuf_loader_new_with_type (String imageType, int error);
    native static final protected boolean gdk_pixbuf_loader_write (Handle loader, byte[] buf, int 
        count, int error);
    native static final protected Handle gdk_pixbuf_loader_get_pixbuf (Handle loader);
    native static final protected Handle gdk_pixbuf_loader_get_animation (Handle loader);
    native static final protected boolean gdk_pixbuf_loader_close (Handle loader, int error);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

