/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:42:29 EDT
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>
#ifdef __cplusplus
extern "C" 
{
#endif

gchar** getStringArray(JNIEnv *env, jobjectArray anArray);
void freeStringArray(JNIEnv *env, jobjectArray anArray, gchar** str);

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    /*
     * Class:     org.gnu.gtk.Image
     * Method:    gtk_image_get_type
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Image_gtk_1image_1get_1type (JNIEnv *env, jclass cls) 
    {
        {
            return (jint)gtk_image_get_type ();
        }
    }

    /*
     * Class:     org.gnu.gtk.Image
     * Method:    gtk_image_new
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Image_gtk_1image_1new (JNIEnv *env, jclass cls) 
    {
        {
            return (jint)gtk_image_new ();
        }
    }

    /*
     * Class:     org.gnu.gtk.Image
     * Method:    gtk_image_new_from_pixmap
     * Signature: (II)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Image_gtk_1image_1new_1from_1pixmap (JNIEnv *env, 
        jclass cls, jint pixmap, jint mask) 
    {
        GdkPixmap *pixmap_g = (GdkPixmap *)pixmap;
        GdkBitmap *mask_g = (GdkBitmap *)mask;
        {
            return (jint)gtk_image_new_from_pixmap (pixmap_g, mask_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Image
     * Method:    gtk_image_new_from_image
     * Signature: (II)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Image_gtk_1image_1new_1from_1image (JNIEnv *env, jclass 
        cls, jint image, jint mask) 
    {
        GdkImage *image_g = (GdkImage *)image;
        GdkBitmap *mask_g = (GdkBitmap *)mask;
        {
            return (jint)gtk_image_new_from_image (image_g, mask_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Image
     * Method:    gtk_image_new_from_file
     * Signature: (java.lang.String;)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Image_gtk_1image_1new_1from_1file (JNIEnv *env, jclass 
        cls, jstring filename) 
    {
        gchar* filename_g = (gchar*)(*env)->GetStringUTFChars(env, filename, 0);
         jint result = (jint)gtk_image_new_from_file (filename_g);
         (*env)->ReleaseStringUTFChars(env, filename, filename_g);
         return result;
    }

    /*
     * Class:     org.gnu.gtk.Image
     * Method:    gtk_image_new_from_pixbuf
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Image_gtk_1image_1new_1from_1pixbuf (JNIEnv *env, 
        jclass cls, jint pixbuf) 
    {
        GdkPixbuf *pixbuf_g = (GdkPixbuf *)pixbuf;
        {
            return (jint)gtk_image_new_from_pixbuf (pixbuf_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Image
     * Method:    gtk_image_new_from_stock
     * Signature: (java.lang.String;I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Image_gtk_1image_1new_1from_1stock (JNIEnv *env, jclass 
        cls, jstring stockId, jint size) 
    {
        gchar* stockId_g = (gchar*)(*env)->GetStringUTFChars(env, stockId, 0);
        jint result = (jint)gtk_image_new_from_stock (stockId_g, (GtkIconSize)size);
        (*env)->ReleaseStringUTFChars(env, stockId, stockId_g);
        return result;
    }

    /*
     * Class:     org.gnu.gtk.Image
     * Method:    gtk_image_new_from_icon_set
     * Signature: (II)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Image_gtk_1image_1new_1from_1icon_1set (JNIEnv *env, 
        jclass cls, jint iconSet, jint size) 
    {
        GtkIconSet *iconSet_g = (GtkIconSet *)iconSet;
        GtkIconSize size_g = (GtkIconSize) size;
        {
            return (jint)gtk_image_new_from_icon_set (iconSet_g, size_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Image
     * Method:    gtk_image_new_from_animation
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Image_gtk_1image_1new_1from_1animation (JNIEnv *env, 
        jclass cls, jint animation) 
    {
        GdkPixbufAnimation *animation_g = (GdkPixbufAnimation *)animation;
        {
            return (jint)gtk_image_new_from_animation (animation_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Image
     * Method:    gtk_image_set_from_pixmap
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Image_gtk_1image_1set_1from_1pixmap (JNIEnv *env, 
        jclass cls, jint image, jint pixmap, jint mask) 
    {
        GtkImage *image_g = (GtkImage *)image;
        GdkPixmap *pixmap_g = (GdkPixmap *)pixmap;
        GdkBitmap *mask_g = (GdkBitmap *)mask;
        {
            gtk_image_set_from_pixmap (image_g, pixmap_g, mask_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Image
     * Method:    gtk_image_set_from_image
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Image_gtk_1image_1set_1from_1image (JNIEnv *env, jclass 
        cls, jint image, jint gdkImage, jint mask) 
    {
        GtkImage *image_g = (GtkImage *)image;
        GdkImage *gdkImage_g = (GdkImage *)gdkImage;
        GdkBitmap *mask_g = (GdkBitmap *)mask;
        {
            gtk_image_set_from_image (image_g, gdkImage_g, mask_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Image
     * Method:    gtk_image_set_from_file
     * Signature: (Ijava.lang.String;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Image_gtk_1image_1set_1from_1file (JNIEnv *env, jclass 
        cls, jint image, jstring filename) 
    {
        gchar* filename_g = (gchar*)(*env)->GetStringUTFChars(env, filename, 0);
        gtk_image_set_from_file ((GtkImage*)image, filename_g);
        (*env)->ReleaseStringUTFChars(env, filename, filename_g);
    }

    /*
     * Class:     org.gnu.gtk.Image
     * Method:    gtk_image_set_from_pixbuf
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Image_gtk_1image_1set_1from_1pixbuf (JNIEnv *env, 
        jclass cls, jint image, jint pixbuf) 
    {
        GtkImage *image_g = (GtkImage *)image;
        GdkPixbuf *pixbuf_g = (GdkPixbuf *)pixbuf;
        {
            gtk_image_set_from_pixbuf (image_g, pixbuf_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Image
     * Method:    gtk_image_set_from_stock
     * Signature: (Ijava.lang.String;I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Image_gtk_1image_1set_1from_1stock (JNIEnv *env, jclass 
        cls, jint image, jstring stockId, jint size) 
    {
        gchar* stockId_g = (gchar*)(*env)->GetStringUTFChars(env, stockId, 0);
        gtk_image_set_from_stock ((GtkImage*)image, stockId_g, (GtkIconSize )size);
        (*env)->ReleaseStringUTFChars(env, stockId, stockId_g);
    }

    /*
     * Class:     org.gnu.gtk.Image
     * Method:    gtk_image_set_from_icon_set
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Image_gtk_1image_1set_1from_1icon_1set (JNIEnv *env, 
        jclass cls, jint image, jint iconSet, jint size) 
    {
        GtkImage *image_g = (GtkImage *)image;
        GtkIconSet *iconSet_g = (GtkIconSet *)iconSet;
        GtkIconSize size_g = (GtkIconSize) size;
        {
            gtk_image_set_from_icon_set (image_g, iconSet_g, size_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Image
     * Method:    gtk_image_set_from_animation
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Image_gtk_1image_1set_1from_1animation (JNIEnv *env, 
        jclass cls, jint image, jint animation) 
    {
        GtkImage *image_g = (GtkImage *)image;
        GdkPixbufAnimation *animation_g = (GdkPixbufAnimation *)animation;
        {
            gtk_image_set_from_animation (image_g, animation_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Image
     * Method:    gtk_image_get_storage_type
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Image_gtk_1image_1get_1storage_1type (JNIEnv *env, 
        jclass cls, jint image) 
    {
        GtkImage *image_g = (GtkImage *)image;
        {
            jint result_j = (jint) (gtk_image_get_storage_type (image_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Image
     * Method:    gtk_image_get_pixmap
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Image_gtk_1image_1get_1pixmap (JNIEnv *env, jclass cls, 
        jint image, jint pixmap, jint mask) 
    {
        GtkImage *image_g = (GtkImage *)image;
        GdkPixmap **pixmap_g = (GdkPixmap **)pixmap;
        GdkBitmap **mask_g = (GdkBitmap **)mask;
        {
            gtk_image_get_pixmap (image_g, pixmap_g, mask_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Image
     * Method:    gtk_image_get_image
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Image_gtk_1image_1get_1image (JNIEnv *env, jclass cls, 
        jint image, jint gdkImage, jint mask) 
    {
        GtkImage *image_g = (GtkImage *)image;
        GdkImage **gdkImage_g = (GdkImage **)gdkImage;
        GdkBitmap **mask_g = (GdkBitmap **)mask;
        {
            gtk_image_get_image (image_g, gdkImage_g, mask_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Image
     * Method:    gtk_image_get_pixbuf
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Image_gtk_1image_1get_1pixbuf (JNIEnv *env, jclass cls, 
        jint image) 
    {
        GtkImage *image_g = (GtkImage *)image;
        {
            return (jint)gtk_image_get_pixbuf (image_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Image
     * Method:    gtk_image_get_stock
     * Signature: ([java/lang/String;[Lint ;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Image_gtk_1image_1get_1stock (JNIEnv *env, jclass cls, 
        jint image, jobjectArray stockId, jintArray size) 
    {
        GtkImage *image_g = (GtkImage *)image;
        gchar **stockId_g = getStringArray(env, stockId);
        gint *size_g_g = (gint *) (*env)->GetIntArrayElements (env, size, NULL);
        GtkIconSize *size_g = (GtkIconSize *)size_g_g;
        gtk_image_get_stock (image_g, stockId_g, size_g);
        (*env)->ReleaseIntArrayElements (env, size, size_g_g, 0);
        freeStringArray(env, stockId, stockId_g);
    }

    /*
     * Class:     org.gnu.gtk.Image
     * Method:    gtk_image_get_icon_set
     * Signature: (I[Lint ;[Lint ;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Image_gtk_1image_1get_1icon_1set (JNIEnv *env, jclass 
        cls, jint image, jintArray iconSet, jintArray size) 
    {
        GtkImage *image_g = (GtkImage *)image;
        gint *iconSet_g_g = (gint *) (*env)->GetIntArrayElements (env, iconSet, NULL);
        GtkIconSet **iconSet_g = (GtkIconSet **)iconSet_g_g;
        gint *size_g_g = (gint *) (*env)->GetIntArrayElements (env, size, NULL);
        GtkIconSize *size_g = (GtkIconSize *)size_g_g;
        {
            gtk_image_get_icon_set (image_g, iconSet_g, size_g);
            (*env)->ReleaseIntArrayElements (env, iconSet, iconSet_g_g, 0);
            (*env)->ReleaseIntArrayElements (env, size, size_g_g, 0);
        }
    }

    /*
     * Class:     org.gnu.gtk.Image
     * Method:    gtk_image_get_animation
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Image_gtk_1image_1get_1animation (JNIEnv *env, jclass 
        cls, jint image) 
    {
        GtkImage *image_g = (GtkImage *)image;
        {
            return (jint)gtk_image_get_animation (image_g);
        }
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
#ifdef __cplusplus
}

#endif
