/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2003 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef _Included_org_gnu_gtk_EntryCompletion
#define _Included_org_gnu_gtk_EntryCompletion
#ifdef __cplusplus
extern "C" {
#endif
/*
 * Class:     org_gnu_gtk_EntryCompletion
 * Method:    gtk_entry_completion_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_EntryCompletion_gtk_1entry_1completion_1get_1type
  (JNIEnv *env, jclass cls)
{
	return (jint)gtk_entry_completion_get_type();
}

/*
 * Class:     org_gnu_gtk_EntryCompletion
 * Method:    gtk_entry_completion_new
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_EntryCompletion_gtk_1entry_1completion_1new
  (JNIEnv *env, jclass cls)
{
	return (jint)gtk_entry_completion_new();
}

/*
 * Class:     org_gnu_gtk_EntryCompletion
 * Method:    gtk_entry_completion_get_entry
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_EntryCompletion_gtk_1entry_1completion_1get_1entry
  (JNIEnv *env, jclass cls, jint entry)
{
	return (jint)gtk_entry_completion_get_entry((GtkEntryCompletion*)entry);
}

/*
 * Class:     org_gnu_gtk_EntryCompletion
 * Method:    gtk_entry_completion_set_model
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_EntryCompletion_gtk_1entry_1completion_1set_1model
  (JNIEnv *env, jclass cls, jint entry, jint model)
{
	gtk_entry_completion_set_model((GtkEntryCompletion*)entry, (GtkTreeModel*)model);
}

/*
 * Class:     org_gnu_gtk_EntryCompletion
 * Method:    gtk_entry_completion_get_model
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_EntryCompletion_gtk_1entry_1completion_1get_1model
  (JNIEnv *env, jclass cls, jint entry)
{
	return (jint)gtk_entry_completion_get_model((GtkEntryCompletion*)entry);
}

/*
 * Class:     org_gnu_gtk_EntryCompletion
 * Method:    gtk_entry_completion_set_minimum_key_length
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_EntryCompletion_gtk_1entry_1completion_1set_1minimum_1key_1length
  (JNIEnv *env, jclass cls, jint entry, jint length)
{
	gtk_entry_completion_set_minimum_key_length((GtkEntryCompletion*)entry, (gint)length);
}

/*
 * Class:     org_gnu_gtk_EntryCompletion
 * Method:    gtk_entry_completion_get_minimum_key_length
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_EntryCompletion_gtk_1entry_1completion_1get_1minimum_1key_1length
  (JNIEnv *env, jclass cls, jint entry)
{
	return (jint)gtk_entry_completion_get_minimum_key_length((GtkEntryCompletion*)entry);
}

/*
 * Class:     org_gnu_gtk_EntryCompletion
 * Method:    gtk_entry_completion_complete
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_EntryCompletion_gtk_1entry_1completion_1complete
  (JNIEnv *env, jclass cls, jint entry)
{
	gtk_entry_completion_complete((GtkEntryCompletion*)entry);
}

/*
 * Class:     org_gnu_gtk_EntryCompletion
 * Method:    gtk_entry_completion_insert_action_text
 * Signature: (IILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_EntryCompletion_gtk_1entry_1completion_1insert_1action_1text
  (JNIEnv *env, jclass cls, jint entry, jint index, jstring text)
{
	const gchar* t = (gchar*)(*env)->GetStringUTFChars(env, text, NULL);
	gtk_entry_completion_insert_action_text((GtkEntryCompletion*)entry, (gint)index, t);
	(*env)->ReleaseStringUTFChars(env, text, t);
}

/*
 * Class:     org_gnu_gtk_EntryCompletion
 * Method:    gtk_entry_completion_insert_action_markup
 * Signature: (IILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_EntryCompletion_gtk_1entry_1completion_1insert_1action_1markup
  (JNIEnv *env, jclass cls, jint entry, jint index, jstring markup)
{
	const gchar* m = (gchar*)(*env)->GetStringUTFChars(env, markup, NULL);
	gtk_entry_completion_insert_action_markup((GtkEntryCompletion*)entry, (gint)index, m);
	(*env)->ReleaseStringUTFChars(env, markup, m);
}

/*
 * Class:     org_gnu_gtk_EntryCompletion
 * Method:    gtk_entry_completion_delete_action
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_EntryCompletion_gtk_1entry_1completion_1delete_1action
  (JNIEnv *env, jclass cls, jint entry, jint index)
{
	gtk_entry_completion_delete_action((GtkEntryCompletion*)entry, (gint)index);
}

/*
 * Class:     org_gnu_gtk_EntryCompletion
 * Method:    gtk_entry_completion_set_text_column
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_EntryCompletion_gtk_1entry_1completion_1set_1text_1column
  (JNIEnv *env, jclass cls, jint entry, jint column)
{
	gtk_entry_completion_set_text_column((GtkEntryCompletion*)entry, (gint)column);
}

#ifdef __cplusplus
}
#endif
#endif
